/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.pluginmanagement;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.pluginmanagement.PluginDefinitionHandler;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.SerializableTool;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class PluginSerializationHandler {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static ConcurrentHashMap<String, Properties> resourceMap = new ConcurrentHashMap(16);
    private static ConcurrentHashMap<String, String> iconPathMap = new ConcurrentHashMap(16);
    private static final String PLUGIN_RESOURCE = "PluginResource";
    private static final String PLUGIN_ICON = "PluginIcon";
    private static IviewLogger logger = IviewLogger.getLogger(PluginSerializationHandler.class, "IVIEW");

    public static boolean checkResExistance(String string) {
        if (null != string) {
            if (resourceMap.containsKey(string)) {
                return true;
            }
        } else {
            logger.error("path is null");
        }
        return false;
    }

    public static Properties getResource(String string) {
        if (string != null) {
            return resourceMap.get(string);
        }
        logger.error("path is null");
        return null;
    }

    public static Properties removeResource(String string) {
        if (null != string) {
            return resourceMap.get(string);
        }
        return null;
    }

    public static void populateResMap(String string, Properties properties) {
        if (string != null && properties != null) {
            resourceMap.put(string, properties);
        } else {
            logger.error("path is:" + string + "resouce is:" + properties);
        }
    }

    public static boolean checkExistance(String string) {
        if (null != string) {
            if (iconPathMap.containsKey(string)) {
                return true;
            }
        } else {
            logger.error("path is null");
        }
        return false;
    }

    public static Icon getIcon(String string) {
        if (null != string) {
            String string2 = iconPathMap.get(string);
            if (null == string2 || "null".equals(string2)) {
                return null;
            }
            URL uRL = ResourceMng.getURLFromJarOrFile(string2);
            return new ImageIcon(uRL);
        }
        logger.error("path is null");
        return null;
    }

    public static void populateIconPathMap(String string, Icon icon, URL uRL) {
        if (null != string) {
            if (null == icon || uRL == null) {
                iconPathMap.put(string, "null");
            } else {
                String string2 = uRL.getPath();
                if ("jar".equals(uRL.getProtocol())) {
                    string2 = string2.substring(string2.lastIndexOf("jar!/") + 5);
                    string2 = string2.replaceAll("%20", " ");
                } else {
                    try {
                        string2 = new File(uRL.toURI()).getPath();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        logger.trace(uRISyntaxException);
                    }
                    string2 = string2.substring(string2.indexOf("plugins"));
                }
                iconPathMap.put(string, string2);
            }
        } else {
            logger.error("path is null");
        }
    }

    public static String getSerializationKey(String string, String string2) {
        return string + ':' + string2;
    }

    public static void readSerializedResource(String string) {
        String string2 = ResourceMng.getInstance().getLocaleString() + ".dat";
        String string3 = FrameworkUtilities.getSubsystemName();
        if (PluginDefinitionHandler.getPluginDefinitionHandler().isConfigurationPresent()) {
            try {
                resourceMap = (ConcurrentHashMap)SerializableTool.readData(string + File.separator + string3 + File.separator + PLUGIN_RESOURCE + '_' + string2);
            }
            catch (ClassCastException classCastException) {
                logger.error("ClassCastException has occured");
                resourceMap = null;
            }
        }
        if (null == resourceMap) {
            resourceMap = new ConcurrentHashMap(16);
        }
        if (PluginDefinitionHandler.getPluginDefinitionHandler().isConfigurationPresent()) {
            try {
                iconPathMap = (ConcurrentHashMap)SerializableTool.readData(string + File.separator + string3 + File.separator + PLUGIN_ICON + '_' + string2);
            }
            catch (ClassCastException classCastException) {
                logger.error("ClassCastException has occured");
                iconPathMap = null;
            }
        }
        if (null == iconPathMap) {
            iconPathMap = new ConcurrentHashMap(16);
        }
    }

    public static void writeSerializedResource(String string) {
        String string2 = ResourceMng.getInstance().getLocaleString() + ".dat";
        String string3 = FrameworkUtilities.getSubsystemName();
        if (!PluginDefinitionHandler.getPluginDefinitionHandler().isConfigurationPresent()) {
            SerializableTool.writeData(string + File.separator + string3 + File.separator + PLUGIN_RESOURCE + '_' + string2, resourceMap);
            SerializableTool.writeData(string + File.separator + string3 + File.separator + PLUGIN_ICON + '_' + string2, iconPathMap);
        }
    }

    static void clear() {
        resourceMap.clear();
        iconPathMap.clear();
    }
}

