/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.pluginmanagement;

import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.util.IStartupElement;
import com.swimap.iview.framework.util.StartupFactory;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.List;

public abstract class PluginProcess {
    private static IviewLogger logger = IviewLogger.getLogger(PluginProcess.class, "IVIEW");
    protected PluginManager pm = null;
    protected List<Plugin> startupPluginList = new ArrayList<Plugin>(15);
    protected List<Plugin> loadedNormalplugins = null;

    PluginProcess(PluginManager pluginManager) {
        this.pm = pluginManager;
    }

    abstract List<Plugin> getStartupLoadedPluginList();

    abstract List<Plugin> getStartupPluginList();

    abstract List<Plugin> loadedNormalPluginList();

    abstract List<Plugin> getAllLoadedPlugins();

    void clearAndReinitialize() {
        if (null != this.loadedNormalplugins) {
            this.loadedNormalplugins = null;
        }
        this.startupPluginList.clear();
    }

    void cleanupWhileOSGIExit() {
        this.startupPluginList.clear();
    }

    public void clear() {
        this.startupPluginList.clear();
    }

    abstract void removePlugin(Plugin var1);

    abstract void addPlugin(Plugin var1);

    static List<String> getStartupPluginElementsNameList() {
        List<IStartupElement> list = StartupFactory.getStartupElements(1);
        if (null == list) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        for (IStartupElement iStartupElement : list) {
            try {
                String string = iStartupElement.getName();
                if (null == string) continue;
                arrayList.add(string);
            }
            catch (Throwable throwable) {
                logger.trace(throwable);
            }
        }
        return arrayList;
    }
}

