/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.pluginmanagement;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.StartupXMLReader;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.modulemanagement.ModuleList;
import com.swimap.iview.framework.pluginmanagement.DuplicateModuleLoadException;
import com.swimap.iview.framework.pluginmanagement.InvalidPluginException;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginProcess;
import com.swimap.iview.framework.pluginmanagement.PluginSubsystemUtilities;
import com.swimap.iview.framework.pluginmanagement.PortalPluginProcess;
import com.swimap.iview.framework.pluginmanagement.TraditionalPluginProcess;
import com.swimap.iview.framework.pluginmanagement.spi.AbstractPlugin;
import com.swimap.iview.framework.pluginmanagement.spi.PluginFactory;
import com.swimap.iview.framework.pluginmanagement.spi.ProductHandlerManager;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.SerializableTool;
import com.swimap.iview.util.SerializationHandler;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.startup.StartupClassLoader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PluginManager {
    private static IviewLogger logger = IviewLogger.getLogger(PluginManager.class, "IVIEW");
    static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/pluginmanagement/Res");
    private static PluginManager instance = null;
    private PluginFactory factory = new PluginFactory();
    private List<Plugin> pluginList = null;
    private List<String> loadedPluginNames = null;
    private Hashtable<String, Plugin> loadedPluginIdTable = null;
    private ConcurrentHashMap<String, Plugin> loadedPluginNameMap = null;
    private List<String> loadedPluginNameLst = null;
    private List<Plugin> startupFeaturePluginLst = null;
    private List<String> startupFeaturePluginNames = null;
    private Set<String> removedPluginsList = new HashSet<String>(10);
    private Map<String, String> modulePluginMap = new HashMap<String, String>(16);
    private static HashMap<String, String> failedPluginModuleMap = new HashMap(16);
    private PluginProcess tpInstance = null;
    private HashMap<String, Plugin> serializedPluginsMap = new HashMap(10);
    private boolean newPluginsLoaded = false;

    public static PluginManager getInstance() {
        if (null == instance) {
            instance = new PluginManager();
        }
        return instance;
    }

    private PluginManager() {
        StartupClassLoader startupClassLoader = StartupClassLoader.getInstance();
        SubsystemManager.LoadMode loadMode = SubsystemManager.getInstance().getClientLoadMode();
        if (null != startupClassLoader) {
            if (loadMode == SubsystemManager.LoadMode.single || !StartupXMLReader.checkStartupXMLExists()) {
                this.tpInstance = new TraditionalPluginProcess(this);
                this.initialize();
            }
        } else {
            this.tpInstance = new TraditionalPluginProcess(this);
        }
    }

    public void reinitializeStartupXMLPlugins() {
        if (null == this.pluginList && null == this.loadedPluginNames && (null != this.startupFeaturePluginLst || null != this.startupFeaturePluginNames)) {
            if (null == this.loadedPluginNames) {
                this.loadedPluginNames = new ArrayList<String>(this.startupFeaturePluginNames.size());
            }
            if (this.pluginList == null) {
                this.pluginList = new ArrayList<Plugin>(this.startupFeaturePluginLst.size());
            }
            this.loadedPluginNames.addAll(this.startupFeaturePluginNames);
            this.pluginList.addAll(this.startupFeaturePluginLst);
            for (Plugin plugin : this.startupFeaturePluginLst) {
                ModuleList.addModuleId(plugin.getModuleInfomation().getModuleLabel());
            }
        }
    }

    public void initializeAfterLogin() {
        if (CommonUtil.isStartupClassLoaded() && null != StartupClassLoader.getInstance()) {
            this.reinitializeStartupXMLPlugins();
            this.initialize();
        }
    }

    private void loadPluginsFromSerialization(List<Plugin> list, List<String> list2) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>(10);
        if (null != this.pluginList) {
            for (Plugin plugin : this.pluginList) {
                arrayList.add(plugin.getPluginName());
            }
            for (Plugin plugin : list) {
                if (arrayList.contains(plugin.getPluginName())) continue;
                this.pluginList.add(plugin);
            }
        } else {
            this.pluginList = list;
        }
        boolean bl = false;
        if (list2.contains("WelcomePage")) {
            for (Plugin plugin : this.pluginList) {
                if (!"WelcomePage".equals(plugin.getPluginName())) continue;
                bl = true;
                break;
            }
        } else {
            object = null;
            for (int i = 0; i < this.pluginList.size(); ++i) {
                object = this.pluginList.get(i);
                if (!"WelcomePage".equals(object.getPluginName())) continue;
                list.remove(i);
                --i;
            }
        }
        this.loadedPluginNames = new ArrayList<String>(this.pluginList.size());
        for (Plugin plugin : this.pluginList) {
            this.loadPluginFromSerialization(plugin, list2);
        }
        if (FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.traditional && !bl) {
            object = new ArrayList(10);
            ((ArrayList)object).add("WelcomePage");
            this.loadPlugins((List<String>)object);
        }
    }

    private void loadPluginFromSerialization(Plugin plugin, List<String> list) {
        if (null == this.loadedPluginNames) {
            this.loadedPluginNames = new ArrayList<String>(16);
        }
        URL uRL = null;
        String string = null;
        if (plugin instanceof AbstractPlugin) {
            uRL = ((AbstractPlugin)plugin).getURL();
            if (null == uRL) {
                uRL = this.getURL(plugin, list);
            }
            if (null != uRL) {
                ((AbstractPlugin)plugin).setURL(uRL);
            }
        }
        string = plugin.getPluginName();
        this.loadedPluginNames.add(string);
        ModuleList.addModuleClassName(plugin.getModuleInfomation().getClassName());
        ModuleList.addSharedClassModuleName(plugin.getModuleInfomation().getClassName());
        this.modulePluginMap.put(plugin.getModuleInfomation().getModuleName(), string);
        ModuleList.addModuleId(plugin.getModuleInfomation().getModuleLabel());
    }

    public void initializeBeforeLogin() {
        if (CommonUtil.isStartupClassLoaded() && null != StartupClassLoader.getInstance()) {
            List<String> list = null;
            list = StartupXMLReader.getNormalAndRequiredPluginList();
            if (list != null && list.size() > 0) {
                this.loadPlugins(list);
                if (this.pluginList != null || this.loadedPluginNames != null) {
                    if (null == this.startupFeaturePluginLst) {
                        this.startupFeaturePluginLst = new ArrayList<Plugin>(this.pluginList.size());
                    }
                    this.startupFeaturePluginLst.addAll(this.pluginList);
                    if (this.startupFeaturePluginNames == null) {
                        this.startupFeaturePluginNames = new ArrayList<String>(this.loadedPluginNames.size());
                    }
                    this.startupFeaturePluginNames.addAll(this.loadedPluginNames);
                }
            }
        }
    }

    private void initialize() {
        if (CommonUtil.isStartupClassLoaded() && null != StartupClassLoader.getInstance()) {
            List<Plugin> list = this.readPlugins("TraditionalStyle_plugins");
            failedPluginModuleMap = this.readFailedPlugins("TraditionalStyle_failedplugins");
            List<String> list2 = SubsystemManager.getInstance().getLoadedSubsystemAllPluginList();
            if (list == null || list.size() == 0 && list2.size() > 0) {
                String string = System.getProperty("subsystem");
                if (null == string && StartupXMLReader.checkStartupXMLExists()) {
                    this.reinitializeProductHandlersOfStartupXMLPlugins(list2);
                }
                this.loadPlugins(list2);
                this.writePlugins((ArrayList)this.getLoadedPluginList(), "TraditionalStyle_plugins");
                if (!failedPluginModuleMap.isEmpty()) {
                    this.writeFailedPlugins(failedPluginModuleMap, "TraditionalStyle_failedplugins");
                }
            } else {
                this.loadPluginsFromSerialization(list, list2);
            }
        }
    }

    private URL getURL(Plugin plugin, List<String> list) {
        String[] stringArray = PluginSubsystemUtilities.getAllPluginNames(list);
        String string = null;
        URL uRL = null;
        for (String string2 : stringArray) {
            if (null == string2) continue;
            string = string2;
            if (string.endsWith(".jar")) {
                string = string.substring(0, string.indexOf(".jar"));
            }
            if (!ResourceUtil.areEquals(plugin.getPluginName(), string)) continue;
            uRL = PluginSubsystemUtilities.getPluginURL(string2);
            return uRL;
        }
        logger.debug("Unable to get the plugin root url");
        return null;
    }

    private void loadPlugins(List<String> list) {
        String[] stringArray = null;
        if (null != list && 0 < list.size()) {
            stringArray = PluginSubsystemUtilities.getAllPluginNames(list);
            if (null != stringArray && 0 < stringArray.length) {
                if (this.pluginList == null) {
                    this.pluginList = new ArrayList<Plugin>(list.size());
                }
                if (this.loadedPluginNames == null) {
                    this.loadedPluginNames = new ArrayList<String>(list.size());
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    this.loadPlugin(stringArray[i]);
                }
            }
        } else {
            logger.debug("Valid Plugins not found" + new File("."));
            this.pluginList = new ArrayList<Plugin>(0);
        }
    }

    private void loadPlugin(String string) {
        URL uRL = null;
        try {
            logger.debug("Start to load plugin : " + string);
            if (this.loadedPluginNames.contains(string)) {
                return;
            }
            uRL = PluginSubsystemUtilities.getPluginURL(string);
            Plugin plugin = this.factory.createPlugin(uRL);
            if (null != plugin && null != plugin.getId()) {
                this.modulePluginMap.put(plugin.getId(), plugin.getPluginName());
                this.pluginList.add(plugin);
            }
            this.loadedPluginNames.add(string);
            if (null != plugin && null != plugin.getModuleInfomation()) {
                logger.info("pluginInformation: [pluginName:" + plugin.getPluginName() + ", plugin moduleId:" + plugin.getId() + ", plugin className:" + plugin.getModuleInfomation().getClassName() + "]");
            }
            logger.debug("Finish to load plugin : " + string);
        }
        catch (MalformedURLException malformedURLException) {
            logger.error(malformedURLException.getMessage(), malformedURLException);
            OptionPane.showMessageDialog(null, res.getString("Plugin_NotFound"), res.getString("Error"), 0);
            Main.instance().exit();
        }
        catch (InvalidPluginException invalidPluginException) {
            logger.warn(invalidPluginException.getMessage(), invalidPluginException);
            logger.error("Failed to load plugin : " + string);
        }
        catch (DuplicateModuleLoadException duplicateModuleLoadException) {
            logger.warn("Duplicate Module Id, plugin : " + string + " is not loaded.");
        }
    }

    public void createProcessInstance() {
        if (null == this.tpInstance) {
            FrameworkCommandProcessor.LoadStyle loadStyle = FrameworkCommandProcessor.getInstance().getUserLoadStyle();
            this.tpInstance = loadStyle == FrameworkCommandProcessor.LoadStyle.application ? new PortalPluginProcess(instance) : new TraditionalPluginProcess(instance);
        }
    }

    public Plugin getPlugin(String string) {
        if (null == string) {
            throw new IllegalArgumentException("PluginID is not valid.");
        }
        Plugin plugin = null;
        if (null != this.loadedPluginIdTable) {
            plugin = this.loadedPluginIdTable.get(string);
        } else if (null != this.pluginList) {
            this.loadedPluginIdTable = new Hashtable(this.pluginList.size());
            for (Plugin plugin2 : this.pluginList) {
                this.loadedPluginIdTable.put(plugin2.getId(), plugin2);
            }
            plugin = this.loadedPluginIdTable.get(string);
        }
        if (null == plugin) {
            logger.warn("There is no plugin with ID = " + string);
        }
        return plugin;
    }

    public Plugin getPluginFromFolder(String string) {
        if (null == string) {
            throw new IllegalArgumentException("Plugin name is not valid.");
        }
        Plugin plugin = null;
        if (null != this.loadedPluginNameMap) {
            plugin = this.loadedPluginNameMap.get(string);
        } else if (null != this.pluginList) {
            this.loadedPluginNameMap = new ConcurrentHashMap(this.pluginList.size());
            for (Plugin plugin2 : this.pluginList) {
                this.loadedPluginNameMap.put(plugin2.getPluginName(), plugin2);
            }
            plugin = this.loadedPluginNameMap.get(string);
        }
        if (null == plugin) {
            logger.warn("There is no plugin with folder name = " + string);
        }
        return plugin;
    }

    public List<Plugin> getLoadedPluginList() {
        return this.pluginList;
    }

    public List<String> getLoadedPluginNames() {
        if (null == this.loadedPluginNameLst && null != this.loadedPluginNames) {
            ArrayList<String> arrayList = new ArrayList<String>(this.loadedPluginNames.size());
            for (String string : this.loadedPluginNames) {
                if (string.endsWith(".jar")) {
                    String string2 = string.substring(0, string.indexOf(".jar"));
                    arrayList.add(string2);
                    continue;
                }
                arrayList.add(string);
            }
            this.loadedPluginNameLst = arrayList;
        }
        return this.loadedPluginNameLst;
    }

    public List<Plugin> getStartupLoadedPluginList() {
        return this.tpInstance.getStartupLoadedPluginList();
    }

    public List<Plugin> getStartupPluginList() {
        return this.tpInstance.getStartupPluginList();
    }

    public List<Plugin> loadedNormalPluginList() {
        if (null == this.tpInstance) {
            List<String> list = StartupXMLReader.getNormalPlugins();
            if (null != list) {
                return this.getPlugins(list);
            }
            this.tpInstance = new TraditionalPluginProcess(instance);
        }
        return this.tpInstance.loadedNormalPluginList();
    }

    private void writePlugins(ArrayList<Plugin> arrayList, String string) {
        if (SerializationHandler.isEnableSerialization()) {
            String string2 = SerializableTool.getFileName(string);
            SerializableTool.writeData(string2, arrayList);
        }
    }

    private void writeFailedPlugins(HashMap<String, String> hashMap, String string) {
        if (SerializationHandler.isEnableSerialization()) {
            String string2 = SerializableTool.getFileName(string);
            SerializableTool.writeData(string2, hashMap);
        }
    }

    private List<Plugin> readPlugins(String string) {
        String string2;
        ArrayList arrayList = null;
        if (SerializationHandler.isEnableSerialization() && null != (arrayList = (ArrayList)SerializableTool.readData(string2 = SerializableTool.getFileName(string)))) {
            for (Plugin plugin : arrayList) {
                plugin.getResource();
            }
        }
        return arrayList;
    }

    private HashMap<String, String> readFailedPlugins(String string) {
        String string2;
        HashMap hashMap = new HashMap(16);
        if (SerializationHandler.isEnableSerialization() && null == (hashMap = (HashMap)SerializableTool.readData(string2 = SerializableTool.getFileName(string)))) {
            hashMap = new HashMap(16);
        }
        return hashMap;
    }

    public void cleanupWhileOSGIExit() {
        if (null != this.pluginList) {
            this.pluginList.clear();
            this.pluginList = null;
        }
        if (null != this.loadedPluginNameLst) {
            this.loadedPluginNameLst.clear();
            this.loadedPluginNameLst = null;
        }
        if (null != this.loadedPluginIdTable) {
            this.loadedPluginIdTable.clear();
            this.loadedPluginIdTable = null;
        }
        if (null != this.loadedPluginNameMap) {
            this.loadedPluginNameMap.clear();
            this.loadedPluginNameMap = null;
        }
        if (this.tpInstance != null) {
            this.tpInstance.cleanupWhileOSGIExit();
        }
        instance = null;
        this.tpInstance = null;
    }

    public void clear() {
        if (null != this.tpInstance) {
            this.tpInstance.clear();
        }
    }

    public void clearAndReinitialize() {
        if (null != this.pluginList) {
            this.pluginList.clear();
            this.pluginList = null;
        }
        if (null != this.loadedPluginNames) {
            this.loadedPluginNames = null;
        }
        if (null != this.loadedPluginNameLst) {
            this.loadedPluginNameLst.clear();
            this.loadedPluginNameLst = null;
        }
        if (null != this.loadedPluginIdTable) {
            this.loadedPluginIdTable.clear();
            this.loadedPluginIdTable = null;
        }
        if (null != this.loadedPluginNameMap) {
            this.loadedPluginNameMap.clear();
            this.loadedPluginNameMap = null;
        }
        if (null != this.tpInstance) {
            this.tpInstance.clearAndReinitialize();
        }
        this.tpInstance = null;
    }

    public List<Plugin> getStartupFeaturePluginLst() {
        return this.startupFeaturePluginLst;
    }

    public static void populateFailedPluginModuleMap(String string, String string2) {
        if (null != string && null != string2) {
            failedPluginModuleMap.put(string, string2);
        }
    }

    public String getPluginFromModuleId(String string) {
        if (string != null) {
            return this.modulePluginMap.get(string);
        }
        return null;
    }

    public void reInitializePlugins() {
        if (Boolean.valueOf(System.getProperty("iView.ServerPlugins.Changed")).booleanValue() && PluginSubsystemUtilities.getStartupPluginNamesList() == null && !this.removedPluginsList.isEmpty()) {
            this.tpInstance.clearAndReinitialize();
            if (this.loadedPluginNameLst != null) {
                this.loadedPluginNameLst.clear();
                this.loadedPluginNameLst = null;
            }
            this.loadPlugins(new ArrayList<String>(this.removedPluginsList));
            for (String string : this.removedPluginsList) {
                Plugin plugin;
                if (!this.modulePluginMap.containsValue(string) || (plugin = this.getPluginFromLoadedPluginList(string)) == null) continue;
                this.addPluginInfoToList(plugin);
                plugin.getCommStyleParser();
                plugin.getIntegrateCommStyleReader();
            }
            this.removedPluginsList.clear();
            Collections.sort(this.pluginList, new Comparator<Plugin>(){

                @Override
                public int compare(Plugin plugin, Plugin plugin2) {
                    String string = plugin.getPluginName();
                    String string2 = plugin2.getPluginName();
                    return string.compareTo(string2);
                }
            });
            Collections.sort(this.loadedPluginNames);
        }
        this.reInitializeFailedPlugins();
        this.reinitializeDuplicatePlugins();
    }

    private void reInitializeFailedPlugins() {
        List<String> list = PluginSubsystemUtilities.getStartupPluginNamesList();
        if (null == list || list.isEmpty()) {
            return;
        }
        if (failedPluginModuleMap.isEmpty()) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(16);
        this.populateElementsFromMap(hashMap);
        Set<String> set = hashMap.keySet();
        String string = null;
        String string2 = null;
        for (String string3 : set) {
            Plugin plugin;
            string = hashMap.get(string3);
            string2 = this.modulePluginMap.get(string);
            if (list.contains(string2)) continue;
            this.removePluginInfo(string2);
            ArrayList<String> arrayList = new ArrayList<String>(10);
            arrayList.add(string3);
            this.loadPlugins(arrayList);
            if (!this.modulePluginMap.containsValue(string3) || (plugin = this.getPluginFromLoadedPluginList(string3)) == null) continue;
            this.addPluginInfoToList(plugin);
            plugin.getCommStyleParser();
            plugin.getIntegrateCommStyleReader();
        }
    }

    private void populateElementsFromMap(HashMap<String, String> hashMap) {
        String string = null;
        Set<String> set = failedPluginModuleMap.keySet();
        for (String string2 : set) {
            string = failedPluginModuleMap.get(string2);
            hashMap.put(string2, string);
        }
    }

    private Plugin getPluginFromLoadedPluginList(String string) {
        if (this.pluginList != null) {
            for (Plugin plugin : this.pluginList) {
                if (!string.equals(plugin.getPluginName())) continue;
                return plugin;
            }
            return null;
        }
        return null;
    }

    private void removePluginInfo(String string) {
        Plugin plugin = this.getPluginFromFolder(string);
        if (plugin == null) {
            if (this.loadedPluginNames.contains(string)) {
                this.loadedPluginNames.remove(string);
            }
            return;
        }
        String string2 = plugin.getModuleInfomation().getModuleLabel();
        String string3 = plugin.getModuleInfomation().getClassName();
        this.modulePluginMap.remove(plugin.getModuleInfomation().getModuleName());
        ModuleList.removeModuleId(string2);
        ModuleList.removeModuleClassName(string3);
        if (this.pluginList != null) {
            this.pluginList.remove(plugin);
        }
        if (this.loadedPluginNames != null) {
            this.loadedPluginNames.remove(plugin.getPluginName());
        }
        if (null != this.loadedPluginIdTable) {
            this.loadedPluginIdTable.remove(plugin.getId());
        }
        if (null != this.loadedPluginNameMap) {
            this.loadedPluginNameMap.remove(plugin.getPluginName());
        }
        this.tpInstance.removePlugin(plugin);
        if (this.loadedPluginNameLst != null) {
            this.loadedPluginNameLst.remove(plugin.getPluginName());
        }
        this.removedPluginsList.add(plugin.getPluginName());
    }

    private void addPluginInfoToList(Plugin plugin) {
        if (this.loadedPluginNameLst != null) {
            String string = plugin.getPluginName();
            if (string.endsWith(".jar")) {
                String string2 = null;
                string2 = string.substring(0, string.indexOf(".jar"));
                if (!this.loadedPluginNameLst.contains(string2)) {
                    this.loadedPluginNameLst.add(string2);
                }
            } else if (!this.loadedPluginNameLst.contains(string)) {
                this.loadedPluginNameLst.add(plugin.getPluginName());
            }
        }
        if (this.loadedPluginNameMap != null) {
            this.loadedPluginNameMap.put(plugin.getPluginName(), plugin);
        }
        if (null != this.loadedPluginIdTable) {
            this.loadedPluginIdTable.put(plugin.getId(), plugin);
        }
        this.tpInstance.addPlugin(plugin);
    }

    private void reinitializeDuplicatePlugins() {
        String string22;
        List<String> list = PluginSubsystemUtilities.getStartupPluginNamesList();
        if (null == list) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        if (this.loadedPluginNameLst != null) {
            this.loadedPluginNameLst.clear();
            this.loadedPluginNameLst = null;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(this.getLoadedPluginNames());
        arrayList2.removeAll(list);
        for (String string22 : arrayList2) {
            this.removePluginInfo(string22);
        }
        for (String string22 : list) {
            Plugin plugin = this.getPluginFromFolder(string22);
            if (plugin != null) continue;
            this.loadedPluginNames.remove(string22);
            arrayList.add(string22);
        }
        this.pluginsTobeLoaded(arrayList);
        if (arrayList.isEmpty()) {
            return;
        }
        HashSet hashSet = new HashSet(10);
        string22 = null;
        for (Plugin object : this.pluginList) {
            string22 = object.getModuleInfomation().getModuleLabel();
            hashSet.add(string22);
        }
        ModuleList.cleanupModuleListWhileOSGIExit();
        ModuleList.reAddModuleIds(hashSet);
        this.loadPlugins(arrayList);
        for (String string : arrayList) {
            Plugin plugin;
            if (!this.modulePluginMap.containsValue(string) || (plugin = this.getPluginFromLoadedPluginList(string)) == null) continue;
            this.addPluginInfoToList(plugin);
            plugin.getCommStyleParser();
            plugin.getIntegrateCommStyleReader();
        }
    }

    private void pluginsTobeLoaded(List<String> list) {
        List<String> list2 = null;
        list2 = FrameworkCommandProcessor.getInstance().isAppStyle() ? ApplicationUtilities.getPluginNamesOfAllApplications() : SubsystemManager.getInstance().getLoadedSubsystemAllPluginList();
        if (null == list2) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list);
        for (String string : arrayList) {
            if (list2.contains(string)) continue;
            list.remove(string);
        }
    }

    public List<Plugin> getPortalPlugins() {
        List<String> list = StartupXMLReader.getPortalPlugins();
        return this.getPlugins(list);
    }

    private List<Plugin> getPlugins(List<String> list) {
        Collections.sort(list);
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>(4);
        Plugin plugin = null;
        for (String string : list) {
            plugin = this.getPluginFromFolder(string);
            if (null == plugin) continue;
            arrayList.add(plugin);
        }
        return arrayList;
    }

    public void initializePlugins(List<String> list) {
        for (String string : list) {
            ProductHandlerManager.getInstance().notifyReadersOfOverridedPlugins(string);
        }
        List<Plugin> list2 = this.readPlugins("ApplicaitonStyle_plugins");
        failedPluginModuleMap = this.readFailedPlugins("ApplicaitonStyle_failedplugins");
        if (list2 == null) {
            this.loadPlugins(list);
            this.writePlugins((ArrayList)this.getLoadedPluginList(), "ApplicaitonStyle_plugins");
            if (!failedPluginModuleMap.isEmpty()) {
                this.writeFailedPlugins(failedPluginModuleMap, "ApplicaitonStyle_failedplugins");
            }
        } else {
            this.loadPluginsFromSerialization(list2, list);
        }
        this.updateAllAPIS(list);
    }

    private void updateAllAPIS(List<String> list) {
        for (String string : list) {
            Plugin plugin;
            if (!this.modulePluginMap.containsValue(string) || (plugin = this.getPluginFromLoadedPluginList(string)) == null) continue;
            this.addPluginInfoToList(plugin);
        }
    }

    public List<Plugin> getAllLoadedPlugins() {
        if (null != this.tpInstance) {
            return this.tpInstance.getAllLoadedPlugins();
        }
        return new ArrayList<Plugin>(1);
    }

    public List<Plugin> getStartupPluginList(String string) {
        if (this.tpInstance instanceof PortalPluginProcess) {
            return ((PortalPluginProcess)this.tpInstance).getStartupPluginList(string);
        }
        return this.getStartupPluginList();
    }

    public List<Plugin> getStartupLoadedPluginList(String string) {
        if (this.tpInstance instanceof PortalPluginProcess) {
            return ((PortalPluginProcess)this.tpInstance).getStartupLoadedPluginList(string);
        }
        return new ArrayList<Plugin>(1);
    }

    private void reinitializeProductHandlersOfStartupXMLPlugins(List<String> list) {
        if (StartupXMLReader.checkStartupXMLExists()) {
            for (String string : list) {
                ProductHandlerManager.getInstance().notifyReadersOfOverridedPlugins(string);
            }
        }
        if (null != this.loadedPluginNameLst) {
            this.loadedPluginNameLst.clear();
            this.loadedPluginNameLst = null;
        }
        if (null != this.loadedPluginIdTable) {
            this.loadedPluginIdTable.clear();
            this.loadedPluginIdTable = null;
        }
        if (null != this.loadedPluginNameMap) {
            this.loadedPluginNameMap.clear();
            this.loadedPluginNameMap = null;
        }
    }
}

