/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.pluginmanagement;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.framework.pluginmanagement.PluginUtil;
import com.swimap.iview.util.MetaDataTool;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.startup.StartupClassLoader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PluginDefinitionHandler {
    private static IviewLogger logger = IviewLogger.getLogger(PluginDefinitionHandler.class, "IVIEW");
    private static PluginDefinitionHandler instance = null;
    public static final String FILENAME = "PluginDef";
    public static final String CURR_DIR = System.getProperty("user.dir");
    public static final String PLUGINJARSDESCNAME = "pluginJarURLList";
    public static final String NORMALPLUGINDESCNAME = "normalPluginList";
    public static final String OSGIPLUGINDESCNAME = "osgiPluginList";
    private static final int JAR_INDEX = 4;
    private volatile boolean isConfigurationPresent = false;
    private List<File> fileURLs = new ArrayList<File>(16);
    private CommStyleInfo metaPluginInfo = null;
    private AreaDescContainer areaDesc = null;
    private List<String> pluginNames = new ArrayList<String>(16);

    public static PluginDefinitionHandler getPluginDefinitionHandler() {
        if (null == instance) {
            instance = new PluginDefinitionHandler();
        }
        return instance;
    }

    public void savePluginDef() {
        boolean bl = StartupClassLoader.getInstance().isNeedWrite();
        if (!bl && null == this.metaPluginInfo) {
            bl = true;
        }
        if (bl && null == this.metaPluginInfo) {
            this.metaPluginInfo = new CommStyleInfo();
            this.areaDesc = new AreaDescContainer();
            this.areaDesc.setAreaName(CURR_DIR);
            this.metaPluginInfo.addAreaDescContainer(this.areaDesc);
            DescContainer descContainer = null;
            Map map = StartupClassLoader.getInstance().getNormalPlugins();
            descContainer = this.createDescContainer(NORMALPLUGINDESCNAME, map);
            this.areaDesc.addDescContainer(descContainer);
            Map map2 = StartupClassLoader.getInstance().getOsgiPlugins();
            descContainer = this.createDescContainer(OSGIPLUGINDESCNAME, map2);
            this.areaDesc.addDescContainer(descContainer);
            descContainer = this.createDescContainer(PLUGINJARSDESCNAME);
            this.areaDesc.addDescContainer(descContainer);
            String string = MetaDataTool.getFileName(FILENAME);
            MetaDataTool.Write(this.metaPluginInfo, string);
        }
    }

    public void initialize() {
        String string = MetaDataTool.getFileName(FILENAME);
        this.metaPluginInfo = MetaDataTool.getData(string);
        if (null != this.metaPluginInfo) {
            this.areaDesc = this.metaPluginInfo.getAreaDescContainer(CURR_DIR);
            if (this.areaDesc != null) {
                this.isConfigurationPresent = true;
                this.populatePluginJarInfoToMap();
                this.readOsgiPluginURLS();
                this.readNormalPlugins();
                StartupClassLoader.getInstance().setConfigurationPresent(this.isConfigurationPresent);
            } else {
                this.metaPluginInfo = null;
            }
        }
    }

    public void populatePluginJarInfoToMap() {
        HashMap hashMap = new HashMap(16);
        if (this.metaPluginInfo != null) {
            DescContainer descContainer = this.areaDesc.getDescContainer(PLUGINJARSDESCNAME);
            int n = descContainer.getDescContainerCount();
            DescContainer descContainer2 = null;
            int n2 = 0;
            ArrayList<URL> arrayList = null;
            PARA pARA = null;
            for (int i = 0; i < n; ++i) {
                descContainer2 = descContainer.getDescContainer(i);
                n2 = descContainer2.getParasItemCount();
                arrayList = new ArrayList<URL>(16);
                for (int j = 0; j < n2; ++j) {
                    pARA = descContainer2.getParasItem(j);
                    try {
                        String string = pARA.getValue();
                        URL uRL = new URL(string);
                        arrayList.add(uRL);
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        logger.trace("Url is not found : file " + pARA.getValue(), malformedURLException);
                    }
                }
                hashMap.put(descContainer2.getDescName(), arrayList);
            }
        }
        StartupClassLoader.getInstance().setPluginJarURLsMap(hashMap);
    }

    private DescContainer createDescContainer(String string) {
        Map map = StartupClassLoader.getInstance().getPluginJarURLsMap();
        DescContainer descContainer = new DescContainer();
        descContainer.setDescName(string);
        Set set = map.keySet();
        DescContainer descContainer2 = null;
        int n = 0;
        List list = null;
        for (String string2 : set) {
            descContainer2 = new DescContainer();
            descContainer2.setDescName(string2);
            n = 0;
            list = (List)map.get(string2);
            for (URL uRL : list) {
                PARA pARA = new PARA();
                pARA.setName("url" + ++n);
                pARA.setValue(uRL.toString());
                descContainer2.addParasItem(pARA);
            }
            descContainer.addDescContainer(descContainer2);
        }
        return descContainer;
    }

    private DescContainer createDescContainer(String string, Map<String, String> map) {
        DescContainer descContainer = new DescContainer();
        descContainer.setDescName(string);
        Set<String> set = map.keySet();
        PARA pARA = null;
        for (String string2 : set) {
            pARA = new PARA();
            pARA.setName(string2);
            pARA.setValue(map.get(string2));
            descContainer.addParasItem(pARA);
        }
        return descContainer;
    }

    public void readNormalPlugins() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (null != this.metaPluginInfo) {
            DescContainer descContainer = this.areaDesc.getDescContainer(NORMALPLUGINDESCNAME);
            int n = descContainer.getParasItemCount();
            PARA pARA = null;
            String string = null;
            String string2 = null;
            File file = null;
            for (int i = 0; i < n; ++i) {
                pARA = descContainer.getParasItem(i);
                string = pARA.getName();
                string2 = pARA.getValue();
                treeMap.put(string, string2);
                if (string.endsWith("jar")) {
                    String string3;
                    int n2 = string.length();
                    string = string3 = string.substring(0, n2 - 4);
                    PluginUtil.PGN_JAR = true;
                }
                file = new File(string2);
                this.fileURLs.add(file);
                this.pluginNames.add(string);
            }
        }
        StartupClassLoader.getInstance().setNormalPlugins(treeMap);
    }

    public List<String> getPluginNamesFromXML() {
        return this.pluginNames;
    }

    public List<File> getFileURLs() {
        return this.fileURLs;
    }

    private void readOsgiPluginURLS() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (this.metaPluginInfo != null) {
            DescContainer descContainer = this.areaDesc.getDescContainer(OSGIPLUGINDESCNAME);
            int n = descContainer.getParasItemCount();
            PARA pARA = null;
            String string = null;
            String string2 = null;
            File file = null;
            for (int i = 0; i < n; ++i) {
                pARA = descContainer.getParasItem(i);
                string = pARA.getValue();
                string2 = pARA.getName();
                treeMap.put(string2, string);
                file = new File(string);
                this.fileURLs.add(file);
            }
        }
        StartupClassLoader.getInstance().setOsgiPlugins(treeMap);
    }

    public boolean isConfigurationPresent() {
        return this.isConfigurationPresent;
    }

    public void clear() {
        this.fileURLs.clear();
        this.pluginNames.clear();
        this.isConfigurationPresent = false;
        this.areaDesc = null;
        this.metaPluginInfo = null;
    }
}

