/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.outputmanagement;

import java.awt.FontMetrics;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

final class ScrollHelper {
    private JScrollPane scrollPane = null;
    private JTextArea textArea = null;
    private int lineHeight = 0;

    ScrollHelper(JScrollPane jScrollPane, JTextArea jTextArea) {
        this.scrollPane = jScrollPane;
        this.textArea = jTextArea;
        FontMetrics fontMetrics = jTextArea.getFontMetrics(jTextArea.getFont());
        this.lineHeight = fontMetrics.getHeight();
    }

    final void scrollToEnd() {
        this.scroll(true, 0);
    }

    final void scrollToFit(int n) {
        this.scroll(false, n);
    }

    private void scroll(final boolean bl, final int n) {
        if (this.scrollPane == null) {
            return;
        }
        final JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        if (jScrollBar != null && jScrollBar.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (bl) {
                        if ("1.4".equals(System.getProperty("java.version").substring(0, 3))) {
                            int n3 = ScrollHelper.this.textArea.getSelectionStart();
                            int n2 = ScrollHelper.this.textArea.getSelectionEnd();
                            jScrollBar.setValue(ScrollHelper.this.textArea.getText().length());
                            ScrollHelper.this.textArea.select(n3, n2);
                        } else {
                            jScrollBar.setValue(ScrollHelper.this.textArea.getText().length());
                        }
                    } else {
                        jScrollBar.setValue(n);
                    }
                }
            });
        }
    }

    final int computeScrollBarValue(int n) {
        return this.textArea.getVisibleRect().y - this.lineHeight * n;
    }
}

