/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.outputmanagement;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.CommStyleParserFactory;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.IProfileParser;
import com.swimap.iview.commstyle.commini.LocalProfileParser;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.corbahelpers.EventPayload;
import com.swimap.iview.corbahelpers.InternalEvent;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.outputmanagement.IOutputManager;
import com.swimap.iview.framework.outputmanagement.MaxLineNumSetting;
import com.swimap.iview.framework.outputmanagement.OutputConfig;
import com.swimap.iview.framework.outputmanagement.ScrollHelper;
import com.swimap.iview.framework.outputmanagement.UIStateHelper;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.tabbedpane.CloseableTabbedPane;
import com.swimap.iview.templates.tabbedpane.CloseableTabbedPaneListener;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.omg.CORBA.ORB;

public class OutputManager
extends BaseModule
implements IOutputManager {
    private static IviewLogger logger = IviewLogger.getLogger(OutputManager.class, "IVIEW");
    private OutputPanel commonOutputPanel = null;
    private static OutputPanel commonOutputPanelStatic = null;
    private OutputConfig commonOutputConfig = null;
    private CloseableTabbedPane outputTabbedPane = new CloseableTabbedPane();
    private Hashtable outputTabbedPaneStore = new Hashtable(5);
    protected static final ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/outputmanagement/Res");
    private String commonTitle = res.getString("OutputManager_Common");
    private boolean tabbedPaneStyle = false;
    private static final String DEFAULTDUMPPATH = "./autoput.txt";
    private boolean isMessageBuffered = false;
    public static final String OUTPUT_STYLE_AREA_NAME = "outputpane";
    public static final String OUTPUT_STYLE_DESC_NAME = "outputpane";
    public static final String MAX_LINENUM_PARA_NAME = "maxlinenum";
    public static final String LOCK_SCROLL_PARA_NAME = "lockscroll";
    public static final String TABBEDPANESTYLE_PARA_NAME = "tabbedPanestyle";
    public static final String IS_SHOWMSGTIME_PARA_NAME = "showtime";
    public static final String DEFAULT_HEIGHT_PARA_NAME = "defaultheight";
    public static final String VISIBLE_PARA_NAME = "visible";
    public static final String MESSAGEBUFFER_PARA_NAME = "messagebuffer";
    public static final String DISPLACE_FILE_NAME = "displacefile";
    public static final String DISPLACE_LINE_NUM = "displacenum";
    public static final String IS_DISPLACE = "isdisplace";
    public static final int MAX_LINE_NUM = 3000;
    public static final int MIN_LINE_NUM = 30;
    public static final int MIN_DISPLACE_NUM = 20;
    protected boolean windowShow = false;
    protected String moduleName = "output module(undefined)";
    public static String settingItemName = "OutputManagerSetting";
    public String styleFileName = null;
    private String currentDisplaceFileName = null;
    private static boolean autoScroll = true;
    private static int defaultHeight = 1;
    private static boolean isDisplace = false;
    private static File currentDisplaceFile = null;
    BufferedWriter currentDisplaceBufferedWriter = null;
    private String backString = ".bak";
    private long outputBufferUpdateTime;
    private boolean isFindMenuItemVisible = true;
    private boolean outputWindowVisible = true;
    private Dimension outputWindowSize = null;
    private static final Dimension INITIAL_SIZE = new Dimension(0, 21);
    private static boolean customizeOutput = false;
    private static boolean isSettingsNeeded = true;
    private IProfileParser profileParser = null;

    public OutputManager(ModuleManager moduleManager, ORB oRB, String string, String string2, String string3) throws ModuleManagementException {
        super(moduleManager, oRB, string, string2);
        this.moduleName = string3;
        this.initializeTabbedPane();
        this.register(this);
        String string4 = System.getProperty("iview.outputsetting.findMenuItemVisible");
        if (string4 != null) {
            this.isFindMenuItemVisible = Boolean.valueOf(string4.trim());
        }
        this.commonOutputConfig = new OutputConfig(500, true, true, this.isFindMenuItemVisible);
        commonOutputPanelStatic = this.commonOutputPanel = new OutputPanel(this.commonOutputConfig);
        this.setDefaultSaveFileName("autoput.txt");
    }

    private void initializeTabbedPane() {
        this.outputTabbedPane.setName("OutputManager_outputTabbedPane");
        this.outputTabbedPane.addCloseableTabbedPaneListener(new CloseableTabbedPaneListener(){

            @Override
            public void tabClosed(Component component) {
                OutputManager.this.refreshDisplay();
            }

            @Override
            public boolean tabClosing(Component component) {
                if (customizeOutput) {
                    int n = OutputManager.this.outputTabbedPane.getSelectedIndex();
                    String string = OutputManager.this.outputTabbedPane.getTitleAt(n);
                    BaseModule baseModule = OutputManager.this.moduleManager.getLocalModule("mainoutputbarsetting");
                    if (baseModule instanceof MaxLineNumSetting) {
                        ((MaxLineNumSetting)baseModule).updateOutputSettingCombo(string, false);
                    }
                }
                return true;
            }
        });
    }

    public OutputManager(ModuleManager moduleManager, String string) throws ModuleManagementException {
        this(moduleManager, null, null, null, string);
    }

    boolean isRemoteProfile() {
        if (null == this.profileParser) {
            CommStyleParserFactory commStyleParserFactory = CommStyleParserFactory.getInstance();
            this.profileParser = commStyleParserFactory.createProfileParser();
        }
        return !(this.profileParser instanceof LocalProfileParser);
    }

    public void setDefaultSaveFileName(String string) {
        this.commonOutputConfig.setDefaultSaveFileName(string);
    }

    void setUserFileEncoding(String string) {
        for (OutputPanel outputPanel : this.outputTabbedPaneStore.values()) {
            if (null == outputPanel) continue;
            outputPanel.setUserFileEncoding(string);
        }
        this.commonOutputPanel.setUserFileEncoding(string);
    }

    public void sendEventToSettingItem() {
        this.sendEventToSettingItem(this.commonOutputConfig);
    }

    public void sendEventToSettingItem(OutputConfig outputConfig) {
        if (null == this.getSettingItemName()) {
            return;
        }
        InternalEvent internalEvent = new InternalEvent();
        EventPayload eventPayload = new EventPayload();
        eventPayload.properties = new String[5];
        eventPayload.values = new String[5];
        eventPayload.properties[0] = "autoscroll";
        eventPayload.values[0] = String.valueOf(outputConfig.isAutoScroll());
        eventPayload.properties[1] = MAX_LINENUM_PARA_NAME;
        eventPayload.values[1] = String.valueOf(outputConfig.getMaxLineNum());
        eventPayload.properties[2] = IS_DISPLACE;
        eventPayload.values[2] = String.valueOf(outputConfig.isDisplace());
        eventPayload.properties[3] = "displacefilename";
        eventPayload.values[3] = String.valueOf(outputConfig.getCurrentDisplaceFile());
        eventPayload.properties[4] = DISPLACE_LINE_NUM;
        eventPayload.values[4] = String.valueOf(outputConfig.getDisplaceNum());
        internalEvent.payload = eventPayload;
        internalEvent.eventId = 112;
        try {
            this.sendEvent(this.getSettingItemName(), internalEvent);
        }
        catch (ModuleManagementException moduleManagementException) {
            logger.trace(moduleManagementException.getMessage(), moduleManagementException);
        }
    }

    @Override
    public void setMaxLineNum(int n) {
        this.commonOutputConfig.setMaxLineNum(n);
    }

    public OutputConfig getCommonOutputConfig() {
        return this.commonOutputConfig;
    }

    public void setDisplaceNum(String string) {
        this.commonOutputConfig.setDisplaceNum(string);
    }

    public void setDisplaceFileName(String string) {
        if (this.currentDisplaceFileName != null && this.currentDisplaceFileName.equals(string)) {
            return;
        }
        if (string.indexOf(".") == 0) {
            string = System.getProperty("user.dir") + System.getProperty("file.separator") + string.substring(2);
        }
        this.currentDisplaceFileName = string;
        if (this.currentDisplaceBufferedWriter != null) {
            try {
                this.currentDisplaceBufferedWriter.close();
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
        }
        this.commonOutputConfig.setCurrentDisplaceFile(string);
    }

    @Override
    public int getMaxLineNum() {
        return this.commonOutputConfig.getMaxLineNum();
    }

    public String getDisplaceNum() {
        return this.commonOutputConfig.getDisplaceNum();
    }

    public String getDisplaceFileName() {
        return this.currentDisplaceFileName;
    }

    public boolean isTabbedPaneStyle() {
        return this.tabbedPaneStyle;
    }

    public String getCommonTitle() {
        return this.commonTitle;
    }

    @Override
    public synchronized boolean addMessage(String string, String string2) {
        if (null == this.commonOutputPanel) {
            return false;
        }
        return this.commonOutputPanel.addMessage(string2, false);
    }

    public synchronized boolean addMultiMessage(String string) {
        if (null == this.commonOutputPanel) {
            return false;
        }
        return this.commonOutputPanel.addMessage(string, true);
    }

    public void loadOutputStyle(String string) {
        this.styleFileName = string;
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getUserProductDefaultCommonStyleFile(string);
        if (null == commStyleInfo) {
            logger.error("Load style error, can not get the style info fromstyle file.");
            return;
        }
        try {
            Object object;
            String string2 = commStyleInfo.getParasItemValue("outputpane", "outputpane", MAX_LINENUM_PARA_NAME);
            String string3 = commStyleInfo.getParasItemValue("outputpane", "outputpane", LOCK_SCROLL_PARA_NAME);
            String string4 = commStyleInfo.getParasItemValue("outputpane", "outputpane", TABBEDPANESTYLE_PARA_NAME);
            String string5 = commStyleInfo.getParasItemValue("outputpane", "outputpane", IS_SHOWMSGTIME_PARA_NAME);
            String string6 = DEFAULTDUMPPATH;
            if (this.isRemoteProfile()) {
                object = CommStyleManager.getInstance().getUserCommonStyleFileAtClient(string);
                if (null != object) {
                    string6 = ((CommStyleInfo)object).getParasItemValue("outputpane", "outputpane", DISPLACE_FILE_NAME);
                }
            } else {
                string6 = commStyleInfo.getParasItemValue("outputpane", "outputpane", DISPLACE_FILE_NAME);
            }
            object = commStyleInfo.getParasItemValue("outputpane", "outputpane", DISPLACE_LINE_NUM);
            String string7 = commStyleInfo.getParasItemValue("outputpane", "outputpane", IS_DISPLACE);
            String string8 = commStyleInfo.getParasItemValue("outputpane", "outputpane", DEFAULT_HEIGHT_PARA_NAME);
            String string9 = commStyleInfo.getParasItemValue("outputpane", "outputpane", VISIBLE_PARA_NAME);
            String string10 = commStyleInfo.getParasItemValue("outputpane", "outputpane", MESSAGEBUFFER_PARA_NAME);
            if (string9 != null && "false".equalsIgnoreCase(string9.trim())) {
                this.displayOutputWindow(false);
            } else {
                this.displayOutputWindow(true);
            }
            if (string8 != null && string8.length() > 0) {
                this.setHeight(Integer.parseInt(string8));
            }
            if (string2 != null && string2.length() > 0) {
                int n = Integer.parseInt(string2);
                logger.trace("OutputManager-loadOutputStyle,read maxLineNum:" + n);
                if (n < 30) {
                    n = 30;
                }
                if (n > 3000) {
                    n = 3000;
                }
                this.setMaxLineNum(n);
            }
            this.setDisplaceNum((String)object);
            if (this.displaceFileValidation(string6)) {
                this.setDisplaceFileName(string6.trim());
            } else {
                this.setDisplaceFileName(DEFAULTDUMPPATH);
            }
            this.setAutoScrolls(string3 == null ? false : !"true".equalsIgnoreCase(string3.trim()));
            this.setDisplace(string7 == null ? false : "true".equalsIgnoreCase(string7.trim()));
            this.tabbedPaneStyle = string4 == null ? false : "true".equalsIgnoreCase(string4.trim());
            this.setShowMsgTime(string5 == null ? true : "true".equalsIgnoreCase(string5.trim()));
            this.setEnableMessageBuffer(string10 == null ? false : "true".equalsIgnoreCase(string10.trim()));
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        this.fitLineCount();
        if (isSettingsNeeded) {
            this.sendEventToSettingItem();
        }
    }

    public void writeBackOutputStyle(String string) {
        this.writeBackOutputStyle(string, this.commonOutputConfig);
    }

    OutputConfig getOutputConfig(String string) {
        OutputPanel outputPanel = (OutputPanel)this.outputTabbedPaneStore.get(string);
        return outputPanel.getOutputConfig();
    }

    public void writeBackOutputStyle(String string, OutputConfig outputConfig) {
        CommStyleInfo commStyleInfo = null;
        try {
            commStyleInfo = CommStyleManager.getInstance().getUserProductDefaultCommonStyleFile(string);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        if (null == commStyleInfo) {
            logger.error("write style error, can not get the style info from style file.");
            return;
        }
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer("outputpane");
        if (null == areaDescContainer) {
            logger.error("write style error, can not get the area info from style file.");
            return;
        }
        String string2 = outputConfig.getOutputConfigName();
        DescContainer descContainer = null;
        if (string2.length() == 0 || this.getCommonTitle().equalsIgnoreCase(string2)) {
            descContainer = areaDescContainer.getDescContainer("outputpane");
        } else if (string2.length() > 0 && null == (descContainer = areaDescContainer.getDescContainer(string2))) {
            descContainer = this.createDescContainer(string2);
            areaDescContainer.addDescContainer(descContainer);
        }
        if (null == descContainer) {
            logger.error("write style error, can not get the desc info from style file.");
            return;
        }
        descContainer.setParasItem(MAX_LINENUM_PARA_NAME, String.valueOf(outputConfig.getMaxLineNum()));
        descContainer.setParasItem(LOCK_SCROLL_PARA_NAME, String.valueOf(!outputConfig.isAutoScroll()));
        descContainer.setParasItem(TABBEDPANESTYLE_PARA_NAME, String.valueOf(this.tabbedPaneStyle));
        descContainer.setParasItem(IS_DISPLACE, String.valueOf(outputConfig.isDisplace()));
        descContainer.setParasItem(DISPLACE_LINE_NUM, String.valueOf(outputConfig.getDisplaceNum()));
        descContainer.setParasItem(DISPLACE_FILE_NAME, outputConfig.getCurrentDisplaceFile());
        descContainer.setParasItem(VISIBLE_PARA_NAME, String.valueOf(this.outputWindowVisible));
        try {
            CommStyleManager.getInstance().writeToServer(commStyleInfo);
            if (this.isRemoteProfile()) {
                CommStyleManager.getInstance().writeToUserAtClient(commStyleInfo);
            }
        }
        catch (IOException iOException) {
            logger.trace(iOException.getMessage(), iOException);
            MaxLineNumSetting.outputsettingfailed = true;
        }
    }

    private DescContainer createDescContainer(String string) {
        DescContainer descContainer = new DescContainer(string);
        PARA pARA = new PARA();
        pARA.setName(MAX_LINENUM_PARA_NAME);
        PARA pARA2 = new PARA();
        pARA2.setName(LOCK_SCROLL_PARA_NAME);
        PARA pARA3 = new PARA();
        pARA3.setName(IS_DISPLACE);
        PARA pARA4 = new PARA();
        pARA4.setName(DISPLACE_LINE_NUM);
        PARA pARA5 = new PARA();
        pARA5.setName(DISPLACE_FILE_NAME);
        descContainer.addParasItem(pARA);
        descContainer.addParasItem(pARA2);
        descContainer.addParasItem(pARA3);
        descContainer.addParasItem(pARA4);
        descContainer.addParasItem(pARA5);
        return descContainer;
    }

    public void writeBackOutputStyle() {
        if (null != this.styleFileName) {
            this.writeBackOutputStyle(this.styleFileName);
        } else {
            logger.error("The write back is no execute because the style file not set.");
        }
    }

    @Override
    public void reinitialize() {
        UIStateHelper.getInstance().initUIList();
        this.loadOutputStyle("conf/mainfrm/outputpane");
        UIStateHelper.getInstance().setUISelected(this.outputWindowVisible);
        if (this.isTabbedPaneStyle()) {
            this.getOutputTabbedPane().add((Component)this.getOutputPane(), this.getCommonTitle());
            this.getOutputTabbedPane().setTabPlacement(3);
            this.getOutputTabbedPane().setMinimumSize(new Dimension(0, 0));
            ((MDIFrame)FrameworkUtilities.getMainFrame()).setBottomComponent(this.getOutputTabbedPane());
        }
        this.setUpdateTime();
    }

    private void setUpdateTime() {
        String string = System.getProperty("iview.outputbufferupdatetime", "5000");
        try {
            this.outputBufferUpdateTime = (int)Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.outputBufferUpdateTime = 5000L;
        }
    }

    @Override
    public void clear() {
        boolean bl = this.clearAllLogs();
        if (!bl) {
            logger.warn("clear all logs failed.");
        }
        if (this.isMessageBuffered) {
            for (OutputPanel outputPanel : this.outputTabbedPaneStore.values()) {
                outputPanel.checkCondition = false;
                outputPanel.clearMessageBufferLength();
            }
            this.commonOutputPanel.checkCondition = false;
            this.commonOutputPanel.clearMessageBufferLength();
        }
        this.resetOutputPanel();
        UIStateHelper.getInstance().clear();
        this.outputWindowVisible = true;
    }

    @Override
    public void stop() {
        super.stop();
        this.resetOutputPanel();
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    public void setWindowShow(boolean bl) {
        this.windowShow = bl;
    }

    public boolean getWindowShow() {
        return this.windowShow;
    }

    public boolean addTabPane(String string) {
        return this.addTabPane(string, new OutputConfig());
    }

    public boolean addTabPane(String string, OutputConfig outputConfig) {
        OutputPanel outputPanel;
        boolean bl;
        if (outputConfig == null) {
            logger.trace("outputConfig is null, use commonOutputConfig instead.");
            outputConfig = new OutputConfig();
        }
        if (bl = this.addTabPane(string, (outputPanel = new OutputPanel(outputConfig)).getOutputPane())) {
            this.outputTabbedPaneStore.put(string, outputPanel);
            if (customizeOutput) {
                outputConfig.setOutputConfigName(string);
                BaseModule baseModule = this.moduleManager.getLocalModule("mainoutputbarsetting");
                if (baseModule instanceof MaxLineNumSetting) {
                    outputConfig.setCurrentDisplaceFile(((MaxLineNumSetting)baseModule).getOutputDumpFileName(string));
                    outputConfig.setDisplace(this.isAutoDisplace());
                    outputConfig.setDisplaceNum(this.getDisplaceNum());
                    ((MaxLineNumSetting)baseModule).updateOutputSettingCombo(string, true);
                    this.writeBackOutputStyle("conf/mainfrm/outputpane", outputConfig);
                }
            }
        }
        return bl;
    }

    public boolean addTabPane(String string, JPanel jPanel) {
        return this.addTabPane(string, jPanel, false);
    }

    public boolean addTabPane(String string, JPanel jPanel, boolean bl) {
        boolean bl2 = false;
        if (string == null || string.length() == 0 || jPanel == null) {
            logger.error("The parameter is not correct.");
            return bl2;
        }
        if (this.outputTabbedPane.indexOfTab(string) >= 0) {
            logger.error("The key :" + string + " it is  already exist.");
            return bl2;
        }
        int n = this.outputTabbedPane.getTabCount();
        if (n == 0) {
            this.outputTabbedPane.addCloseableTab(this.commonTitle, this.commonOutputPanel.getOutputPane(), false);
            BaseModule baseModule = this.moduleManager.getLocalModule("mainoutputbarsetting");
            if (baseModule instanceof MaxLineNumSetting) {
                ((MaxLineNumSetting)baseModule).updateOutputSettingCombo(this.commonTitle, true);
            }
            this.outputTabbedPane.setTabPlacement(3);
            this.outputTabbedPane.setMinimumSize(new Dimension(0, 50));
            Dimension dimension = this.commonOutputPanel.getOutputPane().getSize();
            this.outputTabbedPane.setSize(dimension);
            ((MDIFrame)FrameworkUtilities.getMainFrame()).setBottomComponent(this.outputTabbedPane);
            Dimension dimension2 = this.commonOutputPanel.getOutputPane().getSize();
            Dimension dimension3 = new Dimension(dimension2.width, dimension2.height + 30);
            this.outputTabbedPane.setPreferredSize(dimension3);
        }
        this.outputTabbedPane.addCloseableTab(string, jPanel, bl);
        this.outputTabbedPane.validate();
        bl2 = true;
        return bl2;
    }

    public boolean deleteTabPane(String string) {
        boolean bl = true;
        if (this.commonTitle.equals(string)) {
            return false;
        }
        int n = this.outputTabbedPane.indexOfTab(string);
        Object v = this.outputTabbedPaneStore.get(string);
        if (v instanceof OutputPanel && v != this.commonOutputPanel) {
            ((OutputPanel)v).deteteSettingMenuItem();
            ((OutputPanel)v).checkCondition = false;
        }
        if (n != -1) {
            this.outputTabbedPane.removeTabAt(this.outputTabbedPane.indexOfTab(string));
            this.outputTabbedPaneStore.remove(string);
            BaseModule baseModule = this.moduleManager.getLocalModule("mainoutputbarsetting");
            if (baseModule instanceof MaxLineNumSetting) {
                ((MaxLineNumSetting)baseModule).updateOutputSettingCombo(string, false);
            }
        }
        this.refreshDisplay();
        return bl;
    }

    private void refreshDisplay() {
        Dimension dimension = this.commonOutputPanel.getOutputPane().getSize();
        if (this.outputTabbedPane.getTabCount() == 1 && !this.isTabbedPaneStyle()) {
            this.commonOutputPanel.getOutputPane().setMinimumSize(new Dimension(0, 21));
            Dimension dimension2 = new Dimension(dimension.width, dimension.height);
            this.commonOutputPanel.getOutputPane().setPreferredSize(dimension2);
            ((MDIFrame)FrameworkUtilities.getMainFrame()).setBottomComponent(this.commonOutputPanel.getOutputPane());
        }
    }

    private void resetOutputPanel() {
        ((MDIFrame)FrameworkUtilities.getMainFrame()).setBottomComponent(this.commonOutputPanel.getOutputPane());
        this.resetOutputSize();
        this.outputTabbedPane.removeAll();
        this.outputTabbedPaneStore.clear();
    }

    private void resetOutputSize() {
        this.commonOutputPanel.getOutputPane().setSize(INITIAL_SIZE);
        this.commonOutputPanel.getOutputPane().setPreferredSize(INITIAL_SIZE);
    }

    public boolean setCommonTabTitle(String string) {
        if (this.outputTabbedPane.getTabCount() > 0) {
            this.outputTabbedPane.setTitleAt(0, string);
        }
        this.commonTitle = string;
        return true;
    }

    public synchronized boolean addMessage(String string, String string2, String string3) {
        if (null == string3) {
            logger.warn("Output panel is null");
            this.addMessage(string, string2);
            return false;
        }
        Object v = this.outputTabbedPaneStore.get(string3);
        if (v == null) {
            logger.warn("Can't find output panel for title:" + string3);
            this.addMessage(string, string2);
            return false;
        }
        return ((OutputPanel)v).addMessage(string2, false);
    }

    public void setHeight(int n) {
        if (n > defaultHeight) {
            this.commonOutputPanel.textArea.setRows(n);
        } else {
            this.commonOutputPanel.textArea.setRows(defaultHeight);
        }
    }

    public void setDisplace(boolean bl) {
        isDisplace = bl;
        this.commonOutputConfig.setDisplace(bl);
    }

    @Override
    public boolean setAutoScrolls(boolean bl) {
        return this.commonOutputPanel.setAutoScroll(bl);
    }

    public static boolean isAutoScrolls() {
        return autoScroll;
    }

    public boolean isAutomaticScrolls() {
        return this.commonOutputConfig.isAutoScroll();
    }

    public void setShowMsgTime(boolean bl) {
        this.commonOutputConfig.setShowMsgTime(bl);
    }

    public void setEnableMessageBuffer(boolean bl) {
        this.isMessageBuffered = bl;
    }

    public static boolean isDisplace() {
        return isDisplace;
    }

    public boolean isAutoDisplace() {
        return this.commonOutputConfig.isDisplace();
    }

    @Override
    public boolean clearSelectedLogs() {
        OutputPanel outputPanel = null;
        boolean bl = this.commonOutputPanel.clearSelectedLogs();
        Enumeration enumeration = null;
        if (!this.outputTabbedPaneStore.isEmpty()) {
            enumeration = this.outputTabbedPaneStore.keys();
            while (enumeration.hasMoreElements()) {
                outputPanel = this.getOutputPanel((String)enumeration.nextElement());
                if (outputPanel != null) {
                    outputPanel.clearSelectedLogs();
                    continue;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean clearAllLogs() {
        boolean bl = this.commonOutputPanel.clearAllLogs();
        OutputPanel outputPanel = null;
        Enumeration enumeration = null;
        if (!this.outputTabbedPaneStore.isEmpty()) {
            enumeration = this.outputTabbedPaneStore.keys();
            while (enumeration.hasMoreElements()) {
                outputPanel = this.getOutputPanel((String)enumeration.nextElement());
                if (outputPanel != null) {
                    outputPanel.clearAllLogs();
                    continue;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean clearIndexTabLogs(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        OutputPanel outputPanel = this.getOutputPanel(string);
        if (outputPanel == null) {
            return false;
        }
        outputPanel.clearMessageBufferLength();
        return outputPanel.clearAllLogs();
    }

    @Override
    public JPanel getOutputPane() {
        if (this.commonOutputPanel != null) {
            return this.commonOutputPanel.getOutputPane();
        }
        return null;
    }

    public OutputPanel getOutputPanel(String string) {
        if (string.equals(this.commonTitle) || string.equals("outputpane")) {
            return this.commonOutputPanel;
        }
        return (OutputPanel)this.outputTabbedPaneStore.get(string);
    }

    public JTabbedPane getOutputTabbedPane() {
        return this.outputTabbedPane;
    }

    @Override
    public void launchMaxLineNumSetting() {
        if (null == this.getSettingItemName()) {
            return;
        }
        FrameworkUtilities.getSystemSettingsManager().activeWindow = this.getSettingItemName();
        FrameworkUtilities.getSystemSettingsManager().launchSystemSettingsDialog();
    }

    public void fitLineCount() {
        OutputPanel outputPanel = null;
        Enumeration enumeration = null;
        if (!this.outputTabbedPaneStore.isEmpty()) {
            enumeration = this.outputTabbedPaneStore.keys();
            while (enumeration.hasMoreElements()) {
                outputPanel = this.getOutputPanel((String)enumeration.nextElement());
                if (outputPanel == null) continue;
                outputPanel.fitLineCount();
            }
        }
    }

    public final void fitLineCountApplied() {
        if (this.commonOutputPanel != null) {
            this.commonOutputPanel.fitLineCountApplied();
        }
    }

    public void setSettingItemName(String string) {
        settingItemName = string;
        this.updateSettingMenuItem();
    }

    public String getSettingItemName() {
        return settingItemName;
    }

    public void updateSettingMenuItem() {
        this.commonOutputPanel.updateSettingMenuItem();
        OutputPanel outputPanel = null;
        Enumeration enumeration = null;
        if (!this.outputTabbedPaneStore.isEmpty()) {
            enumeration = this.outputTabbedPaneStore.keys();
            while (enumeration.hasMoreElements()) {
                outputPanel = this.getOutputPanel((String)enumeration.nextElement());
                if (outputPanel == null) continue;
                outputPanel.updateSettingMenuItem();
            }
        }
    }

    public int getRowHeight() {
        return this.commonOutputPanel.getRowHeight();
    }

    public boolean isHorizontalScrollBarVisible() {
        return this.commonOutputPanel.getScrollPane().getHorizontalScrollBar().isVisible();
    }

    public void displayOutputWindow() {
        JTabbedPane jTabbedPane = this.getOutputTabbedPane();
        boolean bl = jTabbedPane.getTabCount() > 0;
        MDIFrame mDIFrame = (MDIFrame)FrameworkUtilities.getMainFrame();
        if (this.outputWindowVisible) {
            mDIFrame.setBottomComponent(null);
            this.outputWindowSize = bl ? jTabbedPane.getSize() : this.getOutputPane().getSize();
            mDIFrame.showOutputPane(false);
            mDIFrame.getRootPane().requestFocus();
            this.outputWindowVisible = false;
        } else {
            if (bl) {
                mDIFrame.setBottomComponent(jTabbedPane);
                jTabbedPane.setSize(this.outputWindowSize);
                jTabbedPane.setPreferredSize(this.outputWindowSize);
            } else {
                mDIFrame.setBottomComponent(this.getOutputPane());
                this.getOutputPane().setSize(this.outputWindowSize);
                this.getOutputPane().setPreferredSize(this.outputWindowSize);
            }
            mDIFrame.showOutputPane(true);
            mDIFrame.requestFocus();
            this.outputWindowVisible = true;
            this.flushAllBufferMessages();
        }
        UIStateHelper.getInstance().setUISelected(this.outputWindowVisible);
        this.writeBackOutputStyle();
    }

    private void flushAllBufferMessages() {
        for (OutputPanel outputPanel : this.outputTabbedPaneStore.values()) {
            if (null == outputPanel) continue;
            outputPanel.flushBufferMessageToOutput();
        }
        this.commonOutputPanel.flushBufferMessageToOutput();
    }

    private void displayOutputWindow(boolean bl) {
        if (this.outputWindowVisible != bl) {
            this.displayOutputWindow();
        }
    }

    public void setOutputWindowVisible(boolean bl) {
        this.outputWindowVisible = bl;
    }

    public static boolean isCustomizeOutput() {
        return customizeOutput;
    }

    public static void setCustomizeOutput(boolean bl) {
        customizeOutput = bl;
        commonOutputPanelStatic.addChangePanelListener();
    }

    public void writeBackOutputStyleToServer() throws IOException {
        if (null != this.styleFileName) {
            CommStyleInfo commStyleInfo = null;
            try {
                commStyleInfo = CommStyleManager.getInstance().getUserProductDefaultCommonStyleFile(this.styleFileName);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            if (null == commStyleInfo) {
                logger.error("write style error, can not get the style info from style file.");
                return;
            }
            AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer("outputpane");
            if (null == areaDescContainer) {
                logger.error("write style error, can not get the area info from style file.");
                return;
            }
            DescContainer descContainer = areaDescContainer.getDescContainer("outputpane");
            if (null == descContainer) {
                logger.error("write style error, can not get the desc info from style file.");
                return;
            }
            descContainer.setParasItem(MAX_LINENUM_PARA_NAME, String.valueOf(this.commonOutputConfig.getMaxLineNum()));
            descContainer.setParasItem(LOCK_SCROLL_PARA_NAME, String.valueOf(!this.isAutomaticScrolls()));
            descContainer.setParasItem(TABBEDPANESTYLE_PARA_NAME, String.valueOf(this.tabbedPaneStyle));
            descContainer.setParasItem(IS_DISPLACE, String.valueOf(this.isAutoDisplace()));
            descContainer.setParasItem(DISPLACE_LINE_NUM, String.valueOf(this.getDisplaceNum()));
            descContainer.setParasItem(DISPLACE_FILE_NAME, this.commonOutputConfig.getCurrentDisplaceFile());
            descContainer.setParasItem(VISIBLE_PARA_NAME, String.valueOf(this.outputWindowVisible));
            CommStyleManager.getInstance().writeToServer(commStyleInfo);
        } else {
            logger.error("The write back is no execute because the style file not set.");
        }
    }

    public static void setSettingsNeeded(boolean bl) {
        isSettingsNeeded = bl;
    }

    private boolean displaceFileValidation(String string) {
        return null != string && !string.trim().equals("null") && !string.trim().equals("");
    }

    public class OutputPanel {
        private JPanel outputPane = null;
        private JTextArea textArea = null;
        private JCheckBoxMenuItem autoScrollItem = null;
        private JMenuItem settingItem = null;
        private JScrollPane scrollPane = null;
        private int cutTextLength = 0;
        private static final long MAX_FILE_CAPABILITY = 0x500000L;
        private final String COLON_SAPERATOR = res.getString("Colon_separator");
        private String lastBlank = "";
        private boolean showDisplaceFailedMessage = true;
        private OutputConfig outputConfig = null;
        private ScrollHelper scrollHelper = null;
        private StringBuffer messageBuffer = new StringBuffer();
        private StringBuffer bufferForNonBufferMessage = new StringBuffer();
        private int bufferForNonBufferMessageLineCount = 0;
        private Thread bufferFlushThread = null;
        private Object lock = new Object();
        private boolean checkCondition = true;
        private String userFileEncoding = "UTF-8";

        public OutputPanel() {
            this(outputManager.commonOutputConfig);
        }

        public OutputPanel(OutputConfig outputConfig) {
            this.init(outputConfig);
        }

        public void addChangePanelListener() {
            final OutputConfig outputConfig = this.outputConfig;
            this.textArea.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    String string = outputConfig.getOutputConfigName();
                    if (0 == string.length()) {
                        string = OutputManager.this.commonTitle;
                    }
                    BaseModule baseModule = OutputManager.this.moduleManager.getLocalModule("mainoutputbarsetting");
                    if (SwingUtilities.isRightMouseButton(mouseEvent) && baseModule instanceof MaxLineNumSetting) {
                        ((MaxLineNumSetting)baseModule).setOutputSettingCombo(string);
                    }
                }
            });
        }

        void setUserFileEncoding(String string) {
            this.userFileEncoding = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean addMessage(String string, boolean bl) {
            if (string == null) {
                return false;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
            String string2 = TimeDateFormatUtil.convertFromUTC(gregorianCalendar.getTimeInMillis(), TimeZone.getDefault());
            String string3 = string;
            String string4 = string3 = string3.replaceAll("\r", "");
            if (this.outputConfig.isShowMsgTime()) {
                if (bl) {
                    int n = string2.length() + this.COLON_SAPERATOR.length();
                    string4 = new StringBuffer("").append(string2).append(this.COLON_SAPERATOR).append(string3.replaceAll("\n", '\n' + this.getBlankString(n))).toString();
                } else {
                    string4 = new StringBuffer("").append(string2).append(this.COLON_SAPERATOR).append(string3).toString();
                }
            }
            if (OutputManager.this.isMessageBuffered) {
                Object object = this.lock;
                synchronized (object) {
                    this.messageBuffer.append("\n");
                    this.messageBuffer.append(string4);
                }
                if (null == this.bufferFlushThread || !this.bufferFlushThread.isAlive()) {
                    this.bufferFlushThread = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            while (OutputPanel.this.checkCondition) {
                                int n = 0;
                                try {
                                    Thread.sleep(OutputManager.this.outputBufferUpdateTime);
                                }
                                catch (InterruptedException interruptedException) {
                                    logger.trace("Thread is interrupted from sleep");
                                }
                                Object object = OutputPanel.this.lock;
                                synchronized (object) {
                                    n = OutputPanel.this.messageBuffer.length();
                                }
                                if (n <= 0) continue;
                                Object object2 = OutputPanel.this.lock;
                                synchronized (object2) {
                                    object = OutputPanel.this.messageBuffer.toString();
                                    OutputPanel.this.messageBuffer.setLength(0);
                                }
                                if (OutputManager.this.outputWindowVisible) {
                                    SwingUtilities.invokeLater(new Runnable((String)object){
                                        final /* synthetic */ String val$strMsg;
                                        {
                                            this.val$strMsg = string;
                                        }

                                        @Override
                                        public void run() {
                                            OutputPanel.this.addOutputWindowMessage(this.val$strMsg);
                                        }
                                    });
                                    continue;
                                }
                                OutputPanel.this.bufferForNonBufferMessage.append((String)object);
                            }
                        }
                    });
                    this.bufferFlushThread.start();
                }
            } else {
                final String string5 = string4;
                if (OutputManager.this.outputWindowVisible) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (OutputPanel.this.textArea.getText().length() > 0) {
                                OutputPanel.this.textArea.append("\n");
                            }
                            OutputPanel.this.addOutputWindowMessage(string5);
                        }
                    });
                } else {
                    Object object = this.lock;
                    synchronized (object) {
                        this.bufferForNonBufferMessage.append("\n" + string5);
                        ++this.bufferForNonBufferMessageLineCount;
                        this.checkForTheLineCount();
                    }
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkForTheLineCount() {
            int n = this.bufferForNonBufferMessageLineCount;
            if (n > this.outputConfig.getMaxLineNum()) {
                if (MaxLineNumSetting.getDisplaceSetting() && this.outputConfig.isDisplace()) {
                    this.setBufferedWriter();
                    String string = null;
                    Object object = this.lock;
                    synchronized (object) {
                        string = this.bufferForNonBufferMessage.toString();
                        this.bufferForNonBufferMessage.setLength(0);
                        this.bufferForNonBufferMessageLineCount = 0;
                    }
                    object = new StringReader(string);
                    BufferedReader bufferedReader = null;
                    String string2 = null;
                    try {
                        bufferedReader = new BufferedReader((Reader)object);
                        while ((string2 = bufferedReader.readLine()) != null) {
                            if (OutputManager.this.currentDisplaceBufferedWriter == null) continue;
                            OutputManager.this.currentDisplaceBufferedWriter.write(string2);
                        }
                        OutputManager.this.currentDisplaceBufferedWriter.flush();
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        logger.trace("Error writing outputBuffer message ,No Client Encoding is set");
                    }
                    catch (IOException iOException) {
                        this.showSaveErrorMessage(OutputManager.this.currentDisplaceFileName, iOException);
                    }
                    finally {
                        try {
                            if (null != object) {
                                ((StringReader)object).close();
                            }
                            if (null != bufferedReader) {
                                bufferedReader.close();
                            }
                            if (null != OutputManager.this.currentDisplaceBufferedWriter) {
                                OutputManager.this.currentDisplaceBufferedWriter.close();
                            }
                        }
                        catch (IOException iOException) {
                            logger.trace("Error writing outputBuffer message ,No Client Encoding is set");
                        }
                        OutputManager.this.currentDisplaceBufferedWriter = null;
                    }
                } else {
                    this.clearMessageNonBufferMessagesBuffer();
                }
            }
        }

        private synchronized boolean addOutputWindowMessage(String string) {
            if (!this.checkCondition) {
                return false;
            }
            this.textArea.append(string);
            try {
                if ("\n".equals(this.textArea.getText(0, 1))) {
                    this.textArea.replaceRange(null, 0, 1);
                }
            }
            catch (BadLocationException badLocationException) {
                logger.trace(badLocationException.getMessage(), badLocationException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.trace("empty string can not be added at the begining");
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OutputPanel.this.fitLineCount();
                    if (OutputPanel.this.outputConfig.isAutoScroll()) {
                        OutputPanel.this.scrollHelper.scrollToEnd();
                    }
                }
            });
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void flushBufferMessageToOutput() {
            if (this.bufferForNonBufferMessage.length() > 0) {
                String string = "";
                Object object = this.lock;
                synchronized (object) {
                    string = this.bufferForNonBufferMessage.toString();
                    this.bufferForNonBufferMessage.setLength(0);
                    this.bufferForNonBufferMessageLineCount = 0;
                }
                this.addOutputWindowMessage(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearMessageBufferLength() {
            Object object = this.lock;
            synchronized (object) {
                this.messageBuffer.setLength(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void clearMessageNonBufferMessagesBuffer() {
            Object object = this.lock;
            synchronized (object) {
                this.bufferForNonBufferMessage.setLength(0);
                this.bufferForNonBufferMessageLineCount = 0;
            }
        }

        private String getBlankString(int n) {
            if (n == this.lastBlank.length()) {
                return this.lastBlank;
            }
            char[] cArray = new char[n];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = 32;
            }
            this.lastBlank = new String(cArray);
            return this.lastBlank;
        }

        protected int getRowHeight() {
            FontMetrics fontMetrics = this.textArea.getFontMetrics(this.textArea.getFont());
            return fontMetrics.getHeight();
        }

        protected JScrollPane getScrollPane() {
            return this.scrollPane;
        }

        public JPanel getOutputPane() {
            return this.outputPane;
        }

        private void init(OutputConfig outputConfig) {
            this.outputConfig = outputConfig == null ? OutputManager.this.commonOutputConfig : outputConfig;
            this.textArea = this.outputConfig.getTextArea();
            this.outputPane = new JPanel();
            this.outputPane.setLayout(new BorderLayout());
            this.scrollPane = new JScrollPane();
            this.scrollPane.setName("OutputManager_OutputPanel_scrollPane");
            this.scrollPane.getViewport().add(this.textArea);
            this.outputConfig.setScrollPane(this.scrollPane);
            this.outputPane.add((Component)this.scrollPane, "Center");
            this.outputPane.setMinimumSize(new Dimension(0, 0));
            this.outputPane.setName("OutputManager_OutputPanel_scrollPane");
            HelpManager.getInstance().enableHelpKey(this.outputPane, "iVIEW.framework.outputmanagement");
            this.textArea.setEditable(false);
            if (customizeOutput) {
                this.addChangePanelListener();
            }
            this.textArea.setDoubleBuffered(true);
            this.scrollHelper = new ScrollHelper(this.scrollPane, this.textArea);
            if (!this.outputConfig.isExtMenuRegistered()) {
                this.outputConfig.addMenuComponent(new JSeparator(), Integer.MAX_VALUE);
                this.autoScrollItem = new JCheckBoxMenuItem(res.getString("OutputManager_autoscroll"));
                this.autoScrollItem.setMnemonic('L');
                this.autoScrollItem.setName("OutputManager_autoscroll");
                final OutputConfig outputConfig2 = outputConfig;
                this.autoScrollItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean bl = OutputPanel.this.setAutoScroll(OutputPanel.this.autoScrollItem.isSelected());
                        if (!bl) {
                            logger.warn("AutoScroll action: set auto scroll failed.");
                        }
                        if (OutputPanel.this == OutputManager.this.commonOutputPanel) {
                            OutputManager.this.sendEventToSettingItem();
                            OutputManager.this.writeBackOutputStyle();
                        } else if (customizeOutput) {
                            outputConfig2.setAutoScroll(OutputPanel.this.autoScrollItem.isSelected());
                            OutputManager.this.sendEventToSettingItem(outputConfig2);
                            OutputManager.this.writeBackOutputStyle("conf/mainfrm/outputpane", outputConfig2);
                        }
                    }
                });
                this.autoScrollItem.setSelected(this.outputConfig.isAutoScroll());
                this.outputConfig.addMenuComponent(this.autoScrollItem, Integer.MAX_VALUE);
                this.outputConfig.setAutoScrollItem(this.autoScrollItem);
                this.outputConfig.setExtMenuRegistered(true);
            }
            this.updateSettingMenuItem();
            if (OutputManager.this.isMessageBuffered) {
                this.checkCondition = true;
            }
        }

        private boolean setAutoScroll(boolean bl) {
            if (this == OutputManager.this.commonOutputPanel) {
                autoScroll = bl;
            }
            this.outputConfig.setAutoScroll(bl);
            this.autoScrollItem.setSelected(bl);
            if (null != this.textArea) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.textArea.updateUI();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OutputPanel.this.textArea.updateUI();
                        }
                    });
                }
            }
            return true;
        }

        public boolean clearSelectedLogs() {
            this.textArea.replaceSelection("");
            return true;
        }

        public boolean clearAllLogs() {
            this.textArea.setText("");
            return true;
        }

        private void setBufferedWriter() {
            String string = this.outputConfig.getCurrentDisplaceFile();
            if (null == string || string.length() <= 0) {
                logger.trace("Invalid Output file name:" + string);
                return;
            }
            FileOutputStream fileOutputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            try {
                currentDisplaceFile = CommonUtil.getAbsoluteFile(string);
                if (!currentDisplaceFile.exists()) {
                    int n = string.lastIndexOf(System.getProperty("file.separator"));
                    String string2 = string.substring(0, n);
                    File file = CommonUtil.getAbsoluteFile(string2);
                    file.mkdirs();
                    currentDisplaceFile = CommonUtil.getAbsoluteFile(string);
                }
                this.checkFileSize(currentDisplaceFile);
                fileOutputStream = new FileOutputStream(currentDisplaceFile, true);
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, this.userFileEncoding);
                OutputManager.this.currentDisplaceBufferedWriter = new BufferedWriter(outputStreamWriter);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
                logger.trace("Current displace file:" + currentDisplaceFile);
                if (this.showDisplaceFailedMessage) {
                    this.addMessage(res.getString("Auto_Displace_Failed"), false);
                    this.showDisplaceFailedMessage = false;
                }
                try {
                    if (null != outputStreamWriter) {
                        outputStreamWriter.close();
                    }
                }
                catch (IOException iOException) {
                    logger.trace("IOException Occured closing the Stream");
                }
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    logger.trace("IOException Occured closing the Stream");
                }
            }
        }

        private void checkFileSize(File file) {
            if (file.length() >= 0x500000L) {
                String string = file.getAbsolutePath();
                File file2 = CommonUtil.getAbsoluteFile(string + OutputManager.this.backString);
                if (file2.exists() && file2.isFile()) {
                    file2.delete();
                }
                currentDisplaceFile.renameTo(CommonUtil.getAbsoluteFile(string + OutputManager.this.backString));
                currentDisplaceFile = CommonUtil.getAbsoluteFile(string);
            }
        }

        public void fitLineCount() {
            if (null == this.textArea) {
                return;
            }
            int n = this.textArea.getLineCount();
            int n2 = Integer.parseInt(this.outputConfig.getDisplaceNum());
            if (!(n <= this.outputConfig.getMaxLineNum() || this.outputConfig.isDisplace() && this.outputConfig.getMaxLineNum() < n2)) {
                int n3;
                int n4 = 0;
                try {
                    n4 = this.outputConfig.isDisplace() ? n2 : n - this.outputConfig.getMaxLineNum();
                    if (OutputManager.this.isMessageBuffered && (n3 = n - this.outputConfig.getMaxLineNum()) > this.cutTextLength) {
                        n4 = n3;
                    }
                }
                catch (Exception exception) {
                    n4 = n - this.outputConfig.getMaxLineNum();
                }
                n3 = this.scrollHelper.computeScrollBarValue(n4);
                if (MaxLineNumSetting.getDisplaceSetting() && this.outputConfig.isDisplace()) {
                    try {
                        this.setBufferedWriter();
                        String string = this.textArea.getText(0, this.textArea.getLineStartOffset(n4));
                        try {
                            if (OutputManager.this.currentDisplaceBufferedWriter != null) {
                                OutputManager.this.currentDisplaceBufferedWriter.write(string);
                                OutputManager.this.currentDisplaceBufferedWriter.flush();
                                OutputManager.this.currentDisplaceBufferedWriter.close();
                                OutputManager.this.currentDisplaceBufferedWriter = null;
                            }
                        }
                        catch (IOException iOException) {
                            this.showSaveErrorMessage(OutputManager.this.currentDisplaceFileName, iOException);
                        }
                        this.showDisplaceFailedMessage = true;
                    }
                    catch (BadLocationException badLocationException) {
                        logger.trace(badLocationException.getMessage(), badLocationException);
                    }
                }
                try {
                    this.textArea.replaceRange(null, 0, this.textArea.getLineStartOffset(Math.min(n4, this.textArea.getLineCount() - 1)));
                }
                catch (BadLocationException badLocationException) {
                    logger.trace(badLocationException.getMessage(), badLocationException);
                }
                if (!this.outputConfig.isAutoScroll()) {
                    this.scrollHelper.scrollToFit(n3);
                }
            }
        }

        final void fitLineCountApplied() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n = 0;
                    while (OutputPanel.this.textArea.getLineCount() > OutputPanel.this.outputConfig.getMaxLineNum()) {
                        n = OutputPanel.this.textArea.getLineCount();
                        OutputPanel.this.fitLineCount();
                        if (n != OutputPanel.this.textArea.getLineCount()) continue;
                        break;
                    }
                }
            });
        }

        private void showSaveErrorMessage(String string, Exception exception) {
            String string2 = res.getString("ErrorHalt");
            MessageFormat messageFormat = new MessageFormat(string2);
            string2 = messageFormat.format(new String[]{string});
            StringBuffer stringBuffer = OptionPane.separateStringWith(string2, "\n");
            OptionPane.showErrorDialog(FrameworkUtilities.getMainFrame(), stringBuffer);
            logger.trace(exception);
        }

        public void updateSettingMenuItem() {
            if (null != OutputManager.this.getSettingItemName()) {
                if (null == this.settingItem) {
                    this.settingItem = new JMenuItem(res.getString("OutputManager_Setting_"));
                    this.settingItem.setName("OutputManager_settingItem");
                    this.settingItem.setMnemonic('S');
                    this.settingItem.setName("OutputManager_settingItem");
                    this.settingItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            OutputManager.this.launchMaxLineNumSetting();
                        }
                    });
                }
                if (this == OutputManager.this.commonOutputPanel || customizeOutput) {
                    this.outputConfig.addMenuComponent(this.settingItem, Integer.MAX_VALUE);
                }
            } else {
                if (null != this.settingItem && (this == OutputManager.this.commonOutputPanel || customizeOutput)) {
                    this.outputConfig.removeMenuComponent(this.settingItem);
                }
                this.settingItem = null;
            }
        }

        public void deteteSettingMenuItem() {
            if (this != OutputManager.this.commonOutputPanel) {
                int n;
                ActionListener[] actionListenerArray;
                if (null != this.settingItem) {
                    actionListenerArray = this.settingItem.getActionListeners();
                    for (n = 0; n < actionListenerArray.length; ++n) {
                        this.settingItem.removeActionListener(actionListenerArray[n]);
                    }
                    this.outputConfig.removeMenuComponent(this.settingItem);
                }
                if (null != this.autoScrollItem) {
                    actionListenerArray = this.autoScrollItem.getActionListeners();
                    for (n = 0; n < actionListenerArray.length; ++n) {
                        this.autoScrollItem.removeActionListener(actionListenerArray[n]);
                    }
                }
            }
        }

        public OutputConfig getOutputConfig() {
            return this.outputConfig;
        }
    }
}

