/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.outputmanagement;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.framework.outputmanagement.OutputManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.textmenu.TextMenuHandler;
import com.swimap.iview.util.IFileStateChecker;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class OutputConfig {
    private static IviewLogger logger = IviewLogger.getLogger(OutputConfig.class, "IVIEW");
    static final int DEFAULT_MAX_LINE_NUM = 500;
    private int maxLineNum = 500;
    private boolean autoScroll = true;
    private boolean isShowMsgTime = true;
    private TextMenuHandler menuHandler = null;
    private JTextArea textArea = new JTextArea();
    public static final int POS_HEAD = 0;
    public static final int POS_TAIL = Integer.MAX_VALUE;
    private boolean isExtMenuRegistered = false;
    private JCheckBoxMenuItem autoScrollItem = null;
    private String currentDisplaceFileName = null;
    private boolean displace = false;
    private String outputConfigName = "";
    private String displaceNum = "300";
    private String currentDisplaceFile = null;

    public String getOutputConfigName() {
        return this.outputConfigName;
    }

    public void setOutputConfigName(String string) {
        this.outputConfigName = string;
    }

    public boolean isDisplace() {
        return this.displace;
    }

    public void setDisplace(boolean bl) {
        this.displace = bl;
    }

    public String getDisplaceNum() {
        if (null == this.displaceNum || this.displaceNum.length() == 0) {
            return String.valueOf(0);
        }
        return this.displaceNum;
    }

    public void setDisplaceNum(String string) {
        if (null != this.displaceNum && this.displaceNum.equals(string)) {
            return;
        }
        this.displaceNum = string;
        if (OutputManager.isCustomizeOutput() && this.getOutputConfigName().length() > 0) {
            FrameworkUtilities.getOutputManager().getOutputPanel(this.getOutputConfigName()).fitLineCount();
        }
    }

    public String getCurrentDisplaceFile() {
        return this.currentDisplaceFile;
    }

    public void setCurrentDisplaceFile(String string) {
        this.currentDisplaceFile = string;
    }

    public OutputConfig() {
        this(500, true, true);
    }

    public OutputConfig(int n, boolean bl, boolean bl2) {
        this(n, bl, bl2, true);
    }

    OutputConfig(int n, boolean bl, boolean bl2, boolean bl3) {
        this.textArea.setName("OutputConfig_textArea");
        this.menuHandler = new TextMenuHandler(this.textArea, FrameworkUtilities.getMainFrame(), bl3);
        this.setMaxLineNum(n);
        this.setAutoScroll(bl);
        this.setShowMsgTime(bl2);
    }

    public void setMaxLineNum(int n) {
        logger.trace("OutputConfig setMaxLineNum: " + n);
        if (n <= 3000 && n >= 30) {
            this.maxLineNum = n;
            return;
        }
        this.maxLineNum = 500;
        logger.warn("OutputConfig setMaxLineNum failed, use the default value instead: 500");
    }

    public void setAutoScroll(boolean bl) {
        this.autoScroll = bl;
        if (this.autoScrollItem != null) {
            this.autoScrollItem.setSelected(bl);
        }
    }

    public void setShowMsgTime(boolean bl) {
        this.isShowMsgTime = bl;
    }

    public int getMaxLineNum() {
        return this.maxLineNum;
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public boolean isShowMsgTime() {
        return this.isShowMsgTime;
    }

    final JTextArea getTextArea() {
        return this.textArea;
    }

    public void addMenuComponent(Component component, int n) {
        this.menuHandler.addMenuComponent(component, n);
    }

    public void addMenuComponent(Component component) {
        this.menuHandler.addMenuComponent(component);
    }

    public void removeMenuComponent(Component component) {
        this.menuHandler.removeMenuComponent(component);
    }

    public void setFileStateChecker(IFileStateChecker iFileStateChecker) {
        this.menuHandler.setFileStateChecker(iFileStateChecker);
    }

    final void setExtMenuRegistered(boolean bl) {
        this.isExtMenuRegistered = bl;
    }

    final boolean isExtMenuRegistered() {
        return this.isExtMenuRegistered;
    }

    final void setAutoScrollItem(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this.autoScrollItem = jCheckBoxMenuItem;
    }

    public JCheckBoxMenuItem getAutoScrollItem() {
        return this.autoScrollItem;
    }

    final void setScrollPane(JScrollPane jScrollPane) {
        this.menuHandler.setScrollPane(jScrollPane);
    }

    public String getCurrentDisplaceFileName() {
        return this.currentDisplaceFileName;
    }

    public void setCurrentDisplaceFileName(String string) {
        this.currentDisplaceFileName = string;
    }

    public void setDefaultSaveFileName(String string) {
        this.menuHandler.setDefaultSaveFileName(string);
    }

    public void initialiseOutputConfig(String string) {
        OutputManager outputManager = FrameworkUtilities.getOutputManager();
        int n = outputManager.getMaxLineNum();
        boolean bl = !outputManager.isAutomaticScrolls();
        String string2 = outputManager.getDisplaceFileName();
        String string3 = outputManager.getDisplaceNum();
        boolean bl2 = outputManager.isAutoDisplace();
        if (OutputManager.isCustomizeOutput()) {
            CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/mainfrm/outputpane");
            String string4 = commStyleInfo.getParasItemValue("outputpane", string, "maxlinenum");
            n = Integer.parseInt(string4);
            bl = Boolean.parseBoolean(commStyleInfo.getParasItemValue("outputpane", string, "lockscroll"));
            string2 = commStyleInfo.getParasItemValue("outputpane", string, "displacefile");
            string3 = commStyleInfo.getParasItemValue("outputpane", string, "displacenum");
            bl2 = Boolean.parseBoolean(commStyleInfo.getParasItemValue("outputpane", string, "isdisplace"));
        }
        this.setAutoScroll(!bl);
        this.setCurrentDisplaceFile(string2);
        this.setDisplace(bl2);
        this.setDisplaceNum(string3);
        this.setMaxLineNum(n);
    }

    public void cleanupWhileOSGIExit() {
        this.menuHandler.cleanupWhileOSGIExit();
        this.menuHandler = null;
    }
}

