/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.outputmanagement;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.corbahelpers.EventPayload;
import com.swimap.iview.corbahelpers.InternalEvent;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.outputmanagement.OutputConfig;
import com.swimap.iview.framework.outputmanagement.OutputManager;
import com.swimap.iview.framework.systemsettingsmanagement.BaseClientSettings;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.textfield.IntegerTextField;
import com.swimap.iview.templates.utils.MultiRowToolTip;
import com.swimap.iview.util.AppendFileOption;
import com.swimap.iview.util.FileChooser;
import com.swimap.iview.util.FileChooserFilter;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.SaveFileChooser;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.omg.CORBA.ORB;

public class MaxLineNumSetting
extends BaseClientSettings {
    private static IviewLogger logger = IviewLogger.getLogger(MaxLineNumSetting.class, "IVIEW");
    private static final int DEFAULT_MAX_LINE_NUMBER = 500;
    public static final int DEFAULT_DISPLACE_NUMBER = 20;
    private int maxLineNum = 500;
    private boolean autoScroll = true;
    private boolean isDisplace = true;
    private String displaceNum = "200";
    private final String DUMPFILEPATH = "./autoput.txt";
    private String displaceFileName = "./autoput.txt";
    private boolean ready = false;
    private JPanel settingPanel = null;
    private static boolean isDisplaceSettingVisible = true;
    static boolean outputsettingfailed = false;
    JLabel maxLineLabel = new JLabel(OutputManager.res.getString("MaxLineNumSetting_Max_line_number_"));
    JLabel displaceFileLabel = new JLabel(OutputManager.res.getString("Displace_File_Name"));
    JLabel displaceNumLabel = new JLabel(OutputManager.res.getString("Displace_Line_Numder"));
    private JPanel outputSettingPanel = new JPanel();
    private static boolean inValidNotification = false;
    JComboBox outputSettingCombo = new JComboBox(){

        public void addItem(Object object) {
            super.addItem(object);
            if (MaxLineNumSetting.this.outputSettingCombo.getItemCount() > 1) {
                MaxLineNumSetting.this.outputSettingPanel.setVisible(true);
            } else {
                MaxLineNumSetting.this.outputSettingPanel.setVisible(false);
            }
        }

        @Override
        public void removeItem(Object object) {
            super.removeItem(object);
            if (MaxLineNumSetting.this.outputSettingCombo.getItemCount() > 1) {
                MaxLineNumSetting.this.outputSettingPanel.setVisible(true);
            } else {
                MaxLineNumSetting.this.outputSettingPanel.setVisible(false);
            }
        }
    };
    private boolean isSystemLoadFinished = false;
    JLabel outputSettingLabel = new JLabel(OutputManager.res.getString("MaxLineNumSetting_Output_Panels"));
    private static final int COMBO_WIDTH = 120;
    private static final int COMBO_HIGHT = 20;
    private static final int BUFFER_SIZE = 16;
    private static boolean reloadOutput = false;
    private IntegerTextField numberSettingField = new IntegerTextField(30, 3000){

        @Override
        public void setText(String string) {
            super.setText(string);
        }
    };
    private JCheckBox autoSrollCheckBox = new JCheckBox();
    private JCheckBox autoDisplaceCheckBox = new JCheckBox();
    private IntegerTextField displaceNumField = new IntegerTextField(20, 3000);
    private JTextField displaceFileField = new JTextField(){

        @Override
        public JToolTip createToolTip() {
            MultiRowToolTip multiRowToolTip = new MultiRowToolTip();
            multiRowToolTip.setMaxLineNumber(10);
            multiRowToolTip.setComponent(this);
            return multiRowToolTip;
        }
    };
    private JButton fileChooserButton = new JButton("...");

    @Override
    public boolean preLogout() {
        this.outputSettingCombo.removeAllItems();
        return true;
    }

    public MaxLineNumSetting(ModuleManager moduleManager, ORB oRB, String string, String string2) throws ModuleManagementException {
        super(moduleManager, oRB, string, string2);
        this.displaceNumField.setText(String.valueOf(20));
    }

    public MaxLineNumSetting(ModuleManager moduleManager) throws ModuleManagementException {
        super(moduleManager);
        this.numberSettingField.setTooltipEnabled(true);
        this.displaceNumField.setTooltipEnabled(true);
        this.displaceNumField.setText(String.valueOf(20));
    }

    public static boolean getDisplaceSetting() {
        return isDisplaceSettingVisible;
    }

    @Override
    public boolean apply() {
        if (!this.numberSettingField.isValid()) {
            FrameworkUtilities.getSystemSettingsManager().activateSetting(this);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MaxLineNumSetting.this.numberSettingField.selectAll();
                    MaxLineNumSetting.this.numberSettingField.requestFocus();
                    OptionPane.showMessageDialog(FrameworkUtilities.getMainFrame(), OutputManager.res.getString("MaxLineNumSetting_the_miniman"));
                }
            });
            return false;
        }
        if (!this.autoDisplaceCheckBox.isSelected() && this.displaceNumField.getText().length() == 0) {
            this.displaceNumField.setText("0");
        } else if (this.maxLineNum == this.numberSettingField.getValue() && this.autoSrollCheckBox.isSelected() == FrameworkUtilities.getOutputManager().isAutomaticScrolls() && this.displaceNumField.getText().trim().equals(this.displaceNum) && this.autoDisplaceCheckBox.isSelected() == FrameworkUtilities.getOutputManager().isAutoDisplace() && this.displaceFileField.getText().trim().equals(this.displaceFileName)) {
            this.notifyChange();
            return true;
        }
        this.maxLineNum = this.numberSettingField.getValue();
        this.autoScroll = this.autoSrollCheckBox.isSelected();
        this.isDisplace = this.autoDisplaceCheckBox.isSelected();
        this.displaceNum = this.displaceNumField.getText();
        this.displaceFileName = this.displaceFileField.getText();
        String string = null;
        if (this.outputSettingPanel.isVisible()) {
            string = this.outputSettingCombo.getSelectedItem().toString();
        }
        OutputConfig outputConfig = null;
        OutputManager outputManager = FrameworkUtilities.getOutputManager();
        String string2 = outputManager.getDisplaceFileName();
        int n = outputManager.getMaxLineNum();
        String string3 = outputManager.getDisplaceNum();
        boolean bl = outputManager.isAutoDisplace();
        boolean bl2 = outputManager.isAutomaticScrolls();
        if (null == string || string.equals(outputManager.getCommonTitle())) {
            outputConfig = outputManager.getCommonOutputConfig();
            outputConfig.setAutoScroll(this.autoScroll);
            outputConfig.setMaxLineNum(this.maxLineNum);
            outputConfig.setDisplace(this.isDisplace);
            outputConfig.setDisplaceNum(this.displaceNum);
            outputConfig.setCurrentDisplaceFile(this.displaceFileName);
            outputManager.writeBackOutputStyle();
            if (!outputsettingfailed) {
                FrameworkUtilities.getSystemSettingsManager().setSystemSettingStatus(this.getTabLabel(), true, "");
            } else {
                FrameworkUtilities.getSystemSettingsManager().setSystemSettingStatus(this.getTabLabel(), false, OutputManager.res.getString("Fail_msg"));
                outputsettingfailed = false;
                outputConfig.setAutoScroll(bl2);
                outputConfig.setMaxLineNum(n);
                outputConfig.setDisplace(bl);
                outputConfig.setDisplaceNum(string3);
                outputConfig.setCurrentDisplaceFile(string2);
                this.numberSettingField.setText(String.valueOf(n));
                this.autoSrollCheckBox.setSelected(bl2);
                this.autoDisplaceCheckBox.setSelected(bl);
                this.displaceNumField.setText(string3);
                this.displaceFileField.setText(string2);
                this.displaceFileName = string2;
                this.maxLineNum = n;
                this.displaceNum = string3;
                this.isDisplace = bl;
                this.autoScroll = bl2;
            }
        } else {
            this.writeBackOutputStyle(string);
            if (outputsettingfailed) {
                FrameworkUtilities.getSystemSettingsManager().setSystemSettingStatus(this.getTabLabel(), false, OutputManager.res.getString("Fail_msg"));
                outputsettingfailed = false;
                this.numberSettingField.setText(String.valueOf(n));
                this.maxLineNum = n;
                this.autoSrollCheckBox.setSelected(bl2);
                this.autoDisplaceCheckBox.setSelected(bl);
                this.displaceNumField.setText(string3);
                this.displaceFileField.setText(string2);
            } else {
                outputConfig = outputManager.getOutputPanel(string).getOutputConfig();
                outputConfig.setAutoScroll(this.autoScroll);
                outputConfig.setMaxLineNum(this.maxLineNum);
                outputConfig.setDisplace(this.isDisplace);
                outputConfig.setDisplaceNum(this.displaceNum);
                outputConfig.setCurrentDisplaceFile(this.displaceFileName);
            }
        }
        outputManager.fitLineCountApplied();
        this.notifyChange();
        return true;
    }

    public void writeBackOutputStyle(String string) {
        OutputManager outputManager = FrameworkUtilities.getOutputManager();
        OutputConfig outputConfig = outputManager.getOutputConfig(string);
        outputConfig.setAutoScroll(this.autoScroll);
        outputConfig.setCurrentDisplaceFile(this.displaceFileName);
        outputConfig.setMaxLineNum(this.maxLineNum);
        outputConfig.setDisplace(this.isDisplace);
        outputConfig.setDisplaceNum(this.displaceNum);
        outputManager.writeBackOutputStyle("conf/mainfrm/outputpane", outputConfig);
    }

    @Override
    public boolean exit() {
        this.numberSettingField.setText(Integer.toString(this.maxLineNum));
        this.autoSrollCheckBox.setSelected(this.autoScroll);
        this.autoDisplaceCheckBox.setSelected(this.isDisplace);
        this.displaceNumField.setText(this.displaceNum);
        this.displaceFileField.setText(this.displaceFileName);
        this.displaceFileField.setToolTipText(this.displaceFileField.getText());
        this.displaceNumField.setEditable(this.isDisplace);
        this.displaceNumField.setEnabled(this.isDisplace);
        this.displaceFileField.setEnabled(this.isDisplace);
        this.fileChooserButton.setEnabled(this.isDisplace);
        return true;
    }

    @Override
    public JPanel getSettingsPanel() {
        if (this.settingPanel == null) {
            this.initPanel();
        }
        return this.settingPanel;
    }

    @Override
    public boolean isChanged() {
        if (inValidNotification) {
            return false;
        }
        try {
            return this.numberSettingField.getValue() != this.maxLineNum || this.autoSrollCheckBox.isSelected() != this.autoScroll || !this.displaceNumField.getText().trim().equals(this.displaceNum.equals("null") ? "" : this.displaceNum) && (this.displaceNumField.getText().length() != 0 || Boolean.FALSE.booleanValue() != this.autoDisplaceCheckBox.isSelected()) || this.autoDisplaceCheckBox.isSelected() != this.isDisplace || !this.displaceFileField.getText().equals(this.displaceFileName);
        }
        catch (NumberFormatException numberFormatException) {
            logger.trace(numberFormatException.getMessage(), numberFormatException);
            return true;
        }
    }

    @Override
    public String getTabLabel() {
        return OutputManager.res.getString("MaxLineNumSetting_Message_Output_Pane");
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public String getModuleName() {
        return "mainoutputbarsetting";
    }

    @Override
    public void processEvent(InternalEvent internalEvent) {
        switch (internalEvent.eventId) {
            case 112: {
                this.ready = true;
                this.updateStateChangedWithEvent(internalEvent);
                break;
            }
        }
    }

    private void updateStateChangedWithEvent(InternalEvent internalEvent) {
        if (null != internalEvent.payload) {
            EventPayload eventPayload = internalEvent.payload;
            if (eventPayload.values == null || eventPayload.values.length < 5) {
                logger.trace("invalid event, return.");
                return;
            }
            String string = eventPayload.values[0];
            String string2 = eventPayload.values[1];
            String string3 = eventPayload.values[2];
            String string4 = eventPayload.values[4];
            String string5 = eventPayload.values[3];
            try {
                this.autoScroll = Boolean.valueOf(string);
                this.maxLineNum = Integer.parseInt(string2);
                this.isDisplace = Boolean.valueOf(string3);
                this.displaceNum = string4;
                this.displaceFileName = string5;
                this.updateSetting();
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
    }

    @Override
    protected void postSystemLoadingFinished() {
        super.postSystemLoadingFinished();
        this.isSystemLoadFinished = true;
    }

    private void initPanel() {
        OutputManager outputManager;
        if (null == this.settingPanel) {
            this.settingPanel = new JPanel();
            this.jbInit();
        }
        if ((outputManager = FrameworkUtilities.getOutputManager()) != null) {
            this.maxLineNum = outputManager.getMaxLineNum();
            this.autoScroll = outputManager.isAutomaticScrolls();
            this.displaceNum = outputManager.getDisplaceNum();
            this.isDisplace = outputManager.isAutoDisplace();
            this.displaceFileName = outputManager.getDisplaceFileName();
            this.updateSetting();
            this.ready = true;
        } else {
            this.ready = false;
        }
    }

    private void updateSetting() {
        if (null != this.settingPanel) {
            this.autoSrollCheckBox.setEnabled(this.ready);
            this.numberSettingField.setEnabled(this.ready);
            this.autoSrollCheckBox.setSelected(this.autoScroll);
            this.numberSettingField.setText(String.valueOf(this.maxLineNum));
            this.autoDisplaceCheckBox.setSelected(this.isDisplace);
            this.displaceFileField.setText(this.displaceFileName);
            this.displaceFileField.setToolTipText(this.displaceFileField.getText());
            if (this.isDisplace) {
                this.displaceNumField.setText(String.valueOf(this.displaceNum));
            } else {
                this.displaceNumField.setText(String.valueOf(this.displaceNum));
            }
            this.displaceNumField.setEditable(this.isDisplace);
            this.displaceNumField.setEnabled(this.isDisplace);
            this.displaceFileField.setEnabled(this.isDisplace);
            this.fileChooserButton.setEnabled(this.isDisplace);
        }
    }

    private void jbInit() {
        try {
            isDisplaceSettingVisible = Boolean.valueOf(System.getProperty("iview.systemsetting.displaceSettingVisible").trim());
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        this.settingPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.settingPanel.setLayout(new BorderLayout());
        int n = this.getLabelMaxWidth();
        this.setLabelWidth(n + 4);
        this.autoSrollCheckBox.setText(OutputManager.res.getString("MaxLineNumSetting_Auto_scroll_while_new"));
        this.autoSrollCheckBox.setName("JDialog_autoSrollCheckBox");
        this.autoSrollCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MaxLineNumSetting.this.notifyChange();
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), ""));
        this.numberSettingField.setText("600");
        this.numberSettingField.setName("JDialog_numberSettingField");
        this.numberSettingField.getDocument().addDocumentListener(new DocumentListener(){
            int maxDisplaceNumber = 3000;

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (MaxLineNumSetting.this.numberSettingField.getText() != null && MaxLineNumSetting.this.numberSettingField.getText().length() != 0) {
                    this.maxDisplaceNumber = Integer.parseInt(MaxLineNumSetting.this.numberSettingField.getText());
                    if (this.maxDisplaceNumber >= 30 && this.maxDisplaceNumber <= 3000) {
                        MaxLineNumSetting.this.displaceNumField.setRange(20, this.maxDisplaceNumber);
                    }
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (MaxLineNumSetting.this.numberSettingField.getText() != null && MaxLineNumSetting.this.numberSettingField.getText().length() != 0) {
                    this.maxDisplaceNumber = Integer.parseInt(MaxLineNumSetting.this.numberSettingField.getText());
                    if (this.maxDisplaceNumber >= 30 && this.maxDisplaceNumber <= 3000) {
                        MaxLineNumSetting.this.displaceNumField.setRange(20, this.maxDisplaceNumber);
                    }
                }
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        if (isDisplaceSettingVisible) {
            this.numberSettingField.setMinimumSize(new Dimension(60, 20));
            this.numberSettingField.setPreferredSize(new Dimension(250, 20));
            jPanel3.add(this.maxLineLabel);
            jPanel3.add(this.numberSettingField);
        } else {
            this.maxLineLabel = new JLabel(OutputManager.res.getString("MaxLineNumSetting_Max_line_number_").trim());
            this.numberSettingField.setMinimumSize(new Dimension(60, 20));
            this.numberSettingField.setPreferredSize(new Dimension(60, 20));
            jPanel3.add(this.maxLineLabel);
            jPanel3.add(Box.createRigidArea(new Dimension(4, 1)));
            jPanel3.add(this.numberSettingField);
        }
        this.numberSettingField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                MaxLineNumSetting.this.notifyChange();
            }
        });
        this.outputSettingPanel.setLayout(new BoxLayout(this.outputSettingPanel, 0));
        this.outputSettingPanel.add(this.outputSettingLabel);
        this.outputSettingCombo.setPreferredSize(new Dimension(120, 20));
        this.outputSettingCombo.setMinimumSize(new Dimension(120, 20));
        this.outputSettingCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (OutputManager.isCustomizeOutput()) {
                    inValidNotification = true;
                    if (null == MaxLineNumSetting.this.outputSettingCombo.getSelectedItem()) {
                        return;
                    }
                    String string = MaxLineNumSetting.this.outputSettingCombo.getSelectedItem().toString();
                    OutputManager outputManager = FrameworkUtilities.getOutputManager();
                    if (ResourceUtil.areEqualsIgnoreCase(outputManager.getCommonTitle(), string)) {
                        string = "outputpane";
                    }
                    MaxLineNumSetting.this.reloadOutputSetting(string);
                    inValidNotification = false;
                }
            }
        });
        this.outputSettingPanel.add(this.outputSettingCombo);
        this.outputSettingPanel.setVisible(false);
        JPanel jPanel4 = null;
        JPanel jPanel5 = null;
        if (isDisplaceSettingVisible) {
            this.autoDisplaceCheckBox.setText(OutputManager.res.getString("Auto_Displace"));
            this.autoDisplaceCheckBox.setName("JDialog_autoDisplaceCheckBox");
            this.autoDisplaceCheckBox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    MaxLineNumSetting.this.displaceNumField.setEditable(MaxLineNumSetting.this.autoDisplaceCheckBox.isSelected());
                    MaxLineNumSetting.this.displaceNumField.setEnabled(MaxLineNumSetting.this.autoDisplaceCheckBox.isSelected());
                    MaxLineNumSetting.this.displaceFileField.setEnabled(MaxLineNumSetting.this.autoDisplaceCheckBox.isSelected());
                    MaxLineNumSetting.this.fileChooserButton.setEnabled(MaxLineNumSetting.this.autoDisplaceCheckBox.isSelected());
                    MaxLineNumSetting.this.notifyChange();
                }
            });
            this.autoDisplaceCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MaxLineNumSetting.this.autoDisplaceCheckBox.isSelected() && (!MaxLineNumSetting.this.displaceNumField.isValid() || MaxLineNumSetting.this.displaceNumField.getText().length() == 0)) {
                        MaxLineNumSetting.this.displaceNumField.setText(String.valueOf(20));
                    }
                    MaxLineNumSetting.this.displaceNumField.setEditable(MaxLineNumSetting.this.autoDisplaceCheckBox.isSelected());
                    MaxLineNumSetting.this.displaceNumField.setEnabled(MaxLineNumSetting.this.autoDisplaceCheckBox.isSelected());
                    MaxLineNumSetting.this.displaceFileField.setEnabled(MaxLineNumSetting.this.autoDisplaceCheckBox.isSelected());
                    MaxLineNumSetting.this.fileChooserButton.setEnabled(MaxLineNumSetting.this.autoDisplaceCheckBox.isSelected());
                    MaxLineNumSetting.this.notifyChange();
                }
            });
            this.displaceNumField.setName("JDialog_displaceNumField");
            this.displaceNumField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    MaxLineNumSetting.this.notifyChange();
                }
            });
            this.displaceNumField.setMinimumSize(new Dimension(60, 20));
            this.displaceNumField.setPreferredSize(new Dimension(250, 20));
            jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 0));
            jPanel4.add(this.displaceNumLabel);
            jPanel4.add(this.displaceNumField);
            this.displaceFileField.setMinimumSize(new Dimension(60, 20));
            this.displaceFileField.setPreferredSize(new Dimension(250, 20));
            this.displaceFileField.setEditable(false);
            jPanel5 = new JPanel();
            jPanel5.setLayout(new BoxLayout(jPanel5, 0));
            this.fileChooserButton.setPreferredSize(new Dimension(20, 20));
            this.fileChooserButton.setMaximumSize(new Dimension(20, 20));
            this.fileChooserButton.setMinimumSize(new Dimension(20, 20));
            this.fileChooserButton.setName("JDialog_fileChooserButton");
            this.fileChooserButton.addActionListener(new ActionListener(){
                boolean flag = false;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.flag) {
                        return;
                    }
                    this.flag = true;
                    String string = MaxLineNumSetting.this.displaceFileField.getText();
                    String string2 = null;
                    String string3 = "";
                    if (!string.toLowerCase().endsWith(".txt")) {
                        logger.trace("Displace File Name:" + MaxLineNumSetting.this.displaceFileName + "(Not a valid file name!)");
                        string2 = System.getProperty("user.dir");
                    } else {
                        int n = string.lastIndexOf(System.getProperty("file.separator"));
                        if (n < string.length()) {
                            string3 = string.substring(n + 1);
                        }
                        if (!new File(string2 = string.substring(0, n)).isDirectory()) {
                            logger.trace("Displace File Name:" + MaxLineNumSetting.this.displaceFileName + "(Directory does not exist!)");
                            string2 = System.getProperty("user.dir");
                        }
                    }
                    SaveFileChooser saveFileChooser = new SaveFileChooser(string2, true, true);
                    saveFileChooser.setName("MaxLineNumSetting_fileChooser");
                    saveFileChooser.setEncodingEnabled(true);
                    saveFileChooser.setFileStateChecker(AppendFileOption.getInstance());
                    saveFileChooser.getTextField(saveFileChooser).setText(string3);
                    saveFileChooser.setAcceptAllFileFilterUsed(false);
                    saveFileChooser.addChoosableFileFilter(FileChooser.TXT_FILECHOOSERFILTER);
                    if (saveFileChooser.showSaveDialog(FrameworkUtilities.getMainFrame()) != 0) {
                        this.flag = false;
                        return;
                    }
                    String string4 = saveFileChooser.getSelectedFile().getPath();
                    if (null != string4 && 0 != string4.length()) {
                        FileChooserFilter fileChooserFilter = (FileChooserFilter)saveFileChooser.getFileFilter();
                        String string5 = '.' + (String)fileChooserFilter.getAllFilters().get(0);
                        if (!string4.toLowerCase().endsWith(string5)) {
                            string4 = string4.concat(string5);
                        }
                        MaxLineNumSetting.this.displaceFileField.setText(string4);
                        MaxLineNumSetting.this.displaceFileField.setToolTipText(MaxLineNumSetting.this.displaceFileField.getText());
                        if (!string4.equals(MaxLineNumSetting.this.displaceFileName)) {
                            MaxLineNumSetting.this.notifyChange();
                        }
                        String string6 = saveFileChooser.getUserEncoding();
                        OutputManager outputManager = FrameworkUtilities.getOutputManager();
                        if (null == string6) {
                            string6 = "UTF-8";
                        }
                        if (null != outputManager) {
                            outputManager.setUserFileEncoding(string6);
                        }
                    }
                    this.flag = false;
                }
            });
            jPanel5.add(this.displaceFileLabel);
            jPanel5.add(this.displaceFileField);
            jPanel5.add(Box.createRigidArea(new Dimension(2, 1)));
            jPanel5.add(this.fileChooserButton);
            jPanel.add((Component)this.outputSettingPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 17, 0, 12), 0, 0));
            jPanel.add((Component)this.autoDisplaceCheckBox, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 17, 0, 12), 0, 0));
            jPanel.add((Component)jPanel4, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 2, new Insets(12, 17, 0, 12), 0, 0));
            jPanel.add((Component)jPanel5, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 18, 2, new Insets(12, 17, 12, 12), 0, 0));
        }
        jPanel2.add((Component)jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(4, 13, 8, 12), 0, 0));
        jPanel2.add((Component)this.autoSrollCheckBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 17, 8, 12), 0, 0));
        this.displaceFileField.setName("MaxLineNumSetting_displaceFileField");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jPanel2, "North");
        jPanel6.add((Component)jPanel, "South");
        this.settingPanel.add((Component)jPanel6, "North");
        this.settingPanel.putClientProperty("HELP_ID_PROPERTY", "iVIEW.systemsetting.output");
        HelpManager.getInstance().enableHelpKey(this.settingPanel, "iVIEW.systemsetting.output");
    }

    public void setOutputSettingCombo(String string) {
        this.outputSettingCombo.setSelectedItem(string);
    }

    public static boolean isReloadOutput() {
        return reloadOutput;
    }

    private void reloadOutputSetting(String string) {
        Object object;
        reloadOutput = true;
        String string2 = "conf/mainfrm/outputpane";
        CommStyleInfo commStyleInfo = null;
        commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(string2);
        if (null == commStyleInfo) {
            commStyleInfo = CommStyleManager.getInstance().getDefaultProductCommonStyleFile(string2);
        }
        if (null == commStyleInfo) {
            logger.trace("write style error, can not get the style info from style file.");
            return;
        }
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer("outputpane");
        if (null == areaDescContainer) {
            logger.trace("write style error, can not get the area info from style file.");
            return;
        }
        DescContainer descContainer = areaDescContainer.getDescContainer(string);
        if (null == descContainer) {
            this.maxLineNum = Integer.parseInt(commStyleInfo.getParasItemValue("outputpane", "outputpane", "maxlinenum"));
            boolean bl = this.autoScroll = !Boolean.parseBoolean(commStyleInfo.getParasItemValue("outputpane", "outputpane", "lockscroll"));
            if (FrameworkUtilities.getOutputManager().isRemoteProfile()) {
                object = CommStyleManager.getInstance().getUserCommonStyleFileAtClient(string2);
                if (null != object) {
                    this.displaceFileName = ((CommStyleInfo)object).getParasItemValue("outputpane", "outputpane", "displacefile");
                }
            } else {
                this.displaceFileName = commStyleInfo.getParasItemValue("outputpane", "outputpane", "displacefile");
            }
            if (null == this.displaceFileName) {
                this.displaceFileName = "./autoput.txt";
            }
            this.displaceNum = commStyleInfo.getParasItemValue("outputpane", "outputpane", "displacenum");
            this.isDisplace = Boolean.parseBoolean(commStyleInfo.getParasItemValue("outputpane", "outputpane", "isdisplace"));
            this.displaceFileName = this.getOutputDumpFileName(this.displaceFileName);
        } else {
            this.maxLineNum = Integer.parseInt(descContainer.getParasItemValue("maxlinenum"));
            this.autoScroll = !Boolean.parseBoolean(descContainer.getParasItemValue("lockscroll"));
            this.displaceFileName = descContainer.getParasItemValue("displacefile");
            this.displaceNum = descContainer.getParasItemValue("displacenum");
            this.isDisplace = Boolean.parseBoolean(descContainer.getParasItemValue("isdisplace"));
        }
        this.numberSettingField.setText(String.valueOf(this.maxLineNum));
        this.autoSrollCheckBox.setSelected(this.autoScroll);
        this.autoDisplaceCheckBox.setSelected(!this.autoDisplaceCheckBox.isSelected());
        this.autoDisplaceCheckBox.setSelected(this.isDisplace);
        this.displaceFileField.setEditable(this.isDisplace);
        this.displaceNumField.setEditable(this.isDisplace);
        this.displaceNum = this.validateDisplaceNum();
        this.displaceNumField.setText(this.displaceNum);
        this.displaceFileField.setText(this.displaceFileName);
        object = FrameworkUtilities.getOutputManager().getOutputPanel(string).getOutputConfig();
        ((OutputConfig)object).setAutoScroll(this.autoScroll);
        ((OutputConfig)object).setMaxLineNum(this.maxLineNum);
        ((OutputConfig)object).setDisplace(this.isDisplace);
        ((OutputConfig)object).setDisplaceNum(this.displaceNum);
        ((OutputConfig)object).setCurrentDisplaceFile(this.displaceFileName);
        reloadOutput = false;
    }

    private String validateDisplaceNum() {
        int n = 20;
        if (null == this.displaceNum || 0 == this.displaceNum.length()) {
            n = 20;
        } else {
            int n2 = Integer.parseInt(this.displaceNum);
            if (n2 > 20 && n2 < this.maxLineNum) {
                n = n2;
            }
        }
        return String.valueOf(n);
    }

    public String getOutputDumpFileName(String string) {
        CommStyleInfo commStyleInfo = null;
        if (FrameworkUtilities.getOutputManager().isRemoteProfile()) {
            commStyleInfo = CommStyleManager.getInstance().getUserCommonStyleFileAtClient("conf/mainfrm/outputpane");
            if (null == commStyleInfo) {
                commStyleInfo = CommStyleManager.getInstance().getAllUsersCommonStyleFileAtClient("conf/mainfrm/outputpane");
            }
            if (null == commStyleInfo) {
                commStyleInfo = CommStyleManager.getInstance().getDefaultProductCommonStyleFile("conf/mainfrm/outputpane");
            }
        } else {
            commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/mainfrm/outputpane");
        }
        String string2 = commStyleInfo.getParasItemValue("outputpane", "outputpane", "displacefile");
        StringBuffer stringBuffer = new StringBuffer(16);
        int n = string2.lastIndexOf(92);
        if (n == -1) {
            n = string2.lastIndexOf(47);
        }
        if (n > -1) {
            stringBuffer.append(string2.subSequence(0, n + 1));
            stringBuffer.append(string);
            stringBuffer.append('_');
            stringBuffer.append(string2.substring(n + 1));
        } else {
            stringBuffer.append(string);
            stringBuffer.append('_');
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private void setLabelWidth(int n) {
        this.outputSettingLabel.setMinimumSize(new Dimension(n, 20));
        this.outputSettingLabel.setPreferredSize(new Dimension(n, 20));
        this.outputSettingLabel.setMaximumSize(new Dimension(n, 20));
        this.maxLineLabel.setMinimumSize(new Dimension(n, 20));
        this.maxLineLabel.setPreferredSize(new Dimension(n, 20));
        this.maxLineLabel.setMaximumSize(new Dimension(n, 20));
        this.displaceFileLabel.setMinimumSize(new Dimension(n, 20));
        this.displaceFileLabel.setPreferredSize(new Dimension(n, 20));
        this.displaceFileLabel.setMaximumSize(new Dimension(n, 20));
        this.displaceNumLabel.setMinimumSize(new Dimension(n, 20));
        this.displaceNumLabel.setPreferredSize(new Dimension(n, 20));
        this.displaceNumLabel.setMaximumSize(new Dimension(n, 20));
    }

    private int getLabelMaxWidth() {
        int[] nArray = new int[3];
        FontMetrics fontMetrics = this.maxLineLabel.getFontMetrics(this.maxLineLabel.getFont());
        nArray[0] = fontMetrics.stringWidth(this.maxLineLabel.getText());
        nArray[1] = fontMetrics.stringWidth(this.displaceFileLabel.getText());
        nArray[2] = fontMetrics.stringWidth(this.displaceNumLabel.getText());
        Arrays.sort(nArray);
        return nArray[2];
    }

    private void notifyChange() {
        if (this.isSystemLoadFinished) {
            FrameworkUtilities.getSystemSettingsManager().clientSettingChanged(this.getModuleName(), this.isChanged());
        }
    }

    @Override
    public int getTitleDescription() {
        return 1;
    }

    @Override
    public String getSettingDescription() {
        return OutputManager.res.getString("outputSetting_Descr");
    }

    public void updateOutputSettingCombo(String string, boolean bl) {
        if (bl) {
            int n = this.outputSettingCombo.getItemCount();
            for (int i = 0; i < n; ++i) {
                if (!string.equals(this.outputSettingCombo.getItemAt(i))) continue;
                return;
            }
            this.outputSettingCombo.addItem(string);
        } else {
            this.outputSettingCombo.removeItem(string);
        }
    }
}

