/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.outputmanagement;

import com.swimap.iview.templates.textfield.IntegerDocument;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;

public class IntegerTextField
extends JTextField {
    private IntegerDocument doc = null;

    public IntegerTextField(int n, int n2) {
        this.doc = new IntegerDocument(n, n2);
        this.setName("IntegerTextField");
        super.setDocument(this.doc);
        this.setToolTipText(new StringBuffer(20).append("[").append(n).append(", ").append(n2).append("]").toString());
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (IntegerTextField.this.isValid() && IntegerTextField.this.getText().length() >= 2 && IntegerTextField.this.getText().startsWith("0")) {
                    IntegerTextField.this.setText(Integer.parseInt(IntegerTextField.this.getText()) + "");
                }
            }
        });
    }

    public int getValue() {
        int n = 0;
        try {
            n = Integer.parseInt(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    public void setRange(int n, int n2) {
        this.doc.setRange(n, n2);
        this.setToolTipText(new StringBuffer(20).append("[").append(n).append(", ").append(n2).append("]").toString());
    }

    public boolean isEmpty() {
        return this.getText().trim().length() == 0;
    }

    @Override
    public boolean isValid() {
        if (null != this.doc) {
            return this.doc.getMin() <= this.getValue();
        }
        return super.isValid();
    }
}

