/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.modulemanagement;

import com.swimap.iview.corbahelpers.ModuleInterface;
import com.swimap.iview.corbahelpers.RemoteReferenceStoreInterfaceOperations;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.ILocalReferenceStoreInterface;
import com.swimap.iview.framework.systemsettingsmanagement.SystemSettingsManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Timer;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;

public class RemoteReferenceStore
implements RemoteReferenceStoreInterfaceOperations {
    protected ILocalReferenceStoreInterface localStore = null;
    protected static final int MODULE_TIMEOUT_INTERVAL = 60000;
    private Hashtable remoteReferences = new Hashtable(11);
    protected Vector orderedRemoteReferences = new Vector(10);
    protected Timer moduleLifeCheckTimer = new Timer(60000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RemoteReferenceStore.this.checkRemoteModules();
        }
    });

    RemoteReferenceStore() {
    }

    public ModuleInterface getRemoteReference(String string) {
        return (ModuleInterface)this.remoteReferences.get(string);
    }

    public boolean register(String string, ModuleInterface moduleInterface) {
        boolean bl = false;
        if (this.remoteReferences.get(string) == null) {
            moduleInterface.initialize();
            this.remoteReferences.put(string, moduleInterface);
            this.orderedRemoteReferences.addElement(string);
            bl = true;
            if (this.remoteReferences.size() == 1) {
                this.moduleLifeCheckTimer.start();
            }
        }
        return bl;
    }

    public boolean unregister(String string) {
        boolean bl = false;
        if (this.remoteReferences.remove(string) != null) {
            bl = true;
            this.orderedRemoteReferences.remove(string);
            if (this.remoteReferences.size() == 0) {
                this.moduleLifeCheckTimer.stop();
            }
        }
        return bl;
    }

    protected void checkRemoteModules() {
        Enumeration enumeration = this.remoteReferences.keys();
        String string = null;
        ModuleInterface moduleInterface = null;
        boolean bl = false;
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            bl2 = false;
            string = (String)enumeration.nextElement();
            if (null != this.localStore && this.localStore.getLocalReference(string) != null) {
                bl2 = true;
            }
            if (bl2 || (moduleInterface = (ModuleInterface)this.remoteReferences.get(string)) == null) continue;
            try {
                bl = moduleInterface.isAlive();
            }
            catch (TRANSIENT tRANSIENT) {
                bl = false;
            }
            catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                bl = false;
            }
            catch (SystemException systemException) {
                bl = false;
            }
            if (bl) continue;
            this.unregister(string);
            BaseModule baseModule = this.localStore.getLocalReference("mainsystemsettingmanager");
            ((SystemSettingsManager)baseModule).processModuleExpiry(string);
        }
    }

    public void setLocalStore(ILocalReferenceStoreInterface iLocalReferenceStoreInterface) {
        this.localStore = iLocalReferenceStoreInterface;
    }

    public void restart() {
        this.remoteReferences.clear();
        this.orderedRemoteReferences.clear();
    }

    public ModuleInterface[] getAllRemoteModules() {
        int n = this.remoteReferences.size();
        ModuleInterface[] moduleInterfaceArray = new ModuleInterface[n];
        for (int i = 0; i < n; ++i) {
            moduleInterfaceArray[i] = (ModuleInterface)this.remoteReferences.get(this.orderedRemoteReferences.elementAt(i));
        }
        return moduleInterfaceArray;
    }
}

