/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.modulemanagement;

import com.swimap.iview.framework.IProgressDialog;
import com.swimap.iview.framework.IProgressPanel;
import com.swimap.iview.framework.ProgressPanel;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.LoadModuleFailedException;
import com.swimap.iview.framework.modulemanagement.ModuleInformation;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.outputmanagement.OutputManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

final class ModuleMngUtil {
    private static IviewLogger logger = IviewLogger.getLogger(ModuleMngUtil.class, "IVIEW");
    static Map<String, ArrayList<String>> appModuleIds = new HashMap<String, ArrayList<String>>(10);

    ModuleMngUtil() {
    }

    public static void showTimeInfo(boolean bl, String string) {
        if ("true".equals(System.getProperty("loadingtime.show"))) {
            String string2 = null;
            string2 = bl ? ModuleManager.res.getString("Starting_Time") : ModuleManager.res.getString("End_Time");
            MessageFormat messageFormat = new MessageFormat(string2);
            string2 = messageFormat.format(new String[]{string}) + System.currentTimeMillis();
            FrameworkUtilities.getOutputManager().addMessage(string2);
        }
    }

    public static String createMessage(String string, LoadModuleFailedException loadModuleFailedException) {
        StringBuffer stringBuffer = new StringBuffer(16);
        String string2 = ModuleManager.res.getString("Load_Failed");
        MessageFormat messageFormat = new MessageFormat(string2);
        if (loadModuleFailedException == null) {
            stringBuffer.append(messageFormat.format(new String[]{string}));
        } else {
            if (loadModuleFailedException.getModuleName() != null) {
                stringBuffer.append(messageFormat.format(new String[]{loadModuleFailedException.getModuleName()}));
            } else {
                stringBuffer.append(messageFormat.format(new String[]{string}));
            }
            stringBuffer.append(System.getProperty("line.separator"));
            stringBuffer.append(ModuleManager.res.getString("Detail_Message"));
            stringBuffer.append(loadModuleFailedException.getTableInfoForOutput());
        }
        return stringBuffer.toString();
    }

    public static void updateProgress(ModuleManager moduleManager, boolean bl) {
        boolean bl2 = ProgressPanel.isSmoothLoadingEnabled();
        if (bl2) {
            IProgressDialog iProgressDialog = FrameworkCommandProcessor.getInstance().getProgressDialog(bl);
            if (iProgressDialog != null) {
                IProgressPanel iProgressPanel = iProgressDialog.getProgressPanel();
                if (null == iProgressPanel) {
                    logger.error("the progressDialog is null");
                    return;
                }
                int n = ProgressPanel.getLoadTime() + ProgressPanel.getPreLoadingTime();
                if (iProgressPanel.getCurrentValue() < n) {
                    moduleManager.incrementProgressBarUnits(false, 1, bl);
                }
            }
        } else {
            moduleManager.incrementProgressBarUnits(false, 1, bl);
        }
    }

    public static BaseModule loadModule(ModuleManager moduleManager, ModuleInformation moduleInformation) {
        long l = System.currentTimeMillis();
        ModuleMngUtil.showTimeInfo(true, moduleInformation.getModuleLabel());
        BaseModule baseModule = null;
        try {
            baseModule = ModuleMngUtil.loadAndRegisterModule(moduleManager, moduleInformation);
        }
        catch (LoadModuleFailedException loadModuleFailedException) {
            logger.error(loadModuleFailedException.getMessage(), loadModuleFailedException);
            if (moduleInformation.isMustLoad()) {
                if (!FrameworkCommandProcessor.getInstance().isLoggingOut()) {
                    moduleManager.crashSystemWithDetailMessage(moduleInformation.getModuleLabel(), loadModuleFailedException);
                }
            } else {
                OutputManager outputManager = (OutputManager)moduleManager.getLocalModule("mainoutputbarmanager");
                if (null != outputManager) {
                    outputManager.addMessage("Module load is failed", loadModuleFailedException.getMessage());
                }
            }
            baseModule = null;
        }
        catch (ModuleManagementException moduleManagementException) {
            logger.error(moduleManagementException.toString());
            baseModule = null;
        }
        catch (Exception exception) {
            logger.error("Fail to load module" + moduleInformation.getClassName());
            logger.error(exception.getMessage(), exception);
            baseModule = null;
        }
        catch (Throwable throwable) {
            logger.error(throwable.getMessage(), throwable);
            logger.error("Fail to load module" + moduleInformation.getClassName());
            baseModule = null;
        }
        ModuleMngUtil.showTimeInfo(false, moduleInformation.getModuleLabel());
        if (null != baseModule) {
            ModuleMngUtil.printTimeForModuleForInit(moduleInformation, l, baseModule);
        }
        return baseModule;
    }

    public static BaseModule loadAppBckGrndModule(ModuleManager moduleManager, ModuleInformation moduleInformation, String string) {
        long l = System.currentTimeMillis();
        ModuleMngUtil.showTimeInfo(true, moduleInformation.getModuleLabel());
        BaseModule baseModule = null;
        try {
            baseModule = ModuleMngUtil.loadAndRegisterModule(moduleManager, moduleInformation);
            if (null != baseModule) {
                ModuleMngUtil.addModuleIdToMap(string, baseModule.getModuleName());
                ApplicationUtilities.populatesData(string, baseModule.getModuleName());
            }
        }
        catch (LoadModuleFailedException loadModuleFailedException) {
            logger.error(loadModuleFailedException.getMessage(), loadModuleFailedException);
            if (moduleInformation.isMustLoad()) {
                if (!FrameworkCommandProcessor.getInstance().isLoggingOut()) {
                    logger.debug("LoadModuleFailed Exception occured..." + moduleInformation.getModuleName());
                    logger.error(loadModuleFailedException.toString());
                }
            } else {
                OutputManager outputManager = (OutputManager)moduleManager.getLocalModule("mainoutputbarmanager");
                if (null != outputManager) {
                    outputManager.addMessage("Module load is failed", loadModuleFailedException.getMessage());
                }
            }
            baseModule = null;
        }
        catch (ModuleManagementException moduleManagementException) {
            logger.error(moduleManagementException.toString());
            baseModule = null;
        }
        catch (Exception exception) {
            logger.error("Fail to load module" + moduleInformation.getClassName());
            logger.error(exception.getMessage(), exception);
            baseModule = null;
        }
        catch (Throwable throwable) {
            logger.error(throwable.getMessage(), throwable);
            logger.error("Fail to load module" + moduleInformation.getClassName());
            baseModule = null;
        }
        ModuleMngUtil.showTimeInfo(false, moduleInformation.getModuleLabel());
        if (null != baseModule) {
            ModuleMngUtil.printTimeForModuleForInit(moduleInformation, l, baseModule);
        }
        return baseModule;
    }

    public static BaseModule loadAppModule(ModuleManager moduleManager, ModuleInformation moduleInformation, String string) {
        long l = System.currentTimeMillis();
        ModuleMngUtil.showTimeInfo(true, moduleInformation.getModuleLabel());
        BaseModule baseModule = null;
        try {
            baseModule = ModuleMngUtil.loadAndRegisterModule(moduleManager, moduleInformation);
            if (null != baseModule) {
                ModuleMngUtil.addModuleIdToMap(string, baseModule.getModuleName());
                ApplicationUtilities.populatesData(string, baseModule.getModuleName());
            }
        }
        catch (LoadModuleFailedException loadModuleFailedException) {
            logger.error(loadModuleFailedException.getMessage(), loadModuleFailedException);
            if (moduleInformation.isMustLoad()) {
                if (!FrameworkCommandProcessor.getInstance().isLoggingOut()) {
                    moduleManager.crashAppSystemWithDetailMessage(string, moduleInformation.getModuleLabel(), loadModuleFailedException);
                }
            } else {
                OutputManager outputManager = (OutputManager)moduleManager.getLocalModule("mainoutputbarmanager");
                if (null != outputManager) {
                    outputManager.addMessage("Module load is failed", loadModuleFailedException.getMessage());
                }
            }
            baseModule = null;
        }
        catch (ModuleManagementException moduleManagementException) {
            logger.error(moduleManagementException.toString());
            baseModule = null;
        }
        catch (Exception exception) {
            logger.error("Fail to load module" + moduleInformation.getClassName());
            logger.error(exception.getMessage(), exception);
            baseModule = null;
        }
        catch (Throwable throwable) {
            logger.error(throwable.getMessage(), throwable);
            logger.error("Fail to load module" + moduleInformation.getClassName());
            baseModule = null;
        }
        ModuleMngUtil.showTimeInfo(false, moduleInformation.getModuleLabel());
        if (null != baseModule) {
            ModuleMngUtil.printTimeForModuleForInit(moduleInformation, l, baseModule);
        }
        return baseModule;
    }

    private static void addModuleIdToMap(String string, String string2) {
        if (string != null) {
            ArrayList<String> arrayList = appModuleIds.get(string);
            if (arrayList != null) {
                arrayList.add(string2);
            }
            appModuleIds.put(string, arrayList);
        }
    }

    public static void postSequencedInit(ModuleManager moduleManager, ModuleInformation moduleInformation) {
        BaseModule baseModule = moduleManager.getLocalModule(moduleInformation.getModuleName(), false);
        if (baseModule != null) {
            try {
                logger.debug("Begin doPostSequencedInit : " + baseModule.getModuleName() + ", className: " + baseModule.getClass().getName());
                long l = System.currentTimeMillis();
                baseModule.postSequencedInit();
                long l2 = System.currentTimeMillis();
                logger.debug("PostSequencedInit time for the module: " + baseModule.getModuleName() + ", className: " + baseModule.getClass().getName() + " = " + (l2 - l));
                logger.debug(baseModule.getModuleName() + " is postSequencedInited.");
            }
            catch (Exception exception) {
                String string = baseModule.getModuleName() + " invoke postSequencedInited() failed.";
                logger.error(string);
                logger.error(exception.getMessage(), exception);
            }
            catch (Throwable throwable) {
                String string = baseModule.getModuleName() + " invoke postSequencedInited() failed.";
                logger.error(string);
                logger.error(throwable.getMessage(), throwable);
            }
        }
    }

    static void postSystemFinished(ModuleManager moduleManager, BaseModule baseModule, boolean bl, IProgressPanel iProgressPanel, int n, boolean bl2) {
        if (baseModule != null) {
            String string = baseModule.getModuleName();
            try {
                logger.debug("Begin postSystemLoadingFinish : " + string + ", className: " + baseModule.getClass().getName());
                long l = System.currentTimeMillis();
                baseModule.postSystemLoadingFinished();
                long l2 = System.currentTimeMillis();
                logger.debug("postSystemLoadingFinished time for the module: " + string + ", className: " + baseModule.getClass().getName() + " = " + (l2 - l));
                logger.debug(string + " is postSystemLoadingFinished.");
            }
            catch (Exception exception) {
                String string2 = string + " invoke postSystemLoadingFinished() failed.";
                logger.error(string2);
                logger.error(exception.getMessage(), exception);
            }
            catch (Throwable throwable) {
                String string3 = string + " invoke postSystemLoadingFinished() failed.";
                logger.error(string3);
                logger.error(throwable.getMessage(), throwable);
            }
            if (bl2 && bl && null != iProgressPanel && iProgressPanel.getCurrentValue() + n < 100) {
                moduleManager.incrementProgressBarUnits(false, n, bl2);
            }
        }
    }

    static int getCorePoolSize() {
        int n = Runtime.getRuntime().availableProcessors();
        return 2 * n + 1;
    }

    private static BaseModule loadAndRegisterModule(ModuleManager moduleManager, ModuleInformation moduleInformation) throws ModuleManagementException {
        long l = System.currentTimeMillis();
        ModuleMngUtil.showTimeInfo(true, moduleInformation.getModuleLabel());
        BaseModule baseModule = null;
        if (moduleInformation.isOrb) {
            baseModule = FrameworkUtilities.loadModule(moduleInformation.getClassName(), moduleManager, moduleManager.getORB(), moduleManager.getTerminalId(), moduleManager.getInstanceId());
            if (baseModule != null) {
                baseModule.setModuleName(moduleInformation.getModuleName());
                moduleManager.getLocalClientModuleList().addElement(moduleInformation);
                logger.debug("ModuleManager success to load  " + baseModule.getModuleName());
            }
        } else {
            baseModule = FrameworkUtilities.loadModule(moduleInformation.getClassName(), moduleManager);
            if (baseModule != null) {
                baseModule.setModuleName(moduleInformation.getModuleName());
                moduleManager.getLocalReferenceStore().register(moduleInformation.getModuleName(), baseModule);
                moduleManager.getLocalClientModuleList().addElement(moduleInformation);
                logger.debug("ModuleManager success to load  " + baseModule.getModuleName());
            }
        }
        return baseModule;
    }

    private static void printTimeForModuleForInit(ModuleInformation moduleInformation, long l, BaseModule baseModule) {
        long l2 = System.currentTimeMillis();
        logger.debug("Time taken to construct and initialize the module " + moduleInformation.getModuleLabel() + ", className: " + baseModule.getClass().getName() + " = " + (l2 - l));
    }
}

