/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.modulemanagement;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.commini.xmlbind.VALUE;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.modulemanagement.IModuleListInterface;
import com.swimap.iview.framework.modulemanagement.ModuleInformation;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class ModuleList
implements IModuleListInterface {
    private static IviewLogger logger = IviewLogger.getLogger(ModuleList.class, "IVIEW");
    private static Map<String, List<String>> extPathsAppLoaded = new ConcurrentHashMap<String, List<String>>(16);
    public static final String MODULELIST_DESC = "modulelist";
    protected Vector moduleInformations = new Vector(10);
    private static ArrayList pluginModuleClassNameList = new ArrayList(10);
    private static ArrayList moduleClassNameList = new ArrayList(10);
    private static Set moduleClassSet = new HashSet(16);
    private static ArrayList sharedClassModules = new ArrayList(10);
    private static HashSet<String> loadedModuleSet = new HashSet(10);
    private static ArrayList<String> notLicensedModules = null;
    private static ConcurrentHashMap<String, Boolean> moduleToLicense = new ConcurrentHashMap(2);
    private static final String PARA_OPTIONAL = "optional";
    private static final String NON_OPERATIONAL = "nonoperational";
    private static Map<String, List<String>> extModuleMap = new ConcurrentHashMap<String, List<String>>(10);
    private static Map<String, ModuleList> extModuleListMap = new ConcurrentHashMap<String, ModuleList>(16);

    @Override
    public Vector getModuleList() {
        return this.moduleInformations;
    }

    public void addModuleInformation(ModuleInformation moduleInformation) {
        this.moduleInformations.add(moduleInformation);
    }

    public void addAllModuleInformation(Vector vector) {
        int n = vector.size();
        ModuleInformation moduleInformation = null;
        for (int i = 0; i < n; ++i) {
            moduleInformation = (ModuleInformation)vector.elementAt(i);
            moduleInformation.validateLicense();
            ModuleList.setLicenseMaps(moduleInformation.getModuleName(), moduleInformation.isLicensed());
            this.addModuleInformation(moduleInformation);
        }
    }

    public static ModuleList loadModuleList(String string) throws ModuleManagementException {
        return ModuleList.loadModuleList(string, null);
    }

    private static ModuleList loadModuleList(String string, String string2) throws ModuleManagementException {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        CommStyleInfo commStyleInfo = null;
        commStyleInfo = ModuleList.getCommstyleInfo(string, string2);
        if (null == commStyleInfo) {
            return null;
        }
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(MODULELIST_DESC);
        if (null == areaDescContainer) {
            throw new ModuleManagementException(" The module list area no be found in style file.");
        }
        ModuleList moduleList = new ModuleList();
        int n = areaDescContainer.getDescCount();
        ModuleInformation moduleInformation = null;
        DescContainer descContainer = null;
        Object e = null;
        ResourceBundle resourceBundle = null;
        String string3 = null;
        Object var12_12 = null;
        Object var13_13 = null;
        Object var14_14 = null;
        Object var15_15 = null;
        for (int i = 0; i < n; ++i) {
            descContainer = areaDescContainer.getDescContainer(i);
            string3 = descContainer.getParasItemValue("type");
            if ("ResourceBundle".equals(string3)) {
                resourceBundle = ModuleList.getResourceBundle(descContainer);
                continue;
            }
            try {
                moduleInformation = ModuleList.getModuleInfoFromDesc(descContainer, resourceBundle, i);
                if (null != moduleInformation) {
                    moduleList.addModuleInformation(moduleInformation);
                    if (FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.application) {
                        String string4 = moduleInformation.getModuleName();
                        arrayList.add(string4);
                    }
                    moduleClassNameList.add(e);
                }
            }
            catch (Exception exception) {
                logger.error(exception.getMessage(), exception);
                logger.error(" The module desc in style file is error, the index is : " + i);
            }
            if (!FrameworkCommandProcessor.getInstance().isAppStyle() || null == string2 || extModuleMap.get(string2) == null) continue;
            extModuleMap.put(string2, arrayList);
        }
        return moduleList;
    }

    private static ResourceBundle getResourceBundle(DescContainer descContainer) {
        ResourceBundle resourceBundle = null;
        String string = descContainer.getParasItemValue("resourceBundleName");
        try {
            resourceBundle = ResourceMng.getInstance().getResourceBundleFromPropertyFile(string);
            if (null == resourceBundle) {
                resourceBundle = ResourceBundle.getBundle(string);
            }
        }
        catch (Exception exception) {
            logger.error(exception);
        }
        return resourceBundle;
    }

    private static ModuleInformation getModuleInfoFromDesc(DescContainer descContainer, ResourceBundle resourceBundle, int n) {
        Object object;
        String string;
        String string2;
        String string3;
        ModuleInformation moduleInformation = null;
        Object var4_4 = null;
        Vector<String> vector = null;
        Vector<String> vector2 = null;
        PARA pARA = null;
        String string4 = null;
        String string5 = string3 = descContainer.getDescName();
        if (resourceBundle != null) {
            try {
                string5 = resourceBundle.getString(string3);
            }
            catch (MissingResourceException missingResourceException) {
                string5 = string3;
            }
        }
        if (moduleClassNameList.contains(string2 = descContainer.getParasItem("ClassName").getValue()) || pluginModuleClassNameList.contains(string2)) {
            StringBuffer stringBuffer = new StringBuffer(16);
            stringBuffer.append(string2);
            stringBuffer.append(" of module ");
            stringBuffer.append(string3);
            stringBuffer.append(" in desc ");
            stringBuffer.append(n);
            stringBuffer.append(" has been loaded!");
            logger.error(stringBuffer.toString());
            return null;
        }
        boolean bl = Boolean.valueOf(descContainer.getParasItem("RunInProcess").getValue());
        int n2 = Integer.parseInt(descContainer.getParasItem("ProcessKey").getValue());
        boolean bl2 = Boolean.valueOf(descContainer.getParasItem("ToBeLoaded").getValue());
        boolean bl3 = Boolean.valueOf(descContainer.getParasItem("IsJavaModule").getValue());
        boolean bl4 = true;
        PARA pARA2 = descContainer.getParasItem("IsOrbModule");
        if (pARA2 != null && (string = pARA2.getValue()) != null) {
            bl4 = Boolean.valueOf(string);
        }
        boolean bl5 = false;
        PARA pARA3 = descContainer.getParasItem("IsMustLoad");
        if (pARA3 != null && (object = pARA3.getValue()) != null) {
            bl5 = Boolean.valueOf((String)object);
        }
        vector = new Vector<String>(5);
        vector2 = new Vector<String>(5);
        object = descContainer.getParasItem("dependModules");
        if (object != null) {
            VALUE[] vALUEArray = ((PARA)object).getVALUE();
            for (int i = 0; i < vALUEArray.length; ++i) {
                string4 = vALUEArray[i].getValue();
                if (string4 == null) continue;
                if (!PARA_OPTIONAL.equals(vALUEArray[i].getType())) {
                    vector2.add(string4);
                }
                vector.add(string4);
                string4 = null;
            }
        }
        int n3 = -1;
        String string6 = descContainer.getParasItemValue("serialnumber");
        if (string6 != null && string6.length() > 0) {
            try {
                n3 = Integer.parseInt(string6);
            }
            catch (Exception exception) {
                logger.error("The module desc in style file is error, the desc name is :" + string3);
                logger.error(exception.getMessage(), exception);
            }
        }
        moduleInformation = new ModuleInformation(string2, bl, n2, bl2, bl3, bl4, string3, string5, bl5, vector, n3);
        pARA = descContainer.getParasItem("SpecificLoadingStates");
        String string7 = descContainer.getParasItemValue("license");
        moduleInformation.setLicenseKeys(string7);
        moduleInformation.setStates(ModuleList.getStates(pARA));
        moduleInformation.setOperational(ModuleList.isOperational(pARA));
        moduleInformation.setRequiredDependModules(vector2);
        return moduleInformation;
    }

    private static CommStyleInfo getCommstyleInfo(String string, String string2) {
        CommStyleInfo commStyleInfo = null == string2 ? CommStyleManager.getInstance().getCommonStyleFromDefaultAndProductStyle(string) : CommStyleManager.getInstance().getCommonStyleFromDefaultAndProductStyleOfExtPath(string, string2);
        return commStyleInfo;
    }

    private static boolean isOperational(PARA pARA) {
        if (null == pARA) {
            return true;
        }
        String string = pARA.getType();
        return !NON_OPERATIONAL.equals(string);
    }

    private static int[] getStates(PARA pARA) {
        if (null == pARA) {
            return new int[0];
        }
        VALUE[] vALUEArray = pARA.getVALUE();
        int[] nArray = new int[vALUEArray.length];
        int n = 0;
        String string = null;
        for (VALUE vALUE : vALUEArray) {
            try {
                string = vALUE.getValue().trim();
                nArray[n] = Integer.parseInt(string);
                ++n;
            }
            catch (NumberFormatException numberFormatException) {
                logger.error("Invalid state given " + numberFormatException);
            }
        }
        return nArray;
    }

    public void loadExtModuleList(String string) {
        this.loadExtModuleList(string, null);
    }

    public void loadExtModuleList(String string, String string2) {
        try {
            ModuleList moduleList = ModuleList.loadModuleList(string, string2);
            if (moduleList != null) {
                this.addAllModuleInformation(moduleList.getModuleList());
            } else {
                logger.warn("Cann't find modulelist file:" + string);
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
        }
    }

    public void loadAppExtModuleList(String string, String string2, String string3) {
        ModuleList moduleList;
        if (!extModuleListMap.containsKey(string2)) {
            try {
                moduleList = ModuleList.loadModuleList(string, string2);
                if (null != moduleList) {
                    extModuleListMap.put(string2, moduleList);
                }
            }
            catch (ModuleManagementException moduleManagementException) {
                moduleManagementException.printStackTrace();
            }
        }
        if ((moduleList = extModuleListMap.get(string2)) != null) {
            this.addAllModuleInformation(moduleList.getModuleList());
        } else {
            logger.warn("Cann't find modulelist file:" + string);
        }
        ArrayList arrayList = new ArrayList(10);
        if (!"".equals(string3)) {
            if (null != string2 && !extPathsAppLoaded.containsKey(string2)) {
                arrayList.add(string3);
            } else {
                if (null != string2) {
                    arrayList = (ArrayList)extPathsAppLoaded.get(string2);
                    arrayList.add(string3);
                    ApplicationUtilities.addModuleIds(string3, ModuleList.getModuleIdsOfExtPath(string2));
                }
                logger.error("Already loaded extPaths:" + string2);
            }
            if (null != string2 && null != arrayList) {
                extPathsAppLoaded.put(string2, arrayList);
            }
        }
    }

    public static void empty() {
        moduleClassNameList.clear();
        moduleClassNameList.addAll(pluginModuleClassNameList);
        moduleToLicense.clear();
        if (null != notLicensedModules) {
            notLicensedModules.clear();
        }
        extPathsAppLoaded.clear();
        extModuleMap.clear();
        extModuleListMap.clear();
    }

    public static ModuleList loadModuleList(CommStyleInfo commStyleInfo, boolean bl) throws ModuleManagementException {
        SubsystemManager subsystemManager = SubsystemManager.getInstance();
        if (null == commStyleInfo) {
            return null;
        }
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(MODULELIST_DESC);
        if (null == areaDescContainer) {
            throw new ModuleManagementException("The modulelistareaDescContainer not found in style file.");
        }
        ModuleList moduleList = new ModuleList();
        int n = areaDescContainer.getDescCount();
        ModuleInformation moduleInformation = null;
        DescContainer descContainer = null;
        String string = null;
        ResourceBundle resourceBundle = null;
        String string2 = null;
        Vector<String> vector = null;
        Vector<String> vector2 = null;
        PARA pARA = null;
        String string3 = null;
        for (int i = 0; i < n; ++i) {
            descContainer = areaDescContainer.getDescContainer(i);
            string2 = descContainer.getParasItemValue("type");
            if ("ResourceBundle".equals(string2)) {
                resourceBundle = ModuleList.getResourceBundle(descContainer);
                continue;
            }
            try {
                Object object;
                boolean bl2;
                String string4;
                String string5 = string4 = descContainer.getDescName();
                if (null != resourceBundle) {
                    try {
                        string5 = resourceBundle.getString(string4);
                    }
                    catch (MissingResourceException missingResourceException) {
                        string5 = string4;
                    }
                }
                if (!(bl2 = loadedModuleSet.add(string5))) {
                    return null;
                }
                string = descContainer.getParasItemValue("ClassName");
                boolean bl3 = false;
                int n2 = 0;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = true;
                boolean bl7 = false;
                vector = new Vector<String>(10);
                vector2 = new Vector<String>(5);
                if (null != string) {
                    Object object2;
                    Object object3;
                    if ((moduleClassNameList.contains(string) || pluginModuleClassNameList.contains(string)) && !bl && sharedClassModules.contains(string)) {
                        object = new StringBuffer(16);
                        ((StringBuffer)object).append(string);
                        ((StringBuffer)object).append(" of module ");
                        ((StringBuffer)object).append(string4);
                        ((StringBuffer)object).append(" in desc ");
                        ((StringBuffer)object).append(i);
                        ((StringBuffer)object).append(" has been loaded!");
                        logger.error(((StringBuffer)object).toString());
                        continue;
                    }
                    bl3 = Boolean.valueOf(descContainer.getParasItemValue("RunInProcess"));
                    n2 = Integer.parseInt(descContainer.getParasItemValue("ProcessKey"));
                    bl4 = Boolean.valueOf(descContainer.getParasItemValue("ToBeLoaded"));
                    bl5 = Boolean.valueOf(descContainer.getParasItemValue("IsJavaModule"));
                    object = descContainer.getParasItem("IsOrbModule");
                    if (null != object && null != (object3 = ((PARA)object).getValue())) {
                        bl6 = Boolean.valueOf((String)object3);
                    }
                    if (null != (object3 = descContainer.getParasItem("IsMustLoad")) && null != (object2 = ((PARA)object3).getValue())) {
                        bl7 = Boolean.valueOf((String)object2);
                    }
                    if (null != (object2 = descContainer.getParasItem("dependModules"))) {
                        VALUE[] vALUEArray = ((PARA)object2).getVALUE();
                        for (int j = 0; j < vALUEArray.length; ++j) {
                            string3 = vALUEArray[j].getValue();
                            if (null == string3) continue;
                            if (!PARA_OPTIONAL.equals(vALUEArray[j].getType())) {
                                vector2.add(string3);
                            }
                            vector.add(string3);
                        }
                    }
                }
                moduleInformation = new ModuleInformation(string, bl3, n2, bl4, bl5, bl6, string4, string5, bl7, vector, -1);
                pARA = descContainer.getParasItem("SpecificLoadingStates");
                object = descContainer.getParasItemValue("license");
                moduleInformation.setLicenseKeys((String)object);
                moduleInformation.setStates(ModuleList.getStates(pARA));
                moduleInformation.setOperational(ModuleList.isOperational(pARA));
                moduleInformation.setRequiredDependModules(vector2);
                moduleList.addModuleInformation(moduleInformation);
                if (null == string) continue;
                moduleClassNameList.add(string);
                if (!bl) {
                    pluginModuleClassNameList.add(string);
                    sharedClassModules.add(string);
                }
                if (null == subsystemManager) continue;
                break;
            }
            catch (Exception exception) {
                logger.error(exception.getMessage(), exception);
                logger.error(" The module desc in style file is error, the index is : " + i);
            }
        }
        return moduleList;
    }

    static void setLicenseMaps(String string, boolean bl) {
        if (null == string) {
            return;
        }
        boolean bl2 = bl;
        Boolean bl3 = moduleToLicense.get(string);
        if (null != bl3) {
            bl2 = bl3;
        } else {
            moduleToLicense.put(string, bl2);
        }
        if (!bl2) {
            if (null == notLicensedModules) {
                notLicensedModules = new ArrayList(0);
            }
            notLicensedModules.add(string);
        }
    }

    public static void clearSharedClassModules() {
        if (null != sharedClassModules) {
            sharedClassModules.clear();
        }
    }

    public static ArrayList<String> getNotLicensedModule() {
        return notLicensedModules;
    }

    public static boolean addModuleClassName(String string) {
        if (null != string) {
            pluginModuleClassNameList.add(string);
            return moduleClassNameList.add(string);
        }
        return false;
    }

    public static boolean removeModuleClassName(String string) {
        pluginModuleClassNameList.remove(string);
        return moduleClassNameList.remove(string);
    }

    public static boolean removeModuleClassNameFromExt(String string) {
        return moduleClassNameList.remove(string);
    }

    public static void cleanupModuleListWhileOSGIExit() {
        loadedModuleSet.clear();
        if ("true".equals(System.getProperty("iview.osgi")) && "false".equals(System.getProperty("client.osgi.exit"))) {
            moduleClassNameList.clear();
            pluginModuleClassNameList.clear();
            sharedClassModules.clear();
        }
    }

    public static void clearWhileSwitchToStyle() {
        loadedModuleSet.clear();
        moduleClassNameList.clear();
        pluginModuleClassNameList.clear();
        sharedClassModules.clear();
    }

    public static void removeModuleId(String string) {
        loadedModuleSet.remove(string);
    }

    public static void reAddModuleIds(Set<String> set) {
        loadedModuleSet.addAll(set);
    }

    public static void addModuleId(String string) {
        loadedModuleSet.add(string);
    }

    public static void addSharedClassModuleName(String string) {
        if (null != string) {
            sharedClassModules.add(string);
        }
    }

    static List<String> getModuleIdsOfExtPath(String string) {
        if (string != null) {
            return extModuleMap.get(string);
        }
        return null;
    }

    static boolean checkNeedsToUnloadExtPath(String string, String string2) {
        if (null == string) {
            return false;
        }
        List<String> list = extPathsAppLoaded.get(string);
        if (list.contains(string2)) {
            return list.contains(string2) && list.size() == 1;
        }
        return false;
    }

    static void removeAppFromExtPaths(String string, String string2) {
        if (null == string) {
            return;
        }
        List<String> list = extPathsAppLoaded.get(string);
        if (list.contains(string2) && list.contains(string2) && list.size() == 1) {
            list.remove(string2);
        }
    }
}

