/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.modulemanagement;

import com.swimap.iview.framework.licensemanagement.LicenseService;
import com.swimap.iview.framework.licensemanagement.LicenseUtilities;
import com.swimap.iview.framework.modulemanagement.IModuleInformationInterface;
import com.swimap.iview.util.log.IviewLogger;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ModuleInformation
implements IModuleInformationInterface {
    public static final String PARAM_CLASSNAME = "ClassName";
    public static final String PARAM_INPROCESS = "RunInProcess";
    public static final String PARAM_PROCESSKEY = "ProcessKey";
    public static final String PARAM_LOADMODULE = "ToBeLoaded";
    public static final String PARAM_ISJAVA = "IsJavaModule";
    public static final String PARAM_ISMUSTLOAD = "IsMustLoad";
    public static final String PARAM_DEPENDMODULS = "dependModules";
    public static final String PARAM_SERIALNUMBER = "serialnumber";
    public static final String PARAM_LICENSE = "license";
    public static final String PARAM_STATE = "SpecificLoadingStates";
    private static final int PROCESS_KEY_IN_PROCESS = 0;
    private static final int PROCESS_KEY_NONE_JAVA = 65535;
    protected String className = null;
    protected boolean inProcess = false;
    protected int processKey = -1;
    protected boolean loadModule = false;
    protected boolean isJava = false;
    protected boolean isMustLoad = false;
    protected Vector<String> dependModules = null;
    public static final String PARAM_ISORB = "IsOrbModule";
    protected boolean isOrb = false;
    protected int moduleOrder = -1;
    protected int groupNo = -1;
    protected String moduleName = null;
    protected String moduleLabel = null;
    private boolean licensed = true;
    private String licenseKeys = "";
    private Vector<String> requiredDependModules = null;
    private static IviewLogger logger = IviewLogger.getLogger(ModuleInformation.class, "IVIEW");
    private int[] states = null;
    private volatile ModuleState moduleState = ModuleState.preLoad;
    final Lock INIT_LOCK = new ReentrantLock();
    final Lock POST_SEQ_LOCK = new ReentrantLock();
    final Lock POST_SEQ_FIN_LOCK = new ReentrantLock();
    private boolean isOperational = true;

    public void setLicensed(boolean bl) {
        this.licensed = bl;
    }

    protected void setLicenseKeys(String string) {
        this.licenseKeys = string;
    }

    public String getLicenseKeys() {
        return this.licenseKeys;
    }

    public void validateLicense() {
        this.licensed = true;
        if (null != this.licenseKeys && this.licenseKeys.length() > 1) {
            try {
                LicenseUtilities.loadLicenseService();
                LicenseService licenseService = LicenseUtilities.getLicenseService();
                if (null == licenseService) {
                    logger.trace("license is null for" + this.moduleName);
                    this.licensed = false;
                } else {
                    this.licensed = licenseService.checkLicense(this.licenseKeys.split("( )*,( )*"));
                }
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
                this.licensed = false;
            }
        }
    }

    public boolean isLicensed() {
        return this.licensed;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    public String getModuleLabel() {
        return this.moduleLabel;
    }

    public ModuleInformation(String string, boolean bl, int n, boolean bl2, boolean bl3, boolean bl4, String string2, String string3, boolean bl5, Vector vector, int n2) {
        this.className = string;
        this.inProcess = bl;
        this.processKey = n;
        this.loadModule = bl2;
        this.isJava = bl3;
        if (this.inProcess) {
            this.processKey = 0;
        }
        if (!bl3) {
            this.processKey = 65535;
        }
        this.isOrb = bl4;
        this.moduleName = string2;
        this.moduleLabel = string3;
        this.isMustLoad = bl5;
        this.dependModules = vector;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean startModuleInProcess() {
        return this.inProcess;
    }

    @Override
    public int getProcessKey() {
        return this.processKey;
    }

    @Override
    public boolean loadModule() {
        return this.loadModule;
    }

    @Override
    public boolean isJavaModule() {
        return this.isJava;
    }

    public boolean isMustLoad() {
        return this.isMustLoad;
    }

    public Vector<String> getDependModules() {
        return null == this.dependModules ? new Vector<String>() : this.dependModules;
    }

    Vector<String> getRequiredDependModules() {
        return this.requiredDependModules;
    }

    void setRequiredDependModules(Vector<String> vector) {
        this.requiredDependModules = vector;
    }

    void removeRequiredDependModules(String string) {
        if (this.requiredDependModules.contains(string)) {
            this.requiredDependModules.remove(string);
        }
    }

    public void setGroupNo(int n) {
        this.groupNo = n;
    }

    public int getGroupNo() {
        return this.groupNo;
    }

    public void setModuleOrder(int n) {
        this.moduleOrder = n;
    }

    public int getModuleOrder() {
        return this.moduleOrder;
    }

    public int getSerialNo() {
        return -1;
    }

    public void setStates(int[] nArray) {
        this.states = nArray;
    }

    public int[] getStates() {
        return this.states;
    }

    public void setOperational(boolean bl) {
        this.isOperational = bl;
    }

    public boolean isOperational() {
        return this.isOperational;
    }

    public String toString() {
        return "Class Name: " + this.className + ", Module Name: " + this.moduleName + ", License Keys: " + this.licenseKeys + ", Licensed: " + this.licensed + ", isMustLoad: " + this.isMustLoad + ", isOperational: " + this.isOperational + ", Depend Modules:" + this.dependModules;
    }

    public ModuleState getModuleState() {
        return this.moduleState;
    }

    public void setModuleState(ModuleState moduleState) {
        logger.debug("setModuleState for Module:" + (Object)((Object)moduleState) + "for moduleName:" + this.moduleName);
        this.moduleState = moduleState;
    }

    public static enum ModuleState {
        preLoad,
        init,
        postSeqInit,
        postSysFinish,
        lowPriority;

    }
}

