/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.modulemanagement;

import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.ILocalReferenceStoreInterface;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.util.log.IviewLogger;
import java.util.Hashtable;
import java.util.Vector;

public class LocalReferenceStore
implements ILocalReferenceStoreInterface {
    private static IviewLogger logger = IviewLogger.getLogger(LocalReferenceStore.class, "IVIEW");
    protected Hashtable localReferences = new Hashtable(11);
    protected Vector orderedLocalReferences = new Vector(10);

    @Override
    public BaseModule getLocalReference(String string) {
        return (BaseModule)this.localReferences.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(String string, BaseModule baseModule) throws ModuleManagementException {
        long l = System.currentTimeMillis();
        if (string == null) {
            logger.error("moduleID  as null,so module will not load");
            return;
        }
        if (baseModule != null) {
            logger.debug("Started to initialize the module : " + string + ", className: " + baseModule.getClass().getName());
            baseModule.initialize();
            logger.debug("Finished to initialize the module : " + string + ", className: " + baseModule.getClass().getName());
            logger.debug("Time taken to initialize the module : " + string + ", className: " + baseModule.getClass().getName() + " = " + (System.currentTimeMillis() - l));
        }
        LocalReferenceStore localReferenceStore = this;
        synchronized (localReferenceStore) {
            if (this.localReferences.get(string) != null) {
                throw new ModuleManagementException("Failed to register the local module with Id = " + string + " since the Module Id is already used");
            }
            this.localReferences.put(string, baseModule);
            this.orderedLocalReferences.addElement(string);
            logger.debug("Finished the module initialization : " + string);
        }
    }

    @Override
    public synchronized boolean unregister(String string) {
        boolean bl = false;
        if (null == string) {
            logger.error("moduleID is null, so it will not unregister");
            return false;
        }
        if (!Main.instance().isCallExit() && string.startsWith("main") && string.endsWith("manager")) {
            this.printStackTrace(string);
        }
        if (this.localReferences.remove(string) != null) {
            bl = true;
        }
        this.orderedLocalReferences.remove(string);
        return bl;
    }

    private void printStackTrace(String string) {
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append("module(").append(string).append(")is unregistered illegally:").append(System.getProperty("line.separator"));
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuffer.append("    at ");
            stringBuffer.append(stackTraceElementArray[i].toString());
            stringBuffer.append('\n');
        }
        logger.debug(stringBuffer.toString());
    }

    @Override
    public synchronized void restart() {
        this.localReferences.clear();
        this.orderedLocalReferences.clear();
    }

    @Override
    public BaseModule[] getAllLocalModules() {
        int n = this.orderedLocalReferences.size();
        BaseModule[] baseModuleArray = new BaseModule[n];
        for (int i = 0; i < n; ++i) {
            baseModuleArray[i] = (BaseModule)this.localReferences.get(this.orderedLocalReferences.elementAt(i));
        }
        return baseModuleArray;
    }
}

