/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.modulemanagement;

import com.swimap.iview.corbahelpers.DataChangeListenerInterface;
import com.swimap.iview.corbahelpers.DataChangeListenerInterfaceOperations;
import com.swimap.iview.corbahelpers.DataChangeNotification;
import com.swimap.iview.corbahelpers.DataShareInterface;
import com.swimap.iview.corbahelpers.DataShareInterfaceOperations;
import com.swimap.iview.corbahelpers.InternalEvent;
import com.swimap.iview.corbahelpers.ModuleInterface;
import com.swimap.iview.corbahelpers.ModuleInterfaceOperations;
import com.swimap.iview.corbahelpers.ModuleInterfacePackage.CrossInvokeException;
import com.swimap.iview.framework.datasharemanagement.BaseDataShare;
import com.swimap.iview.framework.datasharemanagement.DataShareManagementException;
import com.swimap.iview.framework.datasharemanagement.DataShareManager;
import com.swimap.iview.framework.datasharemanagement.IModuleDataShareInterface;
import com.swimap.iview.framework.modulemanagement.ICustomInternalEvent;
import com.swimap.iview.framework.modulemanagement.IModuleManagementExtendedInterface;
import com.swimap.iview.framework.modulemanagement.IModuleServicesInterface;
import com.swimap.iview.framework.modulemanagement.InternalLocalMsg;
import com.swimap.iview.framework.modulemanagement.ModuleInformation;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.modulemanagement.ParameterList;
import com.swimap.iview.framework.outputmanagement.OutputManager;
import com.swimap.iview.framework.util.AnyConverter;
import com.swimap.iview.framework.util.AnyTypeHelper;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.adapter.FrameworkHelper;
import com.swimap.iview.util.log.IviewLogger;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.TimerTask;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.TypeCode;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;

public abstract class BaseModule
implements IModuleServicesInterface,
IModuleManagementExtendedInterface,
IModuleDataShareInterface,
ModuleInterfaceOperations {
    private static IviewLogger logger = IviewLogger.getLogger(BaseModule.class, "IVIEW");
    protected static final int FRAMEWORK_TIMEOUT_INTERVAL = 120000;
    protected ModuleManager moduleManager = null;
    protected boolean isLocalModule = true;
    protected DataShareManager dataShareManager = new DataShareManager();
    protected ORB orb = null;
    protected TimerTask frameworkLifeCheckTimer = null;
    protected String terminalId = null;
    protected String instanceId = null;
    private String baseModuleName = null;

    public BaseModule(ModuleManager moduleManager, ORB oRB, String string, String string2) {
        this.moduleManager = moduleManager;
        this.isLocalModule = true;
        this.orb = oRB;
        this.terminalId = string;
        this.instanceId = string2;
    }

    public BaseModule(ORB oRB, String string, String string2) {
        this.orb = oRB;
        this.terminalId = string;
        this.instanceId = string2;
        POA pOA = null;
        if (this.orb != null) {
            try {
                pOA = POAHelper.narrow((Object)this.orb.resolve_initial_references("RootPOA"));
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            this.moduleManager = new ModuleManager(false, pOA, this.orb, this.terminalId, this.instanceId);
            this.moduleManager.loadRemoteStore(this.terminalId, this.instanceId);
        }
        this.isLocalModule = false;
    }

    @Override
    public void register(ModuleInterface moduleInterface) throws ModuleManagementException {
        this.moduleManager.register(this.getModuleName(), moduleInterface);
        this.frameworkLifeCheckTimer = new TimerTask(){

            @Override
            public void run() {
                BaseModule.this.abort();
            }
        };
        FrameworkUtilities.getSystemTimer().schedule(this.frameworkLifeCheckTimer, 120000L, 120000L);
    }

    @Override
    public void register(BaseModule baseModule) throws ModuleManagementException {
        this.moduleManager.register(this.getModuleName(), baseModule);
    }

    @Override
    public boolean unregister(String string, int n) {
        if (this.frameworkLifeCheckTimer != null) {
            this.frameworkLifeCheckTimer.cancel();
            this.frameworkLifeCheckTimer = null;
        }
        return this.moduleManager.unregister(string, n);
    }

    @Override
    public boolean unregister(int n) {
        return this.unregister(this.getModuleName(), n);
    }

    @Override
    public ModuleInterfaceOperations getReference(String string, String string2) throws ModuleManagementException {
        return this.moduleManager.getReference(string, string2);
    }

    public ModuleInterfaceOperations getReference(String string, String string2, boolean bl) throws ModuleManagementException {
        return this.moduleManager.getReference(string, string2, bl);
    }

    @Override
    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    @Override
    public void initializeModule(String string) throws ModuleManagementException {
        ModuleInterfaceOperations moduleInterfaceOperations = this.getReference(string, "com.swimap.iview.corbahelpers.ModuleInterfaceHelper");
        moduleInterfaceOperations.initialize();
    }

    @Override
    public void reinitializeModule(String string) throws ModuleManagementException {
        ModuleInterfaceOperations moduleInterfaceOperations = this.getReference(string, "com.swimap.iview.corbahelpers.ModuleInterfaceHelper");
        moduleInterfaceOperations.reinitialize();
    }

    @Override
    public void stopModule(String string) throws ModuleManagementException {
        ModuleInterfaceOperations moduleInterfaceOperations = this.getReference(string, "com.swimap.iview.corbahelpers.ModuleInterfaceHelper");
        moduleInterfaceOperations.stop();
    }

    @Override
    public boolean isModuleAlive(String string) throws ModuleManagementException {
        ModuleInterfaceOperations moduleInterfaceOperations = this.getReference(string, "com.swimap.iview.corbahelpers.ModuleInterfaceHelper");
        return moduleInterfaceOperations.isAlive();
    }

    @Override
    public void lockModule(String string) throws ModuleManagementException {
        ModuleInterfaceOperations moduleInterfaceOperations = this.getReference(string, "com.swimap.iview.corbahelpers.ModuleInterfaceHelper");
        moduleInterfaceOperations.lock();
    }

    @Override
    public void unlockModule(String string) throws ModuleManagementException {
        ModuleInterfaceOperations moduleInterfaceOperations = this.getReference(string, "com.swimap.iview.corbahelpers.ModuleInterfaceHelper");
        moduleInterfaceOperations.unlock();
    }

    @Override
    public void restartModuleIdleTimer(String string) throws ModuleManagementException {
        ModuleInterfaceOperations moduleInterfaceOperations = this.getReference(string, "com.swimap.iview.corbahelpers.ModuleInterfaceHelper");
        moduleInterfaceOperations.restartIdleTimer();
    }

    @Override
    public int getModuleIdleTimeLeft(String string) throws ModuleManagementException {
        ModuleInterfaceOperations moduleInterfaceOperations = this.getReference(string, "com.swimap.iview.corbahelpers.ModuleInterfaceHelper");
        return moduleInterfaceOperations.getIdleTimeLeft();
    }

    public BaseModule getLocalReference(String string) throws ModuleManagementException {
        return this.moduleManager.getLocalReference(string);
    }

    public ModuleInterfaceOperations getRemoteReference(String string, String string2) throws ModuleManagementException {
        return this.moduleManager.getRemoteReference(string, string2);
    }

    @Override
    public java.lang.Object crossInvoke(String string, String string2, String string3, ParameterList parameterList) throws ModuleManagementException, CrossInvokeException {
        return this.moduleManager.crossInvoke(string, string2, string3, parameterList);
    }

    @Override
    public java.lang.Object crossInvoke(String string, String string2, String string3, String[] stringArray) throws ModuleManagementException, CrossInvokeException {
        return this.moduleManager.crossInvoke(string, string2, string3, stringArray);
    }

    @Override
    public void sendEvent(String string, InternalEvent internalEvent) throws ModuleManagementException {
        if ("mainmodulemanager".equalsIgnoreCase(string)) {
            this.moduleManager.processEvent(internalEvent);
            return;
        }
        ModuleInterfaceOperations moduleInterfaceOperations = this.getReference(string, "com.swimap.iview.corbahelpers.ModuleInterfaceHelper");
        if (moduleInterfaceOperations != null) {
            internalEvent.senderModuleId = this.getModuleName();
            moduleInterfaceOperations.processEvent(internalEvent);
        }
    }

    public void sendAsynEvent(final String string, final InternalEvent internalEvent) throws ModuleManagementException {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    BaseModule.this.sendEvent(string, internalEvent);
                }
                catch (ModuleManagementException moduleManagementException) {
                    logger.trace(moduleManagementException.getMessage(), moduleManagementException);
                }
            }
        };
        thread.start();
    }

    @Override
    public void sendEvent(String string, ICustomInternalEvent iCustomInternalEvent) throws ModuleManagementException {
        if ("mainmodulemanager".equalsIgnoreCase(string)) {
            this.moduleManager.processLocalEvent(iCustomInternalEvent);
            return;
        }
        BaseModule baseModule = this.getLocalReference(string);
        if (baseModule != null) {
            iCustomInternalEvent.setSenderId(this.getModuleName());
            baseModule.processLocalEvent(iCustomInternalEvent);
        }
    }

    @Override
    public void broadcastEvent(InternalEvent internalEvent) {
        String string;
        int n = 0;
        BaseModule baseModule = null;
        internalEvent.senderModuleId = this.getModuleName();
        BaseModule[] baseModuleArray = this.moduleManager.getAllLocalModules();
        n = Array.getLength(baseModuleArray);
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            string2 = baseModuleArray[i].getModuleName();
            if (string2 == null) {
                string = baseModuleArray[i].getClass().getName();
                logger.warn(string + "'s module name is null, can't" + " process the InternalEvent.");
                continue;
            }
            if (string2.equals(this.getModuleName())) continue;
            try {
                baseModuleArray[i].processEvent(internalEvent);
                continue;
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
        ModuleInterface[] moduleInterfaceArray = this.moduleManager.getAllRemoteModules();
        n = null == moduleInterfaceArray ? 0 : Array.getLength(moduleInterfaceArray);
        string = null;
        for (int i = 0; i < n; ++i) {
            string = moduleInterfaceArray[i].getModuleName();
            try {
                baseModule = this.getLocalReference(string);
            }
            catch (ModuleManagementException moduleManagementException) {
                baseModule = null;
            }
            if (baseModule != null || string == null || string.equals(this.getModuleName())) continue;
            moduleInterfaceArray[i].processEvent(internalEvent);
        }
    }

    public void broadcastAsynEvent(final InternalEvent internalEvent) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                BaseModule.this.broadcastEvent(internalEvent);
            }
        };
        thread.start();
    }

    @Override
    public DataShareManager getDataShareManager() {
        return this.dataShareManager;
    }

    @Override
    public void setDataShareManager(DataShareManager dataShareManager) {
        this.dataShareManager = dataShareManager;
    }

    @Override
    public DataShareInterfaceOperations getDataShare(String string, String string2, String string3) throws ModuleManagementException, DataShareManagementException {
        BaseDataShare baseDataShare = null;
        BaseModule baseModule = null;
        try {
            baseModule = this.getLocalReference(string);
        }
        catch (ModuleManagementException moduleManagementException) {
            logger.trace(moduleManagementException.getMessage(), moduleManagementException);
        }
        if (baseModule != null) {
            baseDataShare = baseModule.getLocalDataShare(string2);
        } else {
            baseModule = this.getRemoteReference(string, "com.swimap.iview.corbahelpers.ModuleInterfaceHelper");
            if (baseModule != null) {
                DataShareInterface dataShareInterface = baseModule.getRemoteDataShare(string2);
                if (dataShareInterface != null) {
                    if (!"com.swimap.iview.corbahelpers.DataShareInterface".equals(string3)) {
                        dataShareInterface = (DataShareInterface)FrameworkUtilities.invokeNarrow(string3, (Object)dataShareInterface);
                    }
                    baseDataShare = dataShareInterface;
                } else {
                    logger.error("Failed to get the remote data share interface with Id = " + string2 + ". The interface does not exist");
                    throw new DataShareManagementException("Failed to get the data share interface with Id = " + string2);
                }
            }
        }
        return baseDataShare;
    }

    @Override
    public void addDataShareInterface(String string, BaseDataShare baseDataShare) throws DataShareManagementException {
        this.dataShareManager.addDataShareInterface(string, baseDataShare);
    }

    @Override
    public void removeDataShareInterface(String string) throws DataShareManagementException {
        this.dataShareManager.removeDataShareInterface(string);
    }

    public DataShareInterface getRemoteDataShare(String string) {
        return this.dataShareManager.getRemoteDataShareInterface(string);
    }

    public BaseDataShare getLocalDataShare(String string) throws DataShareManagementException {
        return this.dataShareManager.getLocalDataShareInterface(string);
    }

    @Override
    public int addDataChangeListener(String string, String string2, DataChangeListenerInterfaceOperations dataChangeListenerInterfaceOperations) throws ModuleManagementException, DataShareManagementException {
        int n = -1;
        BaseModule baseModule = this.getLocalReference(string);
        if (baseModule != null) {
            BaseDataShare baseDataShare = baseModule.getLocalDataShare(string2);
            n = baseDataShare.addDataChangeListener(dataChangeListenerInterfaceOperations);
        }
        return n;
    }

    @Override
    public int addDataChangeListener(String string, String string2, DataChangeListenerInterface dataChangeListenerInterface) throws ModuleManagementException, DataShareManagementException {
        DataShareInterface dataShareInterface;
        int n = -1;
        ModuleInterfaceOperations moduleInterfaceOperations = this.getRemoteReference(string, "com.swimap.iview.corbahelpers.ModuleInterfaceHelper");
        if (moduleInterfaceOperations != null && (dataShareInterface = moduleInterfaceOperations.getRemoteDataShare(string2)) != null) {
            n = dataShareInterface.addDataChangeListener(dataChangeListenerInterface);
        }
        return n;
    }

    @Override
    public int notifyChangeListeners(String string, DataChangeNotification[] dataChangeNotificationArray) throws DataShareManagementException {
        return this.dataShareManager.notifyChangeListeners(string, dataChangeNotificationArray);
    }

    @Override
    public boolean removeDataChangeListener(String string, String string2, int n) throws ModuleManagementException, DataShareManagementException {
        boolean bl = false;
        DataShareInterfaceOperations dataShareInterfaceOperations = this.getDataShare(string, string2, "com.swimap.iview.corbahelpers.DataShareInterface");
        if (dataShareInterfaceOperations != null) {
            bl = dataShareInterfaceOperations.removeDataChangeListener(n);
        }
        return bl;
    }

    public void processEvent(InternalEvent internalEvent) {
    }

    public Any processCrossInvoke(String string, String string2, Any[] anyArray) throws CrossInvokeException {
        AnyConverter anyConverter = new AnyConverter(this.orb);
        Any any = null;
        try {
            java.lang.Object object;
            Class<?> clazz = this.getClass();
            int n = 0;
            TypeCode typeCode = null;
            AnyTypeHelper anyTypeHelper = null;
            Integer n2 = null;
            if (anyArray != null && anyArray[0] != null) {
                typeCode = anyArray[0].type();
                n2 = typeCode.kind().value();
                anyTypeHelper = anyConverter.get(n2);
                object = anyTypeHelper.getTypeInfo();
                n = "String".equals(object) ? (anyTypeHelper.getParameterValue(anyArray[0]).equals("null") ? 0 : anyArray.length) : anyArray.length;
            }
            object = new Class[n];
            java.lang.Object[] objectArray = new java.lang.Object[n];
            for (int i = 0; i < ((Class[])object).length; ++i) {
                typeCode = anyArray[i].type();
                n2 = typeCode.kind().value();
                anyTypeHelper = anyConverter.get(n2);
                object[i] = anyTypeHelper.getParameterClass();
                objectArray[i] = anyTypeHelper.getParameterValue(anyArray[i]);
            }
            Method method = clazz.getMethod(string, (Class<?>)object);
            if (string2 != null) {
                if (string2.equals("void")) {
                    anyConverter.getAny(string2, method.invoke((java.lang.Object)this, objectArray));
                    any = anyArray[0];
                } else {
                    any = anyConverter.getAny(string2, method.invoke((java.lang.Object)this, objectArray));
                }
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            CrossInvokeException crossInvokeException = new CrossInvokeException();
            crossInvokeException.fillInStackTrace();
            throw crossInvokeException;
        }
        return any;
    }

    public void initialize() {
    }

    public void reinitialize() {
    }

    public void clear() {
    }

    public void stop() {
    }

    public void abort() {
        logger.trace(new Exception("Stack trace"));
        logger.trace("System abnormally exit.");
        DebugTracer.cleanup();
        if (FrameworkHelper.isOSGIClient()) {
            logger.trace("......Stoping IviewPlugin bundle.....");
            Thread thread = FrameworkCommandProcessor.getInstance().getLoadThread();
            if (null != thread && thread.isAlive()) {
                thread.interrupt();
            }
            FrameworkHelper.stopBundle();
            logger.debug("......IviewPlugin bundle stopped successfully.....");
        } else {
            logger.debug("System exit!");
            System.exit(-1);
        }
    }

    public boolean isAlive() {
        if (this.frameworkLifeCheckTimer == null) {
            this.frameworkLifeCheckTimer = new TimerTask(){

                @Override
                public void run() {
                    BaseModule.this.abort();
                }
            };
            FrameworkUtilities.getSystemTimer().schedule(this.frameworkLifeCheckTimer, 120000L, 120000L);
        }
        return true;
    }

    public void lock() {
    }

    public void unlock() {
    }

    public void restartIdleTimer() {
    }

    public int getIdleTimeLeft() {
        return -1;
    }

    public boolean preLogout() {
        return true;
    }

    public void processLocalEvent(ICustomInternalEvent iCustomInternalEvent) {
    }

    protected void activateAndRegisterObject() {
        String string = this.getModuleName() + "POA";
        if (this.orb != null) {
            POA pOA = null;
            POA pOA2 = null;
            Servant servant = null;
            ModuleInterface moduleInterface = null;
            try {
                pOA = POAHelper.narrow((Object)this.orb.resolve_initial_references("RootPOA"));
                Policy[] policyArray = new Policy[]{pOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT)};
                try {
                    pOA2 = POAHelper.narrow((Object)pOA.id_to_reference(string.getBytes()));
                }
                catch (Exception exception) {
                    logger.trace(exception.getMessage(), exception);
                }
                if (pOA2 == null) {
                    pOA2 = pOA.create_POA(string, pOA.the_POAManager(), policyArray);
                }
                String string2 = FrameworkUtilities.getFullyQualifiedName(this.getModuleName(), this.terminalId, this.instanceId);
                byte[] byArray = string2.getBytes();
                servant = FrameworkUtilities.createObject(this.getPOATieClassName(), this.getModuleInterfaceClassName(), this);
                pOA2.activate_object_with_id(byArray, servant);
                moduleInterface = (ModuleInterface)FrameworkUtilities.invokeNarrow(this.getModuleHelperClassName(), pOA.servant_to_reference(servant));
                pOA.the_POAManager().activate();
                this.register(moduleInterface);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
                try {
                    moduleInterface = null;
                    servant = null;
                    if (null != pOA2) {
                        pOA2.destroy(false, false);
                    }
                }
                catch (Exception exception2) {
                    logger.trace(exception2.getMessage(), exception2);
                }
            }
        }
    }

    protected String getTerminalId() {
        return this.terminalId;
    }

    protected String getInstanceId() {
        return this.instanceId;
    }

    protected String getPOATieClassName() {
        return "";
    }

    protected String getModuleInterfaceClassName() {
        return "";
    }

    protected String getModuleHelperClassName() {
        return "";
    }

    public BaseModule(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
        this.isLocalModule = true;
    }

    public void addMessage(String string) {
        OutputManager outputManager = (OutputManager)this.getLocalModule("mainoutputbarmanager");
        if (null != outputManager) {
            outputManager.addMessage(this.getModuleName(), string);
        } else {
            logger.trace("OutputManager instance is null!");
        }
    }

    public java.lang.Object sendEvent(String string, InternalLocalMsg internalLocalMsg) {
        try {
            BaseModule baseModule = this.getLocalReference(string);
            if (baseModule != null) {
                return baseModule.processEvent(internalLocalMsg);
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return null;
        }
        return null;
    }

    public java.lang.Object processEvent(InternalLocalMsg internalLocalMsg) {
        return null;
    }

    public void broadcastEvent(InternalLocalMsg internalLocalMsg) {
        BaseModule[] baseModuleArray = this.moduleManager.getAllLocalModules();
        String string = null;
        String string2 = this.getModuleName();
        for (int i = 0; i < baseModuleArray.length; ++i) {
            string = baseModuleArray[i].getModuleName();
            if (string == null) {
                String string3 = baseModuleArray[i].getClass().getName();
                logger.warn(string3 + "'s module name is null, can't" + " process the InternalLocalMsg.");
                continue;
            }
            if (string.equals(string2)) continue;
            try {
                baseModuleArray[i].processEvent(internalLocalMsg);
                continue;
            }
            catch (Throwable throwable) {
                logger.error(throwable.getMessage(), throwable);
            }
        }
    }

    protected void postSequencedInit() {
        logger.trace("Post Initialize module " + this.getModuleName());
    }

    protected void lowPriorityInitAfterLoaded() {
    }

    protected void postSystemLoadingFinished() {
    }

    public String getModuleName() {
        ModuleInformation moduleInformation;
        if (null == this.baseModuleName && null != (moduleInformation = this.moduleManager.getModuleInformation(this))) {
            this.baseModuleName = moduleInformation.getModuleName();
        }
        return this.baseModuleName;
    }

    public BaseModule getLocalModule(String string) {
        return this.moduleManager.getLocalModule(string);
    }

    public BaseModule getLocalModule(String string, boolean bl) {
        return this.moduleManager.getLocalModule(string, bl);
    }

    public ORB getOrb() {
        return this.orb;
    }

    public void setOrb(ORB oRB) {
        this.orb = oRB;
    }

    protected void setModuleName(String string) {
        this.baseModuleName = string;
    }
}

