/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.modulemanagement;

import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.ModuleInformation;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.util.log.IviewLogger;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class AfterLoadThreadTask {
    private static IviewLogger logger = IviewLogger.getLogger(AfterLoadThreadTask.class, "IVIEW");
    private Vector localModuleList = null;
    private String appId = null;

    AfterLoadThreadTask(Vector<String> vector, String string) {
        this.appId = string;
        if (null == vector) {
            BaseModule[] baseModuleArray = Main.instance().getModuleManager().getAllLocalModules();
            List<BaseModule> list = Arrays.asList(baseModuleArray);
            this.localModuleList = new Vector<BaseModule>(list);
        } else {
            if (string.equals("")) {
                this.appId = "IVIEW_APP";
            }
            this.localModuleList = vector;
        }
    }

    public void execute() {
        if (!"".equals(this.appId)) {
            this.initAfterLoaded_ForApplication();
        } else {
            this.initAfterLoaded();
        }
    }

    private void initAfterLoaded() {
        boolean bl = FrameworkCommandProcessor.getInstance().isAppStyle();
        for (Object e : this.localModuleList) {
            if (null == e || !(e instanceof BaseModule)) continue;
            BaseModule baseModule = (BaseModule)e;
            if (bl) {
                ModuleInformation moduleInformation = Main.instance().getModuleManager().getModuleInformation(baseModule);
                if (moduleInformation != null && moduleInformation.getModuleState() == ModuleInformation.ModuleState.postSysFinish) {
                    this.executeCallBack(baseModule);
                    moduleInformation.setModuleState(ModuleInformation.ModuleState.lowPriority);
                    continue;
                }
                this.executeCallBack(baseModule);
                continue;
            }
            this.executeCallBack(baseModule);
        }
    }

    private void executeCallBack(BaseModule baseModule) {
        try {
            logger.debug(baseModule.getModuleName() + " low level loaded, start.");
            baseModule.lowPriorityInitAfterLoaded();
            logger.debug(baseModule.getModuleName() + " low level loaded, finished.");
        }
        catch (Throwable throwable) {
            logger.error(baseModule.getModuleName(), throwable);
        }
    }

    private void initAfterLoaded_ForApplication() {
        BaseModule baseModule = null;
        String string = null;
        for (Object e : this.localModuleList) {
            if (!(e instanceof String)) {
                logger.error("localModuleList doesn't have string");
                return;
            }
            string = (String)e;
            try {
                ModuleInformation moduleInformation = Main.instance().getModuleManager().getModuleInfoTable().get(string);
                if (null == moduleInformation || moduleInformation.getModuleState() != ModuleInformation.ModuleState.postSysFinish) continue;
                baseModule = Main.instance().getModuleManager().getLocalReference(string, false);
                if (baseModule != null) {
                    this.executeCallBack(baseModule);
                }
                moduleInformation.setModuleState(ModuleInformation.ModuleState.lowPriority);
            }
            catch (ModuleManagementException moduleManagementException) {
                logger.debug("moduleManagement Exception occured for the module:" + string);
            }
        }
    }

    public String getAppId() {
        return this.appId;
    }
}

