/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.modulemanagement;

import com.swimap.iview.framework.modulemanagement.AfterLoadThreadTask;
import com.swimap.iview.util.log.IviewLogger;
import java.util.concurrent.LinkedBlockingQueue;

public class AfterLoadThread
extends Thread {
    private static IviewLogger logger = IviewLogger.getLogger(AfterLoadThread.class, "IVIEW");
    private LinkedBlockingQueue<AfterLoadThreadTask> queue = new LinkedBlockingQueue();
    private volatile boolean isLogoutCalled = false;

    public void accept(AfterLoadThreadTask afterLoadThreadTask) {
        if (!this.isLogoutCalled) {
            this.queue.add(afterLoadThreadTask);
        }
    }

    @Override
    public void run() {
        while (!this.isLogoutCalled) {
            try {
                this.execute(this.queue.take());
            }
            catch (InterruptedException interruptedException) {
                logger.debug("AfterLoadThread is interupted");
                this.queue.clear();
                break;
            }
        }
        if (this.isLogoutCalled) {
            this.queue.clear();
        }
    }

    private void execute(AfterLoadThreadTask afterLoadThreadTask) {
        logger.debug("AfterLoadThread task started....." + afterLoadThreadTask.getAppId());
        afterLoadThreadTask.execute();
        logger.debug("AfterLoadThread task completed....." + afterLoadThreadTask.getAppId());
    }

    public void setLogoutFlag(boolean bl) {
        this.isLogoutCalled = bl;
        logger.debug("logoutFlag has setted:" + bl + "for afterLoadThread:" + this);
    }
}

