/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.menumanagement;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commandmng.ICommandProcessor;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CheckBoxMenuItem;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.commstyle.commini.MenuItem;
import com.swimap.iview.commstyle.commini.MenuSet;
import com.swimap.iview.commstyle.commini.RadioButtonMenuItem;
import com.swimap.iview.commstyle.commini.Separator;
import com.swimap.iview.commstyle.commini.UIObjMng;
import com.swimap.iview.commstyle.commini.foldingmenus.FoldingMenuUtilities;
import com.swimap.iview.commstyle.commini.foldingmenus.IActivity;
import com.swimap.iview.framework.menumanagement.MenuActivityStore;
import com.swimap.iview.framework.menumanagement.MenuSetStore;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class MenuSetComponent {
    private static IviewLogger logger = IviewLogger.getLogger(MenuSetComponent.class, "IVIEW");
    protected MenuSetStore menuSetStore = new MenuSetStore();
    protected JMenuBar menuBar = null;
    private String baseMenuSetId = null;
    private int insertIndexBackward = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadMenus(String string, String string2) {
        if (null == string || null == string2) {
            return false;
        }
        MenuSet menuSet = null;
        String string3 = string;
        synchronized (string3) {
            menuSet = this.menuSetStore.getMenuSet(string2);
            if (null != menuSet) {
                return false;
            }
            menuSet = UIObjMng.getInstance().getMenuSet(string, string2);
            if (null == menuSet) {
                return false;
            }
            this.menuSetStore.addMenuSet(menuSet);
        }
        CommandManager.getInstance().addMenuSet(menuSet, FrameworkCommandProcessor.getInstance());
        if (null != this.baseMenuSetId && this.baseMenuSetId.equalsIgnoreCase(string2)) {
            this.initializeMenuBar();
        }
        this.validateMenuSetSeparators(menuSet);
        return true;
    }

    public boolean setBaseMenuSetId(String string) {
        MenuSet menuSet = this.menuSetStore.getMenuSet(string);
        if (null == menuSet) {
            return false;
        }
        this.baseMenuSetId = string;
        this.initializeMenuBar();
        return true;
    }

    public String getBaseMenuSetId() {
        return this.baseMenuSetId;
    }

    private void initializeMenuBar() {
        if (null == this.baseMenuSetId) {
            return;
        }
        MenuSet menuSet = this.menuSetStore.getMenuSet(this.baseMenuSetId);
        if (null == menuSet) {
            return;
        }
        this.menuBar = menuSet.toMenuBar();
        this.menuBar.setName("MenuManager_menuBar");
    }

    public void reinitializeMenuBar() {
        if (null == this.baseMenuSetId) {
            logger.debug("menusetid in invalid, failed to create menu bar");
            return;
        }
        MenuSet menuSet = this.menuSetStore.getMenuSet(this.baseMenuSetId);
        if (null == menuSet) {
            logger.debug("menu set is invalid, failed to create menu bar");
            return;
        }
        this.menuBar = menuSet.refreshMenuBar();
        this.menuBar.setName("MenuManager_menuBar");
    }

    public MenuSet getBaseMenuSet() {
        if (null == this.baseMenuSetId) {
            return null;
        }
        return this.menuSetStore.getMenuSet(this.baseMenuSetId);
    }

    public boolean setInsertIndex(int n) {
        MenuSet menuSet = this.getBaseMenuSet();
        if (null == menuSet) {
            return false;
        }
        int n2 = menuSet.getMenuOrder().size();
        if (n > n2 || n < 0) {
            return false;
        }
        this.insertIndexBackward = n;
        return true;
    }

    public boolean addMenu(String string, String string2) {
        if (null == this.baseMenuSetId) {
            return false;
        }
        if (null == string || null == string2) {
            return false;
        }
        MenuSet menuSet = this.menuSetStore.getMenuSet(string);
        if (null == menuSet) {
            return false;
        }
        Menu menu = menuSet.getMenu(string2);
        if (null == menu) {
            return false;
        }
        this.insertToMenuBar(menu);
        this.menuBar.validate();
        this.menuBar.repaint();
        return true;
    }

    protected void insertToMenuBar(JMenu jMenu) {
        int n;
        int n2 = this.menuBar.getComponentCount();
        int n3 = n2 - this.insertIndexBackward;
        if (this.insertIndexBackward > 0) {
            ++n3;
        }
        if (jMenu instanceof Menu && (n = ((Menu)jMenu).getSerialNumber()) >= 0) {
            n3 = this.getIndex((Menu)jMenu);
        }
        if (n3 <= 0) {
            this.insertToMenuBar(jMenu, 0);
            return;
        }
        if (this.menuBar.getComponent(n2 - 1) instanceof JMenu) {
            this.insertToMenuBar(jMenu, n3);
        } else {
            this.insertToMenuBar(jMenu, n3 - 1);
        }
    }

    private void insertToMenuBar(JMenu jMenu, int n) {
        if (this.menuBar.getComponentIndex(jMenu) < 0) {
            this.menuBar.add((Component)jMenu, n);
        } else {
            logger.error("Insert to menubar failed. " + jMenu.getText() + " had been inserted to menubar!");
        }
    }

    private int getIndex(Menu menu) {
        int n;
        int n2 = n = this.menuBar.getComponentCount();
        int n3 = 0;
        int n4 = menu.getSerialNumber();
        int n5 = n - 1;
        if (!(this.menuBar.getComponent(n5) instanceof JMenu)) {
            --n5;
        }
        while (n5 >= 0) {
            if (this.menuBar.getComponent(n5) instanceof Menu) {
                n3 = ((Menu)this.menuBar.getComponent(n5)).getSerialNumber();
            } else {
                if (this.menuBar.getComponent(n5) instanceof JMenu) {
                    logger.debug(((JMenu)this.menuBar.getComponent(n5)).getText() + " is a JMenu.");
                } else {
                    logger.debug("MenuBar error.");
                }
                n3 = this.menuBar.getComponent(n5 + 1) instanceof Menu ? ((Menu)this.menuBar.getComponent(n5 + 1)).getSerialNumber() - 1 : Integer.MAX_VALUE;
            }
            if (n3 > n4 || -1 == n3) {
                if (--n2 < 0) {
                    break;
                }
            } else {
                return n2;
            }
            --n5;
        }
        return n2;
    }

    public boolean addAllMenuInSet(String string) {
        if (null == this.baseMenuSetId) {
            return false;
        }
        MenuSet menuSet = this.menuSetStore.getMenuSet(string);
        if (null == menuSet) {
            return false;
        }
        Vector vector = menuSet.getMenuOrder();
        if (null == vector) {
            return false;
        }
        JMenu jMenu = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            jMenu = (JMenu)enumeration.nextElement();
            this.insertToMenuBar(jMenu);
        }
        this.menuBar.validate();
        this.menuBar.repaint();
        return true;
    }

    public boolean removeMenu(String string, String string2) {
        logger.debug("Removing menu menuSetId:" + string + "; menuId : " + string2);
        if (null == this.baseMenuSetId) {
            return false;
        }
        MenuSet menuSet = this.menuSetStore.getMenuSet(string);
        if (null == menuSet) {
            return false;
        }
        Menu menu = menuSet.getMenu(string2);
        if (null == menu) {
            return false;
        }
        this.menuBar.remove(menu);
        this.menuBar.validate();
        this.menuBar.repaint();
        return true;
    }

    public boolean addMenuItem(String string, String string2, String string3) {
        JMenuItem jMenuItem;
        if (null == this.baseMenuSetId) {
            return false;
        }
        MenuSet menuSet = this.menuSetStore.getMenuSet(string);
        if (null == menuSet) {
            return false;
        }
        Menu menu = menuSet.getMenu(string2);
        if (null == menu) {
            return false;
        }
        Component component = menu.getMenuItem(string3);
        if (null == component && (jMenuItem = menu.addMenuItem(string3)) != null) {
            CommandManager.getInstance().add(jMenuItem, (ICommandProcessor)FrameworkCommandProcessor.getInstance());
        }
        return true;
    }

    public boolean removeMenuItem(String string, String string2, String string3) {
        if (null == this.baseMenuSetId) {
            return false;
        }
        MenuSet menuSet = this.menuSetStore.getMenuSet(string);
        if (null == menuSet) {
            return false;
        }
        Menu menu = menuSet.getMenu(string2);
        if (null == menu) {
            return false;
        }
        Component component = menu.getMenuItem(string3);
        if (null == component) {
            return false;
        }
        menu.remove(component);
        return true;
    }

    public boolean setMenuItemState(String string, String string2, String string3, String string4, String string5) {
        if (null == string || null == string2) {
            return false;
        }
        MenuSet menuSet = this.menuSetStore.getMenuSet(string);
        if (null == menuSet) {
            String[] stringArray;
            String string6 = MenuSet.getMenuPath(string);
            if (null != string6 && (stringArray = string6.split("-")).length == 1) {
                return this.setMenuItemState(stringArray[0], string2, string3, string4, string5);
            }
            return false;
        }
        Menu menu = menuSet.getMenu(string2);
        if (null == menu) {
            String[] stringArray;
            String string7;
            String string8 = menuSet.getSecondaryId();
            if (null == string8) {
                string8 = string;
            }
            if (null != (string7 = MenuSet.getMenuPath(string8 + "-" + string2)) && (stringArray = string7.split("-")).length == 2) {
                return this.setMenuItemState(stringArray[0], stringArray[1], string3, string4, string5);
            }
            return false;
        }
        Component component = menu.getMenuItem(string3);
        if (null != component) {
            if (component instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)component;
                return menuItem.setState(string4, string5);
            }
            if (component instanceof RadioButtonMenuItem) {
                RadioButtonMenuItem radioButtonMenuItem = (RadioButtonMenuItem)component;
                return radioButtonMenuItem.setState(string4, string5);
            }
            if (component instanceof CheckBoxMenuItem) {
                CheckBoxMenuItem checkBoxMenuItem = (CheckBoxMenuItem)component;
                return checkBoxMenuItem.setState(string4, string5);
            }
        } else {
            String[] stringArray;
            String string9;
            String string10 = menu.getSecondaryId();
            if (null == string10) {
                string10 = string + '-' + string2;
            }
            if (null != (string9 = MenuSet.getMenuPath(string10 + '-' + string3)) && (stringArray = string9.split("-")).length == 3) {
                return this.setMenuItemState(stringArray[0], stringArray[1], stringArray[2], string4, string5);
            }
        }
        return false;
    }

    public boolean unloadMenus(String string) {
        logger.debug("unloading the dynamic menus for " + string);
        if (null == this.baseMenuSetId) {
            return false;
        }
        if (this.baseMenuSetId.equals(string)) {
            return false;
        }
        MenuSet menuSet = this.menuSetStore.getMenuSet(string);
        if (null == menuSet) {
            return false;
        }
        for (int i = menuSet.getMenuCount() - 1; i >= 0; --i) {
            this.removeMenu(menuSet.getMenu(i));
        }
        return this.menuSetStore.removeMenuSet(string);
    }

    public Menu getMenu(String string, String string2) {
        MenuSet menuSet = this.menuSetStore.getMenuSet(string);
        if (null == menuSet) {
            String[] stringArray;
            String string3 = MenuSet.getMenuPath(string);
            if (null != string3 && null != (stringArray = string3.split("-")) && stringArray.length == 1) {
                return this.getMenu(stringArray[0], string2);
            }
            return null;
        }
        Menu menu = menuSet.getMenu(string2);
        if (null == menu) {
            String string4;
            String string5 = menuSet.getSecondaryId();
            if (null == string5) {
                string5 = string;
            }
            if (null != (string4 = MenuSet.getMenuPath(string5 + '-' + string2))) {
                String[] stringArray = string4.split("-");
                if (stringArray.length == 2) {
                    return this.getMenu(stringArray[0], stringArray[1]);
                }
                if (stringArray.length == 3) {
                    return (Menu)this.getMenuItem(stringArray[0], stringArray[1], stringArray[2]);
                }
            }
        }
        return menu;
    }

    public Menu getMenu(JMenuItem jMenuItem) {
        Enumeration enumeration = this.getAllMenuSet();
        MenuSet menuSet = null;
        int n = 0;
        Menu menu = null;
        boolean bl = enumeration.hasMoreElements();
        while (bl) {
            menuSet = (MenuSet)enumeration.nextElement();
            n = menuSet.getMenuCount();
            Menu menu2 = null;
            for (int i = 0; i < n; ++i) {
                menu = menuSet.getMenu(i);
                menu2 = menu.getMenuOf(jMenuItem);
                if (null == menu2) continue;
                return menu2;
            }
            bl = enumeration.hasMoreElements();
        }
        return null;
    }

    public void clearMenuSet() {
        this.menuSetStore.clear();
    }

    public JMenuBar getMenuBar() {
        if (FrameworkUtilities.isFullScreenMode()) {
            this.menuBar.setVisible(false);
        }
        return this.menuBar;
    }

    public Component getMenuItem(String string, String string2, String string3) {
        return this.getMenuItem(string, string2, string3, false);
    }

    public Component getMenuItem(String string, String string2, String string3, boolean bl) {
        Menu menu = this.getMenu(string, string2);
        if (null == menu) {
            String[] stringArray;
            String string4 = MenuSet.getMenuPath(string + '-' + string2);
            if (null != string4 && (stringArray = string4.split("-")).length == 2) {
                return this.getMenuItem(stringArray[0], stringArray[1], string3, bl);
            }
            return null;
        }
        Component component = menu.getMenuItem(string3, bl);
        if (null == component) {
            String[] stringArray;
            String string5;
            String string6 = menu.getSecondaryId();
            if (null == string6) {
                string6 = string + '-' + string2;
            }
            if (null != (string5 = MenuSet.getMenuPath(string6 + '-' + string3)) && (stringArray = string5.split("-")).length == 3) {
                return this.getMenuItem(stringArray[0], stringArray[1], stringArray[2], bl);
            }
        }
        return component;
    }

    public boolean addMenu(String string, String string2, String string3, String string4) {
        Menu menu = this.getMenu(string3, string4);
        if (null == menu) {
            return false;
        }
        Menu menu2 = this.getMenu(string, string2);
        if (null == menu2) {
            return false;
        }
        menu.add(menu2);
        this.menuBar.validate();
        this.menuBar.repaint();
        return true;
    }

    public boolean addMenu(JMenu jMenu) {
        if (null == jMenu) {
            return false;
        }
        if (null == this.menuBar) {
            return false;
        }
        logger.debug("Adding Menu " + jMenu.getText());
        this.insertToMenuBar(jMenu);
        this.menuBar.validate();
        this.menuBar.repaint();
        return true;
    }

    public boolean removeMenu(JMenu jMenu) {
        if (null != this.menuBar && null != jMenu) {
            logger.debug("Remove Menu menu:" + jMenu.getText());
            this.menuBar.remove(jMenu);
            this.menuBar.validate();
            this.menuBar.repaint();
        }
        return true;
    }

    public boolean removeSeparator(String string, String string2, JSeparator jSeparator) {
        if (null == this.baseMenuSetId) {
            return false;
        }
        Menu menu = this.getMenu(string, string2);
        if (null == menu) {
            return false;
        }
        logger.debug("Remove Separator menuSetId:" + string + "; menuID: " + string2);
        if (jSeparator != null) {
            logger.debug("separator: " + jSeparator.getName());
        }
        menu.remove(jSeparator);
        return true;
    }

    public boolean addSeparator(String string, String string2, JSeparator jSeparator) {
        if (null == this.baseMenuSetId) {
            return false;
        }
        Menu menu = this.getMenu(string, string2);
        if (null == jSeparator) {
            return false;
        }
        menu.add(jSeparator);
        return true;
    }

    public boolean addMenuItem(String string, String string2, JMenuItem jMenuItem) {
        if (null == this.baseMenuSetId) {
            return false;
        }
        Menu menu = this.getMenu(string, string2);
        if (null == menu) {
            return false;
        }
        if (jMenuItem != null) {
            logger.debug("MenuItem  : " + jMenuItem.getText());
        }
        menu.add(jMenuItem);
        return true;
    }

    public boolean removeMenuItem(String string, String string2, JMenuItem jMenuItem) {
        if (null == this.baseMenuSetId) {
            return false;
        }
        Menu menu = this.getMenu(string, string2);
        if (null == menu) {
            return false;
        }
        logger.debug("MenuItem : " + jMenuItem.getText());
        menu.remove(jMenuItem);
        return true;
    }

    public boolean loadDynamicMenus(String string, String string2) {
        if (null == string || null == string2) {
            return false;
        }
        return this.loadDynamicMenusOfExtPath(string, string2, null);
    }

    public boolean loadDynamicMenusOfExtPath(String string, String string2, String string3) {
        if (null == string || null == string2) {
            return false;
        }
        MenuSet menuSet = null;
        if (null == string3) {
            menuSet = UIObjMng.getInstance().getMenuSet(string, string2);
        } else {
            logger.debug("Extpath for load dynamic menu :" + string3);
            menuSet = UIObjMng.getInstance().getMenuSetOfExtPath(string, string2, string3);
        }
        if (null == menuSet) {
            return false;
        }
        this.assignSeparatorId(menuSet, string, string2);
        MenuSet menuSet2 = this.menuSetStore.getMenuSet(string2);
        if (null != menuSet2) {
            CommandManager.getInstance().addMenuSet(menuSet, FrameworkCommandProcessor.getInstance());
            this.mergeMenuSet(menuSet, menuSet2);
            if (this.menuBar != null) {
                this.menuBar.revalidate();
                this.menuBar.repaint();
            }
            this.validateMenuSetSeparators(menuSet2);
            return true;
        }
        this.menuSetStore.addMenuSet(menuSet);
        CommandManager.getInstance().addMenuSet(menuSet, FrameworkCommandProcessor.getInstance());
        if (null != this.baseMenuSetId && this.baseMenuSetId.equalsIgnoreCase(string2)) {
            this.initializeMenuBar();
        }
        this.validateMenuSetSeparators(menuSet);
        return true;
    }

    private void assignSeparatorId(MenuSet menuSet, String string, String string2) {
        int n = menuSet.getMenuCount();
        int n2 = 0;
        Menu menu = null;
        Component component = null;
        for (int i = 0; i < n; ++i) {
            menu = menuSet.getMenu(i);
            n2 = menu.getMenuComponentCount();
            for (int j = 0; j < n2; ++j) {
                component = menu.getMenuComponent(j);
                if (!(component instanceof Separator)) continue;
                ((Separator)component).setSeparatorId(string + string2);
            }
        }
    }

    public boolean unloadDynamicMenus(String string, String string2) {
        logger.debug("unloading the dynamic menus for " + string2);
        if (null == string || null == string2) {
            return false;
        }
        MenuSet menuSet = this.menuSetStore.getMenuSet(string2);
        if (null == menuSet) {
            return false;
        }
        MenuSet menuSet2 = UIObjMng.getInstance().getMenuSet(string, string2);
        if (null == menuSet2) {
            return false;
        }
        this.clearMenuInSet(menuSet2, menuSet, string + string2);
        if (null != this.menuBar) {
            this.menuBar.validate();
            this.menuBar.repaint();
        }
        this.validateMenuSetSeparators(menuSet);
        return true;
    }

    private void clearMenuInSet(MenuSet menuSet, MenuSet menuSet2, String string) {
        int n;
        int n2 = menuSet.getMenuCount();
        Menu menu = null;
        Menu menu2 = null;
        for (n = 0; n < n2; ++n) {
            menu = menuSet.getMenu(n);
            if (!this.clearMenu(menu, menu2 = menuSet2.getMenu(menu.getID()))) continue;
            this.removeEmptyMenu(menuSet2, menu2);
        }
        this.clearMenuItemInSet(menuSet, menuSet2, string);
        n2 = menuSet.getMenuCount();
        for (n = 0; n < n2; ++n) {
            menu = menuSet.getMenu(n);
            menu2 = menuSet2.getMenu(menu.getID());
            this.removeEmptyMenu(menuSet2, menu2);
        }
        menuSet = null;
    }

    private void removeEmptyMenu(MenuSet menuSet, Menu menu) {
        if (menu != null && menu.getMenuComponentCount() == 0) {
            this.removeMenu(menuSet.getID(), menu.getID());
        }
    }

    private boolean clearMenu(Menu menu, Menu menu2) {
        if (null == menu || null == menu2) {
            return false;
        }
        Component[] componentArray = menu.getMenuComponents();
        if (null == componentArray || componentArray.length == 0) {
            return false;
        }
        Component component = null;
        for (int i = 0; i < componentArray.length; ++i) {
            Component component2;
            component = componentArray[i];
            if (!(component instanceof Menu) || null == (component2 = menu2.getMenuItem(((Menu)component).getID()))) continue;
            if (((Menu)component2).getMenuComponentCount() != ((Menu)component).getMenuComponentCount()) {
                if (i != componentArray.length - 1) continue;
                return false;
            }
            if (this.clearMenu((Menu)component, (Menu)component2)) {
                menu2.remove(component2);
                menu.remove(component);
                continue;
            }
            if (i != componentArray.length - 1) continue;
            return false;
        }
        return true;
    }

    private void clearMenuItemInSet(MenuSet menuSet, MenuSet menuSet2, String string) {
        int n = menuSet.getMenuCount();
        Menu menu = null;
        Menu menu2 = null;
        for (int i = 0; i < n; ++i) {
            menu = menuSet.getMenu(i);
            menu2 = menuSet2.getMenu(menu.getID());
            this.clearMenuItem(menu, menu2, string);
        }
    }

    private void clearMenuItem(Menu menu, Menu menu2, String string) {
        Component[] componentArray = menu.getMenuComponents();
        if (null == componentArray || componentArray.length == 0) {
            return;
        }
        Component component = null;
        for (int i = 0; i < componentArray.length; ++i) {
            Component component2;
            component = componentArray[i];
            if (component instanceof Menu) {
                if (menu2 == null || (component2 = menu2.getMenuItem(((Menu)component).getID())) == null) continue;
                this.clearMenu((Menu)component, (Menu)component2);
                this.clearMenuItem((Menu)component, (Menu)component2, string);
                continue;
            }
            if (component instanceof MenuItem) {
                if (menu2 == null || (component2 = menu2.getMenuItem(((MenuItem)component).getID())) == null) continue;
                menu2.remove(component2);
                menu.remove(component);
                continue;
            }
            if (component instanceof CheckBoxMenuItem) {
                if (menu2 == null || (component2 = menu2.getMenuItem(((CheckBoxMenuItem)component).getID())) == null) continue;
                menu2.remove(component2);
                menu.remove(component);
                continue;
            }
            if (component instanceof RadioButtonMenuItem) {
                if (menu2 == null || (component2 = menu2.getMenuItem(((RadioButtonMenuItem)component).getID())) == null) continue;
                menu2.remove(component2);
                menu.remove(component);
                continue;
            }
            if (!(component instanceof Separator) || menu2 == null || (component2 = menu2.getSeparator(string)) == null) continue;
            menu2.remove(component2);
            menu.remove(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeMenuSet(MenuSet menuSet, MenuSet menuSet2) {
        int n = menuSet.getMenuCount();
        Menu menu = null;
        Menu menu2 = null;
        MenuSetComponent menuSetComponent = this;
        synchronized (menuSetComponent) {
            for (int i = 0; i < n; ++i) {
                menu = menuSet.getMenu(i);
                menu2 = menuSet2.getMenu(menu.getID());
                if (null == menu2) {
                    menuSet2.insertMenu(menu, this.insertIndexBackward - 1);
                    continue;
                }
                this.mergeMenu(menu, menu2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeIndepndtMenuSet(MenuSet menuSet, MenuSet menuSet2) {
        int n = menuSet.getMenuCount();
        Menu menu = null;
        Menu menu2 = null;
        MenuSetComponent menuSetComponent = this;
        synchronized (menuSetComponent) {
            for (int i = 0; i < n; ++i) {
                menu = menuSet.getMenu(i);
                menu2 = menuSet2.getMenu(menu.getID());
                if (null == menu2) {
                    menuSet2.insertMenu(menu);
                    continue;
                }
                this.mergeMenu(menu, menu2);
            }
        }
    }

    protected void mergeMenu(Menu menu, Menu menu2) {
        Component[] componentArray;
        if (!menu2.isEnabled()) {
            menu2.setEnabled(menu.isEnabled());
        }
        if (!menu2.isVisible()) {
            menu2.setVisible(menu.isVisible());
        }
        if (null == (componentArray = menu.getMenuComponents()) || componentArray.length == 0) {
            return;
        }
        Component component = null;
        for (int i = 0; i < componentArray.length; ++i) {
            component = componentArray[i];
            if (component instanceof Menu) {
                Component component2 = menu2.getMenuItem(((Menu)component).getID());
                if (component2 != null && component2 instanceof Menu) {
                    this.mergeMenu((Menu)component, (Menu)component2);
                    continue;
                }
                menu2.insertComponent(component);
                continue;
            }
            menu2.insertComponent(component);
        }
    }

    public void setMenuAction() {
        logger.debug("Begin setMenuAction()");
        Enumeration enumeration = this.menuSetStore.getAllMenuSet();
        MenuSet menuSet = null;
        while (enumeration.hasMoreElements()) {
            menuSet = (MenuSet)enumeration.nextElement();
            CommandManager.getInstance().setAction(menuSet);
        }
        logger.debug("End setMenuAction()");
    }

    public void filterModuleMenu(ArrayList arrayList) {
        logger.debug("Begin filterModuleMenu()");
        if (null == arrayList || arrayList.size() == 0) {
            this.validateMenu();
            return;
        }
        HashMap hashMap = CommandManager.getInstance().getModuleToCommandIDMap();
        int n = arrayList.size();
        String string = null;
        for (int i = 0; i < n; ++i) {
            string = (String)arrayList.get(i);
            ArrayList arrayList2 = (ArrayList)hashMap.get(string);
            if (arrayList2 == null) continue;
            int n2 = arrayList2.size();
            String string2 = null;
            for (int j = 0; j < n2; ++j) {
                string2 = (String)arrayList2.get(j);
                logger.debug("Remove menus by commandID = '" + string2 + "' in module:" + string);
                this.removeMenuByCommandID(string2);
            }
        }
        this.validateMenu();
        this.validateAllMenuSeparators();
        logger.debug("End filterModuleMenu()");
    }

    private void removeMenuByCommandID(String string) {
        ArrayList arrayList = CommandManager.getInstance().getAbstractButton(string);
        AbstractButton abstractButton = null;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            abstractButton = (AbstractButton)arrayList.get(i);
            if (!(abstractButton instanceof JMenuItem)) continue;
            Menu menu = this.getMenu((JMenuItem)abstractButton);
            if (menu != null) {
                menu.remove(abstractButton);
            }
            arrayList.remove(i);
            n = arrayList.size();
            --i;
        }
    }

    private void validateMenu() {
        Enumeration enumeration = this.menuSetStore.getAllMenuSet();
        int n = 0;
        MenuSet menuSet = null;
        while (enumeration.hasMoreElements()) {
            menuSet = (MenuSet)enumeration.nextElement();
            n = menuSet.getMenuCount();
            for (int i = 0; i < n; ++i) {
                this.validateMenu(menuSet, menuSet.getMenu(i));
                if (menuSet.getMenuCount() == n || i < 0) continue;
                --i;
                n = menuSet.getMenuCount();
            }
        }
    }

    private void validateMenu(MenuSet menuSet, JMenu jMenu) {
        this.validateEmptyMenu(menuSet, jMenu);
    }

    private boolean validateEmptyMenu(MenuSet menuSet, JMenu jMenu) {
        Container container;
        int n = 0;
        int n2 = jMenu.getMenuComponentCount();
        Component component = null;
        for (int i = 0; i < n2; ++i) {
            boolean bl;
            component = jMenu.getMenuComponent(i);
            if (component instanceof JMenu && (bl = this.validateEmptyMenu(menuSet, (JMenu)component))) {
                --i;
                n2 = jMenu.getMenuComponentCount();
                continue;
            }
            if (!(component instanceof JMenu) && !(component instanceof JMenuItem)) continue;
            ++n;
        }
        if (n == 0 && (container = jMenu.getParent()) != null) {
            if (container instanceof JMenuBar) {
                menuSet.removeMenu((Menu)jMenu);
            }
            container.remove(jMenu);
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.menuBar != null) {
            ContainerListener[] containerListenerArray = this.menuBar.getContainerListeners();
            for (int i = 0; i < containerListenerArray.length; ++i) {
                this.menuBar.removeContainerListener(containerListenerArray[i]);
            }
            this.menuBar.removeAll();
        }
        this.menuSetStore.clear();
        this.menuBar = null;
    }

    public void loadMenusFromPlugin() {
        List<Plugin> list = null;
        list = FrameworkCommandProcessor.getInstance().isAppStyle() ? PluginManager.getInstance().getStartupPluginList(null) : PluginManager.getInstance().getStartupPluginList();
        this.loadMenusOfPlugins(list);
    }

    protected void loadMenusOfPlugins(List<Plugin> list) {
        if (null != list) {
            Plugin plugin2 = null;
            CommStyleInfo commStyleInfo = null;
            for (Plugin plugin2 : list) {
                if (!FrameworkUtilities.isInState(plugin2.getModuleInfomation().getStates()) || null == (commStyleInfo = plugin2.getIntegrateCommStyleReader().getCommStyleInfo("menu.xml"))) continue;
                logger.debug("Commstyle path for menu is :" + commStyleInfo.getUrlExternalForm());
                this.loadDynamicMenus(commStyleInfo, "mainMenu");
            }
        }
    }

    public boolean loadDynamicMenus(CommStyleInfo commStyleInfo, String string) {
        MenuSet menuSet = UIObjMng.getInstance().getMenuSet(commStyleInfo, string);
        if (menuSet == null) {
            return false;
        }
        logger.debug("MenuSet in loadDynamic id :" + string + " and hashCode is -" + menuSet.hashCode());
        this.assignSeparatorId(menuSet, commStyleInfo.getFileName(), string);
        return this.loadMenus(menuSet, string);
    }

    public boolean loadDynamicMenus(String string, boolean bl) {
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        CommStyleInfo commStyleInfo = commStyleManager.getCommonStyleFile(string);
        if (null == commStyleInfo) {
            return false;
        }
        if (commStyleInfo.getAreaDescContainerCount() == 0) {
            return false;
        }
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(0);
        int n = areaDescContainer.getDescContainerCount();
        DescContainer descContainer = null;
        DescContainer descContainer2 = null;
        boolean bl2 = false;
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            descContainer = areaDescContainer.getDescContainer(i);
            bl2 = false;
            if (null != descContainer && null != descContainer.getParasItem("type") && "MenuSet".equals(descContainer.getParasItem("type").getValue())) {
                string2 = descContainer.getDescName();
                bl2 = this.loadDynamicMenus(string, string2);
            }
            if (!bl || !bl2) continue;
            int n2 = descContainer.getDescContainerCount();
            for (int j = 0; j < n2; ++j) {
                descContainer2 = descContainer.getDescContainer(j);
                if (null == descContainer2 || !"JMenu".equals(descContainer2.getParasItem("type").getValue())) continue;
                String string3 = descContainer2.getDescName();
                this.addMenu(string2, string3);
            }
        }
        return true;
    }

    public boolean unloadDynamicMenus(String string) {
        logger.debug("unloading the dynamic menus for " + string);
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        CommStyleInfo commStyleInfo = commStyleManager.getCommonStyleFile(string);
        if (null == commStyleInfo) {
            return false;
        }
        if (commStyleInfo.getAreaDescContainerCount() == 0) {
            return false;
        }
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(0);
        if (null == areaDescContainer) {
            return false;
        }
        int n = areaDescContainer.getDescContainerCount();
        DescContainer descContainer = null;
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            boolean bl;
            descContainer = areaDescContainer.getDescContainer(i);
            if (null == descContainer || null == descContainer.getParasItem("type") || !"MenuSet".equals(descContainer.getParasItem("type").getValue()) || !(bl = this.unloadDynamicMenus(string, string2 = descContainer.getDescName()))) continue;
            logger.debug(string2 + " removed from MenuBar");
        }
        return true;
    }

    public boolean unloadDynamicMenus(CommStyleInfo commStyleInfo, String string) {
        logger.debug("unloading the dynamic menus for " + string);
        boolean bl = false;
        if (null != commStyleInfo) {
            bl = this.unloadDynamicMenus(commStyleInfo.getFileName(), string);
            return bl;
        }
        return bl;
    }

    private boolean loadMenus(MenuSet menuSet, String string) {
        if (null == menuSet || null == string) {
            return false;
        }
        MenuSet menuSet2 = this.menuSetStore.getMenuSet(string);
        if (null != menuSet2) {
            CommandManager.getInstance().addMenuSet(menuSet, FrameworkCommandProcessor.getInstance());
            this.mergeMenuSet(menuSet, menuSet2);
            if (null != this.menuBar) {
                this.menuBar.revalidate();
                this.menuBar.repaint();
            }
            logger.debug("Menuset updated, Menuset Id : " + string + " Menu count: " + menuSet2.getMenuCount());
            return true;
        }
        this.menuSetStore.addMenuSet(menuSet);
        CommandManager.getInstance().addMenuSet(menuSet, FrameworkCommandProcessor.getInstance());
        if (null != this.baseMenuSetId && this.baseMenuSetId.equalsIgnoreCase(string)) {
            this.initializeMenuBar();
        }
        return true;
    }

    public void updateMenu(Menu menu) {
        menu.updateMenu();
    }

    public void updateMenu() {
        Enumeration enumeration = this.menuSetStore.getAllMenuSet();
        MenuSet menuSet = null;
        int n = 0;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            menuSet = (MenuSet)enumeration.nextElement();
            n = menuSet.getMenuCount();
            for (n2 = 0; n2 < n; ++n2) {
                if (Thread.currentThread().isInterrupted()) {
                    logger.debug("EDT thread is interrrupted");
                    return;
                }
                menuSet.getMenu(n2).updateMenu();
            }
        }
    }

    public boolean isMenuExist(String string, String string2) {
        MenuSet menuSet = this.menuSetStore.getMenuSet(string);
        if (menuSet == null) {
            return false;
        }
        Menu menu = menuSet.getMenu(string2);
        return menu != null;
    }

    public boolean isMenuExist(MenuSet menuSet, Menu menu) {
        return menuSet.toMenuBar().getComponentIndex(menu) >= 0;
    }

    public void updateMenuItem(JMenuItem jMenuItem) {
        if (jMenuItem instanceof MenuItem) {
            ((MenuItem)jMenuItem).updateMenuItem();
        } else if (jMenuItem instanceof RadioButtonMenuItem) {
            ((RadioButtonMenuItem)jMenuItem).updateMenuItem();
        } else if (jMenuItem instanceof CheckBoxMenuItem) {
            ((CheckBoxMenuItem)jMenuItem).updateMenuItem();
        }
    }

    public Enumeration getAllMenuSet() {
        return this.menuSetStore.getAllMenuSet();
    }

    void storeMenuActivityInfo() {
        try {
            Enumeration enumeration = this.getAllMenuSet();
            boolean bl = enumeration.hasMoreElements();
            MenuSet menuSet = null;
            while (bl) {
                menuSet = (MenuSet)enumeration.nextElement();
                this.setActivityInfo(menuSet);
                bl = enumeration.hasMoreElements();
            }
            MenuActivityStore.getInstance().saveMenuActivityInfo();
        }
        catch (Exception exception) {
            logger.warn("Exception while saving activity info");
        }
    }

    private void setActivityInfo(MenuSet menuSet) {
        String string = menuSet.getID();
        int n = menuSet.getMenuCount();
        Menu menu = null;
        ArrayList<String> arrayList = null;
        for (int i = 0; i < n; ++i) {
            arrayList = new ArrayList<String>(10);
            menu = menuSet.getMenu(i);
            if (null == menu) continue;
            this.setMenuActivityCount(string, arrayList, menu);
        }
    }

    private void setMenuActivityCount(String string, List<String> list, Menu menu) {
        list.add(menu.getID());
        int n = menu.getMenuComponentCount();
        Component component = null;
        IActivity iActivity = null;
        for (int i = 0; i < n; ++i) {
            component = menu.getMenuComponent(i);
            if (!(component instanceof IActivity)) continue;
            iActivity = (IActivity)((Object)component);
            if (iActivity instanceof Menu) {
                this.setMenuActivityCount(string, list, (Menu)iActivity);
                continue;
            }
            String string2 = MenuSet.getMenuItemID(component);
            if (null == string2) continue;
            int n2 = iActivity.getActivityCount();
            if (n2 > 0) {
                --n2;
            }
            MenuActivityStore.getInstance().setActivityCount(string, list, string2, n2);
        }
        list.remove(menu.getID());
    }

    public void setEnableFolding(boolean bl) {
        FoldingMenuUtilities.setEnableFolding(bl);
        Enumeration enumeration = this.getAllMenuSet();
        boolean bl2 = enumeration.hasMoreElements();
        MenuSet menuSet = null;
        Menu menu = null;
        int n = 0;
        while (bl2) {
            menuSet = (MenuSet)enumeration.nextElement();
            n = menuSet.getMenuCount();
            for (int i = 0; i < n; ++i) {
                menu = menuSet.getMenu(i);
                if (null == menu) continue;
                this.processSubMenus(menu, bl);
            }
            bl2 = enumeration.hasMoreElements();
        }
    }

    private void processSubMenus(Menu menu, boolean bl) {
        int n = 0;
        menu.setEnableFolding(bl);
        n = menu.getMenuComponentCount();
        Component[] componentArray = menu.getMenuComponents();
        for (int i = 0; i < n; ++i) {
            if (!(componentArray[i] instanceof Menu)) continue;
            this.processSubMenus((Menu)componentArray[i], bl);
        }
    }

    public void validateAllMenuSeparators() {
        Enumeration enumeration = this.menuSetStore.getAllMenuSet();
        MenuSet menuSet = null;
        while (enumeration.hasMoreElements()) {
            menuSet = (MenuSet)enumeration.nextElement();
            this.validateMenuSetSeparators(menuSet);
        }
    }

    public void validateMenuSeparators(Menu menu) {
        if (null == menu) {
            return;
        }
        menu.validateMenuSeparators();
    }

    public void validateMenuSetSeparators(MenuSet menuSet) {
        if (null == menuSet) {
            return;
        }
        int n = menuSet.getMenuCount();
        for (int i = 0; i < n; ++i) {
            this.validateMenuSeparators(menuSet.getMenu(i));
            if (menuSet.getMenuCount() == n || i < 0) continue;
            --i;
            n = menuSet.getMenuCount();
        }
    }

    protected int getBackwardIndex() {
        return this.insertIndexBackward;
    }

    public void cleanupWhileOSGIExit() {
        this.clear();
        this.menuSetStore.clear();
    }
}

