/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.menumanagement;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.foldingmenus.FoldingMenuUtilities;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.applicationmanagement.Application;
import com.swimap.iview.framework.applicationmanagement.ApplicationLauncher;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.systemsettingsmanagement.BaseClientSettings;
import com.swimap.iview.framework.systemsettingsmanagement.SystemSettingsManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.textfield.IntegerTextField;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.TypeConverter;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.omg.CORBA.ORB;

public class FoldingMenuSetting
extends BaseClientSettings {
    private static IviewLogger logger = IviewLogger.getLogger(FoldingMenuSetting.class, "IVIEW");
    static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/menumanagement/Res");
    private boolean defaultCheckBoxFlag = true;
    private JLabel defMenuItemLbl = new JLabel(res.getString("default_visible_menu_items"));
    private JLabel leastUSedCntLbl = new JLabel(res.getString("Least_used_menu_item_count"));
    private JLabel leastUsedCntLblPost = new JLabel(res.getString("Least_used_menu_iten_count_postLabel"));
    private JPanel menuSettingsPanel = null;
    private static final int MIN_RANGE = 1;
    private static final int MAX_RANGE = 50;
    private IntegerTextField leastUSedCntTf = new IntegerTextField(1, 50);
    private boolean changed = false;
    private JCheckBox menuSettingsCheckBox = new JCheckBox(res.getString("Enable_or_disable_menu_collapsing"));
    private IntegerTextField defMenuItemTf = new IntegerTextField(1, 50);
    private static final String DEFAULT_PATH = "conf/mainfrm/menusettings";
    private static final String MENU_SETTING = "FoldingMenuSetting";
    private int preDefVisCnt = 0;
    private int preLeastUsedCnt = 0;
    private boolean preChkBoxVal = false;
    public static final int TEXTFIELD_HEIGHT = 20;

    public FoldingMenuSetting(ModuleManager moduleManager, ORB oRB, String string, String string2) throws ModuleManagementException {
        super(moduleManager, oRB, string, string2);
    }

    public FoldingMenuSetting(ModuleManager moduleManager) throws ModuleManagementException {
        super(moduleManager);
    }

    private void jbInit() {
        this.setLabelWidths();
        this.defMenuItemTf.setPreferredSize(new Dimension(85, 20));
        this.defMenuItemTf.setMinimumSize(new Dimension(85, 20));
        this.leastUSedCntTf.setPreferredSize(new Dimension(85, 20));
        this.leastUSedCntTf.setMinimumSize(new Dimension(85, 20));
        this.leastUSedCntTf.setText(Integer.toString(FoldingMenuUtilities.getLeastUsedCount()));
        this.defMenuItemTf.setText(Integer.toString(FoldingMenuUtilities.getDefaultVisibleCount()));
        this.defMenuItemTf.setName("Default_Visible_MenuItem_Count_TextField");
        this.leastUSedCntTf.setName("Least_Used_Count_TextField");
        this.menuSettingsCheckBox.setName("Enable_MenuSettings_CheckBox");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean apply() {
        SystemSettingsManager systemSettingsManager = FrameworkUtilities.getSystemSettingsManager();
        boolean bl = this.menuSettingsCheckBox.isSelected();
        if (this.defaultCheckBoxFlag == bl && !this.isChanged()) {
            return true;
        }
        int n = FoldingMenuUtilities.getLeastUsedCount();
        int n2 = FoldingMenuUtilities.getDefaultVisibleCount();
        if (this.defMenuItemTf.getText().length() == 0 && this.leastUSedCntTf.getText().length() == 0 || this.defMenuItemTf.getText().length() == 0 || !this.defMenuItemTf.isValid()) {
            if (bl) {
                systemSettingsManager.activateSetting(this);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FoldingMenuSetting.this.defMenuItemTf.requestFocus();
                        FoldingMenuSetting.this.defMenuItemTf.selectAll();
                        OptionPane.showMessageDialog(FrameworkUtilities.getMainFrame(), res.getString("Error_Dialog_Message"));
                    }
                });
                return false;
            }
            this.defMenuItemTf.setText(Integer.toString(n2));
            if (!this.leastUSedCntTf.isValid()) {
                this.leastUSedCntTf.setText(Integer.toString(n));
            } else {
                n = Integer.parseInt(this.leastUSedCntTf.getText());
            }
        } else if (!this.leastUSedCntTf.isValid()) {
            if (bl) {
                systemSettingsManager.activateSetting(this);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FoldingMenuSetting.this.leastUSedCntTf.requestFocus();
                        FoldingMenuSetting.this.leastUSedCntTf.selectAll();
                        OptionPane.showMessageDialog(FrameworkUtilities.getMainFrame(), res.getString("Error_Dialog_Message"));
                    }
                });
                return false;
            }
            this.leastUSedCntTf.setText(Integer.toString(n));
            if (this.defMenuItemTf.isValid()) {
                n2 = Integer.parseInt(this.defMenuItemTf.getText());
            }
        } else if (this.leastUSedCntTf.isValid() && this.defMenuItemTf.isValid()) {
            n = Integer.parseInt(this.leastUSedCntTf.getText());
            n2 = Integer.parseInt(this.defMenuItemTf.getText());
        }
        try {
            this.saveMenuSettingsInformation(n2, n, bl);
            this.defaultCheckBoxFlag = bl;
            FoldingMenuUtilities.setDefaultVisibleCount(n2);
            FoldingMenuUtilities.setLeastUsedCount(n);
            this.applyFoldingMenuSettings(bl);
            this.preChkBoxVal = bl;
            this.preLeastUsedCnt = n;
            this.preDefVisCnt = n2;
            systemSettingsManager.setSystemSettingStatus(this.getTabLabel(), true, "");
        }
        catch (IOException iOException) {
            logger.debug("IOException during the apply." + iOException);
            systemSettingsManager.setSystemSettingStatus(this.getTabLabel(), false, res.getString("Fail_msg"));
            this.applyFoldingMenuSettings(this.preChkBoxVal);
            this.menuSettingsCheckBox.setSelected(this.preChkBoxVal);
            this.leastUSedCntTf.setEnabled(this.preChkBoxVal);
            this.defMenuItemTf.setEnabled(this.preChkBoxVal);
            this.leastUSedCntTf.setText(this.preLeastUsedCnt + "");
            this.defMenuItemTf.setText(this.preDefVisCnt + "");
        }
        this.changed = false;
        return true;
    }

    @Override
    public boolean exit() {
        this.defMenuItemTf.setText(Integer.toString(this.preDefVisCnt));
        this.leastUSedCntTf.setText(Integer.toString(this.preLeastUsedCnt));
        this.menuSettingsCheckBox.setSelected(this.preChkBoxVal);
        this.defMenuItemTf.setEnabled(this.preChkBoxVal);
        this.leastUSedCntTf.setEnabled(this.preChkBoxVal);
        this.changed = false;
        return true;
    }

    @Override
    public JPanel getSettingsPanel() {
        if (null == this.menuSettingsPanel) {
            this.menuSettingsPanel = new JPanel();
            this.jbInit();
            this.menuSettingsPanel.setLayout(new BorderLayout());
            this.menuSettingsPanel.add((Component)this.createMenuSettingPanel(), "North");
            this.menuSettingsPanel.putClientProperty("HELP_ID_PROPERTY", "iVIEW.systemsetting.menu");
            HelpManager.getInstance().enableHelpKey(this.menuSettingsPanel, "iVIEW.systemsetting.menu");
        }
        return this.menuSettingsPanel;
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public String getTabLabel() {
        return res.getString("menuFoldingSetting_TabLabel");
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public int getTitleDescription() {
        return 1;
    }

    @Override
    public String getSettingDescription() {
        return res.getString("foldingmenuSetting_Descr");
    }

    @Override
    public String getModuleName() {
        return MENU_SETTING;
    }

    private void loadMenuSettingsInformation() {
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(DEFAULT_PATH);
        if (null == commStyleInfo) {
            this.defMenuItemTf.setText(Integer.toString(FoldingMenuUtilities.getDefaultVisibleCount()));
            this.leastUSedCntTf.setText(Integer.toString(FoldingMenuUtilities.getLeastUsedCount()));
            boolean bl = this.menuSettingsCheckBox.isSelected();
            this.menuSettingsCheckBox.setSelected(this.defaultCheckBoxFlag);
            if (bl != this.defaultCheckBoxFlag) {
                this.applyFoldingMenuSettings(this.defaultCheckBoxFlag);
            }
            return;
        }
        DescContainer descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer("MenuSetting");
        if (null != descContainer) {
            this.preDefVisCnt = (Integer)TypeConverter.getParameter(descContainer.getParasItemValue("numberOfMenuItemToBeDisplay"), Integer.class);
            this.defMenuItemTf.setText(Integer.toString(this.preDefVisCnt));
            FoldingMenuUtilities.setDefaultVisibleCount(this.preDefVisCnt);
            this.preLeastUsedCnt = (Integer)TypeConverter.getParameter(descContainer.getParasItemValue("countOfLeastUsedMenuItem"), Integer.class);
            this.leastUSedCntTf.setText(Integer.toString(this.preLeastUsedCnt));
            FoldingMenuUtilities.setLeastUsedCount(this.preLeastUsedCnt);
            this.preChkBoxVal = (Boolean)TypeConverter.getParameter(descContainer.getParasItemValue("isMenuSettingEnable"), Boolean.class);
            this.menuSettingsCheckBox.setSelected(this.preChkBoxVal);
            if (!this.defMenuItemTf.isValid() || !this.leastUSedCntTf.isValid()) {
                this.preChkBoxVal = false;
                this.menuSettingsCheckBox.setSelected(this.preChkBoxVal);
            }
            this.applyFoldingMenuSettings(this.preChkBoxVal);
            this.leastUSedCntTf.setEnabled(this.preChkBoxVal);
            this.defMenuItemTf.setEnabled(this.preChkBoxVal);
        }
    }

    private void applyFoldingMenuSettings(boolean bl) {
        if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
            ApplicationUtilities.getBaseMenuManager().setEnableFolding(bl);
            List<Application> list = ApplicationManager.getInstance().getApplications();
            ApplicationLauncher applicationLauncher = ApplicationLauncher.getAppLauncher();
            for (Application application : list) {
                if (!applicationLauncher.isAppLaunched(application.getId())) continue;
                application.getMenuManager().setEnableFolding(bl);
            }
        } else {
            FrameworkUtilities.getMenuManager().setEnableFolding(bl);
        }
    }

    private JPanel createMenuSettingPanel() {
        this.menuSettingsCheckBox.setSelected(this.defaultCheckBoxFlag);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 5, 0));
        jPanel.add(this.defMenuItemLbl);
        jPanel.add(this.defMenuItemTf);
        jPanel.setName("Default_visible_MenuItem_Panel");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 20, 5, 0));
        jPanel2.add(this.leastUSedCntLbl);
        jPanel2.add(this.leastUSedCntTf);
        jPanel2.add(this.leastUsedCntLblPost);
        jPanel2.setName("Least_Used_MenuItem_Panel");
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.setName("Enable_CheckBox_Panel");
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 20, 5, 0));
        this.menuSettingsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FoldingMenuSetting.this.menuSettingsCheckBox_actionPerformed();
            }
        });
        this.defMenuItemTf.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (FoldingMenuSetting.this.defMenuItemTf.getText().length() == 0 || FoldingMenuSetting.this.defMenuItemTf.getValue() != FoldingMenuSetting.this.preDefVisCnt) {
                    FoldingMenuSetting.this.changed = true;
                    FoldingMenuSetting.this.notifyChange();
                }
            }
        });
        this.leastUSedCntTf.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (FoldingMenuSetting.this.leastUSedCntTf.getText().length() == 0 || FoldingMenuSetting.this.leastUSedCntTf.getValue() != FoldingMenuSetting.this.preLeastUsedCnt) {
                    FoldingMenuSetting.this.changed = true;
                    FoldingMenuSetting.this.notifyChange();
                }
            }
        });
        jPanel3.add(this.menuSettingsCheckBox);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(jPanel3);
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        return jPanel4;
    }

    private void setLabelWidths() {
        FontMetrics fontMetrics = this.leastUSedCntLbl.getFontMetrics(this.leastUSedCntLbl.getFont());
        int n = fontMetrics.stringWidth(this.leastUSedCntLbl.getText());
        this.leastUSedCntLbl.setMinimumSize(new Dimension(n, 20));
        this.leastUSedCntLbl.setPreferredSize(new Dimension(n, 20));
        this.leastUSedCntLbl.setMaximumSize(new Dimension(n, 20));
        int n2 = fontMetrics.stringWidth(this.leastUsedCntLblPost.getText());
        this.leastUsedCntLblPost.setMinimumSize(new Dimension(n2, 20));
        this.leastUsedCntLblPost.setPreferredSize(new Dimension(n2, 20));
        this.leastUsedCntLblPost.setMaximumSize(new Dimension(n2, 20));
        int n3 = fontMetrics.stringWidth(this.defMenuItemLbl.getText()) + 4;
        this.defMenuItemLbl.setMinimumSize(new Dimension(n3, 20));
        this.defMenuItemLbl.setPreferredSize(new Dimension(n3, 20));
        this.defMenuItemLbl.setMaximumSize(new Dimension(n3, 20));
    }

    private void menuSettingsCheckBox_actionPerformed() {
        final boolean bl = this.menuSettingsCheckBox.isSelected();
        this.changed = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FoldingMenuSetting.this.defMenuItemTf.setEnabled(bl);
                FoldingMenuSetting.this.leastUSedCntTf.setEnabled(bl);
            }
        });
        this.notifyChange();
    }

    private void notifyChange() {
        FrameworkUtilities.getSystemSettingsManager().clientSettingChanged(this.getModuleName(), this.isChanged());
    }

    @Override
    public void reinitialize() {
        super.reinitialize();
        this.loadMenuSettingsInformation();
    }

    private void saveMenuSettingsInformation(int n, int n2, boolean bl) throws IOException {
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        CommStyleInfo commStyleInfo = commStyleManager.getCommonStyleFile(DEFAULT_PATH);
        if (null == commStyleInfo) {
            return;
        }
        DescContainer descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer("MenuSetting");
        if (null != descContainer) {
            descContainer.setParasItem("numberOfMenuItemToBeDisplay", String.valueOf(n), false);
            descContainer.setParasItem("countOfLeastUsedMenuItem", String.valueOf(n2), false);
            descContainer.setParasItem("isMenuSettingEnable", String.valueOf(bl), false);
            CommStyleManager.getInstance().writeToServer(commStyleInfo);
        }
    }
}

