/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.mainframe;

import com.swimap.iview.commstyle.commini.MenuBar;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.applicationmanagement.Application;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.applicationmanagement.gui.AppRoundButton;
import com.swimap.iview.framework.mainframe.AdvanceSplitPane;
import com.swimap.iview.framework.mainframe.ApplicationWindow;
import com.swimap.iview.framework.mainframe.LayoutButtonBoxEx;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.outputmanagement.OutputManager;
import com.swimap.iview.framework.statusbarmanagement.StatusBarManager;
import com.swimap.iview.framework.toolbarmanagement.ToolbarManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.util.ResourceAdapter;
import com.swimap.iview.framework.windowmanagement.IDesktopListener;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.framework.windowmanagement.WindowManager;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedManager;
import com.swimap.iview.templates.utils.timer.IviewSwingTimer;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.adapter.LayoutButton;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.mdi.DefaultExternalContainer;
import com.swimap.mdi.ExtendedWindow;
import com.swimap.mdi.ExternalContainer;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MDIFrame
extends JFrame {
    private static IviewLogger logger = IviewLogger.getLogger(MDIFrame.class, "IVIEW");
    private WindowManager windowManager = null;
    private ToolbarManager toolbarManager = null;
    private OutputManager outputManager = null;
    private MenuManager menuManager = null;
    private StatusBarManager statusBarManager = null;
    private KeyEventPostProcessor pressKeyProcessor = null;
    private KeyEventDispatcher keyEventDispatcher = null;
    private KeyEventPostProcessor pressKeyProcessorForCtrlF4 = null;
    private ApplicationWindow window = null;
    private boolean frameSizeAdjusted = false;
    private LayoutButtonBoxEx boxContainer = null;
    private JPanel toolBarPanel = null;
    private JPanel portalToolBarPanel = null;
    private static final String DASH_SAPARATOR = " - ";
    private JPanel statusBarPanel = null;
    private static BuffercleanTimer timer = null;
    private String sBaseTitle = null;
    private String sExtendTitle = null;
    private String appTitle = "";
    private String m_beforeLoginTitle = null;
    private JPanel windowPanel = new JPanel();
    private WindowTabbedManager windowTabbedManager = null;
    private AdvanceSplitPane mainPanel = new AdvanceSplitPane();
    private static final int MIN_BOXCONTAINER_WIDTH_3 = 68;
    private static final int MIN_BOXCONTAINER_WIDTH_2 = 47;
    private static final int MIN_BOXCONTAINER_WIDTH_1 = 26;
    private volatile int boxContainerWidth = 0;
    private int cursorState = 0;
    private String m_PrefixIPAddress = null;
    private String m_PostfixIPAddress = null;
    private MouseListener boxListener = null;
    private FocusListener rootPaneFocusListener = null;
    private MDIFrameDesktopListener desktopListener = null;
    private static AWTEventListener bufferListener = null;
    private int bufferCleanTime = 3600000;
    private int doubleBufferWidth = 500;
    private int doubleBufferHeight = 500;
    private long lastDeactiveTime = 0L;
    private Rectangle restoreSize = new Rectangle(150, 150, 600, 500);
    JTabbedPane m_leftTabPane = new JTabbedPane();
    private Hashtable m_tabListeners = new Hashtable();
    private transient ChangeListener m_tabChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JPanel jPanel = (JPanel)MDIFrame.this.m_leftTabPane.getSelectedComponent();
            if (jPanel == null) {
                return;
            }
            ArrayList arrayList = (ArrayList)MDIFrame.this.m_tabListeners.get(jPanel);
            if (arrayList != null && arrayList.size() > 0) {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    ((ChangeListener)arrayList.get(i)).stateChanged(changeEvent);
                }
            }
        }
    };
    private transient ActionListener bufferListner = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            logger.trace("Buffer clear timer reached ");
            if (null != timer) {
                if (timer.getStartTime() == MDIFrame.this.lastDeactiveTime) {
                    logger.debug("client is not active for last 1 hr, clear volatile image buffer with 500*500 ");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MDIFrame.this.resetRepaintVolatileMap(MDIFrame.this, 500, 500);
                        }
                    });
                } else {
                    logger.debug("client is active .No need to clear volatile image buffer ");
                    timer.seStartTime(MDIFrame.this.lastDeactiveTime);
                    return;
                }
            }
        }
    };
    private MouseEvent mouseEvent = null;
    private boolean mdiEnable = true;
    JDesktopPane desktop = null;

    public MDIFrame(String string) {
        super(string);
        this.sBaseTitle = string;
        HelpManager.getInstance().enableHelpKey(this.getRootPane(), "topics_welcome_p_welcome");
    }

    public Rectangle getRestoreSize() {
        return this.restoreSize;
    }

    public void updateTitle() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateTitleInEDT();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MDIFrame.this.updateTitle();
                }
            });
        }
    }

    private void updateTitleInEDT() {
        StringBuffer stringBuffer = new StringBuffer(16);
        this.calculateTitle(stringBuffer);
        stringBuffer.append(this.sBaseTitle);
        this.setTitleInEDT(stringBuffer.toString());
    }

    private StringBuffer calculateTitle(StringBuffer stringBuffer) {
        if (null != this.m_PrefixIPAddress && !this.m_PrefixIPAddress.isEmpty()) {
            stringBuffer.append(this.m_PrefixIPAddress).append(DASH_SAPARATOR);
        }
        if (null != this.sExtendTitle) {
            stringBuffer.append(this.sExtendTitle).append(DASH_SAPARATOR);
        }
        if (null != this.m_PostfixIPAddress && !this.m_PostfixIPAddress.isEmpty()) {
            stringBuffer.append(this.m_PostfixIPAddress).append(DASH_SAPARATOR);
        }
        return stringBuffer;
    }

    public void setBaseTitle(String string) {
        this.sBaseTitle = string;
    }

    public void setMDITitle(String string) {
        if (null == string) {
            return;
        }
        final String string2 = string.trim();
        if (SwingUtilities.isEventDispatchThread()) {
            this.setMDiTiTleInEDT(string2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MDIFrame.this.setMDITitle(string2);
                }
            });
        }
        this.sBaseTitle = string2;
    }

    private void setMDiTiTleInEDT(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.calculateTitle(stringBuffer);
        if (string.isEmpty()) {
            int n = stringBuffer.lastIndexOf(DASH_SAPARATOR);
            stringBuffer.delete(n, n + 2);
        }
        stringBuffer.append(string);
        this.setTitle(stringBuffer.toString());
    }

    public void setPrefixTitle(String string) {
        this.setIViewTitle(string, true);
    }

    public void setSuffixTitle(String string) {
        this.setIViewTitle(string, false);
    }

    public synchronized void setIViewTitle(String string, boolean bl) {
        if (null == string) {
            return;
        }
        string = string.trim();
        if (bl) {
            this.m_PrefixIPAddress = string;
        } else {
            this.m_PostfixIPAddress = string;
        }
        this.updateTitle();
    }

    public String getPrefixTitle() {
        if (null == this.m_PrefixIPAddress) {
            return null;
        }
        return this.m_PrefixIPAddress;
    }

    public String getSuffixTitle() {
        if (null == this.m_PostfixIPAddress) {
            return null;
        }
        return this.m_PostfixIPAddress;
    }

    public void resetTitleOnLogout() {
        if (this.m_PrefixIPAddress != null || this.m_PostfixIPAddress != null) {
            this.setTitleInEDT(this.sBaseTitle);
        }
        this.m_PrefixIPAddress = null;
        this.m_PostfixIPAddress = null;
        this.sExtendTitle = null;
        if (null != this.m_beforeLoginTitle) {
            this.setTitleInEDT(this.m_beforeLoginTitle);
            this.sBaseTitle = this.m_beforeLoginTitle;
        }
    }

    private void setTitleInEDT(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setTitle(string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MDIFrame.this.setTitleInEDT(string);
                }
            });
        }
    }

    public String getMDITitle() {
        return this.sBaseTitle;
    }

    public void setWindowTabbedManager(WindowTabbedManager windowTabbedManager) {
        this.windowTabbedManager = windowTabbedManager;
    }

    public void showWindowTabbedBar(boolean bl) {
        if (FrameworkUtilities.isFullScreenMode()) {
            return;
        }
        try {
            if (this.windowTabbedManager == null) {
                logger.debug("WindowTabbedManger is null.");
                return;
            }
            if (bl) {
                this.windowPanel.add((Component)this.windowTabbedManager.getTabbedBar(), "North");
            } else {
                this.windowPanel.remove(this.windowTabbedManager.getTabbedBar());
            }
            if (this.windowTabbedManager.getTabbedBar() != null && this.windowManager.getDesktopPane() != null) {
                int n = this.windowTabbedManager.getTabbedBar().getPreferredSize().height;
                this.resetDesktopIconPosition(n, bl);
            }
            this.getLayout().layoutContainer(this);
            this.validateAndRepaint();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            this.validateAndRepaint();
        }
    }

    private void validateAndRepaint() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.validate();
            this.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        MDIFrame.this.validate();
                        MDIFrame.this.repaint();
                    }
                    catch (Exception exception) {
                        logger.trace(exception.getMessage(), exception);
                    }
                }
            });
        }
    }

    private void resetDesktopIconPosition(int n, boolean bl) {
        JInternalFrame[] jInternalFrameArray = this.windowManager.getDesktopPane().getAllFrames();
        if (jInternalFrameArray != null && jInternalFrameArray.length > 0) {
            for (int i = 0; i < jInternalFrameArray.length; ++i) {
                if (!jInternalFrameArray[i].isIcon()) continue;
                Rectangle rectangle = jInternalFrameArray[i].getDesktopIcon().getBounds();
                rectangle.y = rectangle.y + (bl ? -1 : 1) * n;
                jInternalFrameArray[i].getDesktopIcon().setBounds(rectangle);
            }
        }
    }

    public void setMenuManager(MenuManager menuManager) {
        this.menuManager = menuManager;
        if (this.menuManager != null) {
            if (FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.application) {
                if (null != this.boxContainer) {
                    this.boxContainer.removeMouseListener(this.boxListener);
                }
                this.getRootPane().removeFocusListener(this.rootPaneFocusListener);
            }
            this.getRootPane().revalidate();
            if (null != menuManager.getMenuBar()) {
                this.menuManager.getMenuBar().validate();
            }
            MDIFrame.traceMessage("setMenuManager()", "menuBar=" + this.menuManager.getMenuBar());
            this.setJMenuBar();
        } else {
            MDIFrame.traceMessage("setMenuManager()", "set menuBar to null.");
            this.resetJMenuBar();
        }
    }

    private void resetJMenuBar() {
        this.setJMenuBar(null);
        if (null != this.boxContainer) {
            this.boxContainer.removeMouseListener(this.boxListener);
        }
        this.getRootPane().removeFocusListener(this.rootPaneFocusListener);
    }

    private void setJMenuBar() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != MDIFrame.this.boxContainer && null != MDIFrame.this.boxContainer.getParent()) {
                    MDIFrame.this.boxContainer.getParent().remove(MDIFrame.this.boxContainer);
                }
                if (null == MDIFrame.this.menuManager || null == MDIFrame.this.menuManager.getMenuBar()) {
                    return;
                }
                MDIFrame.this.setJMenuBar(MDIFrame.this.menuManager.getMenuBar());
                if (FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.application) {
                    AppRoundButton appRoundButton = AppRoundButton.getInstance();
                    MDIFrame.this.getJMenuBar().setBorder(BorderFactory.createEmptyBorder(0, appRoundButton.getPreferredSize().width, 0, 0));
                    if (!ScreenToolKit.getFullScreenFlg() && !appRoundButton.isVisible()) {
                        appRoundButton.setVisible(true);
                        appRoundButton.requestFocus();
                    }
                } else {
                    MDIFrame.this.getJMenuBar().setBorder(BorderFactory.createEmptyBorder());
                }
                MDIFrame.this.initCoolbar();
                MDIFrame.this.setBoxContainerWidth(false);
                MDIFrame.this.getJMenuBar().revalidate();
                MDIFrame.this.getJMenuBar().repaint();
            }
        });
        this.getRootPane().addFocusListener(this.rootPaneFocusListener);
    }

    private void setBoxContainerWidth(boolean bl) {
        JMenuBar jMenuBar = this.getRootPane().getJMenuBar();
        if (null == jMenuBar) {
            return;
        }
        jMenuBar.validate();
        jMenuBar.repaint();
        int n = jMenuBar.getMenuCount();
        Component component = null;
        JMenu jMenu = null;
        if (n >= 2) {
            component = jMenuBar.getMenu(n - 2);
            jMenu = jMenuBar.getMenu(0);
        }
        if (component == null) {
            return;
        }
        int n2 = component.getLocation().x + component.getSize().width;
        int n3 = component.getLocation().y + component.getSize().height;
        int n4 = jMenuBar.getWidth();
        int n5 = n4 - n2;
        int n6 = n3;
        int n7 = jMenu.getLocation().x;
        if (this.boxContainer.isButtonVisible() && this.boxContainer.getComponentCount() == 3 && n5 < 68) {
            this.boxContainerWidth = n4 - n7;
            n6 += component.getSize().height;
        } else if (this.boxContainer.isButtonVisible() && this.boxContainer.getComponentCount() == 2 && n5 < 47) {
            this.boxContainerWidth = n4 - n7;
            n6 += component.getSize().height;
        } else if (this.boxContainer.isButtonVisible() && this.boxContainer.getComponentCount() == 1 && n5 < 26) {
            this.boxContainerWidth = n4 - n7;
            n6 += component.getSize().height;
        } else {
            this.boxContainerWidth = n5;
        }
        if (bl && !ScreenToolKit.getFullScreenFlg()) {
            jMenuBar.setPreferredSize(new Dimension((int)this.getSize().getWidth(), n6));
        }
        jMenuBar.revalidate();
        jMenuBar.repaint();
    }

    public void setToolbarManager(ToolbarManager toolbarManager) {
        this.toolbarManager = toolbarManager;
        if (toolbarManager != null) {
            this.toolBarPanel = toolbarManager.getToolbar();
            this.toolBarPanel.setBorder(new EtchedBorder(){

                @Override
                public Insets getBorderInsets(Component component) {
                    return new Insets(0, 1, 0, 1);
                }
            });
        } else {
            this.toolBarPanel = null;
        }
    }

    public void setOutputmanager(OutputManager outputManager) {
        this.outputManager = outputManager;
        if (outputManager != null) {
            if (outputManager.isTabbedPaneStyle()) {
                outputManager.getOutputTabbedPane().add((Component)outputManager.getOutputPane(), outputManager.getCommonTitle());
                outputManager.getOutputTabbedPane().setTabPlacement(3);
                outputManager.getOutputTabbedPane().setMinimumSize(new Dimension(0, 0));
                ((MDIFrame)FrameworkUtilities.getMainFrame()).setBottomComponent(outputManager.getOutputTabbedPane());
            } else {
                this.mainPanel.setBottomComponent(outputManager.getOutputPane());
            }
        } else {
            this.mainPanel.setBottomComponent(null);
        }
    }

    public void setWindowManager(WindowManager windowManager) {
        this.windowManager = windowManager;
        if (windowManager != null) {
            this.mainPanel.setCenterComponent(new JScrollPane().getViewport().add(windowManager.getDesktopPane()));
            this.desktopListener = new MDIFrameDesktopListener();
            windowManager.addDesktopListener(this.desktopListener);
            windowManager.setMDIFrame(this);
        } else {
            this.mainPanel.setCenterComponent(null);
        }
        this.m_beforeLoginTitle = this.getMDITitle();
    }

    public void setStatusBarmanager(StatusBarManager statusBarManager) {
        this.statusBarManager = statusBarManager;
        if (statusBarManager != null) {
            this.statusBarPanel = statusBarManager.getStatusBarPanel();
        }
    }

    public void addLeftPanel(JPanel jPanel, String string) {
        Component component = this.mainPanel.getLeftComponent();
        if (component != null && component == this.m_leftTabPane) {
            if (this.m_leftTabPane.indexOfComponent(jPanel) < 0) {
                this.m_leftTabPane.add((Component)jPanel, string);
            }
        } else {
            this.m_leftTabPane.add((Component)jPanel, string);
            this.mainPanel.setLeftComponent(this.m_leftTabPane);
            this.m_leftTabPane.addChangeListener(this.m_tabChangeListener);
        }
        this.m_leftTabPane.setSelectedComponent(jPanel);
    }

    public void addLeftPanel(JPanel jPanel, String string, double d) {
        this.addLeftPanel(jPanel, string);
        this.mainPanel.setDividerLocation("left", d);
    }

    public void removeLeftPanel(JPanel jPanel) {
        if (this.m_leftTabPane.indexOfComponent(jPanel) >= 0) {
            Object object;
            boolean bl = true;
            if (this.m_leftTabPane.getSelectedIndex() != this.m_leftTabPane.indexOfComponent(jPanel)) {
                bl = false;
            }
            if (bl) {
                this.m_leftTabPane.remove(jPanel);
            } else {
                object = this.m_leftTabPane.getChangeListeners();
                if (object != null) {
                    for (int i = 0; i < ((ChangeListener[])object).length; ++i) {
                        this.m_leftTabPane.removeChangeListener((ChangeListener)object[i]);
                    }
                }
                Component component = this.m_leftTabPane.getSelectedComponent();
                this.m_leftTabPane.remove(jPanel);
                Component component2 = this.m_leftTabPane.getSelectedComponent();
                if (component != component2) {
                    this.m_leftTabPane.setSelectedComponent(component);
                }
                if (object != null) {
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        this.m_leftTabPane.addChangeListener((ChangeListener)object[i]);
                    }
                }
            }
            object = (ArrayList)this.m_tabListeners.get(jPanel);
            if (object != null) {
                ((ArrayList)object).clear();
                this.m_tabListeners.remove(jPanel);
            }
            if (this.m_leftTabPane.getTabCount() == 0) {
                this.mainPanel.setLeftComponent(null);
                this.m_leftTabPane.removeChangeListener(this.m_tabChangeListener);
            }
        }
    }

    public void selectLeftPanel(JPanel jPanel) {
        if (this.m_leftTabPane.indexOfComponent(jPanel) >= 0) {
            this.m_leftTabPane.setSelectedComponent(jPanel);
        }
    }

    public JPanel getSelectedLeftPanel() {
        if (this.mainPanel.getLeftComponent() == this.m_leftTabPane) {
            return (JPanel)this.m_leftTabPane.getSelectedComponent();
        }
        return null;
    }

    public void addLeftPanelSelectListener(JPanel jPanel, ChangeListener changeListener) {
        if (jPanel != null && this.m_leftTabPane.indexOfComponent(jPanel) >= 0) {
            ArrayList<ChangeListener> arrayList = (ArrayList<ChangeListener>)this.m_tabListeners.get(jPanel);
            if (arrayList == null) {
                arrayList = new ArrayList<ChangeListener>(3);
                arrayList.add(changeListener);
                this.m_tabListeners.put(jPanel, arrayList);
            } else if (!arrayList.contains(changeListener)) {
                arrayList.add(changeListener);
            }
        }
    }

    public void removeLeftPanelSelectListener(JPanel jPanel, ChangeListener changeListener) {
        ArrayList arrayList;
        if (jPanel != null && this.m_leftTabPane.indexOfComponent(jPanel) >= 0 && (arrayList = (ArrayList)this.m_tabListeners.get(jPanel)) != null) {
            arrayList.remove(changeListener);
            if (arrayList.size() == 0) {
                this.m_tabListeners.remove(jPanel);
            }
        }
    }

    public void setLeftComponent(Component component) {
        this.mainPanel.setLeftComponent(component);
    }

    public void setRightComponent(Component component) {
        this.mainPanel.setRightComponent(component);
    }

    public void setBottomComponent(Component component) {
        if (FrameworkUtilities.isFullScreenMode()) {
            this.mainPanel.setBottomComponent(null);
            this.showOutputPane(false);
        } else {
            this.mainPanel.setBottomComponent(component);
        }
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public ToolbarManager getToolbarManager() {
        return this.toolbarManager;
    }

    public OutputManager getOutputManager() {
        return this.outputManager;
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    public StatusBarManager getStatusBarManager() {
        return this.statusBarManager;
    }

    public Component getLeftComponent() {
        return this.mainPanel.getLeftComponent();
    }

    public Component getRightComponent() {
        return this.mainPanel.getRightComponent();
    }

    public Component getBottomComponent() {
        return this.mainPanel.getBottomComponent();
    }

    public double getLeftDividerLocation() {
        return this.mainPanel.getLeftDividerLocation();
    }

    public void setLeftDividerLocation(double d) {
        double d2 = this.mainPanel.getLeftDividerLocationMinimum();
        d = d > d2 ? d : d2;
        this.mainPanel.setDividerLocation("left", d);
    }

    public void showToolbar(boolean bl) {
        if (FrameworkCommandProcessor.getInstance().getUserLoadStyle() != FrameworkCommandProcessor.LoadStyle.application) {
            if (null == this.toolBarPanel) {
                return;
            }
            if (bl) {
                this.getContentPane().add((Component)this.toolBarPanel, "North");
            } else {
                this.getContentPane().remove(this.toolBarPanel);
            }
        } else {
            if (null == this.toolBarPanel) {
                return;
            }
            if (bl) {
                Dimension dimension = null;
                if (null != this.portalToolBarPanel) {
                    dimension = this.portalToolBarPanel.getSize();
                }
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new GridBagLayout());
                if (null != dimension) {
                    jPanel.setSize(dimension);
                }
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                int n = AppRoundButton.getInstance().getPreferredSize().width;
                JComponent jComponent = (JComponent)Box.createRigidArea(new Dimension(n - 2, 30));
                jComponent.setOpaque(false);
                jPanel.add((Component)jComponent, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                jPanel.add((Component)this.toolBarPanel, gridBagConstraints);
                if (null != this.portalToolBarPanel) {
                    this.getContentPane().remove(this.portalToolBarPanel);
                }
                this.portalToolBarPanel = jPanel;
                this.getContentPane().add((Component)this.portalToolBarPanel, "North");
            } else {
                this.getContentPane().remove(this.portalToolBarPanel);
            }
        }
        this.getLayout().layoutContainer(this);
        this.validateAndRepaint();
    }

    public void showOutputPane(boolean bl) {
        if (this.outputManager == null) {
            return;
        }
        this.mainPanel.showComponent("BOTTOM", bl);
    }

    public void resetSplitPanelResizeWeight() {
        if (null != this.mainPanel) {
            this.mainPanel.setSplitPaneResizeWeight(1.0);
        }
    }

    public void showFullScreenMode() {
        this.dispose();
        this.setUndecorated(true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(0, 0, dimension.width, dimension.height);
        this.setResizable(false);
        this.setVisible(true);
    }

    public void showStatusbar(boolean bl) {
        if (null == this.statusBarPanel) {
            return;
        }
        if (bl) {
            this.getContentPane().add((Component)this.statusBarPanel, "South");
        } else {
            this.getContentPane().remove(this.statusBarPanel);
        }
        this.getLayout().layoutContainer(this);
        this.validateAndRepaint();
    }

    public void showComponent(String string, boolean bl) {
        this.mainPanel.showComponent(string, bl);
    }

    private void setBoxContainerVisible(boolean bl) {
        this.boxContainer.setVisible(bl);
    }

    @Override
    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        JMenuBar jMenuBar = this.getRootPane().getJMenuBar();
        int n = 0;
        if (jMenuBar != null) {
            n = jMenuBar.getPreferredSize().height;
        }
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height + n);
    }

    final void iconButton_actionPerformed(ActionEvent actionEvent) {
        InternalFrame internalFrame = (InternalFrame)this.windowManager.getActiveWindow();
        if (internalFrame.isMaximum()) {
            this.windowManager.minimizeActivateWindow();
        } else {
            InternalFrame internalFrame2 = (InternalFrame)this.windowManager.getDesktopPane().getNextMaximizableInternalFrame();
            this.windowManager.minimizeWindow(internalFrame2.getWindowId());
        }
    }

    final void closeButton_actionPerformed(ActionEvent actionEvent) {
        InternalFrame internalFrame = (InternalFrame)this.windowManager.getActiveWindow();
        if (internalFrame.isMaximum()) {
            this.windowManager.closeActivateWindow();
        } else {
            InternalFrame internalFrame2 = (InternalFrame)this.windowManager.getDesktopPane().getNextMaximizableInternalFrame();
            this.windowManager.closeWindow(internalFrame2.getWindowId());
        }
        if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
            AppRoundButton.getInstance().requestFocus();
        }
    }

    final void maxButton_actionPerformed(ActionEvent actionEvent) {
        InternalFrame internalFrame = (InternalFrame)this.windowManager.getActiveWindow();
        if (internalFrame.isMaximum()) {
            this.windowManager.restoreWindow(internalFrame.getWindowId());
        } else {
            InternalFrame internalFrame2 = (InternalFrame)this.windowManager.getDesktopPane().getNextMaximizableInternalFrame();
            this.windowManager.restoreWindow(internalFrame2.getWindowId());
        }
    }

    public void updateCoolbar(int n, boolean bl) {
        this.setBoxContainerVisible(bl);
        if (!bl) {
            this.sExtendTitle = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MDIFrame.this.updateTitle();
                }
            });
            try {
                this.boxContainer.setMaximizedFrame(null);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            return;
        }
        WindowManager windowManager = FrameworkUtilities.getWindowManager();
        if (null != windowManager) {
            InternalFrame internalFrame = windowManager.getWindow(n);
            if (null != internalFrame) {
                String string = "";
                if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
                    String string2 = internalFrame.getAppID();
                    Application application = ApplicationManager.getInstance().getApplication(string2);
                    if (!ResourceUtil.areEquals(application.getName(), internalFrame.getTitle())) {
                        string = application.getName() + DASH_SAPARATOR;
                    }
                }
                this.boxContainer.setMaximizedFrame(internalFrame);
                this.sExtendTitle = string + internalFrame.getTitle();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MDIFrame.this.updateTitle();
                }
            });
        }
    }

    public void jbInit() {
        Dimension dimension;
        RepaintManager repaintManager;
        this.windowPanel.setLayout(new BorderLayout());
        this.windowPanel.add((Component)this.mainPanel, "Center");
        String string = System.getProperty("mdiframe");
        if (null != string) {
            this.setName(string);
        } else {
            this.setName("MDIFrame");
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.windowPanel, "Center");
        this.boxListener = new MouseAdapter(){
            private MouseListener[] m;

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                this.m = MDIFrame.this.menuManager.getMenuBar().getMouseListeners();
                if (this.m == null) {
                    return;
                }
                for (int i = 0; i < this.m.length; ++i) {
                    this.m[i].mouseClicked(mouseEvent);
                }
            }
        };
        this.rootPaneFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.isTemporary()) {
                    MenuElement[] menuElementArray;
                    if (MDIFrame.this.getJMenuBar() != null && MDIFrame.this.getJMenuBar().getSelectionModel() != null) {
                        MDIFrame.this.getJMenuBar().getSelectionModel().clearSelection();
                    }
                    if ((menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath()) != null && menuElementArray.length != 0 && menuElementArray[0] instanceof MenuBar) {
                        MenuSelectionManager.defaultManager().clearSelectedPath();
                    }
                }
            }
        };
        this.initCoolbar();
        this.boxContainer.setVisible(false);
        this.pressKeyProcessor = new KeyEventPostProcessor(){

            @Override
            public boolean postProcessKeyEvent(KeyEvent keyEvent) {
                JInternalFrame jInternalFrame;
                if (MDIFrame.this.isActive() && keyEvent.getID() == 401 && keyEvent.isControlDown() && keyEvent.getKeyCode() == 9 && (jInternalFrame = FrameworkUtilities.getWindowManager().getDesktopPane().getSelectedFrame()) != null) {
                    jInternalFrame.getRootPane().requestFocus();
                }
                return false;
            }
        };
        this.keyEventDispatcher = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                JInternalFrame jInternalFrame;
                if (MDIFrame.this.isActive() && keyEvent.getID() == 401 && keyEvent.isControlDown() && keyEvent.getKeyCode() == 9 && (jInternalFrame = FrameworkUtilities.getWindowManager().getDesktopPane().getSelectedFrame()) != null) {
                    jInternalFrame.getRootPane().requestFocus();
                }
                return false;
            }
        };
        if ("1.2".equals(System.getProperty("platform"))) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.pressKeyProcessor);
        } else {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
        }
        this.pressKeyProcessorForCtrlF4 = new KeyEventPostProcessor(){

            @Override
            public boolean postProcessKeyEvent(KeyEvent keyEvent) {
                JInternalFrame jInternalFrame;
                if (MDIFrame.this.isActive() && keyEvent.getID() == 401 && keyEvent.isControlDown() && keyEvent.getKeyCode() == 115 && (jInternalFrame = FrameworkUtilities.getWindowManager().getDesktopPane().getSelectedFrame()) != null) {
                    jInternalFrame.getRootPane().requestFocus();
                }
                return false;
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.pressKeyProcessorForCtrlF4);
        ArrayList<Image> arrayList = new ArrayList<Image>(2);
        ImageIcon imageIcon = (ImageIcon)ResourceAdapter.getAboutIcon();
        ImageIcon imageIcon2 = (ImageIcon)ResourceAdapter.getTaskbarIcon();
        if (null != imageIcon) {
            arrayList.add(imageIcon.getImage());
        }
        if (null != imageIcon2) {
            arrayList.add(imageIcon2.getImage());
        }
        this.setIconImages(arrayList);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                MDIFrame.this.updateMenuBarHeight();
            }
        });
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                MDIFrame.this.generateAndPostPseudoEvent();
            }
        });
        if (null == bufferListener) {
            bufferListener = new BufferListner();
            Toolkit.getDefaultToolkit().addAWTEventListener(bufferListener, 120L);
        }
        if (null != (repaintManager = RepaintManager.currentManager(this)) && null != (dimension = repaintManager.getDoubleBufferMaximumSize())) {
            this.doubleBufferWidth = dimension.width;
            this.doubleBufferHeight = dimension.height;
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (MDIFrame.this.getExtendedState() == 0 && !MDIFrame.this.isUndecorated()) {
                    MDIFrame.this.restoreSize = MDIFrame.this.getBounds();
                }
                MDIFrame.this.doubleBufferWidth = ScreenToolKit.getScreenWidth();
                MDIFrame.this.doubleBufferHeight = ScreenToolKit.getScreenHeight();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                if (MDIFrame.this.getExtendedState() == 0 && !MDIFrame.this.isUndecorated()) {
                    Rectangle rectangle = MDIFrame.this.getBounds();
                    if (rectangle.x >= 0 && rectangle.y >= 0) {
                        MDIFrame.this.restoreSize = MDIFrame.this.getBounds();
                    }
                }
            }
        });
    }

    private void resetRepaintVolatileMap(JFrame jFrame, int n, int n2) {
        Dimension dimension;
        RepaintManager repaintManager = RepaintManager.currentManager(jFrame);
        if (null != repaintManager && null != (dimension = repaintManager.getDoubleBufferMaximumSize()) && dimension.width != 500 && dimension.height != 500) {
            this.doubleBufferWidth = dimension.width;
            this.doubleBufferHeight = dimension.height;
            logger.trace("Set image buffer to " + n + ", " + n2);
            repaintManager.setDoubleBufferMaximumSize(new Dimension(n, n2));
        }
    }

    private void resetRepaintVolatileMap(JFrame jFrame) {
        Dimension dimension;
        RepaintManager repaintManager = RepaintManager.currentManager(jFrame);
        if (null != repaintManager && null != (dimension = repaintManager.getDoubleBufferMaximumSize()) && dimension.getWidth() != (double)this.doubleBufferWidth && dimension.getHeight() != (double)this.doubleBufferHeight) {
            logger.trace("Reset image buffer to " + this.doubleBufferWidth + ", " + this.doubleBufferHeight);
            repaintManager.setDoubleBufferMaximumSize(new Dimension(this.doubleBufferWidth, this.doubleBufferHeight));
        }
    }

    private void generateAndPostPseudoEvent() {
        if (this.mouseEvent != null) {
            MouseEvent mouseEvent = new MouseEvent((Component)this.mouseEvent.getSource(), 502, this.mouseEvent.getWhen(), this.mouseEvent.getModifiers(), this.mouseEvent.getX(), this.mouseEvent.getY(), 1, false);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(mouseEvent);
        }
    }

    public void addMouseEventListeners(InternalFrame internalFrame) {
        internalFrame.addMouseMotionListener(new MDIMouseMotionListener());
        internalFrame.addMouseListener(new MDIMouseListener());
    }

    public void updateMenuBarHeight() {
        this.setBoxContainerWidth(true);
    }

    public int getBoxContainerWidth() {
        return this.boxContainerWidth;
    }

    private void initCoolbar() {
        Object object;
        if (null == this.boxContainer) {
            object = new SymAction();
            this.boxContainer = new LayoutButtonBoxEx((ActionListener)object);
        }
        if ((object = this.getRootPane().getJMenuBar()) == null) {
            return;
        }
        if (this.boxContainer.getParent() != object) {
            ((Container)object).add(this.boxContainer);
            this.boxContainer.addMouseListener(this.boxListener);
        }
    }

    public boolean hasPopupMenu() {
        Component[] componentArray = FrameworkUtilities.getMainFrame().getRootPane().getComponents();
        Window[] windowArray = FrameworkUtilities.getMainFrame().getOwnedWindows();
        for (int i = 0; i < windowArray.length; ++i) {
            if (!this.hasPopupMenu(windowArray[i].getComponents())) continue;
            return true;
        }
        return this.hasPopupMenu(componentArray);
    }

    private boolean hasPopupMenu(Component[] componentArray) {
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Container)) continue;
            if (componentArray[i] instanceof JPopupMenu) {
                return true;
            }
            boolean bl = this.hasPopupMenu(((Container)componentArray[i]).getComponents());
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public void hidePopupMenu() {
        Component[] componentArray = this.getRootPane().getComponents();
        Window[] windowArray = FrameworkUtilities.getMainFrame().getOwnedWindows();
        for (int i = 0; i < windowArray.length; ++i) {
            this.hidePopupMenu(windowArray[i].getComponents());
        }
        this.hidePopupMenu(componentArray);
    }

    private void hidePopupMenu(Component[] componentArray) {
        try {
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Container)) continue;
                if (componentArray[i] instanceof JPopupMenu) {
                    CommonUtil.hidePopupMenu((JPopupMenu)componentArray[i]);
                }
                this.hidePopupMenu(((Container)componentArray[i]).getComponents());
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public void setMDI(boolean bl) {
        this.mdiEnable = bl;
    }

    public boolean isMDI() {
        return this.mdiEnable;
    }

    public ExternalContainer createExternalContainer(ExtendedWindow extendedWindow) {
        return new DefaultExternalContainer(extendedWindow);
    }

    public void closeWindow() {
        if (this.windowManager != null) {
            this.windowManager.closeActivateWindow();
        }
    }

    public JDesktopPane getDesktop() {
        return this.desktop;
    }

    private static void traceMessage(String string, String string2) {
        logger.debug(string2);
    }

    public LayoutButtonBoxEx getLayOutBtnBoxEx() {
        return this.boxContainer;
    }

    public void setCursorState(int n) {
        this.cursorState = n;
    }

    public int getCursorState() {
        return this.cursorState;
    }

    public void removeMouseEventListeners(InternalFrame internalFrame) {
        if (null == internalFrame) {
            return;
        }
        MouseMotionListener[] mouseMotionListenerArray = internalFrame.getMouseMotionListeners();
        for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
            if (!(mouseMotionListenerArray[i] instanceof MDIMouseMotionListener)) continue;
            internalFrame.removeMouseMotionListener(mouseMotionListenerArray[i]);
        }
        MouseListener[] mouseListenerArray = internalFrame.getMouseListeners();
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            if (!(mouseListenerArray[i] instanceof MDIMouseListener)) continue;
            internalFrame.removeMouseListener(mouseListenerArray[i]);
        }
        this.mouseEvent = null;
    }

    public void cleanupWhileOSGIExit() {
        int n;
        EventListener[] eventListenerArray;
        if (null != this.mainPanel) {
            this.mainPanel.cleanupWhileOSGIExit();
            this.mainPanel.removeAll();
            this.mainPanel = null;
        }
        if (null != this.m_leftTabPane) {
            this.m_leftTabPane.removeChangeListener(this.m_tabChangeListener);
            this.m_tabChangeListener = null;
        }
        if (null != this.boxContainer) {
            this.boxContainer.cleanupWhileOSGIExit();
            this.boxContainer = null;
        }
        if (null != this.toolBarPanel) {
            this.toolBarPanel.setBorder(null);
            this.toolBarPanel.removeAll();
            this.toolBarPanel = null;
        }
        if (null != this.portalToolBarPanel) {
            this.getContentPane().remove(this.portalToolBarPanel);
        }
        if (null != this.statusBarPanel) {
            this.statusBarPanel.removeAll();
            this.statusBarPanel = null;
        }
        if (null != this.windowPanel) {
            this.windowPanel.removeAll();
            this.windowPanel = null;
        }
        this.setJMenuBar(null);
        if (null != this.boxContainer) {
            eventListenerArray = this.boxContainer.getMouseListeners();
            for (n = 0; n < eventListenerArray.length; ++n) {
                this.boxContainer.removeMouseListener(eventListenerArray[n]);
                eventListenerArray[n] = null;
            }
        }
        this.rootPaneFocusListener = null;
        if ("1.2".equals(System.getProperty("platform"))) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.pressKeyProcessor);
        } else {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyEventDispatcher);
        }
        this.pressKeyProcessor = null;
        this.keyEventDispatcher = null;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.pressKeyProcessorForCtrlF4);
        this.pressKeyProcessorForCtrlF4 = null;
        eventListenerArray = this.getComponentListeners();
        for (n = 0; n < eventListenerArray.length; ++n) {
            this.removeComponentListener((ComponentListener)eventListenerArray[n]);
            eventListenerArray[n] = null;
        }
        WindowFocusListener[] windowFocusListenerArray = this.getWindowFocusListeners();
        for (int i = 0; i < windowFocusListenerArray.length; ++i) {
            this.removeWindowFocusListener(windowFocusListenerArray[i]);
            windowFocusListenerArray[i] = null;
        }
        if (null != this.windowManager) {
            this.windowManager.removeDesktopListener(this.desktopListener);
        }
        this.desktopListener = null;
        this.getContentPane().removeAll();
        this.removeAll();
    }

    public String getBasetitle() {
        return this.sBaseTitle;
    }

    public String getExtendtitle() {
        return this.sExtendTitle;
    }

    public void setExtendtitle(String string) {
        this.sExtendTitle = string;
    }

    public void addDesktopPane(JDesktopPane jDesktopPane) {
        if (this.windowManager != null && null != this.mainPanel) {
            this.mainPanel.setCenterComponent(new JScrollPane().getViewport().add(jDesktopPane));
        }
    }

    public void addWindowAndListeners(ApplicationWindow applicationWindow) {
        this.window = applicationWindow;
        this.window.setVisible(true);
    }

    public JPanel getToolBarPanel() {
        if (FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.traditional) {
            return this.toolBarPanel;
        }
        return this.portalToolBarPanel;
    }

    private class MDIMouseListener
    extends MouseAdapter {
        private MDIMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (MDIFrame.this.mouseEvent == null || MDIFrame.this.mouseEvent.getSource() != mouseEvent.getSource()) {
                MDIFrame.this.mouseEvent = mouseEvent;
            }
        }
    }

    private class MDIMouseMotionListener
    extends MouseMotionAdapter {
        private MDIMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            MDIFrame.this.mouseEvent = mouseEvent;
        }
    }

    class BuffercleanTimer
    extends IviewSwingTimer {
        private long startTime;

        BuffercleanTimer(int n, ActionListener actionListener, long l) {
            super(n, actionListener);
            this.startTime = 0L;
            this.startTime = l;
        }

        long getStartTime() {
            return this.startTime;
        }

        void seStartTime(long l) {
            this.startTime = l;
        }
    }

    private class BufferListner
    implements AWTEventListener {
        private BufferListner() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent instanceof WindowEvent) {
                if (aWTEvent.getID() == 205) {
                    MDIFrame.this.resetRepaintVolatileMap(MDIFrame.this);
                    if (timer == null) {
                        MDIFrame.this.lastDeactiveTime = System.currentTimeMillis();
                        logger.debug("Timer is created for 1 hr to clear volatileimage buffer at" + MDIFrame.this.lastDeactiveTime);
                        timer = new BuffercleanTimer(MDIFrame.this.bufferCleanTime, MDIFrame.this.bufferListner, MDIFrame.this.lastDeactiveTime);
                        timer.start();
                    }
                }
            } else if (aWTEvent instanceof KeyEvent || aWTEvent instanceof MouseEvent) {
                MDIFrame.this.resetRepaintVolatileMap(MDIFrame.this);
                MDIFrame.this.lastDeactiveTime = System.currentTimeMillis();
            }
        }
    }

    private class MDIFrameDesktopListener
    implements IDesktopListener {
        private MDIFrameDesktopListener() {
        }

        @Override
        public void currentWindowStateChanged(int n, boolean bl) {
            MDIFrame.this.updateCoolbar(n, bl);
        }
    }

    private class SymAction
    implements ActionListener {
        private SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (!(object instanceof LayoutButton)) {
                return;
            }
            LayoutButton layoutButton = (LayoutButton)object;
            switch (layoutButton.getControlType()) {
                case 1: {
                    MDIFrame.this.maxButton_actionPerformed(actionEvent);
                    break;
                }
                case 2: {
                    MDIFrame.this.iconButton_actionPerformed(actionEvent);
                    break;
                }
                case 3: {
                    MDIFrame.this.closeButton_actionPerformed(actionEvent);
                    break;
                }
            }
        }
    }
}

