/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.mainframe;

import com.swimap.iview.framework.util.FrameworkUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class AdvanceSplitPane
extends JPanel {
    private JSplitPane mainSplitPane = new JSplitPane();
    private JSplitPane splitPaneLevel1 = new JSplitPane();
    private JSplitPane splitPaneLevel2 = new JSplitPane();
    private Component leftComponent = null;
    private Component rightComponent = null;
    private Component centerComponent = null;
    private Component bottomComponent = null;
    public static final String TOP = "TOP";
    public static final String LEFT = "LEFT";
    public static final String RIGHT = "RIGHT";
    public static final String CENTER = "CENTER";
    public static final String BOTTOM = "BOTTOM";
    static final String LEFT_DIVIDER = "left";
    static final String RIGHT_DIVIDER = "right";
    static final String DOWN_DIVIDER = "down";
    public final int LEAST_COMPONENT_SIZE = 10;
    public final double DEFAULT_DIVIDER_LOCATION = 0.25;
    public final int DEFAULT_DIVIDER_SIZE = 4;
    public final int ONETOUCH_DIVIDER_SIZE = 8;
    public final int INVISIABLE_DIVIDER_SIZE = 0;
    private static int outputHeight = 0;
    private boolean isMinimized = false;

    public AdvanceSplitPane() {
        this.setLayout(new BorderLayout());
        this.mainSplitPane.setOrientation(0);
        this.mainSplitPane.setResizeWeight(1.0);
        this.mainSplitPane.setBounds(new Rectangle(36, 193, 542, 288));
        this.mainSplitPane.setName("AdvanceSplitPane_mainSplitPane");
        this.splitPaneLevel2.setResizeWeight(1.0);
        this.mainSplitPane.add((Component)this.splitPaneLevel1, "top");
        this.splitPaneLevel1.setName("AdvanceSplitPane_splitPaneLevel1");
        this.mainSplitPane.setBottomComponent(null);
        this.splitPaneLevel1.add((Component)this.splitPaneLevel2, RIGHT_DIVIDER);
        this.splitPaneLevel1.setLeftComponent(null);
        this.splitPaneLevel1.setOneTouchExpandable(true);
        this.splitPaneLevel2.setRightComponent(null);
        this.splitPaneLevel2.setLeftComponent(null);
        this.splitPaneLevel2.setName("AdvanceSplitPane_splitPaneLevel2");
        this.add(this.mainSplitPane);
        this.mainSplitPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Object object = componentEvent.getSource();
                if (object == AdvanceSplitPane.this.mainSplitPane) {
                    AdvanceSplitPane.this.dividerLocation();
                }
            }
        });
        this.mainSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("dividerLocation".equals(propertyChangeEvent.getPropertyName()) && AdvanceSplitPane.this.mainSplitPane.getOrientation() == 0) {
                    if (null != FrameworkUtilities.getTerminalManager() && FrameworkUtilities.getTerminalManager().isTerminalLocked()) {
                        return;
                    }
                    double d = ((Integer)propertyChangeEvent.getNewValue()).intValue();
                    double d2 = d / (double)(AdvanceSplitPane.this.mainSplitPane.getHeight() - AdvanceSplitPane.this.mainSplitPane.getDividerSize());
                    if (d < 0.0 || d2 < 0.0) {
                        return;
                    }
                    if (d2 >= 0.0 && d2 <= 1.0) {
                        if (d2 >= 0.95) {
                            d2 = 1.0;
                        }
                        AdvanceSplitPane.this.setSplitPaneResizeWeight(d2);
                    }
                }
            }
        });
    }

    public void setSplitPaneResizeWeight(double d) {
        this.mainSplitPane.setResizeWeight(d);
    }

    private void dividerLocation() {
        int n;
        boolean bl = false;
        if (this.mainSplitPane.getHeight() <= 0) {
            JTabbedPane jTabbedPane = FrameworkUtilities.getOutputManager().getOutputTabbedPane();
            outputHeight = jTabbedPane != null && jTabbedPane.getHeight() > 0 && jTabbedPane.getTabCount() > 1 ? jTabbedPane.getHeight() : (jTabbedPane != null ? jTabbedPane.getHeight() : 0);
            this.isMinimized = true;
            jTabbedPane = null;
        }
        if (this.mainSplitPane.getHeight() > outputHeight + 4 && this.isMinimized) {
            int n2 = this.mainSplitPane.getHeight() - outputHeight - 4 > 50 ? this.mainSplitPane.getHeight() - outputHeight - 4 : 50;
            this.mainSplitPane.setDividerLocation(n2);
            this.isMinimized = false;
            bl = true;
        }
        if ((n = this.mainSplitPane.getDividerLocation()) == 0) {
            this.mainSplitPane.setDividerLocation(10);
            bl = true;
        }
        int n3 = this.splitPaneLevel1.getDividerLocation();
        if (this.getLeftComponent() != null && (n3 < 30 && n3 > 0 || n3 > this.splitPaneLevel1.getWidth() - 30 && n3 > 700)) {
            this.splitPaneLevel1.setDividerLocation(0.25);
            bl = true;
        }
        if (bl) {
            this.mainSplitPane.revalidate();
            this.mainSplitPane.repaint();
        }
    }

    public JSplitPane getBottomSplitPane() {
        return this.mainSplitPane;
    }

    public JSplitPane getLeftSplitPane() {
        return this.splitPaneLevel1;
    }

    public JSplitPane getRightSplitPane() {
        return this.splitPaneLevel2;
    }

    public void setLeftComponent(Component component) {
        this.leftComponent = component;
        this.splitPaneLevel1.setLeftComponent(this.leftComponent);
        this.updateDivider();
    }

    public void setLeftComponent(Component component, double d) {
        this.leftComponent = component;
        this.splitPaneLevel1.setLeftComponent(this.leftComponent);
        this.splitPaneLevel1.setDividerLocation(d);
        this.updateDivider();
    }

    public void setDividerLocation(String string, double d) {
        if (LEFT_DIVIDER.equalsIgnoreCase(string)) {
            if (this.leftComponent != null) {
                this.splitPaneLevel1.setDividerLocation(d);
            }
        } else if (RIGHT_DIVIDER.equalsIgnoreCase(string)) {
            if (this.leftComponent != null) {
                this.splitPaneLevel2.setDividerLocation(1.0 - d);
            }
        } else if (DOWN_DIVIDER.equalsIgnoreCase(string) && this.leftComponent != null) {
            this.mainSplitPane.setDividerLocation(1.0 - d);
        }
    }

    public void setRightComponent(Component component) {
        this.rightComponent = component;
        this.splitPaneLevel2.setRightComponent(this.rightComponent);
        this.updateDivider();
    }

    public void setCenterComponent(Component component) {
        this.centerComponent = component;
        if (null != component) {
            ((JComponent)this.centerComponent).setMinimumSize(new Dimension(100, 50));
        }
        this.splitPaneLevel2.setLeftComponent(this.centerComponent);
        this.updateDivider();
    }

    public void setBottomComponent(Component component) {
        this.bottomComponent = component;
        this.mainSplitPane.setBottomComponent(this.bottomComponent);
        this.updateDivider();
    }

    public Component getLeftComponent() {
        return this.leftComponent;
    }

    public Component getRightComponent() {
        return this.rightComponent;
    }

    public Component getCenterComponent() {
        return this.centerComponent;
    }

    public Component getBottomComponent() {
        return this.bottomComponent;
    }

    final double getLeftDividerLocation() {
        return (double)this.splitPaneLevel1.getDividerLocation() / (double)(this.splitPaneLevel1.getWidth() - this.splitPaneLevel1.getDividerSize());
    }

    final double getLeftDividerLocationMinimum() {
        return (double)this.splitPaneLevel1.getMinimumDividerLocation() / (double)(this.splitPaneLevel1.getWidth() - this.splitPaneLevel1.getDividerSize());
    }

    public void showComponent(String string, boolean bl) {
        if (string == null) {
            return;
        }
        double d = this.DEFAULT_DIVIDER_LOCATION;
        if (string.equals(CENTER)) {
            d = 0.75;
            this.showSplitPaneComp(this.splitPaneLevel2, LEFT, bl, d);
        } else if (string.equals(BOTTOM)) {
            this.showSplitPaneComp(this.mainSplitPane, BOTTOM, bl, d);
        } else if (string.equals(LEFT)) {
            this.showSplitPaneComp(this.splitPaneLevel1, LEFT, bl, d);
        } else if (string.equals(RIGHT)) {
            this.showSplitPaneComp(this.splitPaneLevel2, RIGHT, bl, d);
        }
        this.updateDivider();
    }

    public void showSplitPaneComp(JSplitPane jSplitPane, String string, boolean bl, double d) {
        if (jSplitPane == null || string == null) {
            return;
        }
        if (string.equals(LEFT) || string.equals(TOP)) {
            if (bl) {
                if (jSplitPane.getDividerLocation() <= this.LEAST_COMPONENT_SIZE) {
                    jSplitPane.setDividerLocation(d);
                }
            } else {
                jSplitPane.setDividerLocation(0.0);
            }
        } else if ((string.equals(BOTTOM) || string.equals(RIGHT)) && !bl) {
            jSplitPane.setDividerLocation(1.0);
        }
    }

    public void updateDivider() {
        if (null == this.bottomComponent) {
            this.mainSplitPane.setDividerSize(0);
        } else if (this.mainSplitPane.isOneTouchExpandable()) {
            this.mainSplitPane.setDividerSize(this.ONETOUCH_DIVIDER_SIZE);
        } else {
            this.mainSplitPane.setDividerSize(this.DEFAULT_DIVIDER_SIZE);
        }
        this.updateLeftSplitPane();
        this.updateRightSplitPane();
        this.revalidate();
        this.repaint();
    }

    private void updateRightSplitPane() {
        if (null == this.centerComponent || null == this.rightComponent) {
            this.splitPaneLevel2.setDividerSize(0);
        } else if (this.splitPaneLevel2.isOneTouchExpandable()) {
            this.splitPaneLevel2.setDividerSize(this.ONETOUCH_DIVIDER_SIZE);
        } else {
            this.splitPaneLevel2.setDividerSize(this.DEFAULT_DIVIDER_SIZE);
        }
    }

    private void updateLeftSplitPane() {
        if (null == this.leftComponent) {
            this.splitPaneLevel1.setDividerSize(0);
        } else if (this.splitPaneLevel1.isOneTouchExpandable()) {
            this.splitPaneLevel1.setDividerSize(this.ONETOUCH_DIVIDER_SIZE);
        } else {
            this.splitPaneLevel1.setDividerSize(this.DEFAULT_DIVIDER_SIZE);
        }
    }

    public void cleanupWhileOSGIExit() {
        this.mainSplitPane.removeAll();
        ComponentListener[] componentListenerArray = this.mainSplitPane.getComponentListeners();
        for (int i = 0; i < componentListenerArray.length; ++i) {
            this.mainSplitPane.removeComponentListener(componentListenerArray[i]);
            componentListenerArray[i] = null;
        }
        PropertyChangeListener[] propertyChangeListenerArray = this.mainSplitPane.getPropertyChangeListeners();
        for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
            this.mainSplitPane.removePropertyChangeListener(propertyChangeListenerArray[i]);
            propertyChangeListenerArray[i] = null;
        }
        this.mainSplitPane = null;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.updateDivider();
    }
}

