/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel.skin;

import com.swimap.iview.util.ScreenToolKit;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class TooltipListCellRenderer
extends BasicComboBoxRenderer {
    private JComboBox comboBoxRendered = null;

    public TooltipListCellRenderer(JComboBox jComboBox) {
        this.comboBoxRendered = jComboBox;
        this.comboBoxRendered.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                TooltipListCellRenderer.this.resetToolTip();
            }
        });
        this.comboBoxRendered.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TooltipListCellRenderer.this.resetToolTip();
            }
        });
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        String string = this.getToolTipData(object, jList.getFont(), this.comboBoxRendered.getWidth());
        this.setToolTipText(string);
        return this;
    }

    private String getToolTipData(Object object, Font font, int n) {
        String string;
        String string2 = null;
        if (null != object) {
            string2 = object.toString();
        }
        if (null != string2 && string2.equals(string = ScreenToolKit.getAbbreviatoryString(string2, n, font))) {
            string2 = null;
        }
        return string2;
    }

    public void resetToolTip() {
        JComboBox jComboBox = this.comboBoxRendered;
        Object object = jComboBox.getSelectedItem();
        if (null != object) {
            String string = this.getToolTipData(object, jComboBox.getFont(), jComboBox.getWidth() - 30);
            jComboBox.setToolTipText(string);
        }
    }
}

