/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel.skin;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.lookandfeel.NameValuePair;
import com.swimap.iview.framework.lookandfeel.skin.SkinManager;
import com.swimap.iview.framework.lookandfeel.skin.TooltipListCellRenderer;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.systemsettingsmanagement.BaseClientSettings;
import com.swimap.iview.framework.systemsettingsmanagement.SystemSettingsManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.omg.CORBA.ORB;

public class SkinSettings
extends BaseClientSettings {
    private static IviewLogger logger = IviewLogger.getLogger(SkinSettings.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/lookandfeel/Res");
    public static final String MODULE_NAME = "SkinSettings";
    private JPanel skinPanel = null;
    private JComboBox skinCombo = null;
    private static final int EMPTY_BORDERWIDTH = 12;
    private static final int SKINBOX_WIDTH = 120;
    private final Dimension HGAP12 = new Dimension(12, 1);
    private static final int SKINBOX_HEIGHT = 20;
    private boolean changed = false;

    public SkinSettings(ModuleManager moduleManager, ORB oRB, String string, String string2) throws ModuleManagementException {
        super(moduleManager, oRB, string, string2);
        this.initialize();
    }

    public SkinSettings(ModuleManager moduleManager) throws ModuleManagementException {
        super(moduleManager);
        this.initialize();
    }

    @Override
    public boolean apply() {
        this.actionPerformed();
        return true;
    }

    @Override
    public boolean exit() {
        this.selectCurrentSkinSettings();
        return true;
    }

    private void selectCurrentSkinSettings() {
        for (int i = 0; i < this.skinCombo.getItemCount(); ++i) {
            NameValuePair nameValuePair = (NameValuePair)this.skinCombo.getItemAt(i);
            if (!((String)nameValuePair.getValue()).equals(SkinManager.getInstance().getSelectedSkin())) continue;
            this.skinCombo.setSelectedIndex(i);
            break;
        }
    }

    @Override
    public JPanel getSettingsPanel() {
        return this.skinPanel;
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public String getTabLabel() {
        return res.getString("Skin");
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public void initialize() {
        this.skinPanel = new JPanel();
        this.skinPanel.setLayout(new BorderLayout());
        this.skinPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        JPanel jPanel = this.createSkinPanel();
        this.skinPanel.add((Component)jPanel, "North");
        this.skinPanel.putClientProperty("HELP_ID_PROPERTY", "iVIEW.File.Preferences.skin");
        HelpManager.getInstance().enableHelpKey(this.skinPanel, "iVIEW.File.Preferences.skin");
    }

    private JPanel createSkinPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        String string = res.getString("Skin");
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(this.skinPanel.getBackground().brighter(), this.skinPanel.getBackground().darker()), string);
        jPanel.setBorder(titledBorder);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JLabel jLabel = new JLabel(res.getString(MODULE_NAME));
        HashMap<String, String> hashMap = SkinManager.getInstance().getSkins();
        Object[] objectArray = this.getSkinCombos(hashMap);
        this.skinCombo = new JComboBox<Object>(objectArray);
        this.skinCombo.setName("Skin");
        this.skinCombo.setPreferredSize(new Dimension(120, 20));
        this.skinCombo.setMinimumSize(new Dimension(120, 20));
        this.selectCurrentSkinSettings();
        this.skinCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SkinSettings.this.skinBoxActionPerformed();
            }
        });
        this.skinCombo.setRenderer(new TooltipListCellRenderer(this.skinCombo));
        jPanel2.add(jLabel);
        jPanel2.add(Box.createRigidArea(this.HGAP12));
        jPanel2.add(this.skinCombo);
        jPanel2.add(Box.createRigidArea(this.HGAP12));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(6, 17, 12, 0), 0, 0));
        return jPanel;
    }

    protected void skinBoxActionPerformed() {
        String string = (String)((NameValuePair)this.skinCombo.getSelectedItem()).getValue();
        this.changed = !string.equals(SkinManager.getInstance().getSelectedSkin());
        this.notifyChange();
    }

    private Object[] getSkinCombos(HashMap<String, String> hashMap) {
        Object[] objectArray = new Object[hashMap.size()];
        int n = 0;
        Set<Map.Entry<String, String>> set = hashMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            objectArray[n++] = new NameValuePair<String>(entry.getValue(), entry.getKey());
        }
        return objectArray;
    }

    public void actionPerformed() {
        NameValuePair nameValuePair = (NameValuePair)this.skinCombo.getSelectedItem();
        SkinManager.getInstance().setSelectedSkinSettings((String)nameValuePair.getValue());
        this.changed = false;
        this.notifyChange();
        try {
            SystemSettingsManager systemSettingsManager = (SystemSettingsManager)this.getLocalReference("mainsystemsettingmanager");
            systemSettingsManager.setNeedRestartSystem(true);
            systemSettingsManager.setSystemSettingStatus(this.getTabLabel(), true, systemSettingsManager.getRestartMessage());
        }
        catch (ModuleManagementException moduleManagementException) {
            logger.trace("get SystemSettingsManager Exception in skin settings");
            logger.trace(moduleManagementException);
        }
    }

    private void notifyChange() {
        FrameworkUtilities.getSystemSettingsManager().clientSettingChanged(this.getModuleName(), this.changed);
    }

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public String getSettingDescription() {
        return res.getString("SkinSetting_Descr");
    }

    @Override
    public int getTitleDescription() {
        return 2;
    }
}

