/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel.skin;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.lookandfeel.skin.SkinColors;
import com.swimap.iview.util.DebugTracer;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class SkinManager {
    private static HashMap<String, String> skins = new HashMap(3);
    private static SkinManager instance = null;
    private static String selectedSkin = "";
    private static String defaultSkin = "";
    private static String currentSkin = "";
    private static boolean enableSkinSettings = false;

    private SkinManager() {
        this.readSkinFolder("style/productstyle/conf/skins/");
        this.readSkinFolder("style/defaultstyle/conf/skins/");
        this.readSkinSettings();
    }

    private void readSkinFolder(String string) {
        String string2 = System.getProperty("user.dir");
        String string3 = string2 + File.separator + string;
        File file = new File(string3);
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return new File(file.getAbsolutePath() + File.separator + string).isDirectory();
            }
        });
        CommStyleInfo commStyleInfo = null;
        String string4 = "";
        for (File file2 : fileArray) {
            try {
                string4 = file2.getAbsolutePath() + File.separator + "UIColors";
                string4 = string4.replaceAll("\\\\", "/");
                string4 = string4.substring(string4.indexOf("conf/"), string4.length());
                commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(string4);
                AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer("description");
                String string5 = areaDescContainer.getDescContainer("description").getParasItem("name").getValue().trim();
                string5 = this.getResourceName(string5, areaDescContainer);
                String string6 = file2.getName();
                if (string5.length() == 0 || null != skins.get(string6)) continue;
                skins.put(string6, string5);
            }
            catch (Exception exception) {
                DebugTracer.trace(exception);
            }
        }
    }

    private String getResourceName(String string, AreaDescContainer areaDescContainer) {
        DescContainer descContainer = areaDescContainer.getDescContainer("ResourceBundle");
        ResourceBundle resourceBundle = null;
        if (null != descContainer) {
            String string2 = descContainer.getParasItemValue("resourceBundleName");
            try {
                resourceBundle = ResourceMng.getInstance().getResourceBundleFromPropertyFile(string2);
                if (null == resourceBundle) {
                    resourceBundle = ResourceBundle.getBundle(string2);
                }
            }
            catch (Exception exception) {
                DebugTracer.trace(exception);
            }
        }
        if (null != resourceBundle) {
            try {
                string = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                DebugTracer.trace(missingResourceException);
            }
        }
        return string;
    }

    private void readSkinSettings() {
        String string;
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/mainfrm/UISkin");
        if (null == commStyleInfo) {
            return;
        }
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer("skin");
        if (null == areaDescContainer) {
            return;
        }
        DescContainer descContainer = areaDescContainer.getDescContainer("skin");
        if (null == descContainer) {
            return;
        }
        try {
            string = descContainer.getParasItem("enable").getValue().trim();
            enableSkinSettings = Boolean.valueOf(string);
        }
        catch (Exception exception) {
            DebugTracer.trace("The default skin id settings does not exists or invalid , taking the client default colors");
        }
        try {
            string = descContainer.getParasItem("default_skin_id").getValue().trim();
            if (null != skins.get(string)) {
                defaultSkin = string;
            }
        }
        catch (Exception exception) {
            DebugTracer.trace("The default skin id settings does not exists or invalid , taking the client default colors");
        }
        try {
            string = descContainer.getParasItem("current_skin_id").getValue().trim();
            if (null != skins.get(string)) {
                currentSkin = string;
            }
        }
        catch (Exception exception) {
            DebugTracer.trace("The current skin id settings does not exists or invalid , taking the client default colors");
        }
        if (enableSkinSettings) {
            if (null != skins.get(currentSkin)) {
                selectedSkin = currentSkin;
            }
        } else if (null != skins.get(defaultSkin)) {
            selectedSkin = defaultSkin;
        }
    }

    public static SkinManager getInstance() {
        if (null == instance) {
            instance = new SkinManager();
        }
        return instance;
    }

    public final HashMap<String, String> getSkins() {
        return skins;
    }

    public final String getSelectedSkin() {
        return selectedSkin;
    }

    public SkinColors getSelectedSkinSettings() {
        String string = "conf/skins/" + selectedSkin + File.separator + "UIColors";
        return new SkinColors(string);
    }

    public void setSelectedSkinSettings(String string) {
        if (null == skins.get(string)) {
            return;
        }
        CommStyleInfo commStyleInfo = null;
        try {
            commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/mainfrm/UISkin");
            DescContainer descContainer = null;
            if (null == commStyleInfo) {
                commStyleInfo = new CommStyleInfo();
                commStyleInfo.setFileName("style/all users/conf/mainfrm/UISkin.xml");
                AreaDescContainer areaDescContainer = new AreaDescContainer("skin");
                descContainer = new DescContainer("skin");
                areaDescContainer.addDescContainer(descContainer);
                commStyleInfo.addAreaDescContainer(areaDescContainer);
            } else {
                descContainer = commStyleInfo.getAreaDescContainer("skin").getDescContainer("skin");
            }
            if (enableSkinSettings) {
                descContainer.setParasItem("current_skin_id", string, true);
                descContainer.setParasItem("default_skin_id", defaultSkin, true);
            } else {
                descContainer.setParasItem("current_skin_id", currentSkin, true);
                descContainer.setParasItem("default_skin_id", string, true);
            }
            descContainer.setParasItem("enable", Boolean.toString(enableSkinSettings), true);
            commStyleInfo.writeToAllUsers();
            selectedSkin = string;
        }
        catch (Exception exception) {
            DebugTracer.trace(exception);
        }
    }

    public final boolean isEnableSkinSettings() {
        return enableSkinSettings;
    }

    private ImageIcon getIcon(String string, String string2) {
        ImageIcon imageIcon = null;
        String string3 = System.getProperty("user.dir");
        String string4 = string3 + File.separator + "style/productstyle/conf/skins/" + selectedSkin + File.separator + "images/" + string2 + File.separator + string;
        String string5 = string3 + File.separator + "style/defaultstyle/conf/skins/" + selectedSkin + File.separator + "images/" + string2 + File.separator + string;
        if (new File(string4).exists()) {
            imageIcon = new ImageIcon(string4);
        } else if (new File(string5).exists()) {
            imageIcon = new ImageIcon(string5);
        }
        return imageIcon;
    }

    public ImageIcon getSkinImage(String string, String string2, Class<?> clazz) {
        ImageIcon imageIcon = this.getSkinImage(string2, string);
        if (null == imageIcon) {
            imageIcon = new ImageIcon(clazz.getResource(string2));
        }
        return imageIcon;
    }

    public ImageIcon getSkinImage(String string, String string2) {
        return this.getIcon(string2, string);
    }
}

