/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel.skin;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.util.DebugTracer;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class SkinColors {
    private static final int DEFAULT_INITIAL_CAPACITY = 3;
    private HashMap<String, Color> preDefinedColors = new HashMap(3);
    private HashMap<String, Color> javaColors = new HashMap(3);
    private static String[] preColorsTags = new String[]{"MAIN_BACKGROUD_COLOR", "TOOLBAR_BACKGROUND", "DESKTOP_COLOR", "HYPERLINK_COLOR", "SELECTED_BACKGROUND", "EDIT_BACKGROUND", "BORDER_COLOR", "TABLE_HEADER_BACKGROUND", "DISABLED_BACKGROUND", "DISABLED_FOREGROUND", "TREE_BACKGROUND", "TREE_TEXT_BACKGROUND"};

    public SkinColors(String string) {
        CommStyleInfo commStyleInfo = null;
        try {
            commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(string);
            if (null == commStyleInfo) {
                return;
            }
            AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer("UIColors");
            List<String> list = Arrays.asList(preColorsTags);
            Color color = null;
            String string2 = null;
            for (DescContainer descContainer : areaDescContainer.getDescContainer()) {
                string2 = descContainer.getDescName();
                if (null == string2 || string2.trim().length() == 0) continue;
                try {
                    String string3 = descContainer.getParasItem("rgb").getValue();
                    String[] stringArray = string3.split(",");
                    int n = Integer.parseInt(stringArray[0]);
                    int n2 = Integer.parseInt(stringArray[1]);
                    int n3 = Integer.parseInt(stringArray[2]);
                    color = new Color(n, n2, n3);
                    if (list.contains(string2)) {
                        this.preDefinedColors.put(string2, color);
                        continue;
                    }
                    this.javaColors.put(string2, color);
                }
                catch (Exception exception) {
                    DebugTracer.trace("RGB value configured for " + string2 + " is not valid in " + string);
                }
            }
        }
        catch (Exception exception) {
            DebugTracer.trace(exception);
        }
    }

    public final HashMap<String, Color> getPreDefinedColors() {
        return this.preDefinedColors;
    }

    public final HashMap<String, Color> getJavaColors() {
        return this.javaColors;
    }
}

