/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel.scrollbar;

import com.swimap.iview.framework.lookandfeel.scrollbar.SwimapScrollBarUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;

public class SwimapScrollButton
extends BasicArrowButton {
    private static final Color[] normalColors = new Color[]{new Color(233, 234, 243), new Color(191, 193, 215)};
    private static final Color[] hoverColors = new Color[]{Color.white, new Color(207, 209, 232)};
    private static final Color[] pressedColors = new Color[]{new Color(210, 211, 235), Color.white};
    private static final Color[] disableColors = new Color[]{new Color(233, 233, 233), new Color(193, 193, 193)};
    private static final int ARROW_WIDTH = 3;
    private int buttonWidth;

    public SwimapScrollButton(int n, int n2) {
        super(n);
        this.buttonWidth = n2;
        this.setIcon(SwimapScrollBarUI.trackHorz);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                ButtonModel buttonModel = abstractButton.getModel();
                if (abstractButton.getBounds().contains(mouseEvent.getPoint().getX() + (double)abstractButton.getBounds().x, mouseEvent.getPoint().getY() + (double)abstractButton.getBounds().y)) {
                    buttonModel.setRollover(true);
                } else {
                    buttonModel.setRollover(false);
                }
            }
        });
    }

    @Override
    public void paint(Graphics graphics) {
        Color color = graphics.getColor();
        boolean bl = this.getParent().isEnabled();
        boolean bl2 = this.getModel().isPressed();
        boolean bl3 = this.getModel().isRollover();
        int n = 0;
        int n2 = 0;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (bl) {
            if (this.getDirection() == 1 || this.getDirection() == 5) {
                graphics.drawImage(SwimapScrollBarUI.trackVert.getImage(), 0, 0, n3, n4, SwimapScrollBarUI.trackVert.getImageObserver());
            } else {
                graphics.drawImage(SwimapScrollBarUI.trackHorz.getImage(), 0, 0, n3, n4, SwimapScrollBarUI.trackHorz.getImageObserver());
            }
            if (bl2) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setPaint(new GradientPaint(n, n2, pressedColors[0], n, n4, pressedColors[1]));
                graphics2D.fillRect(2, 2, n3 - 4, n4 - 4);
                this.drawBorder(graphics, new Rectangle(n, n2, n3, n4), (Color)UIManager.get("ScrollBar.thumbActiveHighlight"), (Color)UIManager.get("ScrollBar.thumbActiveDark"));
            } else if (bl3) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setPaint(new GradientPaint(n, n2, hoverColors[0], n, n4, hoverColors[1]));
                graphics2D.fillRect(2, 2, n3 - 4, n4 - 4);
                this.drawBorder(graphics, new Rectangle(n, n2, n3, n4), (Color)UIManager.get("ScrollBar.thumbActiveHighlight"), (Color)UIManager.get("ScrollBar.thumbActiveDark"));
            } else {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setPaint(new GradientPaint(n, n2, normalColors[0], n, n4, normalColors[1]));
                graphics2D.fillRect(2, 2, n3 - 4, n4 - 4);
                this.drawBorder(graphics, new Rectangle(n, n2, n3, n4), (Color)UIManager.get("ScrollBar.thumbNormalHighlight"), (Color)UIManager.get("ScrollBar.thumbNormalDark"));
            }
        } else {
            if (this.getDirection() == 1 || this.getDirection() == 5) {
                graphics.drawImage(SwimapScrollBarUI.disableTrackVert.getImage(), 0, 0, n3, n4, SwimapScrollBarUI.disableTrackVert.getImageObserver());
            } else {
                graphics.drawImage(SwimapScrollBarUI.disableTrackHorz.getImage(), 0, 0, n3, n4, SwimapScrollBarUI.disableTrackHorz.getImageObserver());
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(new GradientPaint(n, n2, disableColors[0], n, n4, disableColors[1]));
            graphics2D.fillRect(2, 2, n3 - 4, n4 - 4);
            this.drawBorder(graphics, new Rectangle(n, n2, n3, n4), (Color)UIManager.get("ScrollBar.thumbDisableHighlight"), (Color)UIManager.get("ScrollBar.thumbDisableDark"));
        }
        this.drawArrow(graphics, new Rectangle(n, n2, n3, n4), this.getDirection(), bl);
        graphics.setColor(color);
    }

    private void drawBorder(Graphics graphics, Rectangle rectangle, Color color, Color color2) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        graphics.setColor(color);
        graphics.drawLine(n + 2, n2, n + n3 - 3, n2);
        graphics.drawLine(n + 2, n2 + n4 - 1, n + n3 - 3, n2 + n4 - 1);
        graphics.drawLine(n, n2 + 2, n, n2 + n4 - 3);
        graphics.drawLine(n + n3 - 1, n2 + 2, n + n3 - 1, n2 + n4 - 3);
        graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
        graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + 1);
        graphics.drawLine(n + 1, n2 + n4 - 2, n + 1, n2 + n4 - 2);
        graphics.drawLine(n + n3 - 2, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
        graphics.setColor(color2);
        graphics.drawLine(n + 2, n2 + 1, n + n3 - 3, n2 + 1);
        graphics.drawLine(n + 2, n2 + n4 - 2, n + n3 - 3, n2 + n4 - 2);
        graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + n4 - 3);
        graphics.drawLine(n + n3 - 2, n2 + 2, n + n3 - 2, n2 + n4 - 3);
    }

    private void drawArrow(Graphics graphics, Rectangle rectangle, int n, boolean bl) {
        Color color = graphics.getColor();
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        if (bl) {
            graphics.setColor((Color)UIManager.get("ScrollBar.arrowEnableColor"));
        } else {
            graphics.setColor((Color)UIManager.get("ScrollBar.arrowEnableColor"));
        }
        if (n == 1) {
            int n4 = rectangle.x + n2 / 2;
            int n5 = rectangle.x + n3 / 3;
            for (int i = 0; i < 3; ++i) {
                graphics.drawLine(n4, n5 + i, n4 - n2 / 4, n5 + n2 / 4 + i);
                graphics.drawLine(n4, n5 + i, n4 + n2 / 4, n5 + n2 / 4 + i);
            }
        } else if (n == 5) {
            int n6 = rectangle.x + n2 / 2;
            int n7 = rectangle.x + n3 * 2 / 3;
            for (int i = 0; i < 3; ++i) {
                graphics.drawLine(n6, n7 - i, n6 - n2 / 4, n7 - n2 / 4 - i);
                graphics.drawLine(n6, n7 - i, n6 + n2 / 4, n7 - n2 / 4 - i);
            }
        } else if (n == 3) {
            int n8 = rectangle.x + n2 * 2 / 3;
            int n9 = rectangle.x + n3 / 2;
            for (int i = 0; i < 3; ++i) {
                graphics.drawLine(n8 - i, n9, n8 - n3 / 4 - i, n9 - n3 / 4);
                graphics.drawLine(n8 - i, n9, n8 - n3 / 4 - i, n9 + n3 / 4);
            }
        } else if (n == 7) {
            int n10 = rectangle.x + n2 / 3;
            int n11 = rectangle.x + n3 / 2;
            for (int i = 0; i < 3; ++i) {
                graphics.drawLine(n10 + i, n11, n10 + n2 / 4 + i, n11 - n2 / 4);
                graphics.drawLine(n10 + i, n11, n10 + n2 / 4 + i, n11 + n2 / 4);
            }
        }
        graphics.setColor(color);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getDirection() == 1 || this.getDirection() == 5 || this.getDirection() == 3 || this.getDirection() == 7) {
            return new Dimension(this.buttonWidth, this.buttonWidth);
        }
        return new Dimension(0, 0);
    }
}

