/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel.scrollbar;

import com.swimap.iview.framework.lookandfeel.scrollbar.SwimapScrollButton;
import com.swimap.iview.framework.lookandfeel.skin.SkinManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class SwimapScrollBarUI
extends BasicScrollBarUI {
    private static final ImageIcon thumbSignHorz = SkinManager.getInstance().getSkinImage("scrollbar", "thumbSignHorz.png", SwimapScrollBarUI.class);
    private static final ImageIcon thumbSignVert = SkinManager.getInstance().getSkinImage("scrollbar", "thumbSignVert.png", SwimapScrollBarUI.class);
    private static final ImageIcon pressThumbHorz = SkinManager.getInstance().getSkinImage("scrollbar", "pressThumbHorz.png", SwimapScrollBarUI.class);
    private static final ImageIcon normalThumbHorz = SkinManager.getInstance().getSkinImage("scrollbar", "normalThumbHorz.png", SwimapScrollBarUI.class);
    private static final ImageIcon hoverThumbHorz = SkinManager.getInstance().getSkinImage("scrollbar", "hoverThumbHorz.png", SwimapScrollBarUI.class);
    private static final ImageIcon pressThumbVert = SkinManager.getInstance().getSkinImage("scrollbar", "pressThumbVert.png", SwimapScrollBarUI.class);
    private static final ImageIcon normalThumbVert = SkinManager.getInstance().getSkinImage("scrollbar", "normalThumbVert.png", SwimapScrollBarUI.class);
    private static final ImageIcon hoverThumbVert = SkinManager.getInstance().getSkinImage("scrollbar", "hoverThumbVert.png", SwimapScrollBarUI.class);
    static final ImageIcon trackVert = SkinManager.getInstance().getSkinImage("scrollbar", "trackVert.png", SwimapScrollBarUI.class);
    static final ImageIcon disableTrackVert = SkinManager.getInstance().getSkinImage("scrollbar", "trackVertDis.png", SwimapScrollBarUI.class);
    static final ImageIcon trackHorz = SkinManager.getInstance().getSkinImage("scrollbar", "trackHorz.png", SwimapScrollBarUI.class);
    static final ImageIcon disableTrackHorz = SkinManager.getInstance().getSkinImage("scrollbar", "trackHorzDis.png", SwimapScrollBarUI.class);
    private ImageIcon thumVertIcon = normalThumbVert;
    private ImageIcon thumHorzIcon = normalThumbHorz;
    private boolean isDragged = false;
    private Color thumBorderOutColor = UIManager.getColor("ScrollBar.thumbNormalHighlight");
    private Color thumBorderInnerColor = UIManager.getColor("ScrollBar.thumbNormalDark");
    private int scrollBarWidth;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SwimapScrollBarUI();
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new IviewTrackListener();
    }

    @Override
    protected JButton createDecreaseButton(int n) {
        return new SwimapScrollButton(n, this.scrollBarWidth);
    }

    @Override
    protected JButton createIncreaseButton(int n) {
        return new SwimapScrollButton(n, this.scrollBarWidth);
    }

    @Override
    protected void installDefaults() {
        this.scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
        super.installDefaults();
    }

    @Override
    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        Color color = this.thumBorderOutColor;
        Color color2 = this.thumBorderInnerColor;
        ImageIcon imageIcon = this.thumVertIcon;
        ImageIcon imageIcon2 = this.thumHorzIcon;
        ImageIcon imageIcon3 = thumbSignVert;
        ImageIcon imageIcon4 = thumbSignHorz;
        if (!jComponent.isEnabled()) {
            super.paintThumb(graphics, jComponent, rectangle);
            return;
        }
        if (this.scrollbar.getOrientation() == 1) {
            this.drawBorder(graphics, new Rectangle(n, n2, n3, n4), color, color2);
            graphics.drawImage(imageIcon.getImage(), n + 2, n2 + 2, n3 - 4, n4 - 4, imageIcon.getImageObserver());
            graphics.drawImage(imageIcon3.getImage(), (n3 - imageIcon3.getIconWidth()) / 2 + n, (n4 - imageIcon3.getIconHeight()) / 2 + n2, imageIcon3.getImageObserver());
        } else {
            this.drawBorder(graphics, new Rectangle(n, n2, n3, n4), color, color2);
            graphics.drawImage(imageIcon2.getImage(), n + 2, n2 + 2, n3 - 4, n4 - 4, imageIcon2.getImageObserver());
            graphics.drawImage(imageIcon4.getImage(), (n3 - imageIcon4.getIconWidth()) / 2 + n, (n4 - imageIcon4.getIconHeight()) / 2 + n2, imageIcon4.getImageObserver());
        }
    }

    @Override
    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (this.scrollbar.getOrientation() == 1) {
            if (jComponent.isEnabled()) {
                graphics.setColor(UIManager.getColor("ScrollBar.darkShadow"));
                graphics.drawRect(n, n2, n3, n4);
                graphics.drawImage(trackVert.getImage(), n + 1, n2, n3 - 1, n4, trackVert.getImageObserver());
            } else {
                graphics.setColor(UIManager.getColor("ScrollBar.darkShadow"));
                graphics.drawRect(n, n2, n3, n4);
                graphics.drawImage(disableTrackVert.getImage(), n + 1, n2, n3 - 1, n4, trackVert.getImageObserver());
            }
        } else if (jComponent.isEnabled()) {
            graphics.setColor(UIManager.getColor("ScrollBar.darkShadow"));
            graphics.drawRect(n, n2, n3, n4);
            graphics.drawImage(trackHorz.getImage(), n, n2 + 1, n3, n4 - 1, trackHorz.getImageObserver());
        } else {
            graphics.setColor(UIManager.getColor("ScrollBar.darkShadow"));
            graphics.drawRect(n, n2, n3, n4);
            graphics.drawImage(disableTrackHorz.getImage(), n, n2 + 1, n3, n4 - 1, trackHorz.getImageObserver());
        }
    }

    private void drawBorder(Graphics graphics, Rectangle rectangle, Color color, Color color2) {
        Color color3 = graphics.getColor();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        graphics.setColor(color);
        graphics.drawLine(n + 2, n2, n + n3 - 3, n2);
        graphics.drawLine(n + 2, n2 + n4 - 1, n + n3 - 3, n2 + n4 - 1);
        graphics.drawLine(n, n2 + 2, n, n2 + n4 - 3);
        graphics.drawLine(n + n3 - 1, n2 + 2, n + n3 - 1, n2 + n4 - 3);
        graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
        graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + 1);
        graphics.drawLine(n + 1, n2 + n4 - 2, n + 1, n2 + n4 - 2);
        graphics.drawLine(n + n3 - 2, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
        graphics.setColor(color2);
        graphics.drawLine(n + 2, n2 + 1, n + n3 - 3, n2 + 1);
        graphics.drawLine(n + 2, n2 + n4 - 2, n + n3 - 3, n2 + n4 - 2);
        graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + n4 - 3);
        graphics.drawLine(n + n3 - 2, n2 + 2, n + n3 - 2, n2 + n4 - 3);
        graphics.setColor(color3);
    }

    private void progressMouseEnteredThumb(MouseEvent mouseEvent) {
        if (this.isDragged) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent) || SwingUtilities.isRightMouseButton(mouseEvent) || SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.getThumbBounds().contains(n, n2)) {
            this.thumBorderOutColor = UIManager.getColor("ScrollBar.thumbActiveHighlight");
            this.thumBorderInnerColor = UIManager.getColor("ScrollBar.thumbActiveDark");
            if (this.scrollbar.getOrientation() == 1) {
                this.thumVertIcon = hoverThumbVert;
            } else {
                this.thumHorzIcon = hoverThumbHorz;
            }
            this.scrollbar.repaint();
        }
    }

    private void progressMouseExitedThumb(MouseEvent mouseEvent) {
        if (this.isDragged) {
            return;
        }
        this.thumBorderOutColor = (Color)UIManager.get("ScrollBar.thumbNormalHighlight");
        this.thumBorderInnerColor = (Color)UIManager.get("ScrollBar.thumbNormalDark");
        this.thumHorzIcon = normalThumbHorz;
        this.thumVertIcon = normalThumbVert;
        this.scrollbar.repaint();
    }

    private void progressMouseMovedThumb(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (!this.getTrackBounds().contains(n, n2)) {
            return;
        }
        if (this.getThumbBounds().contains(n, n2)) {
            if (this.scrollbar.getOrientation() == 1) {
                this.thumVertIcon = hoverThumbVert;
            } else {
                this.thumHorzIcon = hoverThumbHorz;
            }
        } else if (this.scrollbar.getOrientation() == 1) {
            this.thumVertIcon = normalThumbVert;
        } else {
            this.thumHorzIcon = normalThumbHorz;
        }
        this.scrollbar.repaint();
    }

    private void progressMousePressedThumb(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.getThumbBounds().contains(n, n2) && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (this.scrollbar.getOrientation() == 1) {
                this.thumVertIcon = pressThumbVert;
            } else {
                this.thumHorzIcon = pressThumbHorz;
            }
            this.scrollbar.repaint();
        }
    }

    private void progressMouseReleasedThumb(MouseEvent mouseEvent) {
        this.isDragged = false;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.getThumbBounds().contains(n, n2)) {
            this.thumBorderOutColor = (Color)UIManager.get("ScrollBar.thumbActiveHighlight");
            this.thumBorderInnerColor = (Color)UIManager.get("ScrollBar.thumbActiveDark");
            if (this.scrollbar.getOrientation() == 1) {
                this.thumVertIcon = hoverThumbVert;
            } else {
                this.thumHorzIcon = hoverThumbHorz;
            }
        } else {
            this.thumBorderOutColor = (Color)UIManager.get("ScrollBar.thumbNormalHighlight");
            this.thumBorderInnerColor = (Color)UIManager.get("ScrollBar.thumbNormalDark");
            this.thumHorzIcon = normalThumbHorz;
            this.thumVertIcon = normalThumbVert;
        }
        this.scrollbar.repaint();
    }

    private void progressMouseDraggedThumb(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.getThumbBounds().contains(n, n2) && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.isDragged = true;
            if (this.scrollbar.getOrientation() == 1) {
                this.thumVertIcon = pressThumbVert;
            } else {
                this.thumHorzIcon = pressThumbHorz;
            }
            this.scrollbar.repaint();
        }
    }

    private class IviewTrackListener
    extends BasicScrollBarUI.TrackListener {
        private IviewTrackListener() {
            super(SwimapScrollBarUI.this);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            SwimapScrollBarUI.this.progressMouseEnteredThumb(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            SwimapScrollBarUI.this.progressMouseExitedThumb(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            SwimapScrollBarUI.this.progressMouseMovedThumb(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            SwimapScrollBarUI.this.progressMousePressedThumb(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            SwimapScrollBarUI.this.progressMouseReleasedThumb(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDragged(mouseEvent);
            SwimapScrollBarUI.this.progressMouseDraggedThumb(mouseEvent);
        }
    }
}

