/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel.button;

import com.swimap.iview.framework.lookandfeel.button.SwimapButtonListener;
import com.swimap.iview.framework.lookandfeel.button.SwimapButtonUI;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalToggleButtonUI;
import javax.swing.text.View;

public class SwimapToggleButtonUI
extends MetalToggleButtonUI {
    private static final SwimapToggleButtonUI swimapToggleButtonUI = new SwimapToggleButtonUI();

    public static ComponentUI createUI(JComponent jComponent) {
        return swimapToggleButtonUI;
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new SwimapButtonListener(abstractButton);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Object object;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Dimension dimension = abstractButton.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle(dimension);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.right + rectangle.x;
        rectangle.height -= insets.bottom + rectangle.y;
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        graphics.setColor(abstractButton.getBackground());
        if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
            this.paintButtonPressed(graphics, abstractButton);
        } else if (abstractButton.isOpaque()) {
            object = abstractButton.getInsets();
            Insets insets2 = abstractButton.getMargin();
            ImageIcon imageIcon = abstractButton.getModel().isEnabled() ? SwimapButtonUI.BACKGROUND_ICON : SwimapButtonUI.DISABLE_BACKGROUND_ICON;
            Boolean bl = (Boolean)abstractButton.getClientProperty("background");
            if (imageIcon != null && (bl == null || !bl.booleanValue() || abstractButton.getBackground() == UIManager.getColor("Button.background") && bl.booleanValue())) {
                graphics.drawImage(imageIcon.getImage(), ((Insets)object).left - insets2.left, ((Insets)object).top - insets2.top, dimension.width - (((Insets)object).left - insets2.left) - (((Insets)object).right - insets2.right), dimension.height - (((Insets)object).top - insets2.top) - (((Insets)object).bottom - insets2.bottom), imageIcon.getImageObserver());
            }
        }
        if (abstractButton.getIcon() != null) {
            this.paintIcon(graphics, abstractButton, rectangle2);
        }
        if (string != null && !"".equals(string)) {
            object = (View)jComponent.getClientProperty("html");
            if (object != null) {
                ((View)object).paint(graphics, rectangle3);
            } else {
                this.paintText(graphics, (JComponent)abstractButton, rectangle3, string);
            }
        }
        if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
            this.paintFocus(graphics, abstractButton, rectangle, rectangle3, rectangle2);
        }
    }

    @Override
    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
    }
}

