/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel.button;

import com.swimap.iview.framework.lookandfeel.button.SwimapButtonListener;
import com.swimap.iview.framework.lookandfeel.skin.SkinManager;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalButtonUI;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.text.View;

public class SwimapButtonUI
extends MetalButtonUI {
    private static final SwimapButtonUI swimapButtonUI = new SwimapButtonUI();
    static final ImageIcon BACKGROUND_ICON = SkinManager.getInstance().getSkinImage("button", "button_normal.gif", SwimapButtonUI.class);
    static final ImageIcon DISABLE_BACKGROUND_ICON = SkinManager.getInstance().getSkinImage("button", "button_disabled.gif", SwimapButtonUI.class);
    static final ImageIcon PRESSED_BACKGROUND_ICON = SkinManager.getInstance().getSkinImage("button", "button_pressed.gif", SwimapButtonUI.class);

    public static ComponentUI createUI(JComponent jComponent) {
        return swimapButtonUI;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        ImageIcon imageIcon;
        if (jComponent instanceof MetalComboBoxButton) {
            super.paint(graphics, jComponent);
            return;
        }
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle3 = new Rectangle();
        AbstractButton abstractButton = (AbstractButton)jComponent;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        rectangle3.x = insets.left;
        rectangle3.y = insets.top;
        rectangle3.width = abstractButton.getWidth() - (insets.right + rectangle3.x);
        rectangle3.height = abstractButton.getHeight() - (insets.bottom + rectangle3.y);
        Font font = jComponent.getFont();
        graphics.setFont(font);
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle3, rectangle2, rectangle, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        this.clearTextShiftOffset();
        ImageIcon imageIcon2 = imageIcon = abstractButton.getModel().isEnabled() ? BACKGROUND_ICON : DISABLE_BACKGROUND_ICON;
        if (abstractButton.getModel().isPressed()) {
            imageIcon = PRESSED_BACKGROUND_ICON;
        }
        Boolean bl = (Boolean)abstractButton.getClientProperty("background");
        if (imageIcon != null && (bl == null || !bl.booleanValue() || abstractButton.getBackground() == UIManager.getColor("Button.background") && bl.booleanValue())) {
            this.paintIconOnButton(graphics, abstractButton, imageIcon);
        }
        if (abstractButton.getIcon() != null) {
            this.paintIcon(graphics, jComponent, rectangle2);
        }
        if (string != null && !"".equals(string)) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, rectangle);
            } else {
                this.paintText(graphics, (JComponent)abstractButton, rectangle, string);
            }
        }
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new SwimapButtonListener(abstractButton);
    }

    @Override
    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
    }

    private void paintIconOnButton(Graphics graphics, AbstractButton abstractButton, ImageIcon imageIcon) {
        if (graphics != null && imageIcon != null) {
            graphics.drawImage(imageIcon.getImage(), 0, 0, abstractButton.getWidth(), abstractButton.getHeight(), imageIcon.getImageObserver());
        }
    }
}

