/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel.button;

import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicButtonListener;

public class SwimapButtonListener
extends BasicButtonListener {
    private static final String PROPERTY_ANCESTOR = "ancestor";
    public static final String PROPERTY_BACKGROUND = "background";
    private static AbstractButton currentButton = null;
    private static AWTEvent lastMoveEvent = null;

    public SwimapButtonListener(AbstractButton abstractButton) {
        super(abstractButton);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        Rectangle rectangle = abstractButton.getBounds();
        if (rectangle.contains(rectangle.x + mouseEvent.getPoint().x, rectangle.y + mouseEvent.getPoint().y)) {
            abstractButton.getModel().setRollover(true);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        AbstractButton abstractButton;
        currentButton = abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        if (!(SwingUtilities.isLeftMouseButton(mouseEvent) || SwingUtilities.isRightMouseButton(mouseEvent) || SwingUtilities.isMiddleMouseButton(mouseEvent))) {
            buttonModel.setRollover(true);
        }
        if (buttonModel.isPressed()) {
            buttonModel.setArmed(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        currentButton = null;
        lastMoveEvent = null;
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        buttonModel.setRollover(false);
        buttonModel.setArmed(false);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        JButton jButton;
        currentButton = null;
        AbstractButton abstractButton = (AbstractButton)focusEvent.getSource();
        JRootPane jRootPane = abstractButton.getRootPane();
        if (jRootPane != null && abstractButton != (jButton = (JButton)jRootPane.getClientProperty("initialDefaultButton"))) {
            jRootPane.setDefaultButton(jButton);
        }
        abstractButton.getModel().setArmed(false);
        abstractButton.getModel().setRollover(false);
        abstractButton.repaint();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        JRootPane jRootPane;
        AbstractButton abstractButton = (AbstractButton)focusEvent.getSource();
        if (abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultCapable() && (jRootPane = abstractButton.getRootPane()) != null) {
            jRootPane.putClientProperty("temporaryDefaultButton", abstractButton);
            jRootPane.setDefaultButton((JButton)abstractButton);
            jRootPane.putClientProperty("temporaryDefaultButton", null);
        }
        abstractButton.getModel().setArmed(true);
        abstractButton.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (propertyChangeEvent.getSource() instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)propertyChangeEvent.getSource();
            if (string != null && string.equals(PROPERTY_ANCESTOR)) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setRollover(false);
                buttonModel.setArmed(false);
                Object object = abstractButton.getClientProperty("BorderlessButton");
                if (null != object) {
                    abstractButton.setBorderPainted(false);
                }
            } else if (string != null && string.equals(PROPERTY_BACKGROUND)) {
                abstractButton.putClientProperty(PROPERTY_BACKGROUND, Boolean.TRUE);
            }
        }
    }

    public static void setCurrentButton(AbstractButton abstractButton) {
        currentButton = abstractButton;
    }

    public static AbstractButton getCurrentButton() {
        return currentButton;
    }

    public static void setLastMoveEvent(AWTEvent aWTEvent) {
        lastMoveEvent = aWTEvent;
    }

    public static AWTEvent getLastMoveEvent() {
        return lastMoveEvent;
    }
}

