/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel.button;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalComboBoxButton;

public class SwimapButtonBorder
extends MetalBorders.ButtonBorder {
    private static final Color BORDER_LIGHT_COLOR = new Color(192, 192, 192);
    private static final Color BORDER_DARK_COLOR = new Color(77, 77, 77);
    private static final Color DISABLE_BORDER_DARK_COLOR = new Color(134, 134, 134);
    private static final Color HOVER_LIGHT_COLOR = new Color(255, 204, 153);
    private static final Color HOVER_DARK_COLOR = new Color(204, 153, 51);
    private static final Color FOCUSED_LIGHT_COLOR = new Color(153, 204, 255);
    private static final Color FOCUSED_DARK_COLOR = new Color(51, 153, 204);
    private static final Color PRESSED_LIGHT_COLOR = new Color(166, 202, 240);
    private static final Color PRESSED_DARK_COLOR = new Color(77, 77, 77);
    private static final int LINE_WIDTH = 1;
    private static final int MINI_BUTTON_WIDTH = 15;
    private static final int MINI_BUTTON_HIGHT = 15;

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (component instanceof MetalComboBoxButton) {
            super.paintBorder(component, graphics, n, n2, n3, n4);
            return;
        }
        AbstractButton abstractButton = (AbstractButton)component;
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isEnabled()) {
            if (n3 < 15 || n4 < 15) {
                this.drawSmallBorderColor(graphics, abstractButton, BORDER_LIGHT_COLOR, BORDER_DARK_COLOR);
            } else {
                this.drawBorderColor(graphics, abstractButton, BORDER_LIGHT_COLOR, BORDER_DARK_COLOR);
            }
            this.paintStateBorder(graphics, (JComponent)component);
        } else if (n3 < 15 || n4 < 15) {
            this.drawSmallBorderColor(graphics, abstractButton, BORDER_LIGHT_COLOR, DISABLE_BORDER_DARK_COLOR);
        } else {
            this.drawBorderColor(graphics, abstractButton, BORDER_LIGHT_COLOR, DISABLE_BORDER_DARK_COLOR);
        }
    }

    private void drawSmallBorderColor(Graphics graphics, AbstractButton abstractButton, Color color, Color color2) {
        int n = 0;
        int n2 = 0;
        int n3 = abstractButton.getWidth();
        int n4 = abstractButton.getHeight();
        graphics.setColor(color);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
        graphics.drawLine(n + n3 - 1 - 1, n2 + 1, n + n3 - 1 - 1, n2 + 1);
        graphics.drawLine(n + 1, n2 + n4 - 1 - 1, n + 1, n2 + n4 - 1 - 1);
        graphics.drawLine(n + n3 - 1 - 1, n2 + n4 - 1 - 1, n + n3 - 1 - 1, n2 + n4 - 1 - 1);
        graphics.setColor(color2);
        graphics.drawLine(n + 1, n2, n + n3 - 1 - 1, n2);
        graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1 - 1, n2 + n4 - 1);
        graphics.drawLine(n, n2 + 1, n, n2 + n4 - 1 - 1);
        graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1 - 1);
    }

    private void drawBorderColor(Graphics graphics, AbstractButton abstractButton, Color color, Color color2) {
        int n = 0;
        int n2 = 0;
        int n3 = abstractButton.getWidth();
        int n4 = abstractButton.getHeight();
        graphics.setColor(color);
        graphics.drawLine(n + 1, n2, n + n3 - 1 - 1, n2);
        graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1 - 1, n2 + n4 - 1);
        graphics.drawLine(n, n2 + 1, n, n2 + n4 - 1 - 1);
        graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1 - 1);
        graphics.setColor(color2);
        graphics.drawLine(n + 2, n2, n + n3 - 2 - 1, n2);
        graphics.drawLine(n + 2, n2 + n4 - 1, n + n3 - 2 - 1, n2 + n4 - 1);
        graphics.drawLine(n, n2 + 2, n, n2 + n4 - 2 - 1);
        graphics.drawLine(n + n3 - 1, n2 + 2, n + n3 - 1, n2 + n4 - 2 - 1);
        graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
        graphics.drawLine(n + n3 - 1 - 1, n2 + 1, n + n3 - 1 - 1, n2 + 1);
        graphics.drawLine(n + 1, n2 + n4 - 1 - 1, n + 1, n2 + n4 - 1 - 1);
        graphics.drawLine(n + n3 - 1 - 1, n2 + n4 - 1 - 1, n + n3 - 1 - 1, n2 + n4 - 1 - 1);
    }

    private void drawStateColor(Graphics graphics, JComponent jComponent, Color color, Color color2) {
        int n = 0;
        int n2 = 0;
        int n3 = jComponent.getWidth();
        int n4 = jComponent.getHeight();
        graphics.setColor(color);
        if (n3 < 15 || n4 < 15) {
            graphics.drawRect(n + 1, n2 + 1, n3 - 2 - 1, n4 - 2 - 1);
        } else {
            graphics.drawLine(n + 2, n2 + 1, n + n3 - 2 - 1, n2 + 1);
            graphics.drawLine(n + 2, n2 + n4 - 1 - 1, n + n3 - 2 - 1, n2 + n4 - 1 - 1);
            graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + n4 - 2 - 1);
            graphics.drawLine(n + n3 - 1 - 1, n2 + 2, n + n3 - 1 - 1, n2 + n4 - 2 - 1);
        }
        graphics.setColor(color2);
        graphics.drawRect(n + 2, n2 + 2, n3 - 4 - 1, n4 - 4 - 1);
    }

    private void paintStateBorder(Graphics graphics, JComponent jComponent) {
        if (jComponent instanceof MetalComboBoxButton) {
            return;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Color color = null;
        Color color2 = null;
        ButtonModel buttonModel = abstractButton.getModel();
        if (!buttonModel.isEnabled()) {
            color = null;
            color2 = null;
        } else if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
            color = PRESSED_DARK_COLOR;
            color2 = PRESSED_LIGHT_COLOR;
        } else if (buttonModel.isRollover()) {
            if (buttonModel.isSelected()) {
                color = FOCUSED_DARK_COLOR;
                color2 = FOCUSED_LIGHT_COLOR;
            } else {
                color = HOVER_DARK_COLOR;
                color2 = HOVER_LIGHT_COLOR;
            }
        } else if (abstractButton.isFocusOwner()) {
            color = FOCUSED_DARK_COLOR;
            color2 = FOCUSED_LIGHT_COLOR;
        } else {
            color = null;
            color2 = null;
        }
        if (color != null && color2 != null) {
            this.drawStateColor(graphics, jComponent, color, color2);
        }
    }
}

