/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel;

import com.swimap.iview.framework.lookandfeel.StyleFactory;
import com.swimap.iview.framework.lookandfeel.SwimapInternalFrameBorder;
import com.swimap.iview.framework.lookandfeel.SwimapStyleFactory;
import com.swimap.iview.framework.lookandfeel.SwimapTheme;
import com.swimap.iview.framework.lookandfeel.UIStyleManager;
import com.swimap.iview.framework.lookandfeel.button.SwimapButtonBorder;
import com.swimap.iview.framework.lookandfeel.skin.SkinColors;
import com.swimap.iview.framework.lookandfeel.skin.SkinManager;
import com.swimap.iview.util.adapter.ResourceMngHelper;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class UIStyleTool {
    private static IviewLogger logger = IviewLogger.getLogger(UIStyleTool.class, "IVIEW");
    private static final String METAL_CLASS_NAME = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static boolean isWindows = true;
    private static final int DEFAULT_FONT_SIZE_WIN = 12;
    private static int winFontSize = 12;
    private static final int DEFAULT_FONT_SIZE_UNIX = 12;
    private static int unixFontSize = 12;
    private static final String DEFAULT_FONT = "Dialog";
    private static String fontName = "Dialog";
    private static final int DEFAULT_ICON_WIDTH = 16;
    private static final int DEFAULT_ICON_HEIGHT = 14;
    private static StyleFactory styleFactory = null;
    private static Color mAIN_BACKGROUD_COLOR = new Color(239, 239, 239);
    private static Color dESKTOP_COLOR = new Color(224, 224, 224);
    private static Color tOOLBAR_BACKGROUND = new Color(239, 239, 239);
    public static Color HYPERLINK_COLOR = new Color(0, 102, 153);
    private static Color sELECTED_BACKGROUND = new Color(0, 102, 153);
    private static Color eDIT_BACKGROUND = Color.white;
    private static Color tREE_BACKGROUND = Color.white;
    private static Color TREE_TEXT_BACKGROUND = Color.white;
    public static Color BORDER_COLOR = new Color(119, 119, 119);
    private static Color tABLE_HEADER_BACKGROUND = new Color(239, 239, 239);
    private static Color dISABLED_BACKGROUND = new Color(252, 251, 253);
    private static final Color DISABLED_TEXT_BACKGROUND = new Color(239, 239, 239);
    private static Color dISABLED_FOREGROUND = new Color(92, 92, 92);
    private static final int MIN_UNIX_FONTSIZE = 11;
    private static final int MAX_UNIX_FONTSIZE = 20;
    private static final int MIN_WINDOWS_FONTSIZE = 10;
    private static final int MAX_WINDOWS_FONTSIZE = 20;
    private static final int MENUARROW_ICON_WIDTH = 11;
    private static final int MENUARROW_ICON_HEIGHT = 10;
    private static final int MENU_ARROW_POSS = 7;
    private static final int MENU_ARROW_POSS_ONE = 8;
    private static final int MENU_ARROW_POSS_TWO = 9;
    private static final int MENU_ARROW_POSS_THR = 3;
    private static final int MENU_ARROW_POSS_FOUR = 4;
    private static final int MENU_ARROW_POSS_FIVE = 11;
    private static final int MENU_ARROW_POSS_SIX = 10;
    private static final int MENU_ARROW_POSS_SEV = 6;
    private static final int MENU_ARROW_POSS_EIG = 5;
    private static ResourceBundle res = ResourceMngHelper.getResourceBundleFromPropertyFile("mainfrm/iview/framework/lookandfeel/Res");
    private static int portalArrowInsets = 6;

    public static void setPortalArrowInsets(int n) {
        portalArrowInsets = n;
    }

    private static void loadSkinUIColors(SkinColors skinColors) {
        HashMap<String, Color> hashMap = skinColors.getPreDefinedColors();
        if (hashMap.size() == 0) {
            return;
        }
        mAIN_BACKGROUD_COLOR = UIStyleTool.getColors(mAIN_BACKGROUD_COLOR, "MAIN_BACKGROUD_COLOR", hashMap);
        tOOLBAR_BACKGROUND = UIStyleTool.getColors(tOOLBAR_BACKGROUND, "TOOLBAR_BACKGROUND", hashMap);
        dESKTOP_COLOR = UIStyleTool.getColors(dESKTOP_COLOR, "DESKTOP_COLOR", hashMap);
        HYPERLINK_COLOR = UIStyleTool.getColors(HYPERLINK_COLOR, "HYPERLINK_COLOR", hashMap);
        sELECTED_BACKGROUND = UIStyleTool.getColors(sELECTED_BACKGROUND, "SELECTED_BACKGROUND", hashMap);
        eDIT_BACKGROUND = UIStyleTool.getColors(eDIT_BACKGROUND, "EDIT_BACKGROUND", hashMap);
        BORDER_COLOR = UIStyleTool.getColors(BORDER_COLOR, "BORDER_COLOR", hashMap);
        tABLE_HEADER_BACKGROUND = UIStyleTool.getColors(tABLE_HEADER_BACKGROUND, "TABLE_HEADER_BACKGROUND", hashMap);
        dISABLED_BACKGROUND = UIStyleTool.getColors(dISABLED_BACKGROUND, "DISABLED_BACKGROUND", hashMap);
        dISABLED_FOREGROUND = UIStyleTool.getColors(dISABLED_FOREGROUND, "DISABLED_FOREGROUND", hashMap);
        tREE_BACKGROUND = UIStyleTool.getColors(tREE_BACKGROUND, "TREE_BACKGROUND", hashMap);
        TREE_TEXT_BACKGROUND = UIStyleTool.getColors(TREE_TEXT_BACKGROUND, "TREE_TEXT_BACKGROUND", hashMap);
    }

    private static Color getColors(Color color, String string, HashMap<String, Color> hashMap) {
        Color color2 = hashMap.get(string);
        if (null == color2) {
            return color;
        }
        return color2;
    }

    public static void setFontName(String string) {
        if (string != null) {
            if (!string.equals(fontName)) {
                fontName = string;
            }
        } else {
            logger.error("param font is null");
        }
    }

    public static void setUnixFontSize(int n) {
        if (n >= 11 && n <= 20) {
            unixFontSize = n;
        } else {
            logger.error("value is invalid, it should be between 12 and 20");
        }
    }

    public static void setWinFontSize(int n) {
        if (n >= 10 && n <= 20) {
            winFontSize = n;
        } else {
            logger.error("value is invalid, it should be between 12 and 20");
        }
    }

    public static void setSwimapStyle(JFrame jFrame) {
        UIStyleTool.setSwimapStyle();
        if (null != jFrame) {
            SwingUtilities.updateComponentTreeUI(jFrame);
        }
    }

    public static void setSwimapStyle() {
        try {
            MetalLookAndFeel.setCurrentTheme(new SwimapTheme());
            UIManager.setLookAndFeel(METAL_CLASS_NAME);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        UIStyleTool.installSwimapStyle();
    }

    private static void installSwimapStyle() {
        String string;
        String string2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
        UIStyleTool.installCommonStyle(hashMap);
        SkinColors skinColors = SkinManager.getInstance().getSelectedSkinSettings();
        UIStyleTool.loadSkinUIColors(skinColors);
        hashMap.put("TreeUI", "com.swimap.iview.framework.lookandfeel.SwimapMetalTreeUI");
        hashMap.put("ToolBarHandleUI", "com.swimap.iview.framework.lookandfeel.SwimapToolBarHandleUI");
        hashMap.put("FileChooser.cancelButtonText", res.getString("Cancel"));
        hashMap.put("OptionPane.cancelButtonText", res.getString("Cancel"));
        hashMap.put("ColorChooser.cancelText", res.getString("Cancel"));
        hashMap.put("FileChooser.fileDateHeaderText", res.getString("modifyTime"));
        hashMap.put("FileChooser.directoryOpenButtonText", res.getString("Open"));
        hashMap.put("FileChooser.openButtonText", res.getString("Open"));
        hashMap.put("FileChooser.saveButtonText", res.getString("Save"));
        hashMap.put("FileChooser.filesOfTypeLabelText", res.getString("FileType"));
        String string3 = res.getString("LookIn");
        if (null != string3 && !"".equals(string3)) {
            hashMap.put("FileChooser.lookInLabelText", string3);
        }
        if (null != (string2 = res.getString("SaveIn")) && !"".equals(string2)) {
            hashMap.put("FileChooser.saveInLabelText", string2);
        }
        if (null != (string = res.getString("FileName")) && !"".equals(string)) {
            hashMap.put("FileChooser.fileNameLabelText", string);
        }
        hashMap.put("desktop", dESKTOP_COLOR);
        Color color = eDIT_BACKGROUND;
        hashMap.put("window", color);
        hashMap.put("text", color);
        hashMap.put("hyperlinktext", HYPERLINK_COLOR);
        Color color2 = sELECTED_BACKGROUND;
        hashMap.put("textHighlight", color2);
        Color color3 = new Color(255, 255, 255);
        hashMap.put("textHighlightText", color3);
        Color color4 = mAIN_BACKGROUD_COLOR;
        hashMap.put("control", color4);
        Color color5 = new Color(255, 255, 255);
        hashMap.put("controlLtHighlight", color5);
        Color color6 = new Color(128, 128, 128);
        hashMap.put("controlShadow", color6);
        Color color7 = new Color(64, 64, 64);
        hashMap.put("controlDkShadow", color7);
        hashMap.put("scrollbar.thumb", color4);
        hashMap.put("tableGrid", BORDER_COLOR);
        Color color8 = new Color(169, 166, 169);
        hashMap.put("treeline", color8);
        hashMap.put("Button.background", mAIN_BACKGROUD_COLOR);
        hashMap.put("Button.disabledText", dISABLED_FOREGROUND);
        hashMap.put("Button.select", mAIN_BACKGROUD_COLOR);
        hashMap.put("Button.border", new BorderUIResource.CompoundBorderUIResource(new SwimapButtonBorder(), new BasicBorders.MarginBorder()));
        hashMap.put("ToolbarButton.background", tOOLBAR_BACKGROUND);
        hashMap.put("ToolbarButton.borderColor", new Color(130, 133, 171));
        hashMap.put("ToolbarButton.reoverBackground", new Color(211, 212, 223));
        hashMap.put("ToolbarButton.pressedBackground", new Color(188, 190, 212));
        hashMap.put("ToggleButton.background", tOOLBAR_BACKGROUND);
        hashMap.put("ToggleButtonUI", "com.swimap.iview.framework.lookandfeel.button.SwimapToggleButtonUI");
        hashMap.put("ToggleButton.border", new SwimapButtonBorder());
        hashMap.put("RadioButton.background", color4);
        hashMap.put("RadioButton.icon", new SwimapRadioButtonIcon());
        hashMap.put("CheckBox.background", color4);
        hashMap.put("CheckBox.icon", new SwimapCheckBoxIcon());
        hashMap.put("CheckBox.disabledText", dISABLED_FOREGROUND);
        hashMap.put("ComboBox.background", color);
        hashMap.put("ComboBox.listBackground", color);
        hashMap.put("ComboBox.selectionForeground", color3);
        hashMap.put("ComboBox.selectionBackground", color2);
        hashMap.put("ComboBox.disabledForeground", dISABLED_FOREGROUND);
        hashMap.put("Label.foreground", Color.black);
        hashMap.put("Label.background", color4);
        hashMap.put("Label.disabledForeground", dISABLED_FOREGROUND);
        hashMap.put("List.background", color);
        hashMap.put("List.selectionBackground", color2);
        hashMap.put("List.selectionForeground", color3);
        hashMap.put("MenuBar.background", color4);
        hashMap.put("RadioButtonMenuItem.background", color4);
        hashMap.put("RadioButtonMenuItem.acceleratorForeground", Color.black);
        hashMap.put("RadioButtonMenuItem.acceleratorSelectionForeground", color3);
        hashMap.put("RadioButtonMenuItem.selectionBackground", color2);
        hashMap.put("RadioButtonMenuItem.selectionForeground", color3);
        hashMap.put("CheckBoxMenuItem.background", color4);
        hashMap.put("CheckBoxMenuItem.acceleratorForeground", Color.black);
        hashMap.put("CheckBoxMenuItem.acceleratorSelectionForeground", color3);
        hashMap.put("CheckBoxMenuItem.selectionBackground", color2);
        hashMap.put("CheckBoxMenuItem.selectionForeground", color3);
        hashMap.put("Menu.background", color4);
        hashMap.put("Menu.selectionBackground", color2);
        hashMap.put("Menu.selectionForeground", color3);
        hashMap.put("Menu.acceleratorForeground", Color.black);
        hashMap.put("Menu.acceleratorSelectionForeground", color3);
        UIDefaults.ProxyLazyValue proxyLazyValue = new UIDefaults.ProxyLazyValue("javax.swing.plaf.basic.BasicIconFactory", "getMenuItemCheckIcon");
        hashMap.put("Menu.checkIcon", proxyLazyValue);
        hashMap.put("Menu.arrowIcon", new MenuArrowIcon());
        hashMap.put("MenuItem.background", color4);
        hashMap.put("MenuItem.acceleratorForeground", Color.black);
        hashMap.put("MenuItem.acceleratorSelectionForeground", color3);
        hashMap.put("MenuItem.selectionBackground", color2);
        hashMap.put("MenuItem.selectionForeground", color3);
        hashMap.put("MenuItem.checkIcon", proxyLazyValue);
        hashMap.put("PopupMenu.background", color4);
        hashMap.put("PopupMenu.selectionBackground", color2);
        hashMap.put("PopupMenu.selectionForeground", color3);
        hashMap.put("OptionPane.background", color4);
        hashMap.put("Panel.background", color4);
        hashMap.put("ProgressBar.foreground", color2);
        hashMap.put("ProgressBar.background", Color.white);
        hashMap.put("ProgressBar.backgroundHighlight", color2);
        hashMap.put("ProgressBar.selectionBackground", color2);
        hashMap.put("ProgressBar.selectionForeground", color3);
        hashMap.put("ScrollPane.background", color4);
        hashMap.put("ScrollBar.thumb", color4);
        hashMap.put("ScrollBar.thumbHighlight", new Color(157, 160, 176));
        hashMap.put("ScrollBar.thumbDarkShadow", new Color(64, 64, 64));
        hashMap.put("ScrollBar.thumbLightShadow", new Color(128, 128, 128));
        hashMap.put("ScrollBar.width", 15);
        hashMap.put("ScrollBar.minimumThumbSize", new Dimension(12, 12));
        hashMap.put("ScrollBar.thumbNormalHighlight", new Color(121, 124, 162));
        hashMap.put("ScrollBar.thumbNormalDark", new Color(231, 231, 249));
        hashMap.put("ScrollBar.thumbDisableHighlight", new Color(126, 126, 126));
        hashMap.put("ScrollBar.thumbDisableDark", new Color(232, 232, 232));
        hashMap.put("ScrollBar.thumbActiveHighlight", new Color(64, 67, 98));
        hashMap.put("ScrollBar.thumbActiveDark", new Color(255, 255, 255));
        hashMap.put("ScrollBar.arrowEnableColor", new Color(92, 95, 130));
        hashMap.put("Slider.background", color4);
        hashMap.put("SplitPane.background", color4);
        hashMap.put("SplitPane.highlight", mAIN_BACKGROUD_COLOR);
        hashMap.put("Viewport.background", color4);
        hashMap.put("TabbedPane.background", color4);
        hashMap.put("TabbedPane.selected", color4);
        hashMap.put("TabbedPane.highlight", color4);
        hashMap.put("TabbedPaneUI", "com.swimap.iview.framework.lookandfeel.TabbedPaneEclipseStyleUI");
        hashMap.put("ButtonUI", "com.swimap.iview.framework.lookandfeel.button.SwimapButtonUI");
        hashMap.put("ScrollBarUI", "com.swimap.iview.framework.lookandfeel.scrollbar.SwimapScrollBarUI");
        hashMap.put("TableUI", "com.swimap.iview.framework.lookandfeel.SwimapTableUI");
        hashMap.put("Table.background", color);
        hashMap.put("Table.gridColor", BORDER_COLOR);
        hashMap.put("Table.selectionBackground", color2);
        hashMap.put("Table.selectionForeground", color3);
        hashMap.put("TableHeader.background", tABLE_HEADER_BACKGROUND);
        hashMap.put("TextField.background", color);
        hashMap.put("TextField.selectionBackground", color2);
        hashMap.put("TextField.selectionForeground", color3);
        hashMap.put("TextField.inactiveForeground", dISABLED_FOREGROUND);
        hashMap.put("TextField.inactiveBackground", DISABLED_TEXT_BACKGROUND);
        hashMap.put("TextFieldUI", "com.swimap.iview.framework.lookandfeel.SwimapTextFieldUI");
        hashMap.put("PasswordField.background", color);
        hashMap.put("PasswordField.selectionBackground", color2);
        hashMap.put("PasswordField.selectionForeground", color3);
        hashMap.put("PasswordField.inactiveForeground", dISABLED_FOREGROUND);
        hashMap.put("PasswordField.inactiveBackground", dISABLED_BACKGROUND);
        hashMap.put("PasswordFieldUI", "com.swimap.iview.framework.lookandfeel.SwimapPasswordFieldUI");
        hashMap.put("TextArea.background", color);
        hashMap.put("TextArea.selectionBackground", color2);
        hashMap.put("TextArea.selectionForeground", color3);
        hashMap.put("TextArea.inactiveForeground", dISABLED_FOREGROUND);
        hashMap.put("TextArea.inactiveBackground", DISABLED_TEXT_BACKGROUND);
        hashMap.put("TextAreaUI", "com.swimap.iview.framework.lookandfeel.SwimapTextAreaUI");
        hashMap.put("TextPane.background", color);
        hashMap.put("TextPane.selectionBackground", color2);
        hashMap.put("TextPane.selectionForeground", color3);
        hashMap.put("TextPane.inactiveForeground", dISABLED_FOREGROUND);
        hashMap.put("TextPane.inactiveBackground", dISABLED_BACKGROUND);
        hashMap.put("TextPaneUI", "com.swimap.iview.framework.lookandfeel.SwimapTextPaneUI");
        hashMap.put("EditorPane.background", color);
        hashMap.put("EditorPane.selectionBackground", color2);
        hashMap.put("EditorPane.selectionForeground", color3);
        hashMap.put("EditorPane.inactiveForeground", dISABLED_FOREGROUND);
        hashMap.put("EditorPane.inactiveBackground", dISABLED_BACKGROUND);
        hashMap.put("EditorPaneUI", "com.swimap.iview.framework.lookandfeel.SwimapEditorPaneUI");
        hashMap.put("TitledBorder.titleColor", Color.black);
        hashMap.put("ToolBar.background", mAIN_BACKGROUD_COLOR);
        hashMap.put("ToolTip.background", color);
        hashMap.put("ToolTip.acceleratorForeground", Color.black);
        hashMap.put("ToolTipUI", "com.swimap.iview.framework.lookandfeel.SwimapToolTipUI");
        hashMap.put("Separator.foreground", BORDER_COLOR);
        if (isWindows) {
            hashMap.put("InternalFrame.background", dESKTOP_COLOR);
            hashMap.put("InternalFrame.border", new SwimapInternalFrameBorder());
            hashMap.put("InternalFrame.activeTitleBackground", new Color(52, 97, 139));
            hashMap.put("InternalFrame.activeTitleForeground", Color.black);
            hashMap.put("InternalFrame.inactiveTitleForeground", new Color(92, 92, 92));
            hashMap.put("InternalFrameUI", "com.swimap.iview.framework.lookandfeel.SwimapInternalFrameUI");
            hashMap.put("InternalFrame.maximizeIcon", new SwimapInternalFrameMaximizeIcon());
            hashMap.put("InternalFrame.iconifyIcon", new SwimapInternalFrameMinimizeIcon());
            hashMap.put("InternalFrame.minimizeIcon", new SwimapInternalFrameAltMaximizeIcon());
            hashMap.put("InternalFrame.closeIcon", new SwimapInternalFrameCloseIcon());
        } else {
            hashMap.put("InternalFrame.border", new SwimapInternalFrameBorder());
            hashMap.put("activeCaptionBorder", new Color(178, 77, 122));
            hashMap.put("InternalFrame.activeTitleForeground", Color.black);
            hashMap.put("InternalFrame.inactiveTitleForeground", new Color(92, 92, 92));
            hashMap.put("InternalFrameUI", "com.swimap.iview.framework.lookandfeel.SwimapInternalFrameUI");
            hashMap.put("InternalFrame.maximizeIcon", new MotifMaximizeIcon());
            hashMap.put("InternalFrame.iconifyIcon", new MotifIconifyIcon());
            hashMap.put("InternalFrame.minimizeIcon", new MotifMinimizeIcon());
            hashMap.put("InternalFrame.closeIcon", new MotifCloseIcon());
        }
        hashMap.put("DesktopIconUI", "com.swimap.iview.framework.lookandfeel.SwimapDesktopIconUI");
        hashMap.put("Tree.background", tREE_BACKGROUND);
        hashMap.put("Tree.textBackground", TREE_TEXT_BACKGROUND);
        hashMap.put("Tree.selectionBackground", color2);
        hashMap.put("Tree.selectionForeground", color3);
        hashMap.put("Tree.line", new Color(169, 166, 169));
        hashMap.put("Tree.hash", new Color(169, 166, 169));
        hashMap.put("Desktop.background", dESKTOP_COLOR);
        hashMap.put("DesktopIcon.background", color4);
        hashMap.put("FileChooserUI", "com.swimap.iview.framework.lookandfeel.SwimapFileChooseUI");
        hashMap.put("MenuItem.acceleratorDelimiter", "+");
        hashMap.put("SplitPaneUI", "com.swimap.iview.framework.lookandfeel.SwimapMetalSplitPaneUI");
        hashMap.put("SwimapColorChooserUI", "com.swimap.iview.templates.colorchooser.SwimapColorChooserUI");
        hashMap.put("CloseableMetalTabbedPaneUI", "com.swimap.iview.framework.lookandfeel.TabbedPaneEclipseStyleUI");
        UIManager.getDefaults().putAll(hashMap);
        UIStyleTool.loadJavaUIColors(skinColors);
        UIManager.put("OptionPane.informationIcon", new ImageIcon(UIStyleTool.class.getResource("informationIcon.png")));
        UIManager.put("OptionPane.errorIcon", new ImageIcon(UIStyleTool.class.getResource("errorIcon.png")));
        UIManager.put("OptionPane.questionIcon", new ImageIcon(UIStyleTool.class.getResource("questionIcon.png")));
        UIManager.put("OptionPane.warningIcon", new ImageIcon(UIStyleTool.class.getResource("warningIcon.png")));
        UIManager.put("Tree.expandedIcon", new ImageIcon(UIStyleTool.class.getResource("expand.gif")));
        UIManager.put("Tree.collapsedIcon", new ImageIcon(UIStyleTool.class.getResource("collapse.gif")));
        styleFactory = new SwimapStyleFactory();
    }

    private static void loadJavaUIColors(SkinColors skinColors) {
        HashMap<String, Color> hashMap = skinColors.getJavaColors();
        Set<Map.Entry<String, Color>> set = hashMap.entrySet();
        for (Map.Entry<String, Color> entry : set) {
            UIManager.put(entry.getKey(), entry.getValue());
        }
    }

    private static void installCommonStyle(HashMap<String, Object> hashMap) {
        Font font = null;
        Font font2 = null;
        Font font3 = null;
        String string = "Monospaced";
        String string2 = System.getProperty("os.name");
        if (0 <= string2.indexOf("SunOS") || 0 <= string2.indexOf("HP-UX") || 0 <= string2.indexOf("Solaris") || 0 <= string2.indexOf("AIX")) {
            font = new Font(fontName, 0, unixFontSize);
            font3 = new Font(string, 0, unixFontSize);
        } else if (string2.indexOf("Windows") >= 0) {
            font = new Font(fontName, 0, winFontSize);
            font3 = new Font(string, 0, winFontSize);
        } else {
            font = new Font(fontName, 0, unixFontSize);
            font3 = new Font(string, 0, unixFontSize);
        }
        font2 = new Font(fontName, 0, 12);
        hashMap.put("Button.font", font);
        hashMap.put("ToggleButton.font", font);
        hashMap.put("RadioButton.font", font);
        hashMap.put("CheckBox.font", font);
        hashMap.put("ColorChooser.font", font);
        if (UIStyleManager.getFontSize() == 13) {
            hashMap.put("ComboBox.font", font2);
        } else {
            hashMap.put("ComboBox.font", font);
        }
        hashMap.put("Label.font", font);
        hashMap.put("List.font", font);
        hashMap.put("MenuBar.font", font);
        hashMap.put("RadioButtonMenuItem.font", font);
        hashMap.put("RadioButtonMenuItem.acceleratorFont", font);
        hashMap.put("CheckBoxMenuItem.font", font);
        hashMap.put("CheckBoxMenuItem.acceleratorFont", font);
        hashMap.put("Menu.font", font);
        hashMap.put("Menu.acceleratorFont", font);
        hashMap.put("MenuItem.font", font);
        hashMap.put("MenuItem.acceleratorFont", font);
        hashMap.put("PopupMenu.font", font);
        hashMap.put("OptionPane.font", font);
        hashMap.put("OptionPane.buttonFont", font);
        hashMap.put("OptionPane.messageFont", font);
        hashMap.put("ProgressBar.font", font);
        hashMap.put("Panel.font", font);
        hashMap.put("ScrollPane.font", font);
        hashMap.put("Viewport.font", font);
        hashMap.put("TabbedPane.font", font);
        hashMap.put("Table.font", font);
        hashMap.put("TableHeader.font", font);
        hashMap.put("TextField.font", font);
        hashMap.put("PasswordField.font", font);
        hashMap.put("TextArea.font", font3);
        hashMap.put("TextPane.font", font3);
        hashMap.put("EditorPane.font", font3);
        hashMap.put("TitledBorder.font", font);
        hashMap.put("ToolBar.font", font);
        hashMap.put("ToolTip.font", font);
        hashMap.put("InternalFrame.font", font);
        hashMap.put("InternalFrame.titleFont", font);
        hashMap.put("Tree.font", font);
        hashMap.put("DesktopIcon.font", font);
        hashMap.put("Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ENTER", "pressed", "released ENTER", "released", "SPACE", "pressed", "released SPACE", "released"}));
        hashMap.put("ToggleButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ENTER", "pressed", "released ENTER", "released", "SPACE", "pressed", "released SPACE", "released"}));
        BasicBorders.SplitPaneBorder splitPaneBorder = new BasicBorders.SplitPaneBorder(Color.WHITE, BORDER_COLOR){

            @Override
            public Insets getBorderInsets(Component component) {
                return new Insets(0, 0, 0, 0);
            }
        };
        hashMap.put("SplitPane.border", splitPaneBorder);
        CheckBoxMenuItemIcon checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        hashMap.put("CheckBoxMenuItem.checkIcon", checkBoxMenuItemIcon);
        UIStyleTool.installKeyMap(hashMap);
    }

    private static void installKeyMap(HashMap<String, Object> hashMap) {
        hashMap.put("SplitPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "negativeIncrement", "DOWN", "positiveIncrement", "LEFT", "negativeIncrement", "RIGHT", "positiveIncrement", "KP_UP", "negativeIncrement", "KP_DOWN", "positiveIncrement", "KP_LEFT", "negativeIncrement", "KP_RIGHT", "positiveIncrement", "HOME", "selectMin", "END", "selectMax", "ctrl shift TAB", "focusOutBackward"}));
        hashMap.put("Table.ancestorInputMap", new UIDefaults.LazyInputMap(UIStyleTool.getTableAncestorInputArray()));
        hashMap.put("Tree.focusInputMap", new UIDefaults.LazyInputMap(UIStyleTool.getTreeFocusInputArray()));
    }

    private static Object[] getTreeFocusInputArray() {
        return new Object[]{"PASTE", "paste", "ctrl V", "paste", "COPY", "copy", "shift KP_DOWN", "selectNextExtendSelection", "ctrl X", "cut", "CUT", "cut", "shift UP", "selectPreviousExtendSelection", "ctrl C", "copy", "KP_UP", "selectPrevious", "UP", "selectPrevious", "HOME", "selectFirst", "shift PAGE_DOWN", "scrollDownExtendSelection", "shift PAGE_UP", "scrollUpExtendSelection", "PAGE_DOWN", "scrollDownChangeSelection", "PAGE_UP", "scrollUpChangeSelection", "LEFT", "selectParent", "shift END", "selectLastExtendSelection", "KP_RIGHT", "selectChild", "DOWN", "selectNext", "shift DOWN", "selectNextExtendSelection", "shift HOME", "selectFirstExtendSelection", "RIGHT", "selectChild", "KP_DOWN", "selectNext", "shift KP_UP", "selectPreviousExtendSelection", "KP_LEFT", "selectParent", "END", "selectLast", "SPACE", "toggleSelectionPreserveAnchor", "ctrl BACK_SLASH", "clearSelection", "scrollRight", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl LEFT", "scrollLeft", "ctrl PAGE_UP", "scrollUpChangeLead", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_DOWN", "scrollDownChangeLead", "ctrl RIGHT", "scrollRight", "ctrl DOWN", "selectNextChangeLead", "ctrl END", "selectLastChangeLead", "ctrl KP_DOWN", "selectNextChangeLead", "ctrl HOME", "selectFirstChangeLead", "ctrl KP_UP", "selectPreviousChangeLead", "ctrl UP", "selectPreviousChangeLead", "shift SPACE", "extendSelection", "ctrl KP_LEFT", "scrollLeft", "ctrl SPACE", "toggleSelectionPreserveAnchor", "ctrl SLASH", "selectAll", "ctrl A", "selectAll", "ctrl KP_RIGHT"};
    }

    private static Object[] getTableAncestorInputArray() {
        return new Object[]{"LEFT", "selectPreviousColumn", "RIGHT", "selectNextColumn", "KP_UP", "selectPreviousRow", "KP_DOWN", "selectNextRow", "DOWN", "selectNextRow", "KP_LEFT", "selectPreviousColumn", "UP", "selectPreviousRow", "KP_RIGHT", "selectNextColumn", "ctrl C", "copy", "CUT", "cut", "ctrl V", "paste", "COPY", "copy", "ctrl X", "cut", "PASTE", "paste", "ESCAPE", "cancel", "shift HOME", "selectFirstColumnExtendSelection", "shift PAGE_UP", "scrollUpExtendSelection", "HOME", "selectFirstColumn", "PAGE_UP", "scrollUpChangeSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "shift UP", "selectPreviousRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "shift DOWN", "selectNextRowExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "END", "selectLastColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "PAGE_DOWN", "scrollDownChangeSelection", "shift RIGHT", "selectNextColumnExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl END", "selectLastRow", "shift END", "selectLastColumnExtendSelection", "F2", "startEditing", "shift ENTER", "selectPreviousRowCell", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection", "ctrl A", "selectAll", "ctrl PAGE_UP", "scrollLeftChangeSelection", "ctrl HOME", "selectFirstRow", "shift TAB", "selectPreviousColumnCell", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "ENTER", "selectNextRowCell", "ctrl shift END", "selectLastRowExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "TAB", "selectNextColumnCell"};
    }

    public static TabbedPaneUI getBorderLessTabbedPaneUI() {
        return styleFactory.createBorderLessTabbedPaneUI();
    }

    public static void setResource(ResourceBundle resourceBundle) {
        res = resourceBundle;
    }

    public static final Color getTOOLBAR_BACKGROUND() {
        return tOOLBAR_BACKGROUND;
    }

    public static final Color getDISABLED_BACKGROUND() {
        return dISABLED_BACKGROUND;
    }

    static {
        String string = System.getProperty("os.name");
        if (string != null && (string.indexOf("Solaris") != -1 || string.indexOf("SunOS") != -1 || string.indexOf("Linux") != -1 || string.indexOf("HP-UX") != -1)) {
            isWindows = false;
        }
    }

    private static class SwimapRadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 8901181671783190093L;

        private SwimapRadioButtonIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            ButtonModel buttonModel = ((JRadioButton)component).getModel();
            Color color = component.getBackground();
            Color color2 = component.getForeground();
            ColorUIResource colorUIResource = MetalLookAndFeel.getControlDarkShadow();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getControlShadow();
            Color color3 = MetalLookAndFeel.getControlHighlight();
            Color color4 = MetalLookAndFeel.getControlHighlight();
            Color color5 = color;
            if (!buttonModel.isEnabled()) {
                color4 = color;
                color3 = color;
                colorUIResource = colorUIResource2;
                color2 = colorUIResource2;
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                color4 = colorUIResource2;
                color5 = colorUIResource2;
            }
            graphics.translate(n, n2);
            if (buttonModel.isEnabled()) {
                graphics.setColor(eDIT_BACKGROUND);
            } else {
                graphics.setColor(color5);
            }
            graphics.fillRect(2, 2, 9, 9);
            graphics.setColor(colorUIResource);
            this.drawDarkCircle(graphics);
            graphics.setColor(color4);
            this.drawInnerWhiteArc(graphics);
            graphics.setColor(color3);
            this.drawOuterWhiteArc(graphics);
            if (buttonModel.isSelected()) {
                graphics.setColor(color2);
                this.drawDot(graphics);
            }
            graphics.translate(-n, -n2);
        }

        private void drawDot(Graphics graphics) {
            graphics.fillRect(4, 4, 4, 4);
            graphics.drawLine(4, 3, 7, 3);
            graphics.drawLine(8, 4, 8, 7);
            graphics.drawLine(7, 8, 4, 8);
            graphics.drawLine(3, 7, 3, 4);
        }

        private void drawOuterWhiteArc(Graphics graphics) {
            graphics.drawLine(10, 1, 10, 1);
            graphics.drawLine(11, 2, 11, 3);
            graphics.drawLine(12, 4, 12, 7);
            graphics.drawLine(11, 8, 11, 9);
            graphics.drawLine(10, 10, 10, 10);
            graphics.drawLine(9, 11, 8, 11);
            graphics.drawLine(7, 12, 4, 12);
            graphics.drawLine(3, 11, 2, 11);
        }

        private void drawInnerWhiteArc(Graphics graphics) {
            graphics.drawLine(2, 9, 2, 8);
            graphics.drawLine(1, 7, 1, 4);
            graphics.drawLine(2, 2, 2, 3);
            graphics.drawLine(2, 2, 3, 2);
            graphics.drawLine(4, 1, 7, 1);
            graphics.drawLine(8, 2, 9, 2);
        }

        private void drawDarkCircle(Graphics graphics) {
            graphics.drawLine(4, 0, 7, 0);
            graphics.drawLine(8, 1, 9, 1);
            graphics.drawLine(10, 2, 10, 3);
            graphics.drawLine(11, 4, 11, 7);
            graphics.drawLine(10, 8, 10, 9);
            graphics.drawLine(9, 10, 8, 10);
            graphics.drawLine(7, 11, 4, 11);
            graphics.drawLine(3, 10, 2, 10);
            graphics.drawLine(1, 9, 1, 8);
            graphics.drawLine(0, 7, 0, 4);
            graphics.drawLine(1, 3, 1, 2);
            graphics.drawLine(2, 1, 3, 1);
        }

        @Override
        public int getIconWidth() {
            return 13;
        }

        @Override
        public int getIconHeight() {
            return 13;
        }
    }

    private static class SwimapCheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 553647327933664558L;

        private SwimapCheckBoxIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            ButtonModel buttonModel = ((JCheckBox)component).getModel();
            int n3 = this.getControlSize();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    graphics.setColor(MetalLookAndFeel.getControlShadow());
                    graphics.fillRect(n, n2, n3 - 1, n3 - 1);
                    this.drawPressed3DBorder(graphics, n, n2, n3, n3);
                } else {
                    this.drawFlush3DBorder(graphics, n, n2, n3, n3);
                }
                Color color = component.getForeground();
                if (eDIT_BACKGROUND.equals(color)) {
                    graphics.setColor(component.getBackground());
                } else {
                    graphics.setColor(eDIT_BACKGROUND);
                }
                graphics.fillRect(n + 2, n2 + 2, n3 - 4, n3 - 4);
                graphics.setColor(color);
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.drawRect(n, n2, n3 - 2, n3 - 2);
            }
            if (buttonModel.isSelected()) {
                this.drawCheck(component, graphics, n, n2);
            }
        }

        void drawPressed3DBorder(Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            this.drawFlush3DBorder(graphics, 0, 0, n3, n4);
            graphics.drawLine(1, 1, 1, n4 - 2);
            graphics.drawLine(1, 1, n3 - 2, 1);
            graphics.translate(-n, -n2);
        }

        void drawFlush3DBorder(Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawRect(0, 0, n3 - 2, n4 - 2);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.drawLine(0, n4 - 1, 1, n4 - 2);
            graphics.drawLine(n3 - 1, 0, n3 - 2, 1);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawRect(1, 1, n3 - 2, n4 - 2);
            graphics.translate(-n, -n2);
        }

        protected void drawCheck(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.getControlSize();
            graphics.fillRect(n + 3, n2 + 5, 2, n3 - 8);
            graphics.drawLine(n + (n3 - 4), n2 + 3, n + 5, n2 + (n3 - 6));
            graphics.drawLine(n + (n3 - 4), n2 + 4, n + 5, n2 + (n3 - 5));
        }

        @Override
        public int getIconWidth() {
            return this.getControlSize();
        }

        @Override
        public int getIconHeight() {
            return this.getControlSize();
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int ICON_WIDTH = 9;
        private static final int ICON_HEIGHT = 9;

        private CheckBoxMenuItemIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            boolean bl = buttonModel.isSelected();
            boolean bl2 = buttonModel.isEnabled();
            if (bl) {
                if (!bl2) {
                    graphics.setColor(MetalLookAndFeel.getControlDisabled());
                }
                graphics.drawLine(n + 7, n2 + 1, n + 7, n2 + 3);
                graphics.drawLine(n + 6, n2 + 2, n + 6, n2 + 4);
                graphics.drawLine(n + 5, n2 + 3, n + 5, n2 + 5);
                graphics.drawLine(n + 4, n2 + 4, n + 4, n2 + 6);
                graphics.drawLine(n + 3, n2 + 5, n + 3, n2 + 7);
                graphics.drawLine(n + 2, n2 + 4, n + 2, n2 + 6);
                graphics.drawLine(n + 1, n2 + 3, n + 1, n2 + 5);
            }
        }

        @Override
        public int getIconWidth() {
            return 9;
        }

        @Override
        public int getIconHeight() {
            return 9;
        }
    }

    private static class MotifCloseIcon
    implements Icon,
    Serializable {
        private int width = 16;
        private int height = 14;

        private MotifCloseIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            Color color = (Color)UIManager.get("control");
            Color color2 = Color.white;
            Color color3 = Color.black;
            graphics.translate(n, n2);
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.width - 1, this.height - 1);
            if (buttonModel.isPressed() && buttonModel.isArmed() && buttonModel.isEnabled()) {
                graphics.setColor(color3);
                graphics.drawLine(0, 0, this.width - 1, 0);
                graphics.drawLine(0, 1, 0, this.height - 1);
                graphics.setColor(color2);
                graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                graphics.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            } else {
                graphics.setColor(color2);
                graphics.drawLine(0, 0, this.width - 1, 0);
                graphics.drawLine(0, 1, 0, this.height - 1);
                graphics.setColor(color3);
                graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                graphics.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            }
            if (!buttonModel.isEnabled()) {
                graphics.setColor(UIManager.getColor("controlShadow"));
                graphics.drawLine(4, 3, this.width - 6, this.height - 5);
                graphics.drawLine(4, this.height - 5, this.width - 6, 3);
                graphics.drawLine(4, 3, this.width - 6, this.height - 5);
                graphics.drawLine(4, this.height - 5, this.width - 6, 3);
            } else {
                graphics.setColor(color2);
                graphics.drawLine(4, 3, this.width - 6, this.height - 5);
                graphics.drawLine(4, this.height - 5, this.width - 6, 3);
                graphics.setColor(color3);
                graphics.drawLine(4, 3, this.width - 6, this.height - 5);
                graphics.drawLine(4, this.height - 5, this.width - 6, 3);
            }
            graphics.translate(-n, -n2);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private static class MotifMinimizeIcon
    implements Icon,
    Serializable {
        private int width = 16;
        private int height = 14;

        private MotifMinimizeIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            Color color = jButton.getBackground();
            Color color2 = Color.white;
            Color color3 = Color.black;
            graphics.translate(n, n2);
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.width - 1, this.height - 1);
            if (buttonModel.isPressed() && buttonModel.isArmed()) {
                graphics.setColor(color3);
                graphics.drawLine(0, 0, this.width - 1, 0);
                graphics.drawLine(0, 1, 0, this.height - 1);
                graphics.setColor(color2);
                graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                graphics.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            } else {
                graphics.setColor(color2);
                graphics.drawLine(0, 0, this.width - 1, 0);
                graphics.drawLine(0, 1, 0, this.height - 1);
                graphics.setColor(color3);
                graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                graphics.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            }
            graphics.setColor(color3);
            graphics.drawLine(this.width / 2 - 4, this.height / 2 - 4, this.width / 2 + 4, this.height / 2 - 4);
            graphics.drawLine(this.width / 2 - 4, this.height / 2 - 4, this.width / 2 - 4, this.height / 2 + 4);
            graphics.setColor(color2);
            graphics.drawLine(this.width / 2 - 4, this.height / 2 + 4, this.width / 2 + 4, this.height / 2 + 4);
            graphics.drawLine(this.width / 2 + 4, this.height / 2 - 4, this.width / 2 + 4, this.height / 2 + 4);
            graphics.translate(-n, -n2);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private static class MotifMaximizeIcon
    implements Icon,
    Serializable {
        private int width = 16;
        private int height = 14;

        private MotifMaximizeIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            Color color = jButton.getBackground();
            Color color2 = Color.white;
            Color color3 = Color.black;
            graphics.translate(n, n2);
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.width - 1, this.height - 1);
            if (buttonModel.isPressed() && buttonModel.isArmed()) {
                graphics.setColor(color3);
                graphics.drawLine(0, 0, this.width - 1, 0);
                graphics.drawLine(0, 1, 0, this.height - 1);
                graphics.setColor(color2);
                graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                graphics.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            } else {
                graphics.setColor(color2);
                graphics.drawLine(0, 0, this.width - 1, 0);
                graphics.drawLine(0, 1, 0, this.height - 1);
                graphics.setColor(color3);
                graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                graphics.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            }
            graphics.setColor(color2);
            graphics.drawLine(this.width / 2 - 4, this.height / 2 - 4, this.width / 2 + 4, this.height / 2 - 4);
            graphics.drawLine(this.width / 2 - 4, this.height / 2 - 4, this.width / 2 - 4, this.height / 2 + 4);
            graphics.setColor(color3);
            graphics.drawLine(this.width / 2 - 4, this.height / 2 + 4, this.width / 2 + 4, this.height / 2 + 4);
            graphics.drawLine(this.width / 2 + 4, this.height / 2 - 4, this.width / 2 + 4, this.height / 2 + 4);
            graphics.translate(-n, -n2);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private static class MotifIconifyIcon
    implements Icon,
    Serializable {
        private int width = 16;
        private int height = 14;

        private MotifIconifyIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            Color color = jButton.getBackground();
            Color color2 = Color.white;
            Color color3 = Color.black;
            graphics.translate(n, n2);
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.width - 1, this.height - 1);
            if (buttonModel.isPressed() && buttonModel.isArmed()) {
                graphics.setColor(color3);
                graphics.drawLine(0, 0, this.width - 1, 0);
                graphics.drawLine(0, 1, 0, this.height - 1);
                graphics.setColor(color2);
                graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                graphics.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            } else {
                graphics.setColor(color2);
                graphics.drawLine(0, 0, this.width - 1, 0);
                graphics.drawLine(0, 1, 0, this.height - 1);
                graphics.setColor(color3);
                graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                graphics.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            }
            graphics.setColor(color2);
            graphics.drawLine(this.width / 2 - 1, this.height / 2 - 1, this.width / 2 + 2, this.height / 2 - 1);
            graphics.drawLine(this.width / 2 - 1, this.height / 2 - 1, this.width / 2 - 1, this.height / 2 + 1);
            graphics.setColor(color3);
            graphics.drawLine(this.width / 2 - 1, this.height / 2 + 1, this.width / 2 + 2, this.height / 2 + 1);
            graphics.drawLine(this.width / 2 + 2, this.height / 2 - 1, this.width / 2 + 2, this.height / 2 + 1);
            graphics.translate(-n, -n2);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private static class SwimapInternalFrameAltMaximizeIcon
    implements Icon,
    UIResource,
    Serializable {
        private int width = 16;
        private int height = 14;

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            Color color = (Color)UIManager.get("control");
            graphics.translate(n, n2);
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.width, this.height);
            if (buttonModel.isPressed() && buttonModel.isArmed()) {
                graphics.setColor(Color.black);
                graphics.drawLine(0, 0, this.width - 1, 0);
                graphics.drawLine(0, 1, 0, this.height - 1);
                graphics.setColor(Color.white);
                graphics.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
                graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
            } else {
                graphics.setColor(Color.white);
                graphics.drawLine(0, 0, this.width - 1, 0);
                graphics.drawLine(0, 1, 0, this.height - 1);
                graphics.setColor(Color.black);
                graphics.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
                graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
            }
            graphics.setColor(Color.black);
            graphics.drawRect(6, this.height - 11, 5, 5);
            graphics.drawLine(6, this.height - 10, 11, this.height - 10);
            graphics.setColor(color);
            graphics.fillRect(4, this.height - 8, 5, 5);
            graphics.setColor(Color.black);
            graphics.drawRect(4, this.height - 8, 5, 5);
            graphics.drawLine(4, this.height - 7, 9, this.height - 7);
            graphics.translate(-n, -n2);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private static class SwimapInternalFrameMinimizeIcon
    implements Icon,
    UIResource,
    Serializable {
        private int width = 16;
        private int height = 14;

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            Color color = (Color)UIManager.get("control");
            graphics.translate(n, n2);
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.width, this.height);
            if (buttonModel.isPressed() && buttonModel.isArmed()) {
                graphics.setColor(Color.black);
                graphics.drawLine(0, 0, this.width - 1, 0);
                graphics.drawLine(0, 1, 0, this.height - 1);
                graphics.setColor(Color.white);
                graphics.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
                graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
            } else {
                graphics.setColor(Color.white);
                graphics.drawLine(0, 0, this.width - 1, 0);
                graphics.drawLine(0, 1, 0, this.height - 1);
                graphics.setColor(Color.black);
                graphics.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
                graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
            }
            graphics.setColor(Color.black);
            graphics.drawLine(4, this.height - 4, 9, this.height - 4);
            graphics.drawLine(4, this.height - 5, 9, this.height - 5);
            graphics.translate(-n, -n2);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private static class SwimapInternalFrameMaximizeIcon
    implements Icon,
    UIResource,
    Serializable {
        private int width = 16;
        private int height = 14;

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            Color color = (Color)UIManager.get("control");
            graphics.translate(n, n2);
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.width, this.height);
            if (buttonModel.isPressed() && buttonModel.isArmed()) {
                graphics.setColor(Color.black);
                graphics.drawLine(0, 0, this.width - 1, 0);
                graphics.drawLine(0, 1, 0, this.height - 1);
                graphics.setColor(Color.white);
                graphics.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
                graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
            } else {
                graphics.setColor(Color.white);
                graphics.drawLine(0, 0, this.width - 1, 0);
                graphics.drawLine(0, 1, 0, this.height - 1);
                graphics.setColor(Color.black);
                graphics.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
                graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
            }
            graphics.setColor(Color.black);
            graphics.drawRect(3, 3, this.width - 8, this.height - 7);
            graphics.drawLine(3, 4, this.width - 5, 4);
            graphics.translate(-n, -n2);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private static class SwimapInternalFrameCloseIcon
    implements Icon,
    UIResource,
    Serializable {
        private int width = 16;
        private int height = 14;

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            Color color = (Color)UIManager.get("control");
            graphics.translate(n, n2);
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.width, this.height);
            if (buttonModel.isPressed() && buttonModel.isArmed() && buttonModel.isEnabled()) {
                graphics.setColor(Color.black);
                graphics.drawLine(0, 0, this.width - 1, 0);
                graphics.drawLine(0, 1, 0, this.height - 1);
                graphics.setColor(Color.white);
                graphics.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
                graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
            } else {
                graphics.setColor(Color.white);
                graphics.drawLine(0, 0, this.width - 1, 0);
                graphics.drawLine(0, 1, 0, this.height - 1);
                graphics.setColor(Color.black);
                graphics.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
                graphics.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
            }
            if (!buttonModel.isEnabled()) {
                graphics.setColor(UIManager.getColor("controlShadow"));
            } else {
                graphics.setColor(Color.black);
            }
            graphics.drawLine(4, 3, this.width - 6, this.height - 5);
            graphics.drawLine(5, 3, this.width - 5, this.height - 5);
            graphics.drawLine(4, this.height - 5, this.width - 6, 3);
            graphics.drawLine(5, this.height - 5, this.width - 5, 3);
            graphics.translate(-n, -n2);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    public static class LightBevelBorder
    extends BevelBorder {
        LightBevelBorder(int n) {
            super(n);
        }

        @Override
        protected void paintLoweredBevel(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            int n5 = n4;
            int n6 = n3;
            graphics.translate(n, n2);
            graphics.setColor(this.getShadowInnerColor(component));
            graphics.drawLine(0, 0, 0, n5 - 1);
            graphics.drawLine(1, 0, n6 - 1, 0);
            graphics.setColor(this.getShadowOuterColor(component));
            graphics.drawLine(1, 1, 1, n5 - 2);
            graphics.drawLine(2, 1, n6 - 2, 1);
            graphics.setColor(this.getHighlightOuterColor(component));
            graphics.drawLine(1, n5 - 1, n6 - 1, n5 - 1);
            graphics.drawLine(n6 - 1, 1, n6 - 1, n5 - 2);
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }

        @Override
        protected void paintRaisedBevel(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            int n5 = n4;
            int n6 = n3;
            graphics.translate(n, n2);
            graphics.setColor(this.getHighlightOuterColor(component));
            graphics.drawLine(0, 0, 0, n5 - 1);
            graphics.drawLine(1, 0, n6 - 1, 0);
            graphics.setColor(this.getShadowOuterColor(component));
            graphics.drawLine(1, n5 - 1, n6 - 1, n5 - 1);
            graphics.drawLine(n6 - 1, 1, n6 - 1, n5 - 2);
            graphics.setColor(this.getShadowInnerColor(component));
            graphics.drawLine(2, n5 - 2, n6 - 2, n5 - 2);
            graphics.drawLine(n6 - 2, 2, n6 - 2, n5 - 3);
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }
    }

    private static class MenuArrowIcon
    implements Icon {
        private MenuArrowIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            int n3 = this.getIconHeight();
            if (Color.WHITE.equals(color)) {
                graphics.setColor(Color.BLACK);
            }
            graphics.drawLine(n + 7 + portalArrowInsets, n2 + 2 + portalArrowInsets / 2, n + 7 + portalArrowInsets, n2 + n3 - 1 - portalArrowInsets / 2);
            graphics.drawLine(n + 8 + portalArrowInsets, n2 + 3 + portalArrowInsets / 2, n + 8 + portalArrowInsets, n2 + n3 - 2 - portalArrowInsets / 2);
            graphics.drawLine(n + 9 + portalArrowInsets, n2 + 4 + portalArrowInsets / 2, n + 9 + portalArrowInsets, n2 + n3 - 3 - portalArrowInsets / 2);
            graphics.drawLine(n + 10 + portalArrowInsets, n2 + 5 + portalArrowInsets / 2, n + 10 + portalArrowInsets, n2 + n3 - 4 - portalArrowInsets / 2);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 11 + portalArrowInsets;
        }

        @Override
        public int getIconHeight() {
            return 10 + portalArrowInsets;
        }
    }
}

