/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel;

import com.swimap.iview.framework.lookandfeel.UIStyleTool;
import com.swimap.iview.framework.lookandfeel.skin.SkinManager;
import com.swimap.iview.util.ReflectionUtilities;
import com.swimap.iview.util.log.IviewLogger;

public class UIStyleManager {
    private static IviewLogger logger = IviewLogger.getLogger(UIStyleManager.class, "IVIEW");
    public static final String LNF_STYLE_AREA_NAME = "lookandfeel";
    public static final String LNF_STYLE_DESC_NAME = "lookandfeel";
    public static final String LNF_STYLE_PARAC_NAME = "uistyle";
    public static final String FONT_SIZE_PARA_SIZE = "fontsize";
    public static final String FONT_NAME_PARA_NAME = "font";
    public static final int DEFAULT_BUTTON_WIDTH = 83;
    public static final int DEFAULT_BUTTON_HEIGHT = 26;
    public static final String SWIMAP_STYLE = "Swimap";
    public static final String PARAM_STYLE_NAME = "StyleName";
    private static String styleName = "Swimap";
    public static final String STYLE_SETTING_FILE = "conf/mainfrm/lookandfeel";
    private static String currentStyleName = "Swimap";
    private static final int DEFAULT_SIZE = 16;
    private static int fontSize = 16;
    private static Object commStyleManager = null;
    private static Object styleInfo = null;
    private static Object areaDesc = null;
    private static Object confDescContainer = null;

    public static String getUIStyle() {
        return styleName;
    }

    public static int getFontSize() {
        return fontSize;
    }

    public static void setFontSize(int n) {
        fontSize = n;
    }

    public static void loadUIStyleName() {
        commStyleManager = ReflectionUtilities.callStaticMethod("com.swimap.iview.commstyle.commini.CommStyleManager", "getInstance", null, null);
        if (null != commStyleManager) {
            styleInfo = ReflectionUtilities.callTheMethod(commStyleManager, "getCommonStyleFile", new Class[]{String.class}, new Object[]{STYLE_SETTING_FILE});
            if (styleInfo != null) {
                areaDesc = ReflectionUtilities.callTheMethod(styleInfo, "getAreaDescContainer", new Class[]{String.class}, new Object[]{"lookandfeel"});
                confDescContainer = ReflectionUtilities.callTheMethod(areaDesc, "getDescContainer", new Class[]{String.class}, new Object[]{"lookandfeel"});
                try {
                    String string = (String)ReflectionUtilities.callTheMethod(confDescContainer, "getParasItemValue", new Class[]{String.class}, new Object[]{FONT_SIZE_PARA_SIZE});
                    fontSize = Integer.parseInt(string);
                    UIStyleTool.setUnixFontSize(fontSize);
                    UIStyleTool.setWinFontSize(fontSize);
                    String string2 = (String)ReflectionUtilities.callTheMethod(confDescContainer, "getParasItemValue", new Class[]{String.class}, new Object[]{FONT_NAME_PARA_NAME});
                    if (string2 != null && string2.length() > 0) {
                        UIStyleTool.setFontName(string2);
                    }
                }
                catch (Exception exception) {
                    logger.trace(exception.getMessage(), exception);
                }
            } else {
                logger.error("Load style error, can get the style info from style file.");
            }
        }
        UIStyleManager.updateUIStyle();
    }

    public static void writeBackUIStyle(String string) {
        if (null == styleInfo) {
            logger.error("write style error, can get the style info from style file.");
            return;
        }
        if (null == areaDesc) {
            logger.error("write style error, can get the area info from style file.");
            return;
        }
        if (null == confDescContainer) {
            logger.error("write style error, can get the desc info from style file.");
            return;
        }
        String string2 = Integer.toString(UIStyleManager.getFontSize());
        ReflectionUtilities.callTheMethod(confDescContainer, "setParasItem", new Class[]{String.class, String.class}, new Object[]{FONT_SIZE_PARA_SIZE, string2});
        ReflectionUtilities.callTheMethod(confDescContainer, "setParasItem", new Class[]{String.class, String.class}, new Object[]{LNF_STYLE_PARAC_NAME, string});
        ReflectionUtilities.callTheMethod(styleInfo, "writeToAllUsers", new Class[0], new Object[0]);
    }

    public static void updateUIStyle() {
        UIStyleManager.setSwimapStyle();
    }

    public static String getCurrentUIStyle() {
        return currentStyleName;
    }

    public static void setSwimapStyle() {
        UIStyleTool.setSwimapStyle();
    }

    public static String getCurrentSkin() {
        return SkinManager.getInstance().getSelectedSkin();
    }
}

