/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalToolTipUI;

public class SwimapToolTipUI
extends MetalToolTipUI {
    private static SwimapToolTipUI sharedInstance = new SwimapToolTipUI();
    private Font smallFont = null;
    private JToolTip tip = null;
    private String acceleratorDelimiter = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return sharedInstance;
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.tip = (JToolTip)jComponent;
        Font font = jComponent.getFont();
        this.smallFont = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "-";
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.tip = null;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        JToolTip jToolTip = (JToolTip)jComponent;
        super.paint(graphics, jComponent);
        String string = this.getAcceleratorString(jToolTip);
        String string2 = jToolTip.getTipText();
        if (string2 == null) {
            string2 = "";
        }
        if (!"".equals(string)) {
            graphics.setFont(this.smallFont);
            if (jToolTip.getComponent() != null && jToolTip.getComponent().isEnabled()) {
                graphics.setColor(UIManager.getColor("ToolTip.acceleratorForeground"));
            } else {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            }
            Font font = jComponent.getFont();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            if (System.getProperty("java.version").indexOf("1.6") != -1) {
                this.drawAccelString(graphics, jComponent, fontMetrics);
            } else {
                graphics.drawString(string, fontMetrics.stringWidth(string2) + 12, 2 + fontMetrics.getAscent());
            }
        }
    }

    private void drawAccelString(Graphics graphics, JComponent jComponent, FontMetrics fontMetrics) {
        JToolTip jToolTip = (JToolTip)jComponent;
        int n = fontMetrics.getAscent();
        String string = this.getAcceleratorString(jToolTip);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(this.smallFont);
        int n2 = this.calcAccelSpacing(fontMetrics2, string);
        Insets insets = jToolTip.getInsets();
        Dimension dimension = jComponent.getSize();
        Rectangle rectangle = new Rectangle(insets.left + 3, insets.top, dimension.width - (insets.left + insets.right) - 6 - n2, dimension.height - (insets.top + insets.bottom));
        graphics.drawString(string, jToolTip.getWidth() - 1 - insets.right - n2 + 12 - 3, rectangle.y + n);
    }

    private int calcAccelSpacing(FontMetrics fontMetrics, String string) {
        return "".equals(string) ? 0 : 12 + fontMetrics.stringWidth(string);
    }

    private String getAcceleratorString(JToolTip jToolTip) {
        this.tip = jToolTip;
        String string = this.getAcceleratorString();
        this.tip = null;
        return string;
    }

    @Override
    public String getAcceleratorString() {
        int n;
        if (this.tip == null || this.isAcceleratorHidden()) {
            return "";
        }
        JComponent jComponent = this.tip.getComponent();
        if (jComponent == null) {
            return "";
        }
        KeyStroke[] keyStrokeArray = jComponent.getRegisteredKeyStrokes();
        String string = "";
        for (n = 0; n < keyStrokeArray.length; ++n) {
            int n2 = keyStrokeArray[n].getModifiers();
            int n3 = jComponent.getConditionForKeyStroke(keyStrokeArray[n]);
            if (n3 != 2 || (n2 & 8) == 0 && (n2 & 2) == 0 && (n2 & 1) == 0 && (n2 & 4) == 0) continue;
            string = KeyEvent.getKeyModifiersText(n2) + this.acceleratorDelimiter + KeyEvent.getKeyText(keyStrokeArray[n].getKeyCode());
            break;
        }
        if ("".equals(string) && jComponent instanceof JMenuItem && (n = ((JMenuItem)jComponent).getMnemonic()) != 0) {
            string = KeyEvent.getKeyModifiersText(8) + this.acceleratorDelimiter + (char)n;
        }
        return string;
    }
}

