/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellEditor;

public class SwimapTableUI
extends BasicTableUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new SwimapTableUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        UIManager.getLookAndFeelDefaults().put("Table.actionMap", (Object)null);
        super.installUI(jComponent);
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new TableMouseInputHandler();
    }

    public class TableMouseInputHandler
    implements MouseInputListener {
        private Component dispatchComponent = null;
        private boolean selectedOnPress = false;

        private boolean shouldIgnore(MouseEvent mouseEvent) {
            return !SwingUtilities.isLeftMouseButton(mouseEvent) || !SwimapTableUI.this.table.isEnabled() || mouseEvent.isConsumed();
        }

        private void setDispatchComponent(MouseEvent mouseEvent) {
            Component component = SwimapTableUI.this.table.getEditorComponent();
            Point point = SwingUtilities.convertPoint(SwimapTableUI.this.table, mouseEvent.getPoint(), component);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(component, point.x, point.y);
        }

        private void setValueIsAdjusting(boolean bl) {
            SwimapTableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(bl);
            SwimapTableUI.this.table.getSelectionModel().setValueIsAdjusting(bl);
        }

        private boolean repostEvent(MouseEvent mouseEvent) {
            if (this.dispatchComponent == null || !SwimapTableUI.this.table.isEditing()) {
                return false;
            }
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(SwimapTableUI.this.table, mouseEvent, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(mouseEvent2);
            return true;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                this.selectedOnPress = false;
                return;
            }
            this.selectedOnPress = true;
            this.adjustFocusAndSelection(mouseEvent);
        }

        void adjustFocusAndSelection(MouseEvent mouseEvent) {
            if (this.shouldIgnore(mouseEvent)) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n = SwimapTableUI.this.table.rowAtPoint(point);
            int n2 = SwimapTableUI.this.table.columnAtPoint(point);
            if (n2 == -1 || n == -1) {
                return;
            }
            if (SwimapTableUI.this.table.editCellAt(n, n2, mouseEvent)) {
                this.setDispatchComponent(mouseEvent);
                this.repostEvent(mouseEvent);
            } else if (SwimapTableUI.this.table.isRequestFocusEnabled()) {
                SwimapTableUI.this.table.requestFocus();
            }
            TableCellEditor tableCellEditor = SwimapTableUI.this.table.getCellEditor();
            if (tableCellEditor == null || tableCellEditor.shouldSelectCell(mouseEvent)) {
                boolean bl = mouseEvent.getID() == 501;
                this.setValueIsAdjusting(bl);
                SwimapTableUI.this.table.getSelectedRow();
                if (mouseEvent.isShiftDown() && SwimapTableUI.this.table.getSelectedRow() == -1 && SwimapTableUI.this.table.getSelectedColumn() == -1) {
                    SwimapTableUI.this.table.changeSelection(n, n2, mouseEvent.isControlDown(), false);
                } else {
                    SwimapTableUI.this.table.changeSelection(n, n2, mouseEvent.isControlDown(), mouseEvent.isShiftDown());
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.selectedOnPress) {
                if (this.shouldIgnore(mouseEvent)) {
                    return;
                }
                this.repostEvent(mouseEvent);
                this.dispatchComponent = null;
                this.setValueIsAdjusting(false);
            } else {
                this.adjustFocusAndSelection(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.shouldIgnore(mouseEvent)) {
                return;
            }
            this.mouseDraggedImpl(mouseEvent);
        }

        private void changeListSelectionModel(ListSelectionModel listSelectionModel, int n, boolean bl, int n2) {
            if (bl) {
                listSelectionModel.addSelectionInterval(n, n2);
            } else {
                listSelectionModel.removeSelectionInterval(n, n2);
            }
        }

        protected void mouseDraggedImpl(MouseEvent mouseEvent) {
            this.repostEvent(mouseEvent);
            if (SwimapTableUI.this.table.isEditing()) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n = SwimapTableUI.this.table.rowAtPoint(point);
            int n2 = SwimapTableUI.this.table.columnAtPoint(point);
            if (-1 == n2 || -1 == n) {
                return;
            }
            if (mouseEvent.isControlDown()) {
                Rectangle rectangle;
                ListSelectionModel listSelectionModel = SwimapTableUI.this.table.getColumnModel().getSelectionModel();
                ListSelectionModel listSelectionModel2 = SwimapTableUI.this.table.getSelectionModel();
                int n3 = listSelectionModel.getAnchorSelectionIndex();
                int n4 = listSelectionModel2.getAnchorSelectionIndex();
                boolean bl = true;
                if (n4 == -1 || n4 >= SwimapTableUI.this.table.getRowCount()) {
                    n4 = 0;
                    bl = false;
                }
                if (n3 == -1 || n3 >= SwimapTableUI.this.table.getColumnCount()) {
                    n3 = 0;
                    bl = false;
                }
                bl = bl && SwimapTableUI.this.table.isCellSelected(n4, n3);
                this.changeListSelectionModel(listSelectionModel, n3, bl, n2);
                this.changeListSelectionModel(listSelectionModel2, n4, bl, n);
                if (SwimapTableUI.this.table.getAutoscrolls() && (rectangle = SwimapTableUI.this.table.getCellRect(n, n2, false)) != null) {
                    SwimapTableUI.this.table.scrollRectToVisible(rectangle);
                }
            } else {
                SwimapTableUI.this.table.changeSelection(n, n2, false, true);
            }
        }
    }
}

