/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel;

import com.swimap.iview.framework.lookandfeel.SwimapMetalSplitPaneDivider;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.MainDesktopPane;
import com.swimap.iview.framework.windowmanagement.WindowManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class SwimapSplitPaneUI
extends BasicSplitPaneUI {
    protected int oneTouchFlag = 0;
    private static final int SPLIT_SPACE_MIN = 20;
    protected int splitSpace = 20;
    protected SwimapHorizontalLayoutManager iviewLayoutManager;
    private boolean dividerLocationIsSet;
    private boolean isDraggingAllowed = true;
    boolean painted;
    boolean ignoreDividerLocChange;
    private boolean keepHiddenFlag = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SwimapSplitPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.dividerLocationIsSet = false;
        this.keepHiddenFlag = false;
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.dividerLocationIsSet = false;
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (this.splitPane.getLayout() == this.iviewLayoutManager) {
            this.splitPane.setLayout(null);
        }
        this.iviewLayoutManager = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.divider.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("oneTouchFlag".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() instanceof Integer) {
                    SwimapSplitPaneUI.this.oneTouchFlag = (Integer)propertyChangeEvent.getNewValue();
                }
            }
        });
    }

    @Override
    public void resetToPreferredSizes(JSplitPane jSplitPane) {
        if (null == this.splitPane) {
            return;
        }
        this.iviewLayoutManager.resetToPreferredSizes();
        this.splitPane.revalidate();
        this.splitPane.repaint();
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (null == this.splitPane) {
            return new Dimension();
        }
        return this.iviewLayoutManager.preferredLayoutSize(this.splitPane);
    }

    @Override
    public void setDividerLocation(JSplitPane jSplitPane, int n) {
        if (this.ignoreDividerLocChange) {
            this.ignoreDividerLocChange = false;
        } else {
            this.dividerLocationIsSet = true;
            this.splitPane.revalidate();
            this.splitPane.repaint();
        }
        if (this.keepHiddenFlag) {
            Insets insets = this.splitPane.getInsets();
            int n2 = this.splitPane.getOrientation();
            if (n2 == 0 && n != insets.top && n != this.splitPane.getHeight() - this.divider.getHeight() - insets.top || n2 == 1 && n != insets.left && n != this.splitPane.getWidth() - this.divider.getWidth() - insets.left) {
                this.setKeepHiddenFlag(false);
            }
        } else {
            Insets insets = this.splitPane.getInsets();
            int n3 = this.splitPane.getOrientation();
            if (n3 == 0 && n == insets.top || n == this.splitPane.getHeight() - this.divider.getHeight() - insets.top || n3 == 1 && n == insets.left || n == this.splitPane.getWidth() - this.divider.getWidth() - insets.left) {
                this.setKeepHiddenFlag(true);
            }
        }
    }

    @Override
    public void finishedPaintingChildren(JSplitPane jSplitPane, Graphics graphics) {
        if (this.isDraggingAllowed) {
            super.finishedPaintingChildren(jSplitPane, graphics);
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        if (null == this.splitPane) {
            return new Dimension();
        }
        return this.iviewLayoutManager.minimumLayoutSize(this.splitPane);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (!this.painted && this.splitPane.getDividerLocation() < 0) {
            this.ignoreDividerLocChange = true;
            int n = this.getDividerLocation(this.splitPane);
            this.splitPane.setDividerLocation(n);
        }
        this.painted = true;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        if (null == this.splitPane) {
            return new Dimension();
        }
        return this.iviewLayoutManager.maximumLayoutSize(this.splitPane);
    }

    @Override
    protected void resetLayoutManager() {
        this.iviewLayoutManager = this.getOrientation() == 1 ? new SwimapHorizontalLayoutManager(0) : new SwimapHorizontalLayoutManager(1);
        this.splitPane.setLayout(this.iviewLayoutManager);
        this.iviewLayoutManager.updateComponents();
        this.splitPane.revalidate();
        this.splitPane.repaint();
    }

    @Override
    protected void startDragging() {
        if (!this.isDraggingAllowed) {
            return;
        }
        super.startDragging();
    }

    @Override
    protected void dragDividerTo(int n) {
        if (!this.isDraggingAllowed) {
            return;
        }
        super.dragDividerTo(n);
    }

    @Override
    protected void finishDraggingTo(int n) {
        if (!this.isDraggingAllowed) {
            return;
        }
        super.finishDraggingTo(n);
    }

    public void setDraggingAllowed(boolean bl) {
        this.isDraggingAllowed = bl;
        if (null != this.splitPane) {
            this.splitPane.setEnabled(this.isDraggingAllowed);
        }
    }

    void setKeepHiddenFlag(boolean bl) {
        this.keepHiddenFlag = bl;
    }

    private boolean getKeepHiddenFlag() {
        return this.keepHiddenFlag;
    }

    public class SwimapHorizontalLayoutManager
    implements LayoutManager2 {
        protected Component[] componentArray;
        private int lastSplitPaneSize = 0;
        private boolean doReset = false;
        private int axis = 0;
        protected int[] sizeArray;
        private boolean firstInit = false;

        SwimapHorizontalLayoutManager(int n) {
            this.axis = n;
            this.sizeArray = new int[3];
            this.componentArray = new Component[3];
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            if (string == null) {
                throw new IllegalArgumentException("cannot add to layout: unknown constraint: null");
            }
            if (string.equals("divider")) {
                this.componentArray[2] = component;
                this.sizeArray[2] = this.getPrimaryAxisSize(component.getPreferredSize());
            } else if (string.equals("right") || string.equals("bottom")) {
                this.componentArray[1] = component;
                this.sizeArray[1] = 0;
            } else if (string.equals("left") || string.equals("top")) {
                this.componentArray[0] = component;
                this.sizeArray[0] = 0;
            } else if (!string.equals("nonContinuousDivider")) {
                throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + string);
            }
            this.doReset = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container container) {
            int n;
            if (this.checkForDemaximizeAll()) {
                return;
            }
            Dimension dimension = container.getSize();
            if (dimension.width <= 0 || dimension.height <= 0) {
                this.lastSplitPaneSize = 0;
                return;
            }
            Insets insets = SwimapSplitPaneUI.this.splitPane.getInsets();
            int n2 = this.getAvailableSize(dimension, insets);
            int n3 = this.getPrimaryAxisSize(dimension);
            int n4 = this.getPrimaryAxisSize(insets, true);
            Dimension dimension2 = this.componentArray[2] == null ? null : this.componentArray[2].getPreferredSize();
            int n5 = SwimapSplitPaneUI.this.splitPane.getDividerLocation();
            if (this.doReset && !SwimapSplitPaneUI.this.dividerLocationIsSet || n5 < 0) {
                this.resetToPreferredSizes(n2);
            } else if (this.lastSplitPaneSize <= 0 || n2 == this.lastSplitPaneSize || !SwimapSplitPaneUI.this.painted || dimension2 != null && this.getPrimaryAxisSize(dimension2) != this.sizeArray[2]) {
                this.sizeArray[2] = dimension2 == null ? 0 : this.getPrimaryAxisSize(dimension2);
                if ((n3 <= n5 || n5 == 0) && SwimapSplitPaneUI.this.dividerLocationIsSet) {
                    this.setDividerLocation(n5 - n4, n2);
                } else {
                    this.setDividerLocation1(n5 - n4, n2);
                }
                SwimapSplitPaneUI.this.dividerLocationIsSet = false;
            } else if (n2 != this.lastSplitPaneSize) {
                this.distributeSpace(n2 - this.lastSplitPaneSize, SwimapSplitPaneUI.this.getKeepHiddenFlag());
            }
            this.doReset = false;
            SwimapSplitPaneUI.this.dividerLocationIsSet = false;
            this.lastSplitPaneSize = n2;
            int n6 = this.getInitialLocation(insets);
            int n7 = 0;
            block8: while (n7 < 3) {
                if (this.componentArray[n7] != null && this.componentArray[n7].isVisible()) {
                    this.setComponentToSize(this.componentArray[n7], this.sizeArray[n7], n6, insets, dimension);
                    n6 += this.sizeArray[n7];
                }
                switch (n7) {
                    case 0: {
                        n7 = 2;
                        continue block8;
                    }
                    case 1: {
                        n7 = 3;
                        continue block8;
                    }
                    case 2: {
                        n7 = 1;
                        continue block8;
                    }
                }
                n7 = 2;
            }
            if (SwimapSplitPaneUI.this.painted && (n = SwimapSplitPaneUI.this.getDividerLocation(SwimapSplitPaneUI.this.splitPane)) != n5 - n4) {
                int n8 = SwimapSplitPaneUI.this.splitPane.getLastDividerLocation();
                SwimapSplitPaneUI.this.ignoreDividerLocChange = true;
                try {
                    SwimapSplitPaneUI.this.splitPane.setDividerLocation(n);
                    SwimapSplitPaneUI.this.splitPane.setLastDividerLocation(n8);
                }
                finally {
                    SwimapSplitPaneUI.this.ignoreDividerLocChange = false;
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            Insets insets = SwimapSplitPaneUI.this.splitPane.getInsets();
            for (int i = 0; i < 3; ++i) {
                if (this.componentArray[i] == null) continue;
                Dimension dimension = this.componentArray[i].getMinimumSize();
                int n3 = this.getSecondaryAxisSize(dimension);
                n2 += this.getPrimaryAxisSize(dimension);
                if (n3 <= n) continue;
                n = n3;
            }
            if (insets != null) {
                n2 += this.getPrimaryAxisSize(insets, true) + this.getPrimaryAxisSize(insets, false);
                n += this.getSecondaryAxisSize(insets, true) + this.getSecondaryAxisSize(insets, false);
            }
            if (this.axis == 0) {
                return new Dimension(n2, n);
            }
            return new Dimension(n, n2);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            Insets insets = SwimapSplitPaneUI.this.splitPane.getInsets();
            for (int i = 0; i < 3; ++i) {
                if (this.componentArray[i] == null) continue;
                Dimension dimension = this.componentArray[i].getPreferredSize();
                int n3 = this.getSecondaryAxisSize(dimension);
                n += this.getPrimaryAxisSize(dimension);
                if (n3 <= n2) continue;
                n2 = n3;
            }
            if (insets != null) {
                n += this.getPrimaryAxisSize(insets, true) + this.getPrimaryAxisSize(insets, false);
                n2 += this.getSecondaryAxisSize(insets, true) + this.getSecondaryAxisSize(insets, false);
            }
            if (this.axis == 0) {
                return new Dimension(n, n2);
            }
            return new Dimension(n2, n);
        }

        @Override
        public void removeLayoutComponent(Component component) {
            for (int i = 0; i < 3; ++i) {
                if (this.componentArray[i] != component) continue;
                this.componentArray[i] = null;
                this.sizeArray[i] = 0;
                this.doReset = true;
            }
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
            if (object != null && !(object instanceof String)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
            }
            this.addLayoutComponent((String)object, component);
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container container) {
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public void resetToPreferredSizes() {
            this.doReset = true;
        }

        protected void resetSizeAt(int n) {
            this.sizeArray[n] = 0;
            this.doReset = true;
        }

        protected void setSizes(int[] nArray) {
            System.arraycopy(nArray, 0, this.sizeArray, 0, 3);
        }

        protected int[] getSizes() {
            int[] nArray = new int[3];
            System.arraycopy(this.sizeArray, 0, nArray, 0, 3);
            return nArray;
        }

        protected int getPreferredSizeOfComponent(Component component) {
            return this.getPrimaryAxisSize(component.getPreferredSize());
        }

        private int getMinimumSizeOfComponent(Component component) {
            return this.getPrimaryAxisSize(component.getMinimumSize());
        }

        protected int getSizeOfComponent(Component component) {
            return this.getPrimaryAxisSize(component.getSize());
        }

        protected int getAvailableSize(Dimension dimension, Insets insets) {
            if (insets == null) {
                return this.getPrimaryAxisSize(dimension);
            }
            return this.getPrimaryAxisSize(dimension) - (this.getPrimaryAxisSize(insets, true) + this.getPrimaryAxisSize(insets, false));
        }

        protected int getInitialLocation(Insets insets) {
            return insets == null ? 0 : this.getPrimaryAxisSize(insets, true);
        }

        protected void setComponentToSize(Component component, int n, int n2, Insets insets, Dimension dimension) {
            if (insets != null) {
                if (this.axis == 0) {
                    component.setBounds(n2, insets.top, n, dimension.height - (insets.top + insets.bottom));
                } else {
                    component.setBounds(insets.left, n2, dimension.width - (insets.left + insets.right), n);
                }
            } else if (this.axis == 0) {
                component.setBounds(n2, 0, n, dimension.height);
            } else {
                component.setBounds(0, n2, dimension.width, n);
            }
        }

        private int getPrimaryAxisSize(Dimension dimension) {
            return this.axis == 0 ? dimension.width : dimension.height;
        }

        private int getSecondaryAxisSize(Dimension dimension) {
            return this.axis == 0 ? dimension.height : dimension.width;
        }

        private int getPrimaryAxisSize(Insets insets, boolean bl) {
            if (this.axis == 0) {
                if (bl) {
                    return insets.left;
                }
                return insets.right;
            }
            if (bl) {
                return insets.top;
            }
            return insets.bottom;
        }

        private int getSecondaryAxisSize(Insets insets, boolean bl) {
            if (this.axis == 0) {
                if (bl) {
                    return insets.top;
                }
                return insets.bottom;
            }
            if (bl) {
                return insets.left;
            }
            return insets.right;
        }

        protected void updateComponents() {
            Component component = null;
            component = SwimapSplitPaneUI.this.splitPane.getLeftComponent();
            if (this.componentArray[0] != component) {
                this.componentArray[0] = component;
                this.sizeArray[0] = component == null ? 0 : -1;
            }
            if (this.componentArray[1] != (component = SwimapSplitPaneUI.this.splitPane.getRightComponent())) {
                this.componentArray[1] = component;
                this.sizeArray[1] = component == null ? 0 : -1;
            }
            Component[] componentArray = SwimapSplitPaneUI.this.splitPane.getComponents();
            Component component2 = this.componentArray[2];
            this.componentArray[2] = null;
            for (int i = componentArray.length - 1; i >= 0; --i) {
                if (componentArray[i] == this.componentArray[0] || componentArray[i] == this.componentArray[1] || componentArray[i] == SwimapSplitPaneUI.this.nonContinuousLayoutDivider) continue;
                if (component2 == componentArray[i]) {
                    this.componentArray[2] = component2;
                    break;
                }
                this.componentArray[2] = componentArray[i];
                break;
            }
            this.sizeArray[2] = this.componentArray[2] == null ? 0 : this.getPrimaryAxisSize(this.componentArray[2].getPreferredSize());
        }

        private void setDividerLocation(int n, int n2) {
            boolean bl = this.componentArray[0] != null && this.componentArray[0].isVisible();
            boolean bl2 = this.componentArray[1] != null && this.componentArray[1].isVisible();
            boolean bl3 = this.componentArray[2] != null && this.componentArray[2].isVisible();
            int n3 = n2;
            if (bl3) {
                n3 -= this.sizeArray[2];
            }
            n = Math.max(0, Math.min(n, n3));
            if (bl) {
                if (bl2) {
                    this.sizeArray[0] = n;
                    this.sizeArray[1] = n3 - n;
                } else {
                    this.sizeArray[0] = n3;
                    this.sizeArray[1] = 0;
                }
            } else if (bl2) {
                this.sizeArray[1] = n3;
                this.sizeArray[0] = 0;
            }
            if (this.sizeArray[0] == 0 && this.sizeArray[1] != 0) {
                SwimapSplitPaneUI.this.oneTouchFlag = -1;
                this.setDividerOneTouch(-1);
            } else if (this.sizeArray[0] != 0 && this.sizeArray[1] == 0) {
                SwimapSplitPaneUI.this.oneTouchFlag = 1;
                this.setDividerOneTouch(1);
            } else {
                SwimapSplitPaneUI.this.oneTouchFlag = 0;
                this.setDividerOneTouch(0);
            }
        }

        private void setDividerLocation1(int n, int n2) {
            boolean bl = this.componentArray[0] != null && this.componentArray[0].isVisible();
            boolean bl2 = this.componentArray[1] != null && this.componentArray[1].isVisible();
            boolean bl3 = this.componentArray[2] != null && this.componentArray[2].isVisible();
            int n3 = n2;
            int n4 = n;
            int n5 = 1;
            if (bl3) {
                n3 -= this.sizeArray[2];
            }
            if ((n = Math.max(0, Math.min(n, n3))) == 0 && n2 < this.sizeArray[2] && SwimapSplitPaneUI.this.oneTouchFlag == 0 && this.firstInit) {
                n += n5;
            }
            if (this.sizeArray[0] == 0 && this.sizeArray[1] == 0 && SwimapSplitPaneUI.this.oneTouchFlag == 0 && this.firstInit) {
                if (bl) {
                    if (bl2) {
                        if (n3 > 0) {
                            this.sizeArray[0] = n3 / 2;
                            this.sizeArray[1] = n3 - n3 / 2;
                        } else {
                            this.sizeArray[0] = 1;
                            this.sizeArray[1] = n3 - 1;
                        }
                    } else {
                        this.sizeArray[0] = n3;
                        this.sizeArray[1] = 0;
                    }
                } else if (bl2) {
                    this.sizeArray[1] = n3;
                    this.sizeArray[0] = 0;
                }
            } else if (bl) {
                if (bl2) {
                    this.sizeArray[0] = n;
                    this.sizeArray[1] = n3 - n;
                } else {
                    this.sizeArray[0] = n3;
                    this.sizeArray[1] = 0;
                }
            } else if (bl2) {
                this.sizeArray[1] = n3;
                this.sizeArray[0] = 0;
            }
            if (n2 <= n4 && (this.sizeArray[0] == 0 || this.sizeArray[1] == 0) && SwimapSplitPaneUI.this.oneTouchFlag == 0 && this.firstInit) {
                if (this.sizeArray[0] == 0 && this.sizeArray[1] != 0) {
                    if (this.sizeArray[1] > SwimapSplitPaneUI.this.splitSpace) {
                        this.sizeArray[1] = this.sizeArray[1] - SwimapSplitPaneUI.this.splitSpace;
                        this.sizeArray[0] = this.sizeArray[0] + SwimapSplitPaneUI.this.splitSpace;
                    } else if (0 < this.sizeArray[1] && this.sizeArray[1] <= SwimapSplitPaneUI.this.splitSpace) {
                        this.sizeArray[1] = this.sizeArray[1] - (this.sizeArray[1] + 1) / 2;
                        this.sizeArray[0] = this.sizeArray[0] + (this.sizeArray[1] + 1) / 2;
                    }
                    if (this.sizeArray[1] <= 0) {
                        this.sizeArray[0] = this.sizeArray[0] + 1;
                        this.sizeArray[1] = this.sizeArray[1] - 1;
                    }
                } else if (this.sizeArray[0] != 0 && this.sizeArray[1] == 0) {
                    if (this.sizeArray[0] >= SwimapSplitPaneUI.this.splitSpace) {
                        this.sizeArray[0] = this.sizeArray[0] - SwimapSplitPaneUI.this.splitSpace;
                        this.sizeArray[1] = this.sizeArray[1] + SwimapSplitPaneUI.this.splitSpace;
                    } else if (0 < this.sizeArray[0] && this.sizeArray[0] <= SwimapSplitPaneUI.this.splitSpace) {
                        this.sizeArray[0] = this.sizeArray[0] - (this.sizeArray[0] + 1) / 2;
                        this.sizeArray[1] = this.sizeArray[1] + (this.sizeArray[0] + 1) / 2;
                    }
                    if (this.sizeArray[0] <= 0) {
                        this.sizeArray[1] = this.sizeArray[1] + 1;
                        this.sizeArray[0] = this.sizeArray[0] - 1;
                    }
                }
            }
            if (!this.firstInit) {
                this.firstInit = true;
            }
            if (this.sizeArray[0] == 0 && this.sizeArray[1] != 0) {
                SwimapSplitPaneUI.this.oneTouchFlag = -1;
                this.setDividerOneTouch(-1);
            } else if (this.sizeArray[0] != 0 && this.sizeArray[1] == 0) {
                SwimapSplitPaneUI.this.oneTouchFlag = 1;
                this.setDividerOneTouch(1);
            } else {
                SwimapSplitPaneUI.this.oneTouchFlag = 0;
                this.setDividerOneTouch(0);
            }
        }

        private int[] getMinimumSizes() {
            int[] nArray = new int[3];
            for (int i = 0; i < 2; ++i) {
                Component component = this.componentArray[i];
                nArray[i] = component != null && component.isVisible() ? this.getMinimumSizeOfComponent(component) : -1;
            }
            nArray[2] = this.componentArray[2] != null ? this.getMinimumSizeOfComponent(this.componentArray[2]) : -1;
            return nArray;
        }

        private void setDividerOneTouch(int n) {
            if (SwimapSplitPaneUI.this.divider instanceof SwimapMetalSplitPaneDivider) {
                SwimapMetalSplitPaneDivider swimapMetalSplitPaneDivider = (SwimapMetalSplitPaneDivider)SwimapSplitPaneUI.this.divider;
                swimapMetalSplitPaneDivider.oneTouchFlag = n;
            }
        }

        private int[] getPreferredSizes() {
            int[] nArray = new int[3];
            for (int i = 0; i < 3; ++i) {
                Component component = this.componentArray[i];
                nArray[i] = component != null && component.isVisible() ? this.getPreferredSizeOfComponent(component) : -1;
            }
            return nArray;
        }

        private void distributeSpace(int n, boolean bl) {
            boolean bl2;
            boolean bl3 = this.componentArray[0] != null && this.componentArray[0].isVisible();
            boolean bl4 = bl2 = this.componentArray[1] != null && this.componentArray[1].isVisible();
            if (bl) {
                if (bl3 && this.getPrimaryAxisSize(this.componentArray[0].getSize()) == 0) {
                    bl3 = false;
                    if (bl2 && this.getPrimaryAxisSize(this.componentArray[1].getSize()) == 0) {
                        bl3 = true;
                    }
                } else if (bl2 && this.getPrimaryAxisSize(this.componentArray[1].getSize()) == 0) {
                    bl2 = false;
                }
            }
            if (bl3 && bl2) {
                boolean bl5;
                double d = SwimapSplitPaneUI.this.splitPane.getResizeWeight();
                int n2 = (int)(d * (double)n);
                int n3 = n - n2;
                this.sizeArray[0] = this.sizeArray[0] + n2;
                this.sizeArray[1] = this.sizeArray[1] + n3;
                int n4 = this.getMinimumSizeOfComponent(this.componentArray[0]);
                int n5 = this.getMinimumSizeOfComponent(this.componentArray[1]);
                boolean bl6 = this.sizeArray[0] >= n4;
                boolean bl7 = bl5 = this.sizeArray[1] >= n5;
                if (!bl6 && !bl5) {
                    if (this.sizeArray[0] < 0) {
                        this.sizeArray[1] = this.sizeArray[1] + this.sizeArray[0];
                        this.sizeArray[0] = 0;
                    } else if (this.sizeArray[1] < 0) {
                        this.sizeArray[0] = this.sizeArray[0] + this.sizeArray[1];
                        this.sizeArray[1] = 0;
                    }
                } else if (!bl6) {
                    if (this.sizeArray[1] - (n4 - this.sizeArray[0]) < n5) {
                        if (this.sizeArray[0] < 0) {
                            this.sizeArray[1] = this.sizeArray[1] + this.sizeArray[0];
                            this.sizeArray[0] = 0;
                        }
                    } else {
                        this.sizeArray[1] = this.sizeArray[1] - (n4 - this.sizeArray[0]);
                        this.sizeArray[0] = n4;
                    }
                } else if (!bl5) {
                    if (this.sizeArray[0] - (n5 - this.sizeArray[1]) < n4) {
                        if (this.sizeArray[1] < 0) {
                            this.sizeArray[0] = this.sizeArray[0] + this.sizeArray[1];
                            this.sizeArray[1] = 0;
                        }
                    } else {
                        this.sizeArray[0] = this.sizeArray[0] - (n5 - this.sizeArray[1]);
                        this.sizeArray[1] = n5;
                    }
                }
                if (this.sizeArray[0] < 0) {
                    this.sizeArray[0] = 0;
                }
                if (this.sizeArray[1] < 0) {
                    this.sizeArray[1] = 0;
                }
            } else if (bl3) {
                this.sizeArray[0] = Math.max(0, this.sizeArray[0] + n);
            } else if (bl2) {
                this.sizeArray[1] = Math.max(0, this.sizeArray[1] + n);
            }
            if (SwimapSplitPaneUI.this.oneTouchFlag == 0 && (this.sizeArray[0] == 0 || this.sizeArray[1] == 0) && this.firstInit) {
                if (this.sizeArray[0] == 0 && this.sizeArray[1] != 0) {
                    if (this.sizeArray[1] > SwimapSplitPaneUI.this.splitSpace) {
                        this.sizeArray[1] = this.sizeArray[1] - SwimapSplitPaneUI.this.splitSpace;
                        this.sizeArray[0] = this.sizeArray[0] + SwimapSplitPaneUI.this.splitSpace;
                    } else if (0 < this.sizeArray[1] && this.sizeArray[1] <= SwimapSplitPaneUI.this.splitSpace) {
                        this.sizeArray[1] = this.sizeArray[1] - (this.sizeArray[1] + 1) / 2;
                        this.sizeArray[0] = this.sizeArray[0] + (this.sizeArray[1] + 1) / 2;
                    }
                    if (this.sizeArray[1] <= 0) {
                        this.sizeArray[0] = this.sizeArray[0] + 1;
                        this.sizeArray[1] = this.sizeArray[1] - 1;
                    }
                } else if (this.sizeArray[0] != 0 && this.sizeArray[1] == 0) {
                    if (this.sizeArray[0] >= SwimapSplitPaneUI.this.splitSpace) {
                        this.sizeArray[0] = this.sizeArray[0] - SwimapSplitPaneUI.this.splitSpace;
                        this.sizeArray[1] = this.sizeArray[1] + SwimapSplitPaneUI.this.splitSpace;
                    } else if (0 < this.sizeArray[0] && this.sizeArray[0] <= SwimapSplitPaneUI.this.splitSpace) {
                        this.sizeArray[0] = this.sizeArray[0] - (this.sizeArray[0] + 1) / 2;
                        this.sizeArray[1] = this.sizeArray[1] + (this.sizeArray[0] + 1) / 2;
                    }
                    if (this.sizeArray[0] <= 0) {
                        this.sizeArray[1] = this.sizeArray[1] + 1;
                        this.sizeArray[0] = this.sizeArray[0] - 1;
                    }
                } else if (this.sizeArray[0] == 0 && this.sizeArray[1] == 0) {
                    this.sizeArray[0] = this.sizeArray[0] + 1;
                    this.sizeArray[1] = this.sizeArray[1] - 1;
                }
            }
            if (!this.firstInit) {
                this.firstInit = true;
            }
        }

        private void resetToPreferredSizes(int n) {
            int n2;
            int[] nArray = this.getPreferredSizes();
            int n3 = 0;
            for (n2 = 0; n2 < 3; ++n2) {
                if (nArray[n2] == -1) continue;
                n3 += nArray[n2];
            }
            if (n3 > n) {
                n3 = 0;
                nArray = this.getMinimumSizes();
                for (n2 = 0; n2 < 3; ++n2) {
                    if (nArray[n2] == -1) continue;
                    n3 += nArray[n2];
                }
            }
            this.setSizes(nArray);
            this.distributeSpace(n - n3, false);
        }

        private boolean checkForDemaximizeAll() {
            MainDesktopPane mainDesktopPane;
            WindowManager windowManager = FrameworkUtilities.getWindowManager();
            if (windowManager != null && (mainDesktopPane = windowManager.getDesktopPane()) != null) {
                return mainDesktopPane.isDemaxAll();
            }
            return false;
        }
    }
}

