/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.text.Position;
import javax.swing.tree.TreePath;

public class SwimapMetalTreeUI
extends MetalTreeUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new SwimapMetalTreeUI();
    }

    @Override
    protected KeyListener createKeyListener() {
        return new TreeKeyHandler();
    }

    private class TreeKeyHandler
    extends KeyAdapter {
        protected Action repeatKeyAction = null;
        protected boolean isKeyDown = false;

        private TreeKeyHandler() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (SwimapMetalTreeUI.this.tree != null && SwimapMetalTreeUI.this.tree.getRowCount() > 0 && SwimapMetalTreeUI.this.tree.hasFocus() && SwimapMetalTreeUI.this.tree.isEnabled()) {
                TreePath treePath;
                if (keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown()) {
                    return;
                }
                boolean bl = true;
                char[] cArray = new char[]{keyEvent.getKeyChar()};
                String string = new String(cArray);
                int n = SwimapMetalTreeUI.this.tree.getMinSelectionRow() + 1;
                if (n < 0 || n >= SwimapMetalTreeUI.this.tree.getRowCount()) {
                    bl = false;
                    n = 0;
                }
                if ((treePath = SwimapMetalTreeUI.this.tree.getNextMatch(string, n, Position.Bias.Forward)) != null) {
                    SwimapMetalTreeUI.this.tree.setSelectionPath(treePath);
                    SwimapMetalTreeUI.this.tree.scrollPathToVisible(treePath);
                } else if (bl && (treePath = SwimapMetalTreeUI.this.tree.getNextMatch(string, 0, Position.Bias.Forward)) != null) {
                    SwimapMetalTreeUI.this.tree.setSelectionPath(treePath);
                    SwimapMetalTreeUI.this.tree.scrollPathToVisible(treePath);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (SwimapMetalTreeUI.this.tree != null && SwimapMetalTreeUI.this.tree.hasFocus() && SwimapMetalTreeUI.this.tree.isEnabled()) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
                if (SwimapMetalTreeUI.this.tree.getConditionForKeyStroke(keyStroke) == 0) {
                    ActionListener actionListener = SwimapMetalTreeUI.this.tree.getActionForKeyStroke(keyStroke);
                    if (actionListener instanceof Action) {
                        this.repeatKeyAction = (Action)actionListener;
                        if (!this.repeatKeyAction.isEnabled()) {
                            this.repeatKeyAction = null;
                        }
                    } else {
                        this.repeatKeyAction = null;
                    }
                } else {
                    this.repeatKeyAction = null;
                }
                if (this.isKeyDown && this.repeatKeyAction != null) {
                    this.repeatKeyAction.actionPerformed(new ActionEvent(SwimapMetalTreeUI.this.tree, 1001, "", keyEvent.getWhen(), keyEvent.getModifiers()));
                    keyEvent.consume();
                } else {
                    this.isKeyDown = true;
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.isKeyDown = false;
        }
    }
}

