/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel;

import com.swimap.iview.framework.lookandfeel.DownButtonState;
import com.swimap.iview.framework.lookandfeel.LeftButtonState;
import com.swimap.iview.framework.lookandfeel.MetalSplitPaneDivider;
import com.swimap.iview.framework.lookandfeel.RightButtonState;
import com.swimap.iview.framework.lookandfeel.SplitButton;
import com.swimap.iview.framework.lookandfeel.SwimapSplitPaneUI;
import com.swimap.iview.framework.lookandfeel.TopButtonState;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class SwimapMetalSplitPaneDivider
extends MetalSplitPaneDivider {
    public static final String INIT_STATE_CHANGED = "init state changed";
    private PropertyChangeSupport propertyChangeListeners = new PropertyChangeSupport(this);
    protected int oneTouchFlag = 0;
    private boolean initState = true;

    public SwimapMetalSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
        super(basicSplitPaneUI);
        this.splitPane.addPropertyChangeListener(new PositionListener());
        this.splitPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals(SwimapMetalSplitPaneDivider.INIT_STATE_CHANGED)) {
                    SwimapMetalSplitPaneDivider.this.setInitState(SwimapMetalSplitPaneDivider.this.splitButton, (Boolean)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    public void setOneTouchFlag(int n) {
        int n2 = this.oneTouchFlag;
        this.oneTouchFlag = n;
        this.propertyChangeListeners.firePropertyChange("oneTouchFlag", (Object)n2, (Object)n);
    }

    public int getOneTouchFlag() {
        return this.oneTouchFlag;
    }

    @Override
    protected void oneTouchExpandableChanged() {
        if (this.splitPane.isOneTouchExpandable() && this.splitButton == null) {
            this.splitButton = this.createOneTouchButton(true);
            this.splitPane.setLastDividerLocation(-1);
            if (this.splitButton != null) {
                this.splitButton.addActionListener(new OneTouchActionHandler(this.splitButton));
                this.add(this.splitButton);
            }
        }
        this.invalidate();
        this.validate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getSource() == this.splitPane && propertyChangeEvent.getPropertyName().equals("orientation")) {
            this.setInitState(this.splitButton, this.initState);
            this.invalidate();
            this.validate();
        }
    }

    protected SplitButton createOneTouchButton(boolean bl) {
        SplitButton splitButton = new SplitButton();
        if (this.splitPane != null) {
            this.orientation = this.splitPane.getOrientation();
            this.setInitState(splitButton, bl);
        }
        splitButton.setCursor(Cursor.getPredefinedCursor(0));
        splitButton.setFocusPainted(false);
        splitButton.setBorderPainted(false);
        splitButton.setRequestFocusEnabled(false);
        return splitButton;
    }

    private void setInitState(SplitButton splitButton, boolean bl) {
        this.initState = bl;
        if (splitButton == null) {
            return;
        }
        if (this.orientation == 0) {
            splitButton.setButtonState(bl ? DownButtonState.getInstance() : TopButtonState.getInstance());
        } else {
            splitButton.setButtonState(bl ? LeftButtonState.getInstance() : RightButtonState.getInstance());
        }
    }

    private void setOneTouchFlagHander(boolean bl) {
        int n = this.oneTouchFlag;
        if (bl) {
            if (n != -1) {
                this.setOneTouchFlag(--n);
            }
        } else if (n != 1) {
            this.setOneTouchFlag(++n);
        }
    }

    private void oneTouchAction(boolean bl) {
        Insets insets = this.splitPane.getInsets();
        int n = this.splitPane.getLastDividerLocation();
        int n2 = this.splitPaneUI.getDividerLocation(this.splitPane);
        int n3 = 0;
        if (bl) {
            if (this.orientation == 0) {
                if (n2 >= this.splitPane.getHeight() - insets.bottom - this.getHeight()) {
                    int n4 = this.splitPane.getMaximumDividerLocation();
                    n3 = Math.min(n, n4);
                    if (this.splitPaneUI instanceof SwimapSplitPaneUI) {
                        ((SwimapSplitPaneUI)this.splitPaneUI).setKeepHiddenFlag(false);
                    }
                } else {
                    n3 = insets.top;
                    if (this.splitPaneUI instanceof SwimapSplitPaneUI) {
                        ((SwimapSplitPaneUI)this.splitPaneUI).setKeepHiddenFlag(true);
                    }
                }
            } else if (n2 >= this.splitPane.getWidth() - insets.right - this.getWidth()) {
                int n5 = this.splitPane.getMaximumDividerLocation();
                n3 = Math.min(n, n5);
                if (this.splitPaneUI instanceof SwimapSplitPaneUI) {
                    ((SwimapSplitPaneUI)this.splitPaneUI).setKeepHiddenFlag(false);
                }
            } else {
                n3 = insets.left;
                if (this.splitPaneUI instanceof SwimapSplitPaneUI) {
                    ((SwimapSplitPaneUI)this.splitPaneUI).setKeepHiddenFlag(true);
                }
            }
        } else if (this.orientation == 0) {
            if (n2 == insets.top) {
                int n6 = this.splitPane.getMaximumDividerLocation();
                n3 = Math.min(n, n6);
                if (this.splitPaneUI instanceof SwimapSplitPaneUI) {
                    ((SwimapSplitPaneUI)this.splitPaneUI).setKeepHiddenFlag(false);
                }
            } else {
                n3 = this.splitPane.getHeight() - this.getHeight() - insets.top;
                if (this.splitPaneUI instanceof SwimapSplitPaneUI) {
                    ((SwimapSplitPaneUI)this.splitPaneUI).setKeepHiddenFlag(true);
                }
            }
        } else if (n2 == insets.left) {
            int n7 = this.splitPane.getMaximumDividerLocation();
            n3 = Math.min(n, n7);
            if (this.splitPaneUI instanceof SwimapSplitPaneUI) {
                ((SwimapSplitPaneUI)this.splitPaneUI).setKeepHiddenFlag(false);
            }
        } else {
            n3 = this.splitPane.getWidth() - this.getWidth() - insets.left;
            if (this.splitPaneUI instanceof SwimapSplitPaneUI) {
                ((SwimapSplitPaneUI)this.splitPaneUI).setKeepHiddenFlag(true);
            }
        }
        if (n2 != n3) {
            this.splitPane.setDividerLocation(n3);
            this.splitPane.setLastDividerLocation(n2);
        }
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.propertyChangeListeners.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.propertyChangeListeners.addPropertyChangeListener(propertyChangeListener);
    }

    private class PositionListener
    implements PropertyChangeListener {
        private PositionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("dividerLocation")) {
                int n = (Integer)propertyChangeEvent.getOldValue();
                int n2 = (Integer)propertyChangeEvent.getNewValue();
                if (null != SwimapMetalSplitPaneDivider.this.splitPane && SwimapMetalSplitPaneDivider.this.splitPane.getHeight() > SwimapMetalSplitPaneDivider.this.splitPane.getDividerSize() && SwimapMetalSplitPaneDivider.this.splitButton != null && SwimapMetalSplitPaneDivider.this.splitButton.isNeedChangeState(SwimapMetalSplitPaneDivider.this.splitPane, SwimapMetalSplitPaneDivider.this.initState, n2, n)) {
                    SwimapMetalSplitPaneDivider.this.splitButton.setButtonState(SwimapMetalSplitPaneDivider.this.splitButton.buttonState.nextButtonState());
                }
            }
        }
    }

    private class OneTouchActionHandler
    implements ActionListener {
        private SplitButton splitButton = null;

        OneTouchActionHandler(SplitButton splitButton) {
            this.splitButton = splitButton;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwimapMetalSplitPaneDivider.this.oneTouchAction(this.splitButton.buttonState.isToMinimum());
            SwimapMetalSplitPaneDivider.this.setOneTouchFlagHander(this.splitButton.buttonState.getFlag());
            this.splitButton.getModel().setRollover(false);
        }
    }
}

