/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.lookandfeel.button.SwimapButtonWithouBGUI;
import com.swimap.iview.templates.utils.MultiRowToolTip;
import com.swimap.iview.util.adapter.LineWrapper;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class SwimapInternalFrameTitlePane
extends MetalInternalFrameTitlePane {
    private static IviewLogger logger = IviewLogger.getLogger(SwimapInternalFrameTitlePane.class, "IVIEW");
    private static final int MAX_LINE_TOOLTIP = 10;
    private static final int TITLE_PANEL_HIGHT = 25;
    private static final int MINI_WIDTH = 30;
    private static final int CLOSABLE_WIDTH = 21;
    private static final int MAXIMIABLE_WIDTH = 16;
    private static final int ICONIFIABLE_WIDTH = 16;
    public static final int NORMAL = 0;
    public static final int HOVER = 1;
    public static final int PRESSED = 2;
    private ImageIcon activeTitleIcon = new ImageIcon(SwimapInternalFrameTitlePane.class.getResource("title_act.gif"));
    private ImageIcon inactiveTitleIcon = new ImageIcon(SwimapInternalFrameTitlePane.class.getResource("title_inact.gif"));
    private static ImageIcon[] maxButtons = new ImageIcon[]{new ImageIcon(SwimapInternalFrameTitlePane.class.getResource("btnmax_normal.gif")), new ImageIcon(SwimapInternalFrameTitlePane.class.getResource("btnmax_hover.gif")), new ImageIcon(SwimapInternalFrameTitlePane.class.getResource("btnmax_pressed.gif"))};
    private static ImageIcon[] minButtons = new ImageIcon[]{new ImageIcon(SwimapInternalFrameTitlePane.class.getResource("btnmin_normal.gif")), new ImageIcon(SwimapInternalFrameTitlePane.class.getResource("btnmin_hover.gif")), new ImageIcon(SwimapInternalFrameTitlePane.class.getResource("btnmin_pressed.gif"))};
    private static ImageIcon[] closeButtons = new ImageIcon[]{new ImageIcon(SwimapInternalFrameTitlePane.class.getResource("btncls_normal.gif")), new ImageIcon(SwimapInternalFrameTitlePane.class.getResource("btncls_hover.gif")), new ImageIcon(SwimapInternalFrameTitlePane.class.getResource("btncls_pressed.gif"))};
    private static ImageIcon[] restoreButtons = new ImageIcon[]{new ImageIcon(SwimapInternalFrameTitlePane.class.getResource("btnrestore_normal.gif")), new ImageIcon(SwimapInternalFrameTitlePane.class.getResource("btnrestore_hover.gif")), new ImageIcon(SwimapInternalFrameTitlePane.class.getResource("btnrestore_pressed.gif"))};

    public SwimapInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 25));
    }

    @Override
    protected void createButtons() {
        super.createButtons();
        this.iconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwimapInternalFrameTitlePane.this.iconButton.setIcon(SwimapInternalFrameTitlePane.this.iconButton.getPressedIcon());
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                try {
                    SwimapInternalFrameTitlePane.this.frame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    logger.trace(propertyVetoException.getMessage(), propertyVetoException);
                }
            }
        };
        this.closeButton.addMouseListener(mouseAdapter);
        this.closeButton.setUI(new SwimapButtonWithouBGUI());
        this.iconButton.addMouseListener(mouseAdapter);
        this.iconButton.setUI(new SwimapButtonWithouBGUI());
        this.maxButton.addMouseListener(mouseAdapter);
        this.maxButton.setUI(new SwimapButtonWithouBGUI());
    }

    private static final boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    private JInternalFrame getFrame() {
        return this.frame;
    }

    private JButton getIconButton() {
        return this.iconButton;
    }

    public JButton getCloseButton() {
        return this.closeButton;
    }

    private JButton getMaxButton() {
        return this.maxButton;
    }

    @Override
    public void paintPalette(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        ColorUIResource colorUIResource = MetalLookAndFeel.getPrimaryControlShadow();
        ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControlDarkShadow();
        graphics.setColor(colorUIResource);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(colorUIResource2);
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        int n2 = 0;
        ImageIcon imageIcon = null;
        if (this.isPalette) {
            this.paintPalette(graphics);
            return;
        }
        boolean bl = SwimapInternalFrameTitlePane.isLeftToRight(this.frame);
        boolean bl2 = this.frame.isSelected();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        Color color = null;
        Color color2 = null;
        ColorUIResource colorUIResource = null;
        if (bl2) {
            color = (Color)UIManager.get("InternalFrame.activeTitleBackground");
            color2 = (Color)UIManager.get("InternalFrame.activeTitleForeground");
            colorUIResource = MetalLookAndFeel.getPrimaryControlDarkShadow();
            imageIcon = this.activeTitleIcon;
        } else {
            color = MetalLookAndFeel.getWindowTitleInactiveBackground();
            color2 = UIManager.getColor("InternalFrame.inactiveTitleForeground");
            colorUIResource = MetalLookAndFeel.getControlDarkShadow();
            imageIcon = this.inactiveTitleIcon;
        }
        graphics.setColor(color);
        if (imageIcon != null) {
            graphics.drawImage(imageIcon.getImage(), 0, 0, n3, n4, null);
        }
        graphics.setColor(colorUIResource);
        graphics.drawLine(0, n4 - 1, n3, n4 - 1);
        int n5 = bl ? 5 : n3 - 5;
        String string = this.frame.getTitle();
        Icon icon = this.frame.getFrameIcon();
        int n6 = this.getIconButton().getWidth() + this.getMaxButton().getWidth() + this.getCloseButton().getWidth();
        if (icon != null && this.getWidth() - n6 - icon.getIconWidth() - 5 > 0) {
            if (!bl) {
                n5 -= icon.getIconWidth();
            }
            n = n4 / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, graphics, n5, n);
            n5 += bl ? icon.getIconWidth() + 5 : -5;
        }
        if (string != null) {
            String string2;
            n = this.getWidth() - Math.abs(n5) - (this.getIconButton().getWidth() + this.getMaxButton().getWidth() + this.getCloseButton().getWidth()) - 15;
            if (n < 0) {
                n = 0;
            }
            if (!ResourceUtil.areEqualsIgnoreCase(string2 = LineWrapper.getAbbreviatoryString(string, n, this.getFont()), string)) {
                this.setToolTipText(string);
                string = string2;
            } else {
                this.setToolTipText(null);
            }
            if (n > 0) {
                Font font = this.getFont();
                graphics.setFont(font);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                n2 = fontMetrics.stringWidth(string);
                graphics.setColor(color2);
                int n7 = (n4 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
                if (!bl) {
                    n5 -= n2;
                }
                graphics.drawString(string, n5, n7);
                n5 += bl ? n2 + 5 : -5;
            }
        } else {
            this.setToolTipText(null);
        }
    }

    @Override
    protected LayoutManager createLayout() {
        return new SwimapTitlePaneLayout();
    }

    @Override
    public JToolTip createToolTip() {
        MultiRowToolTip multiRowToolTip = new MultiRowToolTip();
        multiRowToolTip.setMaxLineNumber(10);
        multiRowToolTip.setComponent(this);
        return multiRowToolTip;
    }

    public static void installIcon(AbstractButton abstractButton, ImageIcon[] imageIconArray) {
        if (abstractButton == null || imageIconArray == null || imageIconArray.length < 3) {
            throw new IllegalArgumentException("Invalid arguments.");
        }
        abstractButton.setIcon(imageIconArray[0]);
        abstractButton.setRolloverIcon(imageIconArray[1]);
        abstractButton.setPressedIcon(imageIconArray[2]);
        abstractButton.setMargin(new Insets(0, 0, 0, 0));
        abstractButton.setBorderPainted(false);
        abstractButton.setContentAreaFilled(false);
        abstractButton.putClientProperty("DISABLE_UI_PIC", "true");
    }

    @Override
    protected void setButtonIcons() {
        super.setButtonIcons();
        if (this.frame.isIcon()) {
            SwimapInternalFrameTitlePane.installIcon(this.iconButton, minButtons);
            SwimapInternalFrameTitlePane.installIcon(this.maxButton, maxButtons);
        } else if (this.frame.isMaximum()) {
            SwimapInternalFrameTitlePane.installIcon(this.iconButton, minButtons);
            SwimapInternalFrameTitlePane.installIcon(this.maxButton, restoreButtons);
        } else {
            SwimapInternalFrameTitlePane.installIcon(this.iconButton, minButtons);
            SwimapInternalFrameTitlePane.installIcon(this.maxButton, maxButtons);
        }
        SwimapInternalFrameTitlePane.installIcon(this.closeButton, closeButtons);
    }

    public static ImageIcon[] getInternalFrameMaxIcons() {
        return maxButtons;
    }

    public static ImageIcon[] getInternalFrameMinIcons() {
        return minButtons;
    }

    public static ImageIcon[] getInternalFrameRestoreIcons() {
        return restoreButtons;
    }

    public static ImageIcon[] getInternalFrameCloseIcons() {
        return closeButtons;
    }

    private final class SwimapTitlePaneLayout
    implements LayoutManager {
        private SwimapTitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            int n;
            int n2;
            int n3 = 30;
            int n4 = 0;
            if (SwimapInternalFrameTitlePane.this.frame.isClosable()) {
                n3 += 21;
            }
            if (SwimapInternalFrameTitlePane.this.frame.isMaximizable()) {
                n3 += 16 + (SwimapInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (SwimapInternalFrameTitlePane.this.frame.isIconifiable()) {
                n3 += 21 + (SwimapInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (SwimapInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics fontMetrics = SwimapInternalFrameTitlePane.this.getFontMetrics(SwimapInternalFrameTitlePane.this.getFont());
            String string = SwimapInternalFrameTitlePane.this.frame.getTitle();
            int n5 = string != null ? fontMetrics.stringWidth(string) : 0;
            int n6 = n2 = string != null ? string.length() : 0;
            n3 = n2 > 2 ? (n3 += n5 < (n = fontMetrics.stringWidth(SwimapInternalFrameTitlePane.this.frame.getTitle().substring(0, 2) + "...")) ? n5 : n) : (n3 += n5);
            if (SwimapInternalFrameTitlePane.this.isPalette) {
                n4 = SwimapInternalFrameTitlePane.this.paletteTitleHeight;
            } else {
                n = fontMetrics.getHeight();
                n += 7;
                Icon icon = SwimapInternalFrameTitlePane.this.frame.getFrameIcon();
                int n7 = 0;
                if (icon != null) {
                    n7 = Math.min(icon.getIconHeight(), 12);
                }
                n4 = Math.min(n, n7 += 5) + 6;
            }
            return new Dimension(n3, n4);
        }

        @Override
        public void layoutContainer(Container container) {
            JButton jButton;
            JInternalFrame jInternalFrame = SwimapInternalFrameTitlePane.this.getFrame();
            boolean bl = SwimapInternalFrameTitlePane.isLeftToRight(jInternalFrame);
            int n = SwimapInternalFrameTitlePane.this.getWidth();
            int n2 = bl ? n : 0;
            int n3 = 2;
            int n4 = 0;
            JButton jButton2 = SwimapInternalFrameTitlePane.this.getCloseButton();
            int n5 = jButton2.getIcon().getIconHeight();
            int n6 = jButton2.getIcon().getIconWidth();
            if (jInternalFrame.isClosable()) {
                if (SwimapInternalFrameTitlePane.this.isPalette) {
                    n4 = 0;
                    n2 = bl ? n2 - n4 - (n6 + 2) : n2 + n4;
                    jButton2.setBounds(n2, n3, n6 + 2, SwimapInternalFrameTitlePane.this.getHeight() - 4);
                    if (!bl) {
                        n2 += n6 + 2;
                    }
                } else {
                    n4 = 1;
                    n2 = bl ? n2 - n4 - n6 : n2 + n4;
                    jButton2.setBounds(n2, n3, n6, n5);
                    if (!bl) {
                        n2 += n6;
                    }
                }
            }
            if (jInternalFrame.isMaximizable() && !SwimapInternalFrameTitlePane.this.isPalette) {
                jButton = SwimapInternalFrameTitlePane.this.getMaxButton();
                n4 = 1;
                n2 = bl ? n2 - n4 - n6 : n2 + n4;
                jButton.setBounds(n2, n3, n6, n5);
                if (!bl) {
                    n2 += n6;
                }
            }
            if (jInternalFrame.isIconifiable() && !SwimapInternalFrameTitlePane.this.isPalette) {
                jButton = SwimapInternalFrameTitlePane.this.getIconButton();
                n4 = jInternalFrame.isMaximizable() ? 0 : 1;
                n2 = bl ? n2 - n4 - n6 : n2 + n4;
                jButton.setBounds(n2, n3, n6, n5);
                if (!bl) {
                    n2 += n6;
                }
            }
        }
    }
}

