/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.util.FileChooserFilter;
import com.swimap.iview.util.OpenFileChooser;
import com.swimap.iview.util.ReflectionUtilities;
import com.swimap.iview.util.SaveFileChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.plaf.metal.MetalFileChooserUI;

public class SwimapFileChooseUI
extends MetalFileChooserUI {
    static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/util/Res");
    private static final int MIN_SIZE = 60;
    private static final int PRE_SIZE = 150;
    private JComboBox encodingFilter = null;
    private static final String GBK_ENCODING = "GBK";
    private static final String UTF_ENCODING = "UTF-8";
    private static final String ISO_ENCODING = "ISO-8859-1";
    JFileChooser fileChooser = null;

    public SwimapFileChooseUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SwimapFileChooseUI((JFileChooser)jComponent);
    }

    @Override
    public boolean isDirectorySelected() {
        return super.isDirectorySelected();
    }

    @Override
    public File getDirectory() {
        return super.getDirectory();
    }

    @Override
    protected MetalFileChooserUI.FilterComboBoxModel createFilterComboBoxModel() {
        return new SwImapFilterComboBoxModel();
    }

    public String processResetFileName() {
        int n;
        String string = this.getFileName();
        String string2 = null;
        String string3 = null;
        FileFilter[] fileFilterArray = this.getFileChooser().getChoosableFileFilters();
        String string4 = null;
        int n2 = 0;
        int n3 = 0;
        if (string != null && (n = string.lastIndexOf(".")) != -1) {
            string4 = string.substring(n);
            for (int i = 0; i < fileFilterArray.length; ++i) {
                string2 = fileFilterArray[i].getDescription();
                n2 = string2.lastIndexOf(".");
                n3 = string2.lastIndexOf(")");
                if (n2 == -1 || n3 == -1 || !(string3 = string2.substring(n2, n3)).equalsIgnoreCase(string4)) continue;
                string2 = this.getFileChooser().getFileFilter().getDescription();
                n2 = string2.lastIndexOf(".");
                n3 = string2.lastIndexOf(")");
                if (n2 == -1 || n3 == -1) {
                    return string;
                }
                string3 = string2.substring(n2, n3);
                boolean bl = Boolean.getBoolean("isFileExtensionChange");
                if (!string4.equalsIgnoreCase(string3) && bl) {
                    string4 = string3;
                    string = string.substring(0, n) + string4;
                }
                return string;
            }
        }
        return string;
    }

    @Override
    public void installComponents(JFileChooser jFileChooser) {
        this.fileChooser = jFileChooser;
        super.installComponents(jFileChooser);
        try {
            this.fixJDKBug1_4_2();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fixJDKBug1_4_2() throws Exception {
        Class<?> clazz = Class.forName("javax.swing.plaf.metal.MetalFileChooserUI");
        Field field = clazz.getDeclaredField("directoryComboBox");
        field.setAccessible(true);
        JComboBox jComboBox = (JComboBox)field.get(this);
        Dimension dimension = jComboBox.getMinimumSize();
        dimension.width = 60;
        jComboBox.setMinimumSize(dimension);
        dimension = jComboBox.getPreferredSize();
        dimension.width = 150;
        jComboBox.setPreferredSize(dimension);
    }

    @Override
    protected JPanel createDetailsView(JFileChooser jFileChooser) {
        JPanel jPanel = super.createDetailsView(jFileChooser);
        this.setFilePaneUI(jPanel);
        return jPanel;
    }

    private void setFilePaneUI(JPanel jPanel) {
        Component component = null;
        Component component2 = null;
        Component component3 = null;
        int n = jPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            component = jPanel.getComponent(i);
            if (!(component instanceof JScrollPane)) continue;
            JScrollPane jScrollPane = (JScrollPane)component;
            int n2 = jScrollPane.getComponentCount();
            for (int j = 0; j < n2; ++j) {
                component2 = jScrollPane.getComponent(j);
                if (!(component2 instanceof JViewport)) continue;
                JViewport jViewport = (JViewport)component2;
                int n3 = jViewport.getComponentCount();
                for (int k = 0; k < n3; ++k) {
                    component3 = jViewport.getComponent(k);
                    if (!(component3 instanceof JTable)) continue;
                    JTable jTable = (JTable)component3;
                    jTable.setUI(new BasicTableUI());
                }
            }
        }
    }

    @Override
    protected void addControlButtons() {
        if (this.fileChooser instanceof SaveFileChooser && ((SaveFileChooser)this.fileChooser).isEncodingEnabled() || this.fileChooser instanceof OpenFileChooser && ((OpenFileChooser)this.fileChooser).isEncodingEnabled()) {
            JPanel jPanel = super.getBottomPanel();
            Component component = null;
            JComboBox jComboBox = null;
            Object object = null;
            Component component2 = jPanel.getComponent(0);
            if (component2 instanceof JPanel) {
                component = ((JPanel)component2).getComponent(0);
            }
            Component component3 = null;
            Component component4 = jPanel.getComponent(2);
            if (component4 instanceof JPanel) {
                component3 = ((JPanel)component4).getComponent(0);
                jComboBox = (JComboBox)((JPanel)component4).getComponent(1);
                jComboBox.addItemListener(new FileTypeListener());
                object = jComboBox.getSelectedItem();
            }
            int n = 70;
            if (null != component3 && null != component) {
                n = component.getMaximumSize().width > component3.getMaximumSize().width ? component.getMaximumSize().width : component3.getMaximumSize().width;
            }
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 2));
            Dimension dimension = new Dimension(1, 5);
            jPanel.add(Box.createRigidArea(dimension));
            JLabel jLabel = new JLabel(res.getString("encoding"));
            jLabel.setToolTipText(jLabel.getText());
            jLabel.setPreferredSize(new Dimension(n + 11, 25));
            this.encodingFilter = new JComboBox();
            jLabel.setLabelFor(this.encodingFilter);
            jLabel.setDisplayedMnemonic('E');
            this.encodingFilter.setName("Encoding_ComboBox");
            if (object != null) {
                String[] stringArray = this.getEncodingValues((FileFilter)object);
                this.encodingFilter.setModel(new DefaultComboBoxModel<String>(stringArray));
                if (stringArray.length > 1) {
                    this.encodingFilter.setEnabled(true);
                } else {
                    this.encodingFilter.setEnabled(false);
                }
            } else {
                this.encodingFilter.setEnabled(false);
            }
            jPanel2.add(jLabel);
            jPanel2.add(this.encodingFilter);
            jPanel.add(jPanel2);
            jPanel.add(this.getButtonPanel());
        } else {
            super.addControlButtons();
        }
    }

    private String[] getEncodingValues(FileFilter fileFilter) {
        String string = "";
        if (fileFilter instanceof FileChooserFilter) {
            Object object;
            FileChooserFilter fileChooserFilter = (FileChooserFilter)fileFilter;
            string = (String)ReflectionUtilities.getFieldByObject(fileChooserFilter, "fileType");
            if (null == string) {
                object = fileChooserFilter.getAllFilters();
                string = ((LinkedList)object).size() > 0 ? ((LinkedList)object).get(0).toString().trim() : "";
            }
            object = ResourceMng.getInstance().getLocaleString();
            String[] stringArray = new String[]{};
            if (string.equals("xls") || string.equals("xlsx") || string.equals("pdf") || string.equals("html") || string.equals("xml")) {
                return stringArray;
            }
            if (string.equals("txt")) {
                return this.getLocaleBasedEncoding();
            }
            if (string.equals("csv")) {
                stringArray = new String[1];
                stringArray[0] = ((String)object).equalsIgnoreCase("zh_CN") ? GBK_ENCODING : UTF_ENCODING;
            } else {
                return this.getLocaleBasedEncoding();
            }
            return stringArray;
        }
        return this.getLocaleBasedEncoding();
    }

    private String[] getLocaleBasedEncoding() {
        String[] stringArray = new String[]{};
        String string = ResourceMng.getInstance().getLocaleString();
        if (this.fileChooser instanceof SaveFileChooser) {
            stringArray = new String[]{string.equalsIgnoreCase("zh_CN") ? GBK_ENCODING : ISO_ENCODING, UTF_ENCODING};
        } else {
            String string2 = res.getString("auto");
            stringArray = new String[]{string2, string.equalsIgnoreCase("zh_CN") ? GBK_ENCODING : ISO_ENCODING, UTF_ENCODING};
        }
        return stringArray;
    }

    public String getEncodingType() {
        String string = null;
        if (this.fileChooser instanceof SaveFileChooser) {
            string = System.getProperty("file.encoding");
        }
        if (null != this.encodingFilter) {
            string = (String)this.encodingFilter.getSelectedItem();
        }
        return string;
    }

    private class FileTypeListener
    implements ItemListener {
        private FileTypeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                String[] stringArray = SwimapFileChooseUI.this.getEncodingValues((FileFilter)jComboBox.getSelectedItem());
                SwimapFileChooseUI.this.encodingFilter.setModel(new DefaultComboBoxModel<String>(stringArray));
                if (stringArray.length > 1) {
                    SwimapFileChooseUI.this.encodingFilter.setEnabled(true);
                } else {
                    SwimapFileChooseUI.this.encodingFilter.setEnabled(false);
                }
            }
        }
    }

    protected class SwImapFilterComboBoxModel
    extends MetalFileChooserUI.FilterComboBoxModel {
        protected SwImapFilterComboBoxModel() {
            super(SwimapFileChooseUI.this);
        }

        @Override
        public void setSelectedItem(Object object) {
            if (object != null) {
                SwimapFileChooseUI.this.getFileChooser().setFileFilter((FileFilter)object);
                SwimapFileChooseUI.this.setFileName(SwimapFileChooseUI.this.processResetFileName());
                this.fireContentsChanged(this, -1, -1);
            }
        }
    }
}

