/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel;

import com.swimap.iview.framework.lookandfeel.IVBumps;
import com.swimap.iview.templates.utils.MultiRowToolTip;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class SwimapDesktopIconUI
extends BasicDesktopIconUI {
    private static final String TITLE = "title";
    private static final String FRAMEICON = "frameIcon";
    private static final int MAX_LINE_TOOLTIP = 10;
    private JButton button = null;
    private JLabel label = null;
    private TitleChangeListener titleChangeListener = null;
    private int width = 0;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SwimapDesktopIconUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (SwimapDesktopIconUI.this.button != null) {
                    SwimapDesktopIconUI.this.button.requestFocus();
                }
            }
        });
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installColorsAndFont(this.desktopIcon, "DesktopIcon.background", "DesktopIcon.foreground", "DesktopIcon.font");
        this.width = UIManager.getInt("DesktopIcon.width");
        this.desktopIcon.setOpaque(true);
    }

    @Override
    protected void installComponents() {
        this.initializeButton();
        this.initializeLabel();
        this.desktopIcon.setLayout(new BorderLayout(2, 0));
        this.desktopIcon.add((Component)this.button, "Center");
        this.desktopIcon.add((Component)this.label, "West");
    }

    private void initializeLabel() {
        int n = this.button.getPreferredSize().height;
        IVBumps iVBumps = new IVBumps(n / 3, n, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getControl());
        this.label = new JLabel(iVBumps);
        this.label.setBorder(new MatteBorder(0, 2, 0, 1, this.desktopIcon.getBackground()));
    }

    private void initializeButton() {
        this.frame = this.desktopIcon.getInternalFrame();
        this.button = new JButton(this.frame.getTitle(), this.frame.getFrameIcon()){

            @Override
            public JToolTip createToolTip() {
                MultiRowToolTip multiRowToolTip = new MultiRowToolTip();
                multiRowToolTip.setMaxLineNumber(10);
                multiRowToolTip.setComponent(this);
                return multiRowToolTip;
            }
        };
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwimapDesktopIconUI.this.deiconize();
            }
        });
        this.button.setBackground(this.desktopIcon.getBackground());
        this.button.setFont(this.desktopIcon.getFont());
        this.button.setForeground(this.desktopIcon.getForeground());
        this.button.setToolTipText(this.frame.getTitle());
    }

    @Override
    protected void uninstallComponents() {
        this.desktopIcon.remove(this.button);
        this.button = null;
        this.desktopIcon.remove(this.label);
        this.frame = null;
        this.desktopIcon.setLayout(null);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.titleChangeListener = new TitleChangeListener();
        this.desktopIcon.getInternalFrame().addPropertyChangeListener(this.titleChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.desktopIcon.getInternalFrame().removePropertyChangeListener(this.titleChangeListener);
        super.uninstallListeners();
        this.titleChangeListener = null;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        int n = this.desktopIcon.getLayout().minimumLayoutSize((Container)this.desktopIcon).height;
        return new Dimension(this.width, n);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    private class TitleChangeListener
    implements PropertyChangeListener {
        private TitleChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getNewValue();
            String string = propertyChangeEvent.getPropertyName();
            if (SwimapDesktopIconUI.TITLE.equals(string)) {
                SwimapDesktopIconUI.this.button.setToolTipText((String)object);
                SwimapDesktopIconUI.this.button.setText((String)object);
            }
            if (SwimapDesktopIconUI.FRAMEICON.equals(string)) {
                SwimapDesktopIconUI.this.button.setIcon((Icon)object);
            }
        }
    }
}

