/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel;

import com.swimap.iview.framework.lookandfeel.ButtonState;
import com.swimap.iview.framework.lookandfeel.DownButtonState;
import com.swimap.iview.framework.lookandfeel.LeftButtonState;
import com.swimap.iview.framework.lookandfeel.TopButtonState;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JSplitPane;

final class SplitButton
extends JButton {
    ButtonState buttonState = null;
    private int orientation = 1;
    private int dividerSize = -1;

    SplitButton() {
    }

    public void setButtonState(ButtonState buttonState) {
        this.buttonState = buttonState;
        this.orientation = buttonState.getOrientation();
    }

    @Override
    public void paint(Graphics graphics) {
        this.drawbg(graphics);
        this.drawborder(graphics);
        this.drawLines(graphics);
        this.drawArrowhead(graphics);
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    final boolean isNeedChangeState(JSplitPane jSplitPane, boolean bl, int n, int n2) {
        boolean bl2 = false;
        Insets insets = jSplitPane.getInsets(new Insets(0, 0, 0, 0));
        if (this.dividerSize == -1) {
            this.dividerSize = jSplitPane.getDividerSize();
        }
        if (bl) {
            bl2 = this.orientation == 0 ? (n + jSplitPane.getDividerSize() + insets.bottom == jSplitPane.getHeight() && this.buttonState.getFlag() ? false : n == 0 && this.buttonState.getFlag() || n2 + this.dividerSize + insets.bottom >= jSplitPane.getHeight() && this.buttonState.getFlag() || n + jSplitPane.getDividerSize() + insets.bottom >= jSplitPane.getHeight() && 0 != jSplitPane.getHeight() && !this.buttonState.getFlag()) : n == insets.left && this.buttonState.getFlag() || n2 == insets.left && !this.buttonState.getFlag();
        } else if (this.orientation == 0) {
            bl2 = n == insets.top && this.buttonState.getFlag() || n2 == insets.top && !this.buttonState.getFlag();
        } else if (n + this.dividerSize + insets.right == jSplitPane.getWidth() && this.buttonState.getFlag()) {
            bl2 = false;
        } else if (n2 + this.dividerSize + insets.right >= jSplitPane.getWidth() && !this.buttonState.getFlag()) {
            bl2 = false;
        } else {
            boolean bl3 = bl2 = n2 + this.dividerSize + insets.right >= jSplitPane.getWidth() && this.buttonState.getFlag() || n + jSplitPane.getDividerSize() + insets.right >= jSplitPane.getWidth() && !this.buttonState.getFlag();
        }
        if (this.dividerSize != jSplitPane.getDividerSize()) {
            this.dividerSize = jSplitPane.getDividerSize();
        }
        return bl2;
    }

    private void drawbg(Graphics graphics) {
        Color color = ButtonState.COLORS[0];
        if (this.getModel().isPressed()) {
            color = ButtonState.COLORS[2];
        } else if (this.getModel().isRollover()) {
            color = ButtonState.COLORS[1];
        }
        graphics.setColor(color);
        graphics.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
    }

    private void drawborder(Graphics graphics) {
        Color color = null;
        Color color2 = null;
        color = this.getModel().isPressed() ? ButtonState.COLORS[5] : ButtonState.COLORS[4];
        color2 = ButtonState.COLORS[3];
        if (this.buttonState.getOrientation() == 0) {
            graphics.setColor(color);
            graphics.drawLine(0, 0, this.getWidth() - 1, 0);
            graphics.drawLine(0, 1, 0, this.getHeight() - 2);
            graphics.setColor(color2);
            graphics.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
            graphics.drawLine(this.getWidth() - 1, 1, this.getWidth() - 1, this.getHeight() - 2);
        } else {
            graphics.setColor(color);
            graphics.drawLine(0, 0, this.getWidth() - 2, 0);
            graphics.drawLine(0, 1, 0, this.getHeight() - 1);
            graphics.setColor(color2);
            graphics.drawLine(1, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
            graphics.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 2);
        }
    }

    private void drawLines(Graphics graphics) {
        Color color = null;
        Color color2 = null;
        color = this.getModel().isPressed() ? ButtonState.COLORS[5] : ButtonState.COLORS[4];
        color2 = ButtonState.COLORS[3];
        if (this.buttonState.getOrientation() == 0) {
            graphics.setColor(color2);
            graphics.drawLine(7, 1, 7, this.getHeight() - 2);
            graphics.drawLine(10, 1, 10, this.getHeight() - 2);
            graphics.drawLine(13, 1, 13, this.getHeight() - 2);
            graphics.drawLine(33, 1, 33, this.getHeight() - 2);
            graphics.drawLine(36, 1, 36, this.getHeight() - 2);
            graphics.drawLine(39, 1, 39, this.getHeight() - 2);
            graphics.setColor(color);
            graphics.drawLine(8, 1, 8, this.getHeight() - 2);
            graphics.drawLine(11, 1, 11, this.getHeight() - 2);
            graphics.drawLine(14, 1, 14, this.getHeight() - 2);
            graphics.drawLine(34, 1, 34, this.getHeight() - 2);
            graphics.drawLine(37, 1, 37, this.getHeight() - 2);
            graphics.drawLine(40, 1, 40, this.getHeight() - 2);
        } else {
            graphics.setColor(color2);
            graphics.drawLine(1, 7, this.getWidth() - 2, 7);
            graphics.drawLine(1, 10, this.getWidth() - 2, 10);
            graphics.drawLine(1, 13, this.getWidth() - 2, 13);
            graphics.drawLine(1, 33, this.getWidth() - 2, 33);
            graphics.drawLine(1, 36, this.getWidth() - 2, 36);
            graphics.drawLine(1, 39, this.getWidth() - 2, 39);
            graphics.setColor(color);
            graphics.drawLine(1, 8, this.getWidth() - 2, 8);
            graphics.drawLine(1, 11, this.getWidth() - 2, 11);
            graphics.drawLine(1, 14, this.getWidth() - 2, 14);
            graphics.drawLine(1, 34, this.getWidth() - 2, 34);
            graphics.drawLine(1, 37, this.getWidth() - 2, 37);
            graphics.drawLine(1, 40, this.getWidth() - 2, 40);
        }
    }

    private void drawArrowhead(Graphics graphics) {
        Color color = ButtonState.COLORS[6];
        Color color2 = ButtonState.COLORS[7];
        if (this.buttonState instanceof TopButtonState) {
            int n = (this.getHeight() - 4) / 2;
            int n2 = n + 3;
            graphics.setColor(color);
            graphics.drawLine(20, n2, 23, n);
            graphics.drawLine(24, n, 27, n2);
            graphics.setColor(color2);
            graphics.drawLine(23, n + 1, 24, n + 1);
            graphics.drawLine(22, n + 2, 25, n + 2);
            graphics.drawLine(21, n + 3, 26, n + 3);
        } else if (this.buttonState instanceof DownButtonState) {
            int n = (this.getHeight() - 4) / 2;
            int n3 = n + 3;
            graphics.setColor(color);
            graphics.drawLine(20, n, 23, n3);
            graphics.drawLine(24, n3, 27, n);
            graphics.setColor(color2);
            graphics.drawLine(23, n + 2, 24, n + 2);
            graphics.drawLine(22, n + 1, 25, n + 1);
            graphics.drawLine(21, n, 26, n);
        } else if (this.buttonState instanceof LeftButtonState) {
            int n = (this.getWidth() - 4) / 2;
            int n4 = n + 3;
            graphics.setColor(color);
            graphics.drawLine(n, 23, n4, 20);
            graphics.drawLine(n, 24, n4, 27);
            graphics.setColor(color2);
            graphics.drawLine(n + 1, 23, n + 1, 24);
            graphics.drawLine(n + 2, 22, n + 2, 25);
            graphics.drawLine(n + 3, 21, n + 3, 26);
        } else {
            int n = (this.getWidth() - 4) / 2;
            int n5 = n + 3;
            graphics.setColor(color);
            graphics.drawLine(n, 20, n5, 23);
            graphics.drawLine(n, 27, n5, 24);
            graphics.setColor(color2);
            graphics.drawLine(n, 21, n, 26);
            graphics.drawLine(n + 1, 22, n + 1, 25);
            graphics.drawLine(n + 2, 23, n + 2, 24);
        }
    }
}

