/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.framework.lookandfeel.TabbedPaneEclipseStyleUI;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.Icon;

public class PortalTabbedPaneUI
extends TabbedPaneEclipseStyleUI {
    private static IviewLogger logger = IviewLogger.getLogger(PortalTabbedPaneUI.class, "IVIEW");
    private static Color BG_COLOR = new Color(239, 239, 239);
    private int x = 0;
    private int y = 0;
    private int w = 0;
    private int h = 0;

    public PortalTabbedPaneUI() {
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFromDefaultAndProductStyle("conf/mainfrm/app/portalstyleConfig");
        if (null != commStyleInfo) {
            try {
                String[] stringArray;
                DescContainer descContainer = commStyleInfo.getAreaDescContainer()[0].getDescContainer("FloatingPanelSettings");
                String string = descContainer.getParasItemValue("panelColor");
                if (string != null && (stringArray = string.split(",")).length == 3) {
                    int n = Integer.parseInt(stringArray[0]);
                    int n2 = Integer.parseInt(stringArray[1]);
                    int n3 = Integer.parseInt(stringArray[2]);
                    BG_COLOR = new Color(n, n2, n3);
                }
            }
            catch (Exception exception) {
                logger.trace("Exception while reading portal style settings" + exception);
            }
        }
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (n == 1 && bl) {
            int n7 = n4;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = Color.white;
            Color color2 = new Color(155, 185, 230);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n8 = n3 + n5 + 20;
            int[] nArray = new int[]{n3, n3, n3 + 1, n3 + 1, n3 + 4, n3 + 5, n3 + 6, n8 - 26, n8 - 25, n8 - 25, n8 - 22, n8 - 21, n8 - 20, n8 - 20};
            int[] nArray2 = new int[]{n7 + n6, n7 + 6, n7 + 5, n7 + 4, n7 + 1, n7 + 1, n7, n7, n7 + 1, n7 + 1, n7 + 4, n7 + 5, n7 + 6, n7 + n6};
            int n9 = nArray.length;
            Polygon polygon = new Polygon(nArray, nArray2, n9);
            graphics.fillPolygon(polygon);
            PortalTabbedPaneUI.fillGradient(graphics2D, polygon, color, color2, true);
        } else {
            super.paintTabBackground(graphics, n, n2, n3, n4, n5, n6, bl);
        }
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        super.paintTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
        if (n == 1 && bl) {
            int n7 = --n3 + n5 + 20;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(this.lightHighlight);
            graphics2D.setColor(this.shadow);
            graphics2D.drawLine(n7 - 20, n4 + n6, n7 - 20, n4 + 5);
            graphics2D.drawLine(n7 - 25, n4, n7 - 24, n4);
            graphics2D.drawLine(n7 - 23, n4 + 1, n7 - 23, n4 + 1);
            graphics2D.drawLine(n7 - 22, n4 + 2, n7 - 22, n4 + 2);
            graphics2D.drawLine(n7 - 21, n4 + 3, n7 - 21, n4 + 4);
        }
    }

    @Override
    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        super.paintContentBorder(graphics, n, n2);
        Graphics2D graphics2D = null;
        graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(BG_COLOR);
        graphics2D.fillRect(this.x, this.y, this.w, this.h);
        graphics2D.setColor(new Color(102, 102, 102));
        graphics2D.drawLine(this.x, this.y - 1, this.x + this.w - 3, this.y - 1);
        graphics2D.setColor(new Color(218, 226, 226));
        graphics2D.drawRect(this.x, this.y, this.w - 1, this.h - 2);
        graphics2D.setColor(new Color(102, 102, 102));
        graphics2D.drawLine(this.w - 2, this.y - 1, this.w - 2, this.h + 22);
        graphics2D.drawLine(this.x, this.h + 23, this.w - 2, this.h + 23);
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        super.paintContentBorderTopEdge(graphics, n, n2, n3, n4, n5, n6);
        this.x = n3;
        this.y = n4 + 1;
        this.w = n5;
        this.h = n6;
    }

    @Override
    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        super.layoutLabel(n, fontMetrics, n2, string, icon, rectangle, rectangle2, rectangle3, bl);
        if (n == 1 && bl) {
            rectangle2.x += 10;
            rectangle3.x += 11;
        }
    }

    public Rectangle[] getRects() {
        return this.rects;
    }

    @Override
    protected boolean isDrawShadowText() {
        return false;
    }
}

