/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel;

import com.swimap.iview.framework.lookandfeel.SplitButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

class MetalSplitPaneDivider
extends BasicSplitPaneDivider {
    private static final int ONE_TOUCH_BUTTON_LONGTH = 48;
    protected SplitButton splitButton = null;
    private static final Color SPLIT_DIVIDER_HIGHLIGHT = new Color(255, 255, 255);

    MetalSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
        super(basicSplitPaneUI);
        this.setLayout(new MetalDividerLayout());
    }

    @Override
    public void setBorder(Border border) {
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(UIManager.getColor("SplitPane.highlight"));
        if (this.orientation == 0) {
            graphics.drawLine(0, 0, 0, this.getHeight() - 1);
        } else {
            graphics.drawLine(0, 0, this.getWidth() - 1, 0);
        }
        graphics.setColor(SPLIT_DIVIDER_HIGHLIGHT);
        if (this.orientation == 0) {
            graphics.drawLine(0, 0, this.getWidth() - 1, 0);
        } else {
            graphics.drawLine(0, 0, 0, this.getHeight() - 1);
        }
        graphics.setColor(UIManager.getColor("SplitPane.darkShadow"));
        if (this.orientation == 0) {
            graphics.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
        } else {
            graphics.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        super.paint(graphics);
    }

    private int getOneTouchSizeFromSuper() {
        return 6;
    }

    private int getOrientationFromSuper() {
        return this.orientation;
    }

    private JSplitPane getSplitPaneFromSuper() {
        return this.splitPane;
    }

    class MetalDividerLayout
    implements LayoutManager {
        private static final int BUTTON_X = -48;
        private static final int BUTTON_Y = -48;

        MetalDividerLayout() {
        }

        @Override
        public void layoutContainer(Container container) {
            JSplitPane jSplitPane = MetalSplitPaneDivider.this.getSplitPaneFromSuper();
            int n = MetalSplitPaneDivider.this.getOrientationFromSuper();
            int n2 = MetalSplitPaneDivider.this.getOneTouchSizeFromSuper();
            int n3 = 0;
            Insets insets = MetalSplitPaneDivider.this.getInsets();
            if (null == MetalSplitPaneDivider.this.splitButton || container != MetalSplitPaneDivider.this) {
                return;
            }
            if (jSplitPane.isOneTouchExpandable()) {
                if (n == 0) {
                    int n4 = insets == null ? 0 : insets.top;
                    int n5 = MetalSplitPaneDivider.this.getDividerSize();
                    if (insets != null) {
                        n5 -= insets.top + insets.bottom;
                    }
                    n5 = Math.min(n5, n2);
                    n3 = (container.getWidth() - 48) / 2;
                    MetalSplitPaneDivider.this.splitButton.setBounds(n3, n4, 48, MetalSplitPaneDivider.this.getHeight());
                } else {
                    int n6;
                    int n7 = MetalSplitPaneDivider.this.getDividerSize();
                    int n8 = n6 = insets != null ? insets.left : 0;
                    if (insets != null) {
                        n7 -= insets.left + insets.right;
                    }
                    n7 = Math.min(n7, n2);
                    n3 = (container.getHeight() - 48) / 2;
                    MetalSplitPaneDivider.this.splitButton.setBounds(n6, n3, MetalSplitPaneDivider.this.getWidth(), 48);
                }
                jSplitPane.firePropertyChange("dividerLocation", -1, jSplitPane.getDividerLocation());
            } else {
                MetalSplitPaneDivider.this.splitButton.setBounds(-48, -48, 1, 1);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return new Dimension();
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return new Dimension();
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }
    }
}

