/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.lookandfeel.UIStyleManager;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.systemsettingsmanagement.BaseClientSettings;
import com.swimap.iview.framework.systemsettingsmanagement.SystemSettingsManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.omg.CORBA.ORB;

public class LookAndFeelSetting
extends BaseClientSettings {
    private static IviewLogger logger = IviewLogger.getLogger(LookAndFeelSetting.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/lookandfeel/Res");
    public static final String LOOKANDFEEL_SETTING_NAME = "lookfeelsetting";
    private static final int SMALL_FONT_SIZE = 11;
    private static final int DEFAULT_FONT_SIZE = 12;
    private static final int BIG_FONT_SIZE = 13;
    private JPanel lnfPanel = null;
    private boolean changed = false;
    private int currentFontSize = 12;
    private JRadioButton smallButton = null;
    private JRadioButton defaultButton = null;
    private JRadioButton bigButton = null;

    public LookAndFeelSetting(ModuleManager moduleManager, ORB oRB, String string, String string2) throws ModuleManagementException {
        super(moduleManager, oRB, string, string2);
        this.initialize();
    }

    public LookAndFeelSetting(ModuleManager moduleManager) throws ModuleManagementException {
        super(moduleManager);
        this.initialize();
    }

    @Override
    public boolean apply() {
        this.actionPerformed();
        return true;
    }

    @Override
    public boolean exit() {
        this.resumeCurrentFontSize();
        return true;
    }

    private void resumeCurrentFontSize() {
        switch (this.currentFontSize) {
            case 11: {
                this.smallButton.setSelected(true);
                break;
            }
            case 12: {
                this.defaultButton.setSelected(true);
                break;
            }
            case 13: {
                this.bigButton.setSelected(true);
                break;
            }
            default: {
                this.defaultButton.setSelected(true);
            }
        }
    }

    @Override
    public JPanel getSettingsPanel() {
        return this.lnfPanel;
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public String getTabLabel() {
        return res.getString("LookAndFeelSetting_Look_Feel");
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public void initialize() {
        this.lnfPanel = new JPanel();
        this.lnfPanel.putClientProperty("HELP_ID_PROPERTY", "iVIEW.systemsetting.lookandfeel");
        HelpManager.getInstance().enableHelpKey(this.lnfPanel, "iVIEW.systemsetting.lookandfeel");
        this.lnfPanel.setLayout(new BorderLayout());
        JPanel jPanel = this.createFontPanel();
        this.lnfPanel.add((Component)jPanel, "North");
    }

    private JPanel createFontPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(res.getString("Font_size"));
        this.smallButton = new JRadioButton(res.getString("small"));
        this.smallButton.setName("LookandFeelSettings_SmallFontRB");
        this.defaultButton = new JRadioButton(res.getString("default"));
        this.defaultButton.setName("LookandFeelSettings_defaultFontRB");
        this.bigButton = new JRadioButton(res.getString("bigFont"));
        this.bigButton.setName("LookandFeelSettings_LargeFontRB");
        ButtonGroup buttonGroup = new ButtonGroup();
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0625, 0.0, 17, 2, new Insets(12, 8, 0, 0), 0, 0));
        jPanel2.add((Component)this.smallButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.defaultButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.bigButton, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 0, 0), 0, 0));
        buttonGroup.add(this.smallButton);
        buttonGroup.add(this.defaultButton);
        buttonGroup.add(this.bigButton);
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(6, 17, 12, 0), 0, 0));
        int n = UIStyleManager.getFontSize();
        switch (n) {
            case 11: {
                this.smallButton.setSelected(true);
                this.currentFontSize = n;
                break;
            }
            case 12: {
                this.defaultButton.setSelected(true);
                this.currentFontSize = n;
                break;
            }
            case 13: {
                this.bigButton.setSelected(true);
                this.currentFontSize = n;
                break;
            }
            default: {
                this.defaultButton.setSelected(true);
                this.currentFontSize = 12;
                UIStyleManager.setFontSize(12);
                UIStyleManager.writeBackUIStyle("Swimap");
            }
        }
        this.smallButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LookAndFeelSetting.this.radioButtonActionPerformed(11);
            }
        });
        this.defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LookAndFeelSetting.this.radioButtonActionPerformed(12);
            }
        });
        this.bigButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LookAndFeelSetting.this.radioButtonActionPerformed(13);
            }
        });
        return jPanel;
    }

    private void radioButtonActionPerformed(int n) {
        this.changed = n != this.currentFontSize;
        this.notifyChange();
    }

    private void notifyChange() {
        FrameworkUtilities.getSystemSettingsManager().clientSettingChanged(this.getModuleName(), this.changed);
    }

    public void actionPerformed() {
        int n = this.getSelectedFont();
        if (this.currentFontSize == n) {
            return;
        }
        this.currentFontSize = n;
        this.changed = false;
        this.notifyChange();
        try {
            SystemSettingsManager systemSettingsManager = (SystemSettingsManager)this.getLocalReference("mainsystemsettingmanager");
            systemSettingsManager.setSystemSettingStatus(this.getTabLabel(), true, systemSettingsManager.getRestartMessage());
        }
        catch (ModuleManagementException moduleManagementException) {
            logger.error("get SystemSettingsManager Exception.");
            logger.trace(moduleManagementException.getMessage(), moduleManagementException);
        }
        UIStyleManager.setFontSize(this.currentFontSize);
        UIStyleManager.writeBackUIStyle("Swimap");
    }

    @Override
    public String getModuleName() {
        return LOOKANDFEEL_SETTING_NAME;
    }

    private int getSelectedFont() {
        if (this.smallButton.isSelected()) {
            return 11;
        }
        if (this.defaultButton.isSelected()) {
            return 12;
        }
        if (this.bigButton.isSelected()) {
            return 13;
        }
        return 12;
    }

    @Override
    public int getTitleDescription() {
        return 2;
    }

    @Override
    public String getSettingDescription() {
        return res.getString("lnfSetting_Descr");
    }
}

