/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.lookandfeel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;

class IVBumpBuffer {
    private GraphicsConfiguration graphicConfig = null;
    private Color shadowColor = null;
    private Color topColor = null;
    private Color backColor = null;
    private transient Image img = null;
    private static final int DEFAULT_SIZE = 64;
    private static Dimension SIZE = new Dimension(64, 64);

    IVBumpBuffer(GraphicsConfiguration graphicsConfiguration, Color color, Color color2, Color color3) {
        this.graphicConfig = graphicsConfiguration;
        this.topColor = color;
        this.shadowColor = color2;
        this.backColor = color3;
        this.createImage();
        this.fillBumpBuffer();
    }

    private void createImage() {
        if (this.graphicConfig == null) {
            int[] nArray = new int[]{this.backColor.getRGB(), this.topColor.getRGB(), this.shadowColor.getRGB()};
            IndexColorModel indexColorModel = new IndexColorModel(8, 3, nArray, 0, false, -1, 0);
            this.img = new BufferedImage(64, 64, 13, indexColorModel);
        } else {
            this.img = this.graphicConfig.createCompatibleImage(64, 64);
        }
    }

    private void fillBumpBuffer() {
        int n;
        int n2;
        Graphics graphics = this.img.getGraphics();
        graphics.setColor(this.backColor);
        graphics.fillRect(0, 0, 64, 64);
        graphics.setColor(this.topColor);
        for (n2 = 0; n2 < 64; n2 += 4) {
            for (n = 0; n < 64; n += 4) {
                graphics.drawLine(n2, n, n2, n);
                graphics.drawLine(n2 + 2, n + 2, n2 + 2, n + 2);
            }
        }
        graphics.setColor(this.shadowColor);
        for (n2 = 0; n2 < 64; n2 += 4) {
            for (n = 0; n < 64; n += 4) {
                graphics.drawLine(n2 + 1, n + 1, n2 + 1, n + 1);
                graphics.drawLine(n2 + 3, n + 3, n2 + 3, n + 3);
            }
        }
        graphics.dispose();
    }

    public boolean hasSameConfiguration(GraphicsConfiguration graphicsConfiguration, Color color, Color color2, Color color3) {
        if (this.graphicConfig != null ? !this.graphicConfig.equals(graphicsConfiguration) : graphicsConfiguration != null) {
            return false;
        }
        return this.topColor.equals(color) && this.shadowColor.equals(color2) && this.backColor.equals(color3);
    }

    public Image getImage() {
        return this.img;
    }

    public Dimension getImageSize() {
        return SIZE;
    }
}

