/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.logintype;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.logintype.LoginTypeSetting;
import com.swimap.iview.util.TypeConverter;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class LoginTypeSettingPanel
extends JPanel {
    private static IviewLogger logger = IviewLogger.getLogger(LoginTypeSettingPanel.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/logintype/Res");
    private LoginTypeSetting loginTypeSetting = null;
    private JRadioButton normatStart = new JRadioButton(res.getString("normal_start"));
    private JRadioButton quickStart = new JRadioButton("quick_start");
    private ButtonGroup buttonGroup = new ButtonGroup();
    private static final int DEFAULT_LOGIN_TYPE = 0;
    private final String DEFAULT_PATH = "conf/mainfrm/logintype";
    private int loginType = 0;
    private JPanel innerPanel = new JPanel();
    private JPanel basePanel = new JPanel(new BorderLayout());
    private GridBagLayout gridBagLayout1 = new GridBagLayout();

    public LoginTypeSettingPanel() {
        this.jbInit();
    }

    public LoginTypeSettingPanel(LoginTypeSetting loginTypeSetting) {
        this.loginTypeSetting = loginTypeSetting;
        this.jbInit();
        this.initData();
        loginTypeSetting.setLoginTypeMode(this.loginType);
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.basePanel, "North");
        this.innerPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), res.getString("logintype_header")));
        this.innerPanel.setLayout(this.gridBagLayout1);
        this.basePanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.normatStart.setText(res.getString("normal_start"));
        this.normatStart.setSelected(true);
        jLabel.setText("<HTML><DIV align='JUSTIFY'><P STYLE=\"word-wrap:break-word;width:100%;left:0\">" + res.getString("normal_login_message") + "</P></DIV></HTML>");
        jLabel2.setText("<HTML><DIV align='JUSTIFY'><P STYLE=\"word-wrap:break-word;width:100%;left:0\">" + res.getString("quick_login_message") + "</P></DIV></HTML>");
        this.quickStart.setText(res.getString("quick_start"));
        this.buttonGroup.add(this.normatStart);
        this.buttonGroup.add(this.quickStart);
        this.normatStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoginTypeSettingPanel.this.checkModified();
                LoginTypeSettingPanel.this.setLoginType(0);
            }
        });
        this.quickStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoginTypeSettingPanel.this.checkModified();
                LoginTypeSettingPanel.this.setLoginType(1);
            }
        });
        this.add((Component)this.innerPanel, "West");
        this.innerPanel.add((Component)this.quickStart, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 17, 6, 12), 0, 0));
        this.innerPanel.add((Component)this.normatStart, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 17, 6, 12), 0, 0));
        this.innerPanel.add((Component)jLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 37, 6, 12), 0, 0));
        this.innerPanel.add((Component)jLabel2, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 37, 6, 12), 0, 0));
        this.basePanel.add((Component)this.innerPanel, "North");
        this.putClientProperty("HELP_ID_PROPERTY", "iVIEW.systemsetting.logintype");
        HelpManager.getInstance().enableHelpKey(this, "iVIEW.systemsetting.logintype");
    }

    public void checkModified() {
        this.loginTypeSetting.setChanged(true);
    }

    public void initData() {
        this.initStartType();
    }

    private void initStartType() {
        boolean bl;
        this.loginType = this.getLoginTypeFromConfigure();
        boolean bl2 = bl = 0 == this.loginType;
        if (bl) {
            this.normatStart.setSelected(true);
        } else {
            this.quickStart.setSelected(true);
        }
    }

    private int getLoginTypeFromConfigure() {
        int n = 0;
        try {
            CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/mainfrm/logintype");
            DescContainer descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer("loginTypeSetting");
            n = (Integer)TypeConverter.getParameter(descContainer.getParasItemValue("loginType"), Integer.class);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return n;
    }

    public int getLoginType() {
        return this.loginType;
    }

    public void setLoginType(int n) {
        this.loginType = n;
    }

    public void resetSelectedItems() {
        this.initStartType();
    }
}

