/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.logintype;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.logintype.LoginTypeSettingPanel;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.systemsettingsmanagement.BaseClientSettings;
import com.swimap.iview.framework.systemsettingsmanagement.SystemSettingsManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.omg.CORBA.ORB;

public class LoginTypeSetting
extends BaseClientSettings {
    private static IviewLogger logger = IviewLogger.getLogger(LoginTypeSetting.class, "IVIEW");
    static final String CLASS_NAME = "com.swimap.iview.framework.systemsettingsmanagement.LoginTypeSetting";
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/logintype/Res");
    static final String MODULE_NAME = "Login Type";
    private LoginTypeSettingPanel loginTypeSettingPanel = null;
    private boolean bChanged = false;
    private CommStyleInfo commStyleInfo = null;
    public static final int QUICK_LOGIN = 1;
    public static final int NORMAL_LOGIN = 0;
    private int m_loginTypeMode = 0;
    private ModuleManager moduleManager = null;

    public LoginTypeSetting(ModuleManager moduleManager, ORB oRB, String string, String string2) throws ModuleManagementException {
        super(moduleManager, oRB, string, string2);
        this.moduleManager = moduleManager;
    }

    @Override
    public boolean apply() {
        this.m_loginTypeMode = this.loginTypeSettingPanel.getLoginType();
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        SystemSettingsManager systemSettingsManager = FrameworkUtilities.getSystemSettingsManager();
        try {
            if (this.commStyleInfo == null) {
                this.commStyleInfo = commStyleManager.getCommonStyleFile("conf/mainfrm/logintype");
            }
            DescContainer descContainer = this.commStyleInfo.getAreaDescContainer(0).getDescContainer("loginTypeSetting");
            descContainer.setParasItem("loginType", String.valueOf(this.m_loginTypeMode), true);
            try {
                commStyleManager.writeToServer(this.commStyleInfo);
                systemSettingsManager.setSystemSettingStatus(this.getTabLabel(), true, "");
            }
            catch (IOException iOException) {
                logger.trace("IOException during the apply.");
                systemSettingsManager.setSystemSettingStatus(this.getTabLabel(), false, res.getString("Fail_msg"));
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        this.bChanged = false;
        this.setLoginTypeMode(this.m_loginTypeMode);
        return true;
    }

    public void setChanged(boolean bl) {
        this.bChanged = bl;
        FrameworkUtilities.getSystemSettingsManager().clientSettingChanged(this.getModuleName(), this.isChanged());
    }

    @Override
    public boolean exit() {
        this.loginTypeSettingPanel.resetSelectedItems();
        this.bChanged = false;
        return true;
    }

    @Override
    public boolean actived() {
        return true;
    }

    @Override
    public JPanel getSettingsPanel() {
        if (this.loginTypeSettingPanel == null) {
            this.loginTypeSettingPanel = new LoginTypeSettingPanel(this);
        }
        return this.loginTypeSettingPanel;
    }

    @Override
    public boolean isChanged() {
        return this.bChanged;
    }

    @Override
    public String getTabLabel() {
        return res.getString("LoginTypeSetting_Tab");
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    void notifyChange(boolean bl) {
        SystemSettingsManager systemSettingsManager = FrameworkUtilities.getSystemSettingsManager();
        systemSettingsManager.clientSettingChanged(this.getModuleName(), bl || this.isChanged());
    }

    public int getLoginTypeMode() {
        return this.loginTypeSettingPanel.getLoginType();
    }

    public void setLoginTypeMode(int n) {
        this.m_loginTypeMode = n;
        if (0 == n) {
            this.moduleManager.setSystemLoading(false);
        } else {
            this.moduleManager.setSystemLoading(true);
        }
    }

    @Override
    public void reinitialize() {
    }

    @Override
    public int getTitleDescription() {
        return 1;
    }

    @Override
    public String getSettingDescription() {
        return res.getString("LoginType_Setting_Descr");
    }
}

