/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.licensemanagement;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.framework.licensemanagement.LicenseService;
import com.swimap.iview.util.log.IviewLogger;
import java.io.Serializable;

public class LicenseUtilities {
    private static IviewLogger logger = IviewLogger.getLogger(LicenseUtilities.class, "IVIEW");
    private static LicenseService licenseService = null;
    private static boolean isLicenseSeviceFailed = false;

    public static void loadLicenseService() {
        Serializable serializable;
        if (null != licenseService) {
            return;
        }
        String string = null;
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/mainfrm/license");
        if (commStyleInfo != null) {
            serializable = commStyleInfo.getAreaDescContainer(0).getDescContainer("license");
            string = ((DescContainer)serializable).getParasItemValue("license");
        } else {
            logger.trace("commStyleInfo is null");
        }
        try {
            if (null != string) {
                serializable = Class.forName(string);
                logger.debug(" Begin invoke className " + string);
                licenseService = (LicenseService)((Class)serializable).newInstance();
            }
        }
        catch (Exception exception) {
            logger.trace("Loading License service is failed." + exception.getMessage());
            isLicenseSeviceFailed = true;
        }
    }

    public static LicenseService getLicenseService() {
        if (!isLicenseSeviceFailed && null == licenseService) {
            LicenseUtilities.loadLicenseService();
            logger.trace("License Service is loaded in getLicenseService");
        }
        return licenseService;
    }

    public static boolean isLicenseSeviceLoadFail() {
        return isLicenseSeviceFailed;
    }
}

