/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.dockingmanagement.theme;

import bibliothek.extension.gui.dock.theme.eclipse.RoundRectButton;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import com.swimap.iview.framework.dockingmanagement.images.PerspectiveViewImages;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;

public class PerspectiveViewButton
extends RoundRectButton
implements MouseListener {
    private BasicButtonModel model = null;
    private PerspectiveViewImages images = null;
    private static final int FOUR = 4;
    private BasicTrigger trigger = null;

    public PerspectiveViewButton(BasicTrigger basicTrigger) {
        super(basicTrigger);
        this.trigger = basicTrigger;
        this.addMouseListener(this);
        this.images = PerspectiveViewImages.getInstance();
    }

    protected void paintComponent(Graphics graphics) {
        this.model = this.getModel();
        int n = this.getWidth() - 1;
        int n2 = this.getHeight() - 1;
        Icon icon = this.model.getPaintIcon();
        if (icon != null) {
            icon.paintIcon((Component)((Object)this), graphics, (n + 1 - icon.getIconWidth()) / 2, (n2 + 1 - icon.getIconHeight()) / 2);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.pressedAndClicked();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        Icon icon = this.model.getPaintIcon();
        String string = icon.toString();
        if (string.equals(this.images.getImages("close_normal").toString())) {
            this.model.setIcon(this.images.getImages("close_hover"));
        }
        if (string.equals(this.images.getImages("max_normal").toString())) {
            this.model.setIcon(this.images.getImages("max_hover"));
        }
        if (string.equals(this.images.getImages("min_normal").toString())) {
            this.model.setIcon(this.images.getImages("min_hover"));
        }
        if (string.equals(this.images.getImages("restore_normal").toString())) {
            this.model.setIcon(this.images.getImages("restore_hover"));
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        Icon icon = this.model.getPaintIcon();
        String string = icon.toString();
        if (string.equals(this.images.getImages("close_hover").toString())) {
            this.model.setIcon(this.images.getImages("close_normal"));
        }
        if (string.equals(this.images.getImages("max_hover").toString())) {
            this.model.setIcon(this.images.getImages("max_normal"));
        }
        if (string.equals(this.images.getImages("min_hover").toString())) {
            this.model.setIcon(this.images.getImages("min_normal"));
        }
        if (string.equals(this.images.getImages("restore_hover").toString())) {
            this.model.setIcon(this.images.getImages("restore_normal"));
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.pressedAndClicked();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Icon icon = this.model.getPaintIcon();
        String string = icon.toString();
        if (string.equals(this.images.getImages("close_pressed").toString())) {
            this.model.setIcon(this.images.getImages("close_normal"));
        }
        if (string.equals(this.images.getImages("max_pressed").toString())) {
            this.model.setIcon(this.images.getImages("max_normal"));
        }
        if (string.equals(this.images.getImages("min_pressed").toString())) {
            this.model.setIcon(this.images.getImages("min_normal"));
        }
        if (string.equals(this.images.getImages("restore_pressed").toString())) {
            this.model.setIcon(this.images.getImages("restore_normal"));
        }
        if (this.isEnabled()) {
            this.trigger.triggered();
        }
    }

    private void pressedAndClicked() {
        Icon icon = this.model.getPaintIcon();
        String string = icon.toString();
        if (string.equals(this.images.getImages("close_normal").toString()) || string.equals(this.images.getImages("close_hover").toString())) {
            this.model.setIcon(this.images.getImages("close_pressed"));
        }
        if (string.equals(this.images.getImages("max_normal").toString()) || string.equals(this.images.getImages("max_hover").toString())) {
            this.model.setIcon(this.images.getImages("max_pressed"));
        }
        if (string.equals(this.images.getImages("min_normal").toString()) || string.equals(this.images.getImages("min_hover").toString())) {
            this.model.setIcon(this.images.getImages("min_pressed"));
        }
        if (string.equals(this.images.getImages("restore_normal").toString()) || string.equals(this.images.getImages("restore_hover").toString())) {
            this.model.setIcon(this.images.getImages("restore_pressed"));
        }
    }
}

